/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2020-10-12 21:56:35 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `puy_booter_404s` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `hits` int(11) unsigned NOT NULL DEFAULT '0',
  `created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uid` (`uid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `puy_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `puy_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `puy_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

CREATE TABLE `puy_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `puy_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=4999 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `puy_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=14252 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `puy_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=2771 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `puy_redirection_404` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `created` datetime NOT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `agent` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referrer` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `created` (`created`),
  KEY `url` (`url`(191)),
  KEY `referrer` (`referrer`(191)),
  KEY `ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `puy_redirection_groups` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tracking` int(11) NOT NULL DEFAULT '1',
  `module_id` int(11) unsigned NOT NULL DEFAULT '0',
  `status` enum('enabled','disabled') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'enabled',
  `position` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `module_id` (`module_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `puy_redirection_items` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `url` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `match_url` varchar(2000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `match_data` text COLLATE utf8mb4_unicode_ci,
  `regex` int(11) unsigned NOT NULL DEFAULT '0',
  `position` int(11) unsigned NOT NULL DEFAULT '0',
  `last_count` int(10) unsigned NOT NULL DEFAULT '0',
  `last_access` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `group_id` int(11) NOT NULL DEFAULT '0',
  `status` enum('enabled','disabled') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'enabled',
  `action_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_code` int(11) unsigned NOT NULL,
  `action_data` mediumtext COLLATE utf8mb4_unicode_ci,
  `match_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `url` (`url`(191)),
  KEY `status` (`status`),
  KEY `regex` (`regex`),
  KEY `group_idpos` (`group_id`,`position`),
  KEY `group` (`group_id`),
  KEY `match_url` (`match_url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `puy_redirection_logs` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `created` datetime NOT NULL,
  `url` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `sent_to` mediumtext COLLATE utf8mb4_unicode_ci,
  `agent` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `referrer` mediumtext COLLATE utf8mb4_unicode_ci,
  `redirection_id` int(11) unsigned DEFAULT NULL,
  `ip` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `module_id` int(11) unsigned NOT NULL,
  `group_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `created` (`created`),
  KEY `redirection_id` (`redirection_id`),
  KEY `ip` (`ip`),
  KEY `group_id` (`group_id`),
  KEY `module_id` (`module_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `puy_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `puy_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `puy_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `puy_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `puy_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=134 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `puy_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `puy_yoast_indexable` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `permalink` longtext COLLATE utf8mb4_unicode_ci,
  `permalink_hash` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `object_id` int(11) unsigned DEFAULT NULL,
  `object_type` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `object_sub_type` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `author_id` int(11) unsigned DEFAULT NULL,
  `post_parent` int(11) unsigned DEFAULT NULL,
  `title` text COLLATE utf8mb4_unicode_ci,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `breadcrumb_title` text COLLATE utf8mb4_unicode_ci,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `is_protected` tinyint(1) DEFAULT '0',
  `has_public_posts` tinyint(1) DEFAULT NULL,
  `number_of_pages` int(11) unsigned DEFAULT NULL,
  `canonical` longtext COLLATE utf8mb4_unicode_ci,
  `primary_focus_keyword` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `primary_focus_keyword_score` int(3) DEFAULT NULL,
  `readability_score` int(3) DEFAULT NULL,
  `is_cornerstone` tinyint(1) DEFAULT '0',
  `is_robots_noindex` tinyint(1) DEFAULT '0',
  `is_robots_nofollow` tinyint(1) DEFAULT '0',
  `is_robots_noarchive` tinyint(1) DEFAULT '0',
  `is_robots_noimageindex` tinyint(1) DEFAULT '0',
  `is_robots_nosnippet` tinyint(1) DEFAULT '0',
  `twitter_title` text COLLATE utf8mb4_unicode_ci,
  `twitter_image` longtext COLLATE utf8mb4_unicode_ci,
  `twitter_description` longtext COLLATE utf8mb4_unicode_ci,
  `twitter_image_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `twitter_image_source` text COLLATE utf8mb4_unicode_ci,
  `open_graph_title` text COLLATE utf8mb4_unicode_ci,
  `open_graph_description` longtext COLLATE utf8mb4_unicode_ci,
  `open_graph_image` longtext COLLATE utf8mb4_unicode_ci,
  `open_graph_image_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `open_graph_image_source` text COLLATE utf8mb4_unicode_ci,
  `open_graph_image_meta` mediumtext COLLATE utf8mb4_unicode_ci,
  `link_count` int(11) DEFAULT NULL,
  `incoming_link_count` int(11) DEFAULT NULL,
  `prominent_words_version` int(11) unsigned DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint(20) NOT NULL DEFAULT '1',
  `language` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `region` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `schema_page_type` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `schema_article_type` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `has_ancestors` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `object_type_and_sub_type` (`object_type`,`object_sub_type`),
  KEY `object_id_and_type` (`object_id`,`object_type`),
  KEY `permalink_hash_and_object_type` (`permalink_hash`,`object_type`),
  KEY `subpages` (`post_parent`,`object_type`,`post_status`,`object_id`),
  KEY `prominent_words` (`prominent_words_version`,`object_type`,`object_sub_type`,`post_status`)
) ENGINE=InnoDB AUTO_INCREMENT=2156 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `puy_yoast_indexable_hierarchy` (
  `indexable_id` int(11) unsigned NOT NULL DEFAULT '0',
  `ancestor_id` int(11) unsigned NOT NULL DEFAULT '0',
  `depth` int(11) unsigned DEFAULT NULL,
  `blog_id` bigint(20) NOT NULL DEFAULT '1',
  PRIMARY KEY (`indexable_id`,`ancestor_id`),
  KEY `indexable_id` (`indexable_id`),
  KEY `ancestor_id` (`ancestor_id`),
  KEY `depth` (`depth`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `puy_yoast_migrations` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `puy_yoast_migrations_version` (`version`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `puy_yoast_primary_term` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` int(11) unsigned NOT NULL,
  `term_id` int(11) unsigned NOT NULL,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint(20) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `post_taxonomy` (`post_id`,`taxonomy`),
  KEY `post_term` (`post_id`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `puy_yoast_seo_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_id` bigint(20) unsigned NOT NULL,
  `target_post_id` bigint(20) unsigned NOT NULL,
  `type` varchar(8) COLLATE utf8mb4_unicode_ci NOT NULL,
  `indexable_id` int(11) unsigned DEFAULT NULL,
  `target_indexable_id` int(11) unsigned DEFAULT NULL,
  `height` int(11) unsigned DEFAULT NULL,
  `width` int(11) unsigned DEFAULT NULL,
  `size` int(11) unsigned DEFAULT NULL,
  `language` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `region` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `indexable_link_direction` (`indexable_id`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=51573 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `puy_yoast_seo_meta` (
  `object_id` bigint(20) unsigned NOT NULL,
  `internal_link_count` int(10) unsigned DEFAULT NULL,
  `incoming_link_count` int(10) unsigned DEFAULT NULL,
  UNIQUE KEY `object_id` (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


/* INSERT TABLE DATA: puy_duplicator_packages */
INSERT INTO `puy_duplicator_packages` VALUES("1", "20201012_d7a9d799d7a8d795d7aad79ed7a8d7", "da06342feee7cf156002_20201012215609", "22", "2020-10-12 21:56:35", "unknown", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2020-10-12 21:56:09\";s:7:\"Version\";s:6:\"1.3.38\";s:9:\"VersionWP\";s:5:\"5.5.1\";s:9:\"VersionDB\";s:6:\"5.5.41\";s:10:\"VersionPHP\";s:6:\"7.0.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:39:\"20201012_d7a9d799d7a8d795d7aad79ed7a8d7\";s:4:\"Hash\";s:35:\"da06342feee7cf156002_20201012215609\";s:8:\"NameHash\";s:75:\"20201012_d7a9d799d7a8d795d7aad79ed7a8d7_da06342feee7cf156002_20201012215609\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:85:\"20201012_d7a9d799d7a8d795d7aad79ed7a8d7_da06342feee7cf156002_20201012215609_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.7\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":21:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:87:\"20201012_d7a9d799d7a8d795d7aad79ed7a8d7_da06342feee7cf156002_20201012215609_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:47:\"/home/pltempur/domains/c-serv.co.il/public_html\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":5:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":6:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2020-10-12 21:56:09\";s:7:\"Version\";s:6:\"1.3.38\";s:9:\"VersionWP\";s:5:\"5.5.1\";s:9:\"VersionDB\";s:6:\"5.5.41\";s:10:\"VersionPHP\";s:6:\"7.0.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:39:\"20201012_d7a9d799d7a8d795d7aad79ed7a8d7\";s:4:\"Hash\";s:35:\"da06342feee7cf156002_20201012215609\";s:8:\"NameHash\";s:75:\"20201012_d7a9d799d7a8d795d7aad79ed7a8d7_da06342feee7cf156002_20201012215609\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":11:{s:4:\"File\";s:89:\"20201012_d7a9d799d7a8d795d7aad79ed7a8d7_da06342feee7cf156002_20201012215609_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:61;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:88:\"20201012_d7a9d799d7a8d795d7aad79ed7a8d7_da06342feee7cf156002_20201012215609_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":15:{s:9:\"buildMode\";N;s:13:\"collationList\";a:0:{}s:17:\"isTablesUpperCase\";N;s:15:\"isNameUpperCase\";N;s:4:\"name\";N;s:15:\"tablesBaseCount\";N;s:16:\"tablesFinalCount\";N;s:14:\"tablesRowCount\";N;s:16:\"tablesSizeOnDisk\";N;s:18:\"varLowerCaseTables\";i:0;s:7:\"version\";N;s:14:\"versionComment\";N;s:18:\"tableWiseRowCounts\";a:3:{s:15:\"puy_booter_404s\";s:1:\"0\";s:15:\"puy_commentmeta\";s:1:\"0\";s:12:\"puy_comments\";s:1:\"0\";}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:168:\"/home/pltempur/domains/c-serv.co.il/public_html/wp-content/backups-dup-lite/tmp/20201012_d7a9d799d7a8d795d7aad79ed7a8d7_da06342feee7cf156002_20201012215609_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:61;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:56:\"/home/pltempur/domains/c-serv.co.il/public_html/wp-admin\";i:1;s:66:\"/home/pltempur/domains/c-serv.co.il/public_html/wp-content/uploads\";i:2;s:68:\"/home/pltempur/domains/c-serv.co.il/public_html/wp-content/languages\";i:3;s:65:\"/home/pltempur/domains/c-serv.co.il/public_html/wp-content/themes\";i:4;s:59:\"/home/pltempur/domains/c-serv.co.il/public_html/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:47:\"/home/pltempur/domains/c-serv.co.il/public_html\";i:1;s:58:\"/home/pltempur/domains/c-serv.co.il/public_html/wp-content\";}}s:9:\"Installer\";r:82;s:8:\"Database\";r:94;s:13:\"BuildProgress\";r:128;}");

/* INSERT TABLE DATA: puy_options */
INSERT INTO `puy_options` VALUES("1", "siteurl", "https://www.c-serv.co.il", "yes");
INSERT INTO `puy_options` VALUES("2", "home", "https://www.c-serv.co.il", "yes");
INSERT INTO `puy_options` VALUES("3", "blogname", "שירות מרום", "yes");
INSERT INTO `puy_options` VALUES("4", "blogdescription", "נותנת השירות הרשמית למותגים הטובים והאיכותיים מבית ניופאן, ראלקו קריסטל וביג אלקטריק.", "yes");
INSERT INTO `puy_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `puy_options` VALUES("6", "admin_email", "matan@hdigital.co.il", "yes");
INSERT INTO `puy_options` VALUES("7", "start_of_week", "0", "yes");
INSERT INTO `puy_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `puy_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `puy_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `puy_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `puy_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `puy_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `puy_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `puy_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `puy_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `puy_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `puy_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `puy_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `puy_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `puy_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `puy_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `puy_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `puy_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `puy_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `puy_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `puy_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `puy_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `puy_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `puy_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `puy_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `puy_options` VALUES("33", "active_plugins", "a:12:{i:0;s:34:\"advanced-custom-fields-pro/acf.php\";i:1;s:32:\"duplicate-page/duplicatepage.php\";i:2;s:25:\"duplicator/duplicator.php\";i:3;s:37:\"elementor-extras/elementor-extras.php\";i:4;s:31:\"elementor-pro/elementor-pro.php\";i:5;s:23:\"elementor/elementor.php\";i:6;s:35:\"google-site-kit/google-site-kit.php\";i:7;s:47:\"lenix-elementor-leads-addon/elementor-leads.php\";i:8;s:41:\"pojo-accessibility/pojo-accessibility.php\";i:9;s:37:\"post-types-order/post-types-order.php\";i:10;s:27:\"redirection/redirection.php\";i:11;s:24:\"wordpress-seo/wp-seo.php\";}", "yes");
INSERT INTO `puy_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `puy_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `puy_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `puy_options` VALUES("37", "gmt_offset", "", "yes");
INSERT INTO `puy_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `puy_options` VALUES("39", "recently_edited", "a:5:{i:0;s:100:\"/home/pltempur/domains/c-serv.co.il/public_html/wp-content/themes/hdigital-theme-child/functions.php\";i:1;s:96:\"/home/pltempur/domains/c-serv.co.il/public_html/wp-content/themes/hdigital-theme-child/style.css\";i:3;s:97:\"/home/pltempur/domains/c-serv.co.il/public_html/wp-content/themes/hdigital-theme-child/readme.txt\";i:4;s:97:\"/home/pltempur/domains/c-serv.co.il/public_html/wp-content/themes/hdigital-theme-child/scripts.js\";i:5;s:0:\"\";}", "no");
INSERT INTO `puy_options` VALUES("40", "template", "hello-elementor", "yes");
INSERT INTO `puy_options` VALUES("41", "stylesheet", "hdigital-theme-child", "yes");
INSERT INTO `puy_options` VALUES("44", "comment_registration", "0", "yes");
INSERT INTO `puy_options` VALUES("45", "html_type", "text/html", "yes");
INSERT INTO `puy_options` VALUES("46", "use_trackback", "0", "yes");
INSERT INTO `puy_options` VALUES("47", "default_role", "subscriber", "yes");
INSERT INTO `puy_options` VALUES("48", "db_version", "48748", "yes");
INSERT INTO `puy_options` VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `puy_options` VALUES("50", "upload_path", "", "yes");
INSERT INTO `puy_options` VALUES("51", "blog_public", "1", "yes");
INSERT INTO `puy_options` VALUES("52", "default_link_category", "2", "yes");
INSERT INTO `puy_options` VALUES("53", "show_on_front", "page", "yes");
INSERT INTO `puy_options` VALUES("54", "tag_base", "", "yes");
INSERT INTO `puy_options` VALUES("55", "show_avatars", "1", "yes");
INSERT INTO `puy_options` VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO `puy_options` VALUES("57", "upload_url_path", "", "yes");
INSERT INTO `puy_options` VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO `puy_options` VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO `puy_options` VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO `puy_options` VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO `puy_options` VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO `puy_options` VALUES("63", "avatar_default", "mystery", "yes");
INSERT INTO `puy_options` VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO `puy_options` VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO `puy_options` VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO `puy_options` VALUES("67", "image_default_size", "", "yes");
INSERT INTO `puy_options` VALUES("68", "image_default_align", "", "yes");
INSERT INTO `puy_options` VALUES("69", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `puy_options` VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO `puy_options` VALUES("71", "thread_comments", "1", "yes");
INSERT INTO `puy_options` VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO `puy_options` VALUES("73", "page_comments", "0", "yes");
INSERT INTO `puy_options` VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO `puy_options` VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO `puy_options` VALUES("76", "comment_order", "asc", "yes");
INSERT INTO `puy_options` VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `puy_options` VALUES("78", "widget_categories", "a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `puy_options` VALUES("79", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `puy_options` VALUES("80", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `puy_options` VALUES("81", "uninstall_plugins", "a:2:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:27:\"redirection/redirection.php\";a:2:{i:0;s:17:\"Redirection_Admin\";i:1;s:16:\"plugin_uninstall\";}}", "no");
INSERT INTO `puy_options` VALUES("82", "timezone_string", "Asia/Jerusalem", "yes");
INSERT INTO `puy_options` VALUES("83", "page_for_posts", "0", "yes");
INSERT INTO `puy_options` VALUES("84", "page_on_front", "2", "yes");
INSERT INTO `puy_options` VALUES("85", "default_post_format", "0", "yes");
INSERT INTO `puy_options` VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO `puy_options` VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `puy_options` VALUES("88", "site_icon", "546", "yes");
INSERT INTO `puy_options` VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO `puy_options` VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO `puy_options` VALUES("91", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `puy_options` VALUES("92", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `puy_options` VALUES("93", "admin_email_lifespan", "1609246351", "yes");
INSERT INTO `puy_options` VALUES("94", "initial_db_version", "47018", "yes");
INSERT INTO `puy_options` VALUES("95", "puy_user_roles", "a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:62:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:20:\"wpseo_manage_options\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:35:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:36:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}}", "yes");
INSERT INTO `puy_options` VALUES("96", "fresh_site", "0", "yes");
INSERT INTO `puy_options` VALUES("97", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `puy_options` VALUES("98", "widget_recent-posts", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `puy_options` VALUES("99", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `puy_options` VALUES("100", "widget_archives", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `puy_options` VALUES("101", "widget_meta", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `puy_options` VALUES("102", "sidebars_widgets", "a:2:{s:19:\"wp_inactive_widgets\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `puy_options` VALUES("103", "cron", "a:11:{i:1602543152;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1602550352;a:2:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1602550476;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1602582066;a:1:{s:19:\"wpseo-reindex-links\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1602593551;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1602593733;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1602593809;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1602593813;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1602754864;a:1:{s:16:\"wpseo_ryte_fetch\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1602852751;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `puy_options` VALUES("104", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `puy_options` VALUES("105", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `puy_options` VALUES("106", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `puy_options` VALUES("107", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `puy_options` VALUES("108", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `puy_options` VALUES("109", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `puy_options` VALUES("110", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `puy_options` VALUES("111", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `puy_options` VALUES("112", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `puy_options` VALUES("114", "theme_mods_twentytwenty", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1593694783;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:9:\"sidebar-2\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}}}}", "yes");
INSERT INTO `puy_options` VALUES("115", "recovery_keys", "a:0:{}", "yes");
INSERT INTO `puy_options` VALUES("123", "WPLANG", "he_IL", "yes");
INSERT INTO `puy_options` VALUES("139", "booter_version", "1.5.5", "yes");
INSERT INTO `puy_options` VALUES("142", "booter_settings", "a:6:{s:9:\"uninstall\";s:2:\"no\";s:5:\"debug\";s:2:\"no\";s:10:\"rate_limit\";a:5:{s:7:\"enabled\";s:2:\"no\";s:17:\"enabled_logged_in\";s:2:\"no\";s:14:\"requests_limit\";s:2:\"30\";s:9:\"block_for\";s:3:\"600\";s:7:\"exclude\";a:1:{i:0;s:11:\"uptimerobot\";}}s:5:\"block\";a:10:{s:7:\"enabled\";s:3:\"yes\";s:16:\"block_useragents\";s:4:\"bots\";s:19:\"enabled_woocommerce\";s:2:\"no\";s:7:\"strings\";a:38:{i:0;s:11:\"public_html\";i:1;s:10:\"index.php?\";i:2;s:4:\".win\";i:3;s:5:\".asia\";i:4;s:5:\".work\";i:5;s:4:\".xyz\";i:6;s:5:\".wine\";i:7;s:4:\".wtf\";i:8;s:4:\".xin\";i:9;s:6:\".world\";i:10;s:5:\".zone\";i:11;s:5:\".yoga\";i:12;s:5:\".wiki\";i:13;s:9:\".business\";i:14;s:3:\".us\";i:15;s:4:\".ltd\";i:16;s:7:\".photos\";i:17;s:5:\".cool\";i:18;s:5:\".game\";i:19;s:5:\".host\";i:20;s:5:\".fund\";i:21;s:4:\".pet\";i:22;s:5:\".help\";i:23;s:4:\".mba\";i:24;s:9:\".clothing\";i:25;s:9:\".business\";i:26;s:5:\".life\";i:27;s:7:\"suspect\";i:28;s:5:\".pass\";i:29;s:4:\".edu\";i:30;s:4:\".ink\";i:31;s:5:\".diet\";i:32;s:4:\".fit\";i:33;s:6:\"viagra\";i:34;s:6:\"dating\";i:35;s:3:\"sex\";i:36;s:6:\"mailto\";i:37;s:5:\"CHAR(\";}s:13:\"http_response\";s:3:\"410\";s:16:\"block_bad_robots\";s:3:\"yes\";s:9:\"badrobots\";a:574:{i:0;s:9:\"360Spider\";i:1;s:10:\"404checker\";i:2;s:8:\"404enemy\";i:3;s:6:\"80legs\";i:4;s:6:\"Abonti\";i:5;s:8:\"Aboundex\";i:6;s:11:\"Aboundexbot\";i:7;s:8:\"Acunetix\";i:8;s:7:\"ADmantX\";i:9;s:20:\"AfD-Verbotsverfahren\";i:10;s:9:\"AhrefsBot\";i:11;s:5:\"AIBOT\";i:12;s:8:\"AiHitBot\";i:13;s:6:\"Aipbot\";i:14;s:8:\"Alexibot\";i:15;s:9:\"Alligator\";i:16;s:12:\"AllSubmitter\";i:17;s:8:\"AlphaBot\";i:18;s:8:\"Anarchie\";i:19;s:5:\"Ankit\";i:20;s:6:\"Apexoo\";i:21;s:15:\"archive.org_bot\";i:22;s:10:\"arquivo.pt\";i:23;s:19:\"arquivo-web-crawler\";i:24;s:8:\"Aspiegel\";i:25;s:7:\"ASPSeek\";i:26;s:8:\"Asterias\";i:27;s:6:\"Attach\";i:28;s:15:\"autoemailspider\";i:29;s:12:\"AwarioRssBot\";i:30;s:14:\"AwarioSmartBot\";i:31;s:11:\"BackDoorBot\";i:32;s:13:\"Backlink-Ceck\";i:33;s:14:\"backlink-check\";i:34;s:15:\"BacklinkCrawler\";i:35;s:10:\"BackStreet\";i:36;s:7:\"BackWeb\";i:37;s:6:\"Badass\";i:38;s:6:\"Bandit\";i:39;s:10:\"Barkrowler\";i:40;s:8:\"BatchFTP\";i:41;s:18:\"Battleztar Bazinga\";i:42;s:6:\"BBBike\";i:43;s:6:\"BDCbot\";i:44;s:7:\"BDFetch\";i:45;s:7:\"BetaBot\";i:46;s:7:\"Bigfoot\";i:47;s:7:\"Bitacle\";i:48;s:10:\"Blackboard\";i:49;s:10:\"Black Hole\";i:50;s:10:\"BlackWidow\";i:51;s:7:\"BLEXBot\";i:52;s:4:\"Blow\";i:53;s:8:\"BlowFish\";i:54;s:11:\"Boardreader\";i:55;s:4:\"Bolt\";i:56;s:7:\"BotALot\";i:57;s:12:\"Brandprotect\";i:58;s:10:\"Brandwatch\";i:59;s:5:\"Buddy\";i:60;s:13:\"BuiltBotTough\";i:61;s:9:\"BuiltWith\";i:62;s:8:\"Bullseye\";i:63;s:13:\"BunnySlippers\";i:64;s:8:\"BuzzSumo\";i:65;s:8:\"Calculon\";i:66;s:13:\"CATExplorador\";i:67;s:11:\"CazoodleBot\";i:68;s:5:\"CCBot\";i:69;s:9:\"Cegbfeieh\";i:70;s:9:\"CheeseBot\";i:71;s:12:\"CherryPicker\";i:72;s:7:\"CheTeam\";i:73;s:9:\"ChinaClaw\";i:74;s:6:\"Chlooe\";i:75;s:10:\"Claritybot\";i:76;s:8:\"Cliqzbot\";i:77;s:13:\"Cloud mapping\";i:78;s:13:\"coccocbot-web\";i:79;s:9:\"Cogentbot\";i:80;s:12:\"cognitiveseo\";i:81;s:9:\"Collector\";i:82;s:17:\"com.plumanalytics\";i:83;s:6:\"Copier\";i:84;s:14:\"CopyRightCheck\";i:85;s:9:\"Copyscape\";i:86;s:6:\"Cosmos\";i:87;s:8:\"Craftbot\";i:88;s:9:\"crawler4j\";i:89;s:16:\"crawler.feedback\";i:90;s:15:\"crawl.sogou.com\";i:91;s:15:\"CrazyWebCrawler\";i:92;s:8:\"Crescent\";i:93;s:9:\"CrunchBot\";i:94;s:6:\"CSHttp\";i:95;s:7:\"Curious\";i:96;s:5:\"Custo\";i:97;s:20:\"DatabaseDriverMysqli\";i:98;s:9:\"DataCha0s\";i:99;s:6:\"DBLBot\";i:100;s:14:\"demandbase-bot\";i:101;s:5:\"Demon\";i:102;s:5:\"Deusu\";i:103;s:5:\"Devil\";i:104;s:9:\"Digincore\";i:105;s:13:\"DigitalPebble\";i:106;s:6:\"DIIbot\";i:107;s:9:\"Dirbuster\";i:108;s:5:\"Disco\";i:109;s:8:\"Discobot\";i:110;s:12:\"Discoverybot\";i:111;s:8:\"Dispatch\";i:112;s:11:\"DittoSpyder\";i:113;s:7:\"DnyzBot\";i:114;s:14:\"DomainAppender\";i:115;s:13:\"DomainCrawler\";i:116;s:18:\"DomainSigmaCrawler\";i:117;s:15:\"Domains Project\";i:118;s:18:\"domainsproject.org\";i:119;s:14:\"DomainStatsBot\";i:120;s:6:\"Dotbot\";i:121;s:15:\"Download Wonder\";i:122;s:9:\"Dragonfly\";i:123;s:4:\"Drip\";i:124;s:7:\"DSearch\";i:125;s:9:\"DTS Agent\";i:126;s:6:\"EasyDL\";i:127;s:9:\"Ebingbong\";i:128;s:6:\"eCatch\";i:129;s:8:\"ECCP/1.0\";i:130;s:4:\"Ecxi\";i:131;s:10:\"EirGrabber\";i:132;s:12:\"EMail Siphon\";i:133;s:10:\"EMail Wolf\";i:134;s:10:\"EroCrawler\";i:135;s:9:\"evc-batch\";i:136;s:4:\"Evil\";i:137;s:6:\"Exabot\";i:138;s:19:\"Express WebPictures\";i:139;s:11:\"ExtLinksBot\";i:140;s:9:\"Extractor\";i:141;s:12:\"ExtractorPro\";i:142;s:22:\"Extreme Picture Finder\";i:143;s:8:\"EyeNetIE\";i:144;s:6:\"Ezooms\";i:145;s:15:\"facebookscraper\";i:146;s:3:\"FDM\";i:147;s:14:\"FemtosearchBot\";i:148;s:6:\"FHscan\";i:149;s:5:\"Fimap\";i:150;s:11:\"Firefox/7.0\";i:151;s:8:\"FlashGet\";i:152;s:6:\"Flunky\";i:153;s:6:\"Foobot\";i:154;s:12:\"Freeuploader\";i:155;s:9:\"FrontPage\";i:156;s:11:\"FyberSpider\";i:157;s:7:\"Fyrebot\";i:158;s:9:\"GalaxyBot\";i:159;s:6:\"Genieo\";i:160;s:11:\"GermCrawler\";i:161;s:9:\"Getintent\";i:162;s:8:\"GetRight\";i:163;s:6:\"GetWeb\";i:164;s:9:\"Gigablast\";i:165;s:7:\"Gigabot\";i:166;s:13:\"G-i-g-a-b-o-t\";i:167;s:15:\"Go-Ahead-Got-It\";i:168;s:5:\"Gotit\";i:169;s:7:\"GoZilla\";i:170;s:8:\"Go!Zilla\";i:171;s:7:\"Grabber\";i:172;s:7:\"GrabNet\";i:173;s:7:\"Grafula\";i:174;s:7:\"GrapeFX\";i:175;s:16:\"GrapeshotCrawler\";i:176;s:7:\"GridBot\";i:177;s:7:\"GT::WWW\";i:178;s:8:\"Haansoft\";i:179;s:12:\"HaosouSpider\";i:180;s:7:\"Harvest\";i:181;s:5:\"Havij\";i:182;s:13:\"HEADMasterSEO\";i:183;s:8:\"heritrix\";i:184;s:8:\"Heritrix\";i:185;s:7:\"Hloader\";i:186;s:6:\"HMView\";i:187;s:10:\"HTMLparser\";i:188;s:10:\"HTTP::Lite\";i:189;s:7:\"HTTrack\";i:190;s:10:\"Humanlinks\";i:191;s:9:\"HybridBot\";i:192;s:5:\"Iblog\";i:193;s:5:\"IDBot\";i:194;s:9:\"Id-search\";i:195;s:7:\"IlseBot\";i:196;s:11:\"Image Fetch\";i:197;s:12:\"Image Sucker\";i:198;s:9:\"IndeedBot\";i:199;s:12:\"Indy Library\";i:200;s:13:\"InfoNaviRobot\";i:201;s:10:\"InfoTekies\";i:202;s:8:\"instabid\";i:203;s:11:\"Intelliseek\";i:204;s:8:\"InterGET\";i:205;s:14:\"Internet Ninja\";i:206;s:12:\"InternetSeer\";i:207;s:21:\"internetVista monitor\";i:208;s:9:\"ips-agent\";i:209;s:4:\"Iria\";i:210;s:6:\"IRLbot\";i:211;s:7:\"Iskanie\";i:212;s:10:\"IstellaBot\";i:213;s:8:\"JamesBOT\";i:214;s:8:\"Jbrofuzz\";i:215;s:8:\"JennyBot\";i:216;s:6:\"JetCar\";i:217;s:5:\"Jetty\";i:218;s:10:\"JikeSpider\";i:219;s:14:\"JOC Web Spider\";i:220;s:6:\"Joomla\";i:221;s:6:\"Jorgee\";i:222;s:8:\"JustView\";i:223;s:7:\"Jyxobot\";i:224;s:13:\"Kenjin Spider\";i:225;s:15:\"Keyword Density\";i:226;s:5:\"Kinza\";i:227;s:9:\"Kozmosbot\";i:228;s:10:\"Lanshanbot\";i:229;s:6:\"Larbin\";i:230;s:8:\"LeechFTP\";i:231;s:8:\"LeechGet\";i:232;s:7:\"LexiBot\";i:233;s:4:\"Lftp\";i:234;s:6:\"LibWeb\";i:235;s:10:\"Libwhisker\";i:236;s:10:\"LieBaoFast\";i:237;s:17:\"Lightspeedsystems\";i:238;s:5:\"Likse\";i:239;s:10:\"Linkdexbot\";i:240;s:16:\"LinkextractorPro\";i:241;s:10:\"LinkpadBot\";i:242;s:8:\"LinkScan\";i:243;s:12:\"LinksManager\";i:244;s:10:\"LinkWalker\";i:245;s:27:\"LinqiaMetadataDownloaderBot\";i:246;s:12:\"LinqiaRSSBot\";i:247;s:15:\"LinqiaScrapeBot\";i:248;s:9:\"Lipperhey\";i:249;s:16:\"Lipperhey Spider\";i:250;s:15:\"Litemage_walker\";i:251;s:8:\"Lmspider\";i:252;s:11:\"LNSpiderguy\";i:253;s:5:\"Ltx71\";i:254;s:11:\"lwp-request\";i:255;s:11:\"LWP::Simple\";i:256;s:11:\"lwp-trivial\";i:257;s:6:\"Magnet\";i:258;s:7:\"Mag-Net\";i:259;s:14:\"magpie-crawler\";i:260;s:11:\"Mail.RU_Bot\";i:261;s:10:\"Majestic12\";i:262;s:12:\"Majestic-SEO\";i:263;s:12:\"Majestic SEO\";i:264;s:11:\"MarkMonitor\";i:265;s:9:\"MarkWatch\";i:266;s:7:\"Masscan\";i:267;s:15:\"Mass Downloader\";i:268;s:9:\"Mata Hari\";i:269;s:7:\"MauiBot\";i:270;s:13:\"Mb2345Browser\";i:271;s:11:\"meanpathbot\";i:272;s:11:\"Meanpathbot\";i:273;s:12:\"MeanPath Bot\";i:274;s:15:\"Mediatoolkitbot\";i:275;s:10:\"mediawords\";i:276;s:12:\"MegaIndex.ru\";i:277;s:7:\"Metauri\";i:278;s:15:\"MFC_Tear_Sample\";i:279;s:14:\"MicroMessenger\";i:280;s:21:\"Microsoft Data Access\";i:281;s:21:\"Microsoft URL Control\";i:282;s:11:\"MIDown tool\";i:283;s:6:\"MIIxpc\";i:284;s:10:\"Mister PiX\";i:285;s:7:\"MJ12bot\";i:286;s:6:\"Mojeek\";i:287;s:11:\"Mojolicious\";i:288;s:23:\"Morfeus Fucking Scanner\";i:289;s:7:\"Mozlila\";i:290;s:10:\"MQQBrowser\";i:291;s:6:\"Mr.4x3\";i:292;s:11:\"MSFrontPage\";i:293;s:11:\"MSIECrawler\";i:294;s:7:\"Msrabot\";i:295;s:12:\"muhstik-scan\";i:296;s:7:\"Musobot\";i:297;s:17:\"Name Intelligence\";i:298;s:11:\"Nameprotect\";i:299;s:7:\"Navroad\";i:300;s:8:\"NearSite\";i:301;s:6:\"Needle\";i:302;s:6:\"Nessus\";i:303;s:7:\"NetAnts\";i:304;s:8:\"Netcraft\";i:305;s:20:\"netEstate NE Crawler\";i:306;s:8:\"NetLyzer\";i:307;s:11:\"NetMechanic\";i:308;s:9:\"NetSpider\";i:309;s:8:\"Nettrack\";i:310;s:11:\"Net Vampire\";i:311;s:8:\"Netvibes\";i:312;s:6:\"NetZIP\";i:313;s:16:\"NextGenSearchBot\";i:314;s:7:\"Nibbler\";i:315;s:9:\"NICErsPRO\";i:316;s:8:\"Niki-bot\";i:317;s:5:\"Nikto\";i:318;s:13:\"NimbleCrawler\";i:319;s:12:\"Nimbostratus\";i:320;s:5:\"Ninja\";i:321;s:4:\"Nmap\";i:322;s:5:\"NPbot\";i:323;s:5:\"Nutch\";i:324;s:4:\"oBot\";i:325;s:7:\"Octopus\";i:326;s:16:\"Offline Explorer\";i:327;s:17:\"Offline Navigator\";i:328;s:7:\"OnCrawl\";i:329;s:8:\"Openfind\";i:330;s:16:\"OpenLinkProfiler\";i:331;s:7:\"Openvas\";i:332;s:7:\"OpenVAS\";i:333;s:8:\"OPPO A33\";i:334;s:9:\"OrangeBot\";i:335;s:12:\"OrangeSpider\";i:336;s:12:\"OutclicksBot\";i:337;s:9:\"OutfoxBot\";i:338;s:12:\"PageAnalyzer\";i:339;s:13:\"Page Analyzer\";i:340;s:11:\"PageGrabber\";i:341;s:11:\"page scorer\";i:342;s:10:\"PageScorer\";i:343;s:11:\"Pandalytics\";i:344;s:9:\"Panscient\";i:345;s:9:\"Papa Foto\";i:346;s:5:\"Pavuk\";i:347;s:9:\"pcBrowser\";i:348;s:10:\"PECL::HTTP\";i:349;s:9:\"PeoplePal\";i:350;s:8:\"PHPCrawl\";i:351;s:8:\"Picscout\";i:352;s:9:\"Picsearch\";i:353;s:13:\"PictureFinder\";i:354;s:9:\"Pimonster\";i:355;s:10:\"Pi-Monster\";i:356;s:6:\"Pixray\";i:357;s:11:\"PleaseCrawl\";i:358;s:13:\"plumanalytics\";i:359;s:6:\"Pockey\";i:360;s:25:\"POE-Component-Client-HTTP\";i:361;s:15:\"polaris version\";i:362;s:11:\"Probethenet\";i:363;s:11:\"ProPowerBot\";i:364;s:12:\"ProWebWalker\";i:365;s:5:\"Psbot\";i:366;s:4:\"Pump\";i:367;s:8:\"PxBroker\";i:368;s:6:\"PyCurl\";i:369;s:17:\"QueryN Metasearch\";i:370;s:13:\"Quick-Crawler\";i:371;s:10:\"RankActive\";i:372;s:17:\"RankActiveLinkBot\";i:373;s:8:\"RankFlex\";i:374;s:10:\"RankingBot\";i:375;s:11:\"RankingBot2\";i:376;s:10:\"Rankivabot\";i:377;s:9:\"RankurBot\";i:378;s:12:\"RealDownload\";i:379;s:6:\"Reaper\";i:380;s:10:\"RebelMouse\";i:381;s:8:\"Recorder\";i:382;s:11:\"RedesScrapy\";i:383;s:5:\"ReGet\";i:384;s:10:\"RepoMonkey\";i:385;s:6:\"Ripper\";i:386;s:13:\"RocketCrawler\";i:387;s:8:\"Rogerbot\";i:388;s:9:\"RSSingBot\";i:389;s:6:\"s1z.ru\";i:390;s:16:\"SalesIntelligent\";i:391;s:6:\"SBIder\";i:392;s:9:\"ScanAlert\";i:393;s:7:\"Scanbot\";i:394;s:8:\"scan.lol\";i:395;s:8:\"ScoutJet\";i:396;s:6:\"Scrapy\";i:397;s:11:\"ScreenerBot\";i:398;s:12:\"Searchestate\";i:399;s:16:\"SearchmetricsBot\";i:400;s:7:\"Semrush\";i:401;s:10:\"SemrushBot\";i:402;s:8:\"SEOkicks\";i:403;s:14:\"SEOkicks-Robot\";i:404;s:16:\"SEOlyticsCrawler\";i:405;s:6:\"Seomoz\";i:406;s:11:\"SEOprofiler\";i:407;s:11:\"seoscanners\";i:408;s:14:\"SeoSiteCheckup\";i:409;s:8:\"SEOstats\";i:410;s:11:\"serpstatbot\";i:411;s:11:\"sexsearcher\";i:412;s:6:\"Shodan\";i:413;s:6:\"Siphon\";i:414;s:7:\"SISTRIX\";i:415;s:8:\"Sitebeam\";i:416;s:12:\"SiteExplorer\";i:417;s:11:\"Siteimprove\";i:418;s:14:\"SiteLockSpider\";i:419;s:11:\"SiteSnagger\";i:420;s:10:\"SiteSucker\";i:421;s:11:\"Site Sucker\";i:422;s:9:\"Sitevigil\";i:423;s:9:\"SlySearch\";i:424;s:13:\"SmartDownload\";i:425;s:6:\"SMTBot\";i:426;s:5:\"Snake\";i:427;s:7:\"Snapbot\";i:428;s:6:\"Snoopy\";i:429;s:15:\"SocialRankIOBot\";i:430;s:11:\"Sociscraper\";i:431;s:11:\"sogouspider\";i:432;s:16:\"Sogou web spider\";i:433;s:10:\"Sosospider\";i:434;s:8:\"Sottopop\";i:435;s:10:\"SpaceBison\";i:436;s:7:\"Spammen\";i:437;s:8:\"SpankBot\";i:438;s:7:\"Spanner\";i:439;s:11:\"sp_auditbot\";i:440;s:5:\"Spbot\";i:441;s:7:\"Spinn3r\";i:442;s:10:\"SputnikBot\";i:443;s:5:\"spyfu\";i:444;s:6:\"Sqlmap\";i:445;s:7:\"Sqlworm\";i:446;s:6:\"Sqworm\";i:447;s:7:\"Steeler\";i:448;s:8:\"Stripper\";i:449;s:6:\"Sucker\";i:450;s:6:\"Sucuri\";i:451;s:8:\"SuperBot\";i:452;s:9:\"SuperHTTP\";i:453;s:7:\"Surfbot\";i:454;s:9:\"SurveyBot\";i:455;s:7:\"Suzuran\";i:456;s:8:\"Swiftbot\";i:457;s:7:\"sysscan\";i:458;s:7:\"Szukacz\";i:459;s:11:\"T0PHackTeam\";i:460;s:6:\"T8Abot\";i:461;s:7:\"tAkeOut\";i:462;s:8:\"Teleport\";i:463;s:11:\"TeleportPro\";i:464;s:8:\"Telesoft\";i:465;s:11:\"Telesphoreo\";i:466;s:11:\"Telesphorep\";i:467;s:16:\"The Intraformant\";i:468;s:8:\"TheNomad\";i:469;s:7:\"Thumbor\";i:470;s:12:\"TightTwatBot\";i:471;s:5:\"Titan\";i:472;s:5:\"Toata\";i:473;s:9:\"Toweyabot\";i:474;s:11:\"Tracemyfile\";i:475;s:11:\"Trendiction\";i:476;s:14:\"Trendictionbot\";i:477;s:15:\"trendiction.com\";i:478;s:14:\"trendiction.de\";i:479;s:10:\"True_Robot\";i:480;s:8:\"Turingos\";i:481;s:8:\"Turnitin\";i:482;s:11:\"TurnitinBot\";i:483;s:9:\"TwengaBot\";i:484;s:5:\"Twice\";i:485;s:8:\"Typhoeus\";i:486;s:10:\"UnisterBot\";i:487;s:6:\"Upflow\";i:488;s:12:\"URLy.Warning\";i:489;s:12:\"URLy Warning\";i:490;s:6:\"Vacuum\";i:491;s:9:\"Vagabondo\";i:492;s:10:\"VB Project\";i:493;s:3:\"VCI\";i:494;s:15:\"VeriCiteCrawler\";i:495;s:14:\"VidibleScraper\";i:496;s:8:\"Virusdie\";i:497;s:7:\"VoidEYE\";i:498;s:4:\"Voil\";i:499;s:7:\"Voltron\";i:500;s:14:\"Wallpapers/3.0\";i:501;s:12:\"WallpapersHD\";i:502;s:12:\"WASALive-Bot\";i:503;s:11:\"WBSearchBot\";i:504;s:7:\"Webalta\";i:505;s:7:\"WebAuto\";i:506;s:8:\"Web Auto\";i:507;s:9:\"WebBandit\";i:508;s:10:\"WebCollage\";i:509;s:11:\"Web Collage\";i:510;s:9:\"WebCopier\";i:511;s:6:\"WEBDAV\";i:512;s:11:\"WebEnhancer\";i:513;s:12:\"Web Enhancer\";i:514;s:8:\"WebFetch\";i:515;s:9:\"Web Fetch\";i:516;s:7:\"WebFuck\";i:517;s:8:\"Web Fuck\";i:518;s:8:\"WebGo IS\";i:519;s:17:\"WebImageCollector\";i:520;s:10:\"WebLeacher\";i:521;s:22:\"WebmasterWorldForumBot\";i:522;s:15:\"webmeup-crawler\";i:523;s:6:\"WebPix\";i:524;s:7:\"Web Pix\";i:525;s:9:\"WebReaper\";i:526;s:9:\"WebSauger\";i:527;s:10:\"Web Sauger\";i:528;s:7:\"Webshag\";i:529;s:16:\"WebsiteExtractor\";i:530;s:14:\"WebsiteQuester\";i:531;s:15:\"Website Quester\";i:532;s:7:\"Webster\";i:533;s:11:\"WebStripper\";i:534;s:9:\"WebSucker\";i:535;s:10:\"Web Sucker\";i:536;s:10:\"WebWhacker\";i:537;s:6:\"WebZIP\";i:538;s:5:\"WeSEE\";i:539;s:5:\"Whack\";i:540;s:7:\"Whacker\";i:541;s:7:\"Whatweb\";i:542;s:10:\"Who.is Bot\";i:543;s:5:\"Widow\";i:544;s:10:\"WinHTTrack\";i:545;s:14:\"WiseGuys Robot\";i:546;s:10:\"WISENutbot\";i:547;s:9:\"Wonderbot\";i:548;s:6:\"Woobot\";i:549;s:6:\"Wotbox\";i:550;s:7:\"Wprecon\";i:551;s:6:\"WPScan\";i:552;s:15:\"WWW-Collector-E\";i:553;s:13:\"WWW-Mechanize\";i:554;s:14:\"WWW::Mechanize\";i:555;s:8:\"WWWOFFLE\";i:556;s:10:\"x09Mozilla\";i:557;s:10:\"x22Mozilla\";i:558;s:16:\"Xaldon_WebSpider\";i:559;s:16:\"Xaldon WebSpider\";i:560;s:4:\"Xenu\";i:561;s:11:\"xpymep1.exe\";i:562;s:9:\"YoudaoBot\";i:563;s:4:\"Zade\";i:564;s:5:\"Zauba\";i:565;s:8:\"zauba.io\";i:566;s:7:\"Zermelo\";i:567;s:4:\"Zeus\";i:568;s:5:\"zgrab\";i:569;s:7:\"Zitebot\";i:570;s:4:\"ZmEu\";i:571;s:6:\"ZumBot\";i:572;s:6:\"ZyBorg\";i:573;s:9:\"WP Rocket\";}s:13:\"regex_enabled\";s:3:\"yes\";s:5:\"regex\";a:1:{i:0;s:29:\"[\\/+\\-_.][0-9]{7,20}[\\/+\\-_.]\";}s:22:\"block_empty_useragents\";s:3:\"yes\";}s:7:\"log_404\";a:3:{s:7:\"enabled\";s:3:\"yes\";s:11:\"send_report\";s:2:\"no\";s:12:\"report_email\";s:0:\"\";}s:6:\"robots\";a:6:{s:7:\"enabled\";s:3:\"yes\";s:9:\"block_all\";s:2:\"no\";s:15:\"sitemap_enabled\";s:2:\"no\";s:11:\"sitemap_url\";s:0:\"\";s:11:\"manage_type\";s:6:\"simple\";s:10:\"useragents\";a:1:{i:0;a:7:{s:9:\"useragent\";s:1:\"*\";s:10:\"crawl_rate\";s:1:\"0\";s:21:\"include_block_strings\";s:3:\"yes\";s:17:\"restrict_wp_admin\";s:3:\"yes\";s:13:\"allow_wp_ajax\";s:3:\"yes\";s:8:\"disallow\";a:2:{i:0;s:14:\"/*public_html/\";i:1;s:12:\"/*index.php?\";}s:5:\"allow\";a:0:{}}}}}", "yes");
INSERT INTO `puy_options` VALUES("148", "elementor_version", "3.0.6", "yes");
INSERT INTO `puy_options` VALUES("154", "elementor_remote_info_library", "a:3:{s:10:\"types_data\";a:2:{s:5:\"block\";a:1:{s:10:\"categories\";a:22:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:14:\"call to action\";i:4;s:7:\"clients\";i:5;s:7:\"contact\";i:6;s:3:\"faq\";i:7;s:8:\"features\";i:8;s:6:\"footer\";i:9;s:6:\"header\";i:10;s:4:\"hero\";i:11;s:9:\"portfolio\";i:12;s:7:\"pricing\";i:13;s:15:\"product archive\";i:14;s:8:\"services\";i:15;s:11:\"single page\";i:16;s:11:\"single post\";i:17;s:14:\"single product\";i:18;s:5:\"stats\";i:19;s:9:\"subscribe\";i:20;s:4:\"team\";i:21;s:12:\"testimonials\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}}s:10:\"categories\";a:22:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:14:\"call to action\";i:4;s:7:\"clients\";i:5;s:7:\"contact\";i:6;s:3:\"faq\";i:7;s:8:\"features\";i:8;s:6:\"footer\";i:9;s:6:\"header\";i:10;s:4:\"hero\";i:11;s:9:\"portfolio\";i:12;s:7:\"pricing\";i:13;s:15:\"product archive\";i:14;s:8:\"services\";i:15;s:11:\"single page\";i:16;s:11:\"single post\";i:17;s:14:\"single product\";i:18;s:5:\"stats\";i:19;s:9:\"subscribe\";i:20;s:4:\"team\";i:21;s:12:\"testimonials\";}s:9:\"templates\";a:741:{i:0;a:14:{s:2:\"id\";i:5525;s:5:\"title\";s:8:\"About 14\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_10.png\";s:12:\"tmpl_created\";i:1520443532;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:9;s:11:\"trend_index\";i:6;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:1;a:14:{s:2:\"id\";i:10107;s:5:\"title\";s:34:\"Classic | Promotion | Announcement\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/balls_small.png\";s:12:\"tmpl_created\";i:1547851373;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/classic-promotion-announcement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:240;s:11:\"trend_index\";i:197;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:2;a:14:{s:2:\"id\";i:14790;s:5:\"title\";s:33:\"Luxury Real Estate &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/07/Header.png\";s:12:\"tmpl_created\";i:1595315760;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/luxury-real-estate-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:37:\"[\"header\",\"real estate\",\"realestate\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:320;s:11:\"trend_index\";i:12;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:3;a:14:{s:2:\"id\";i:5533;s:5:\"title\";s:8:\"About 15\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_10.png\";s:12:\"tmpl_created\";i:1520443534;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:27;s:11:\"trend_index\";i:11;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:4;a:14:{s:2:\"id\";i:14799;s:5:\"title\";s:38:\"Luxury Real Estate &#8211; single post\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/07/Post.png\";s:12:\"tmpl_created\";i:1595315792;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/blocks/luxury-real-estate-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:28:\"[\"real estate\",\"realestate\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:586;s:11:\"trend_index\";i:129;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:5;a:14:{s:2:\"id\";i:5575;s:5:\"title\";s:5:\"CTA 7\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_3.png\";s:12:\"tmpl_created\";i:1520443543;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:14;s:11:\"trend_index\";i:13;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:6;a:14:{s:2:\"id\";i:14809;s:5:\"title\";s:45:\"Luxury Real Estate &#8211; Properties Archive\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/07/Properties.png\";s:12:\"tmpl_created\";i:1595315826;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/blocks/luxury-real-estate-properties-archive/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:28:\"[\"real estate\",\"realestate\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:598;s:11:\"trend_index\";i:195;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:7;a:14:{s:2:\"id\";i:5615;s:5:\"title\";s:10:\"Features 6\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_5.png\";s:12:\"tmpl_created\";i:1520443551;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:33;s:11:\"trend_index\";i:64;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:8;a:14:{s:2:\"id\";i:14816;s:5:\"title\";s:47:\"Luxury Real Estate &#8211; Property single post\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2020/07/Single-Property-.png\";s:12:\"tmpl_created\";i:1595315847;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/blocks/luxury-real-estate-property-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:28:\"[\"real estate\",\"realestate\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:646;s:11:\"trend_index\";i:278;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:9;a:14:{s:2:\"id\";i:5624;s:5:\"title\";s:10:\"Features 5\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_black_1.png\";s:12:\"tmpl_created\";i:1520443553;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:77;s:11:\"trend_index\";i:157;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:10;a:14:{s:2:\"id\";i:14827;s:5:\"title\";s:39:\"Slide-In | Contact | Luxury Real Estate\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/07/PopUp.png\";s:12:\"tmpl_created\";i:1595323523;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/slide-in-contact-luxury-real-estate/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:28:\"[\"real estate\",\"realestate\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:672;s:11:\"trend_index\";i:425;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:11;a:14:{s:2:\"id\";i:5684;s:5:\"title\";s:5:\"FAQ 8\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_1.png\";s:12:\"tmpl_created\";i:1520443565;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:67;s:11:\"trend_index\";i:75;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:12;a:14:{s:2:\"id\";i:10158;s:5:\"title\";s:17:\"Classic | Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/coco_small.png\";s:12:\"tmpl_created\";i:1547852227;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/classic-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:268;s:11:\"trend_index\";i:238;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:13;a:14:{s:2:\"id\";i:15052;s:5:\"title\";s:36:\"Flooring Company &#8211; Single post\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/08/Single.png\";s:12:\"tmpl_created\";i:1597738858;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/flooring-company-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:688;s:11:\"trend_index\";i:175;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:14;a:14:{s:2:\"id\";i:5693;s:5:\"title\";s:5:\"FAQ 9\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_1.png\";s:12:\"tmpl_created\";i:1520443567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:200;s:11:\"trend_index\";i:198;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:15;a:14:{s:2:\"id\";i:15007;s:5:\"title\";s:31:\"Flooring Company &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/08/Header.png\";s:12:\"tmpl_created\";i:1597738896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/flooring-company-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:48:\"[\"Flooring company\",\"Flooring website\",\"header\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:685;s:11:\"trend_index\";i:192;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:16;a:14:{s:2:\"id\";i:5703;s:5:\"title\";s:6:\"FAQ 13\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_2.png\";s:12:\"tmpl_created\";i:1520443569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/faq-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:28;s:11:\"trend_index\";i:25;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:17;a:14:{s:2:\"id\";i:15017;s:5:\"title\";s:31:\"Flooring Company &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/08/Footer.png\";s:12:\"tmpl_created\";i:1597738933;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/flooring-company-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:48:\"[\"Flooring company\",\"Flooring website\",\"footer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:632;s:11:\"trend_index\";i:83;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:18;a:14:{s:2:\"id\";i:5711;s:5:\"title\";s:5:\"FAQ 1\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_2.png\";s:12:\"tmpl_created\";i:1520443571;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:192;s:11:\"trend_index\";i:265;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:19;a:14:{s:2:\"id\";i:10190;s:5:\"title\";s:30:\"Classic | Register | Subscribe\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/engage_small.png\";s:12:\"tmpl_created\";i:1547885703;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-register-subscribe-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:246;s:11:\"trend_index\";i:137;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:20;a:14:{s:2:\"id\";i:15042;s:5:\"title\";s:32:\"Flooring Company &#8211; Archive\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/08/Blog.png\";s:12:\"tmpl_created\";i:1597739084;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/blocks/flooring-company-archive/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:635;s:11:\"trend_index\";i:88;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:21;a:14:{s:2:\"id\";i:5719;s:5:\"title\";s:5:\"FAQ 4\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_3.png\";s:12:\"tmpl_created\";i:1520443573;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:119;s:11:\"trend_index\";i:145;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:22;a:14:{s:2:\"id\";i:15033;s:5:\"title\";s:28:\"Flooring Company &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/08/404.png\";s:12:\"tmpl_created\";i:1597739459;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/flooring-company-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:45:\"[\"404\",\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:724;s:11:\"trend_index\";i:306;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:23;a:14:{s:2:\"id\";i:5729;s:5:\"title\";s:5:\"FAQ 5\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_3.png\";s:12:\"tmpl_created\";i:1520443575;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:304;s:11:\"trend_index\";i:368;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:24;a:14:{s:2:\"id\";i:15075;s:5:\"title\";s:34:\"Slide-In | Menu | Flooring Company\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/08/PopUp-1.png\";s:12:\"tmpl_created\";i:1597739605;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/slide-in-menu-flooring-company/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:690;s:11:\"trend_index\";i:255;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:25;a:14:{s:2:\"id\";i:5737;s:5:\"title\";s:6:\"FAQ 10\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_4.png\";s:12:\"tmpl_created\";i:1520443576;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/faq-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:157;s:11:\"trend_index\";i:115;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:26;a:14:{s:2:\"id\";i:15062;s:5:\"title\";s:35:\"Fly-In | Sign up | Flooring Company\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/08/PopUp.png\";s:12:\"tmpl_created\";i:1597739629;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/fly-in-sign-up-flooring-company/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:725;s:11:\"trend_index\";i:337;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:27;a:14:{s:2:\"id\";i:5746;s:5:\"title\";s:6:\"FAQ 11\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_4.png\";s:12:\"tmpl_created\";i:1520443578;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/faq-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:195;s:11:\"trend_index\";i:167;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:28;a:14:{s:2:\"id\";i:5755;s:5:\"title\";s:5:\"FAQ 6\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_5.png\";s:12:\"tmpl_created\";i:1520443580;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:99;s:11:\"trend_index\";i:140;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:29;a:14:{s:2:\"id\";i:5764;s:5:\"title\";s:5:\"FAQ 7\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_5.png\";s:12:\"tmpl_created\";i:1520443582;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:315;s:11:\"trend_index\";i:315;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:30;a:14:{s:2:\"id\";i:10256;s:5:\"title\";s:20:\"Classic | Sale | Pop\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/fruit_small.png\";s:12:\"tmpl_created\";i:1547888909;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:431;s:11:\"trend_index\";i:465;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:31;a:14:{s:2:\"id\";i:5773;s:5:\"title\";s:7:\"Hero 11\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_1.png\";s:12:\"tmpl_created\";i:1520443584;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/hero-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:34;s:11:\"trend_index\";i:51;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:32;a:14:{s:2:\"id\";i:10267;s:5:\"title\";s:29:\"Classic | Contact | Christmas\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/christmas_small.png\";s:12:\"tmpl_created\";i:1547889047;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/classic-contact-christmas/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:305;s:11:\"trend_index\";i:216;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:33;a:14:{s:2:\"id\";i:5783;s:5:\"title\";s:7:\"Hero 10\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_2.png\";s:12:\"tmpl_created\";i:1520443586;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/hero-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:344;s:11:\"trend_index\";i:514;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:34;a:14:{s:2:\"id\";i:5792;s:5:\"title\";s:6:\"Hero 9\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_3.png\";s:12:\"tmpl_created\";i:1520443588;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:220;s:11:\"trend_index\";i:308;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:35;a:14:{s:2:\"id\";i:5801;s:5:\"title\";s:6:\"Hero 7\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_4.png\";s:12:\"tmpl_created\";i:1520443589;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:10:\"[\"header\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:16;s:11:\"trend_index\";i:14;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:36;a:14:{s:2:\"id\";i:5811;s:5:\"title\";s:6:\"Hero 8\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_5.png\";s:12:\"tmpl_created\";i:1520443591;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:116;s:11:\"trend_index\";i:63;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:37;a:14:{s:2:\"id\";i:10307;s:5:\"title\";s:43:\"Fly In | Promotion | Christmas | Teddy Bear\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/teddy_small.png\";s:12:\"tmpl_created\";i:1547893266;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/fly-in-promotion-christmas/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:599;s:11:\"trend_index\";i:578;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:38;a:14:{s:2:\"id\";i:5820;s:5:\"title\";s:9:\"Contact 2\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/contact_white_1.png\";s:12:\"tmpl_created\";i:1520443593;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:173;s:11:\"trend_index\";i:251;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:39;a:14:{s:2:\"id\";i:10318;s:5:\"title\";s:27:\"Classic | Contact | Bicycle\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2019/01/by_small.png\";s:12:\"tmpl_created\";i:1547893367;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/popups/classic-contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:336;s:11:\"trend_index\";i:398;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:40;a:14:{s:2:\"id\";i:5828;s:5:\"title\";s:9:\"Contact 3\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/contact_black_1.png\";s:12:\"tmpl_created\";i:1520443595;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:300;s:11:\"trend_index\";i:288;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:41;a:14:{s:2:\"id\";i:5836;s:5:\"title\";s:10:\"Contact 10\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/contact_white_2.png\";s:12:\"tmpl_created\";i:1520443597;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/contact-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:115;s:11:\"trend_index\";i:111;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:42;a:14:{s:2:\"id\";i:10339;s:5:\"title\";s:22:\"Fly In | Contact | Spa\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/spa_small.png\";s:12:\"tmpl_created\";i:1547893603;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/fly-in-contact-spa/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:397;s:11:\"trend_index\";i:600;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:43;a:14:{s:2:\"id\";i:15204;s:5:\"title\";s:24:\"Psychologist &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/09/404.jpg\";s:12:\"tmpl_created\";i:1600161419;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/psychologist-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:40:\"[\"404\",\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:44;a:14:{s:2:\"id\";i:5844;s:5:\"title\";s:10:\"Contact 11\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/contact_black_2.png\";s:12:\"tmpl_created\";i:1520443599;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/contact-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:285;s:11:\"trend_index\";i:317;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:45;a:14:{s:2:\"id\";i:10352;s:5:\"title\";s:23:\"Fly In | Contact | Wine\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/01/fly_wine_small.png\";s:12:\"tmpl_created\";i:1547915335;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/fly-in-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:440;s:11:\"trend_index\";i:445;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:46;a:14:{s:2:\"id\";i:15212;s:5:\"title\";s:28:\"Psychologist &#8211; Archive\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/09/Blog.jpg\";s:12:\"tmpl_created\";i:1600162340;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/psychologist-archive/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:47;a:14:{s:2:\"id\";i:5852;s:5:\"title\";s:6:\"CTA 34\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2018/03/form_1.png\";s:12:\"tmpl_created\";i:1520443600;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-34/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:8:\"[\"form\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:510;s:11:\"trend_index\";i:615;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:48;a:14:{s:2:\"id\";i:15219;s:5:\"title\";s:27:\"Psychologist &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/09/Footer.jpg\";s:12:\"tmpl_created\";i:1600163069;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/psychologist-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:43:\"[\"footer\",\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:49;a:14:{s:2:\"id\";i:5947;s:5:\"title\";s:7:\"Stats 8\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_1.png\";s:12:\"tmpl_created\";i:1520443621;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:343;s:11:\"trend_index\";i:466;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:50;a:14:{s:2:\"id\";i:10372;s:5:\"title\";s:29:\"Fly In | Register | Subscribe\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/phone_small.png\";s:12:\"tmpl_created\";i:1547915554;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/fly-in-register-subscribe-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:596;s:11:\"trend_index\";i:661;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:51;a:14:{s:2:\"id\";i:15230;s:5:\"title\";s:27:\"Psychologist &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/09/Header.png\";s:12:\"tmpl_created\";i:1600163444;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/psychologist-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:43:\"[\"header\",\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:52;a:14:{s:2:\"id\";i:5956;s:5:\"title\";s:7:\"Stats 7\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_black_1.png\";s:12:\"tmpl_created\";i:1520443623;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:504;s:11:\"trend_index\";i:421;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:53;a:14:{s:2:\"id\";i:10382;s:5:\"title\";s:35:\"Bottom Bar | Announcement | Cookies\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2019/01/bottom_pink_small.png\";s:12:\"tmpl_created\";i:1547916616;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/bottom-bar-announcement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:281;s:11:\"trend_index\";i:220;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:54;a:14:{s:2:\"id\";i:15240;s:5:\"title\";s:34:\"Psychologist &#8211; single post 1\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/09/Single-Post.png\";s:12:\"tmpl_created\";i:1600164087;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/psychologist-single-post-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:55;a:14:{s:2:\"id\";i:5963;s:5:\"title\";s:10:\"Features 7\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_2.png\";s:12:\"tmpl_created\";i:1520443626;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:63;s:11:\"trend_index\";i:60;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:56;a:14:{s:2:\"id\";i:15251;s:5:\"title\";s:34:\"Psychologist &#8211; single post 2\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2020/09/Single-Service-Page.png\";s:12:\"tmpl_created\";i:1600165179;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/psychologist-single-post-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:57;a:14:{s:2:\"id\";i:5974;s:5:\"title\";s:10:\"Features 4\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_3.png\";s:12:\"tmpl_created\";i:1520443629;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:62;s:11:\"trend_index\";i:103;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:58;a:14:{s:2:\"id\";i:15259;s:5:\"title\";s:31:\"Hello Bar | Menu | Psychologist\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/09/Menu-PopUp.png\";s:12:\"tmpl_created\";i:1600170209;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/hello-bar-menu-psychologist/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:59;a:14:{s:2:\"id\";i:5983;s:5:\"title\";s:10:\"Features 3\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_black_3.png\";s:12:\"tmpl_created\";i:1520443630;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:11:\"[\"featues\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:230;s:11:\"trend_index\";i:281;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:60;a:14:{s:2:\"id\";i:15272;s:5:\"title\";s:32:\"Classic | Contact | Psychologist\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/09/PopUp.png\";s:12:\"tmpl_created\";i:1600170487;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-contact-psychologist/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:61;a:14:{s:2:\"id\";i:5991;s:5:\"title\";s:11:\"Features 10\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_4.png\";s:12:\"tmpl_created\";i:1520443632;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/features-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:123;s:11:\"trend_index\";i:174;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:62;a:14:{s:2:\"id\";i:5999;s:5:\"title\";s:7:\"Team 14\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_10.png\";s:12:\"tmpl_created\";i:1520443634;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:89;s:11:\"trend_index\";i:135;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:63;a:14:{s:2:\"id\";i:10434;s:5:\"title\";s:27:\"Classic | Sale | Headphones\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/head_small.png\";s:12:\"tmpl_created\";i:1547961950;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:369;s:11:\"trend_index\";i:327;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:64;a:14:{s:2:\"id\";i:6008;s:5:\"title\";s:6:\"Team 6\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_10.png\";s:12:\"tmpl_created\";i:1520443636;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/team-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:66;s:11:\"trend_index\";i:99;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:65;a:14:{s:2:\"id\";i:10444;s:5:\"title\";s:17:\"Classic | Contact\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/plant_small.png\";s:12:\"tmpl_created\";i:1547962029;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/popups/classic-contact-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:396;s:11:\"trend_index\";i:484;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:66;a:14:{s:2:\"id\";i:6027;s:5:\"title\";s:7:\"About 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_1-1.png\";s:12:\"tmpl_created\";i:1520443639;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/about-5-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:39;s:11:\"trend_index\";i:49;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:67;a:14:{s:2:\"id\";i:6036;s:5:\"title\";s:7:\"About 6\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_1-1.png\";s:12:\"tmpl_created\";i:1520443641;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/about-6-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:86;s:11:\"trend_index\";i:85;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:68;a:14:{s:2:\"id\";i:10467;s:5:\"title\";s:27:\"Bottom Bar | Contact | Lego\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/tro_small.png\";s:12:\"tmpl_created\";i:1547962277;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/bottom-bar-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:669;s:11:\"trend_index\";i:694;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:69;a:14:{s:2:\"id\";i:6044;s:5:\"title\";s:11:\"Features 11\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_5.png\";s:12:\"tmpl_created\";i:1520443643;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/features-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:65;s:11:\"trend_index\";i:71;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:70;a:14:{s:2:\"id\";i:6053;s:5:\"title\";s:10:\"Features 1\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_black_5.png\";s:12:\"tmpl_created\";i:1520443645;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:168;s:11:\"trend_index\";i:205;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:71;a:14:{s:2:\"id\";i:10487;s:5:\"title\";s:18:\"Slide In | Contact\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/acc_small.png\";s:12:\"tmpl_created\";i:1547964527;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/slide-in-contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:520;s:11:\"trend_index\";i:503;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:72;a:14:{s:2:\"id\";i:6063;s:5:\"title\";s:7:\"Stats 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_2.png\";s:12:\"tmpl_created\";i:1520443647;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:161;s:11:\"trend_index\";i:257;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:73;a:14:{s:2:\"id\";i:10498;s:5:\"title\";s:14:\"Classic | Sale\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/pink_small-1.png\";s:12:\"tmpl_created\";i:1547964616;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:416;s:11:\"trend_index\";i:304;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:74;a:14:{s:2:\"id\";i:6071;s:5:\"title\";s:8:\"Stats 13\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_3.png\";s:12:\"tmpl_created\";i:1520443649;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/stats-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:160;s:11:\"trend_index\";i:242;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:75;a:14:{s:2:\"id\";i:6079;s:5:\"title\";s:7:\"Stats 3\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_4.png\";s:12:\"tmpl_created\";i:1520443651;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:269;s:11:\"trend_index\";i:350;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:76;a:14:{s:2:\"id\";i:10519;s:5:\"title\";s:27:\"Hello Bar | Promotion | App\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/app_small-1.png\";s:12:\"tmpl_created\";i:1547964801;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/hello-bar-promotion-app-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:549;s:11:\"trend_index\";i:456;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:77;a:14:{s:2:\"id\";i:6089;s:5:\"title\";s:7:\"Stats 4\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_5.png\";s:12:\"tmpl_created\";i:1520443653;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:183;s:11:\"trend_index\";i:292;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:78;a:14:{s:2:\"id\";i:6097;s:5:\"title\";s:7:\"Stats 6\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_black_2.png\";s:12:\"tmpl_created\";i:1520443655;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:262;s:11:\"trend_index\";i:209;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:79;a:14:{s:2:\"id\";i:6106;s:5:\"title\";s:7:\"Stats 2\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_6.png\";s:12:\"tmpl_created\";i:1520443657;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:337;s:11:\"trend_index\";i:443;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:80;a:14:{s:2:\"id\";i:6114;s:5:\"title\";s:7:\"Stats 1\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_black_6.png\";s:12:\"tmpl_created\";i:1520443659;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:378;s:11:\"trend_index\";i:439;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:81;a:14:{s:2:\"id\";i:6122;s:5:\"title\";s:7:\"About 8\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_2-1.png\";s:12:\"tmpl_created\";i:1520443661;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/about-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:36;s:11:\"trend_index\";i:45;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:82;a:14:{s:2:\"id\";i:10569;s:5:\"title\";s:15:\"Slide In | Sale\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/off_small.png\";s:12:\"tmpl_created\";i:1547967812;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/popups/slide-in-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:501;s:11:\"trend_index\";i:556;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:83;a:14:{s:2:\"id\";i:6135;s:5:\"title\";s:8:\"About 10\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_2.png\";s:12:\"tmpl_created\";i:1520443663;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:83;s:11:\"trend_index\";i:121;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:84;a:14:{s:2:\"id\";i:6144;s:5:\"title\";s:7:\"Team 17\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_11.png\";s:12:\"tmpl_created\";i:1520443664;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:155;s:11:\"trend_index\";i:277;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:85;a:14:{s:2:\"id\";i:10590;s:5:\"title\";s:19:\"Full Screen | Login\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/pass1_small.png\";s:12:\"tmpl_created\";i:1547967978;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/classic-login-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:470;s:11:\"trend_index\";i:411;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:86;a:14:{s:2:\"id\";i:6152;s:5:\"title\";s:7:\"Stats 9\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_black_1.png\";s:12:\"tmpl_created\";i:1520443666;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:241;s:11:\"trend_index\";i:233;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:87;a:14:{s:2:\"id\";i:10600;s:5:\"title\";s:18:\"Slide In | Contact\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/orange_small.png\";s:12:\"tmpl_created\";i:1547968080;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/slide-in-contact-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:459;s:11:\"trend_index\";i:530;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:88;a:14:{s:2:\"id\";i:6162;s:5:\"title\";s:11:\"Services 31\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_white_1.png\";s:12:\"tmpl_created\";i:1520443668;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-31/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:339;s:11:\"trend_index\";i:430;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:89;a:14:{s:2:\"id\";i:6170;s:5:\"title\";s:8:\"Stats 11\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_black_2.png\";s:12:\"tmpl_created\";i:1520443670;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/stats-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:332;s:11:\"trend_index\";i:419;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:90;a:14:{s:2:\"id\";i:10622;s:5:\"title\";s:34:\"Full Screen | Contact | Headphones\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/full_hear_small.png\";s:12:\"tmpl_created\";i:1547969678;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/full-screen-contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:528;s:11:\"trend_index\";i:459;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:91;a:14:{s:2:\"id\";i:6178;s:5:\"title\";s:8:\"Stats 10\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_white_2.png\";s:12:\"tmpl_created\";i:1520443676;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/stats-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:383;s:11:\"trend_index\";i:549;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:92;a:14:{s:2:\"id\";i:10633;s:5:\"title\";s:23:\"Slide In | Login | Lego\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/tro_small-1.png\";s:12:\"tmpl_created\";i:1547969858;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/slide-in-login/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:620;s:11:\"trend_index\";i:573;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:93;a:14:{s:2:\"id\";i:6186;s:5:\"title\";s:8:\"Stats 12\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_white_3.png\";s:12:\"tmpl_created\";i:1520443678;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/stats-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:486;s:11:\"trend_index\";i:586;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:94;a:14:{s:2:\"id\";i:10644;s:5:\"title\";s:26:\"Fly In | Contact | Webinar\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/blue_small-1.png\";s:12:\"tmpl_created\";i:1547970814;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/fly-in-contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:456;s:11:\"trend_index\";i:436;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:95;a:14:{s:2:\"id\";i:6196;s:5:\"title\";s:10:\"Features 9\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_6.png\";s:12:\"tmpl_created\";i:1520443680;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:106;s:11:\"trend_index\";i:130;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:96;a:14:{s:2:\"id\";i:10654;s:5:\"title\";s:31:\"Full Screen | Login | Christmas\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2019/01/full_login_small.png\";s:12:\"tmpl_created\";i:1547970917;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/full-screen-login-christmas/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:615;s:11:\"trend_index\";i:638;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:97;a:14:{s:2:\"id\";i:6204;s:5:\"title\";s:10:\"Features 8\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_black_6.png\";s:12:\"tmpl_created\";i:1520443681;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:213;s:11:\"trend_index\";i:170;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:98;a:14:{s:2:\"id\";i:10664;s:5:\"title\";s:34:\"Slide In | Contact | Gym | Fitness\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/slide_gym_small.png\";s:12:\"tmpl_created\";i:1547973928;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/slide-in-contact-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:515;s:11:\"trend_index\";i:517;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:99;a:14:{s:2:\"id\";i:6212;s:5:\"title\";s:11:\"Features 12\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_7.png\";s:12:\"tmpl_created\";i:1520443684;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/features-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:76;s:11:\"trend_index\";i:67;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:100;a:14:{s:2:\"id\";i:10675;s:5:\"title\";s:35:\"Full Screen | Login | Gym | Fitness\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/01/gym_full_small.png\";s:12:\"tmpl_created\";i:1547974110;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/full-screen-login-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:496;s:11:\"trend_index\";i:510;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:101;a:14:{s:2:\"id\";i:6220;s:5:\"title\";s:10:\"Features 2\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_8.png\";s:12:\"tmpl_created\";i:1520443685;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:82;s:11:\"trend_index\";i:156;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:102;a:14:{s:2:\"id\";i:6230;s:5:\"title\";s:6:\"Hero 6\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_white_1.png\";s:12:\"tmpl_created\";i:1520443687;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:379;s:11:\"trend_index\";i:399;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:103;a:14:{s:2:\"id\";i:9719;s:5:\"title\";s:30:\"Classic | Subscribe | Register\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/01/register_small.png\";s:12:\"tmpl_created\";i:1547976107;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/classic-subscribe-register/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:414;s:11:\"trend_index\";i:194;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:104;a:14:{s:2:\"id\";i:6239;s:5:\"title\";s:6:\"Hero 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_1.png\";s:12:\"tmpl_created\";i:1520443689;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:26;s:11:\"trend_index\";i:24;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:105;a:14:{s:2:\"id\";i:6249;s:5:\"title\";s:6:\"Hero 5\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_2.png\";s:12:\"tmpl_created\";i:1520443691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:56;s:11:\"trend_index\";i:87;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:106;a:14:{s:2:\"id\";i:6258;s:5:\"title\";s:6:\"Hero 4\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_3.png\";s:12:\"tmpl_created\";i:1520443693;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:428;s:11:\"trend_index\";i:591;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:107;a:14:{s:2:\"id\";i:10137;s:5:\"title\";s:34:\"Full Screen | Contact | Restaurant\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/rest_small.png\";s:12:\"tmpl_created\";i:1547976342;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/full-screen-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:527;s:11:\"trend_index\";i:534;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:108;a:14:{s:2:\"id\";i:6266;s:5:\"title\";s:6:\"Hero 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_4.png\";s:12:\"tmpl_created\";i:1520443695;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:53;s:11:\"trend_index\";i:90;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:109;a:14:{s:2:\"id\";i:10244;s:5:\"title\";s:17:\"Bottom Bar | Sale\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/wow_small.png\";s:12:\"tmpl_created\";i:1547976402;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/bottom-bar-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:579;s:11:\"trend_index\";i:624;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:110;a:14:{s:2:\"id\";i:6274;s:5:\"title\";s:6:\"Hero 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_5.png\";s:12:\"tmpl_created\";i:1520443698;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:95;s:11:\"trend_index\";i:89;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:111;a:14:{s:2:\"id\";i:6017;s:5:\"title\";s:6:\"CTA 14\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_14.png\";s:12:\"tmpl_created\";i:1520520331;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:150;s:11:\"trend_index\";i:155;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:112;a:14:{s:2:\"id\";i:10127;s:5:\"title\";s:35:\"Fly In | Announcement | Maintenance\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/pizza_small.png\";s:12:\"tmpl_created\";i:1547984061;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/fly-in-announcement-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:637;s:11:\"trend_index\";i:666;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:113;a:14:{s:2:\"id\";i:4826;s:5:\"title\";s:14:\"Testimonial 24\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_1.png\";s:12:\"tmpl_created\";i:1520520544;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/testimonial-24-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:254;s:11:\"trend_index\";i:309;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:114;a:14:{s:2:\"id\";i:4835;s:5:\"title\";s:14:\"Testimonial 16\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_1.png\";s:12:\"tmpl_created\";i:1520520546;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:381;s:11:\"trend_index\";i:423;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:115;a:14:{s:2:\"id\";i:4843;s:5:\"title\";s:14:\"Testimonial 18\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_2.png\";s:12:\"tmpl_created\";i:1520520548;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:409;s:11:\"trend_index\";i:492;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:116;a:14:{s:2:\"id\";i:4854;s:5:\"title\";s:14:\"Testimonial 13\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_2.png\";s:12:\"tmpl_created\";i:1520520549;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:580;s:11:\"trend_index\";i:610;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:117;a:14:{s:2:\"id\";i:4863;s:5:\"title\";s:14:\"Testimonial 19\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_3.png\";s:12:\"tmpl_created\";i:1520520551;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-19/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:244;s:11:\"trend_index\";i:343;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:118;a:14:{s:2:\"id\";i:10776;s:5:\"title\";s:33:\"Fly In | Contact | Social | Share\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/01/social1_small.png\";s:12:\"tmpl_created\";i:1548047055;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/fly-in-contact-social-share/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:640;s:11:\"trend_index\";i:660;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:119;a:14:{s:2:\"id\";i:4871;s:5:\"title\";s:14:\"Testimonial 12\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_3.png\";s:12:\"tmpl_created\";i:1520520552;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:245;s:11:\"trend_index\";i:329;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:120;a:14:{s:2:\"id\";i:10785;s:5:\"title\";s:33:\"Fly In | Contact | Social | Share\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/01/social2_small.png\";s:12:\"tmpl_created\";i:1548047593;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/fly-in-contact-social-share-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:455;s:11:\"trend_index\";i:524;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:121;a:14:{s:2:\"id\";i:4880;s:5:\"title\";s:14:\"Testimonial 20\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/customers-1.jpg\";s:12:\"tmpl_created\";i:1520520554;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-20/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:394;s:11:\"trend_index\";i:427;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:122;a:14:{s:2:\"id\";i:4889;s:5:\"title\";s:14:\"Testimonial 11\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/customers-2.jpg\";s:12:\"tmpl_created\";i:1520520556;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:513;s:11:\"trend_index\";i:537;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:123;a:14:{s:2:\"id\";i:4897;s:5:\"title\";s:14:\"Testimonial 21\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_5.png\";s:12:\"tmpl_created\";i:1520520557;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-21/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:71;s:11:\"trend_index\";i:69;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:124;a:14:{s:2:\"id\";i:4905;s:5:\"title\";s:14:\"Testimonial 22\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_6.png\";s:12:\"tmpl_created\";i:1520520559;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-22/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:114;s:11:\"trend_index\";i:138;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:125;a:14:{s:2:\"id\";i:4913;s:5:\"title\";s:14:\"Testimonial 23\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_7.png\";s:12:\"tmpl_created\";i:1520520561;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-23/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:232;s:11:\"trend_index\";i:291;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:126;a:14:{s:2:\"id\";i:4921;s:5:\"title\";s:14:\"Testimonial 10\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_5.png\";s:12:\"tmpl_created\";i:1520520562;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:209;s:11:\"trend_index\";i:218;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:127;a:14:{s:2:\"id\";i:4929;s:5:\"title\";s:14:\"Testimonial 24\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_8.png\";s:12:\"tmpl_created\";i:1520520564;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-24/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:43;s:11:\"trend_index\";i:70;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:128;a:14:{s:2:\"id\";i:4939;s:5:\"title\";s:13:\"Testimonial 9\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_8.png\";s:12:\"tmpl_created\";i:1520520565;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/testimonial-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:90;s:11:\"trend_index\";i:133;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:129;a:14:{s:2:\"id\";i:4947;s:5:\"title\";s:14:\"Testimonial 27\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_9.png\";s:12:\"tmpl_created\";i:1520520567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-27/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:197;s:11:\"trend_index\";i:313;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:130;a:14:{s:2:\"id\";i:4955;s:5:\"title\";s:14:\"Testimonial 29\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_9.png\";s:12:\"tmpl_created\";i:1520520569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-29/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:346;s:11:\"trend_index\";i:416;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:131;a:14:{s:2:\"id\";i:4963;s:5:\"title\";s:14:\"Testimonial 25\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_10.png\";s:12:\"tmpl_created\";i:1520520570;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/testimonial-25-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:391;s:11:\"trend_index\";i:401;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:132;a:14:{s:2:\"id\";i:4971;s:5:\"title\";s:14:\"Testimonial 26\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_11.png\";s:12:\"tmpl_created\";i:1520520572;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-26/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:594;s:11:\"trend_index\";i:664;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:133;a:14:{s:2:\"id\";i:4979;s:5:\"title\";s:14:\"Testimonial 15\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_10.png\";s:12:\"tmpl_created\";i:1520520573;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:529;s:11:\"trend_index\";i:648;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:134;a:14:{s:2:\"id\";i:4987;s:5:\"title\";s:14:\"Testimonial 17\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_12-1.png\";s:12:\"tmpl_created\";i:1520520575;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:151;s:11:\"trend_index\";i:239;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:135;a:14:{s:2:\"id\";i:4995;s:5:\"title\";s:14:\"Testimonial 14\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_12.png\";s:12:\"tmpl_created\";i:1520520577;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:372;s:11:\"trend_index\";i:509;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:136;a:14:{s:2:\"id\";i:5007;s:5:\"title\";s:11:\"Portfolio 7\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_1.png\";s:12:\"tmpl_created\";i:1520520578;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:41;s:11:\"trend_index\";i:36;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:137;a:14:{s:2:\"id\";i:5019;s:5:\"title\";s:11:\"Portfolio 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_1.png\";s:12:\"tmpl_created\";i:1520520580;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:164;s:11:\"trend_index\";i:207;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:138;a:14:{s:2:\"id\";i:5027;s:5:\"title\";s:12:\"Portfolio 11\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_2.png\";s:12:\"tmpl_created\";i:1520520581;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:301;s:11:\"trend_index\";i:389;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:139;a:14:{s:2:\"id\";i:10794;s:5:\"title\";s:34:\"Classic | Contact | Social | Share\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/01/s_small.png\";s:12:\"tmpl_created\";i:1548067619;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-contact-social-share/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:430;s:11:\"trend_index\";i:296;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:140;a:14:{s:2:\"id\";i:5037;s:5:\"title\";s:12:\"Portfolio 12\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_3.png\";s:12:\"tmpl_created\";i:1520520583;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:265;s:11:\"trend_index\";i:346;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:141;a:14:{s:2:\"id\";i:5057;s:5:\"title\";s:12:\"Portfolio 13\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_4.png\";s:12:\"tmpl_created\";i:1520520586;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:231;s:11:\"trend_index\";i:334;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:142;a:14:{s:2:\"id\";i:5071;s:5:\"title\";s:12:\"Portfolio 14\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_5.png\";s:12:\"tmpl_created\";i:1520520588;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:272;s:11:\"trend_index\";i:271;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:143;a:14:{s:2:\"id\";i:10871;s:5:\"title\";s:20:\"Bottom Bar | Contact\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/01/m_small.png\";s:12:\"tmpl_created\";i:1548074396;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/bottom-bar-contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:649;s:11:\"trend_index\";i:681;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:144;a:14:{s:2:\"id\";i:5082;s:5:\"title\";s:11:\"Portfolio 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_4.png\";s:12:\"tmpl_created\";i:1520520589;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:490;s:11:\"trend_index\";i:448;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:145;a:14:{s:2:\"id\";i:10936;s:5:\"title\";s:25:\"Full Screen | Toggle Menu\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/menu_small.png\";s:12:\"tmpl_created\";i:1548874587;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/full-screen-toggle-menu/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:442;s:11:\"trend_index\";i:511;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:146;a:14:{s:2:\"id\";i:5090;s:5:\"title\";s:12:\"Portfolio 15\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_6.png\";s:12:\"tmpl_created\";i:1520520591;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:171;s:11:\"trend_index\";i:191;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:147;a:14:{s:2:\"id\";i:5098;s:5:\"title\";s:12:\"Portfolio 16\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_7.png\";s:12:\"tmpl_created\";i:1520520593;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:152;s:11:\"trend_index\";i:142;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:148;a:14:{s:2:\"id\";i:5107;s:5:\"title\";s:11:\"Portfolio 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_7.png\";s:12:\"tmpl_created\";i:1520520594;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:359;s:11:\"trend_index\";i:433;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:149;a:14:{s:2:\"id\";i:10964;s:5:\"title\";s:59:\"Classic | Promotion | Coupon | Love | Valentine&#8217;s Day\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/02/love_small.png\";s:12:\"tmpl_created\";i:1550039106;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/popups/classic-promotion-coupon/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:581;s:11:\"trend_index\";i:486;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:150;a:14:{s:2:\"id\";i:5115;s:5:\"title\";s:12:\"Portfolio 17\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_8.png\";s:12:\"tmpl_created\";i:1520520596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:22;s:11:\"trend_index\";i:18;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:151;a:14:{s:2:\"id\";i:10992;s:5:\"title\";s:59:\"Classic | Promotion | Coupon | Love | Valentine&#8217;s Day\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/02/h_small.png\";s:12:\"tmpl_created\";i:1550072007;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/classic-promotion-coupon-love-valentines-day/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:631;s:11:\"trend_index\";i:698;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:152;a:14:{s:2:\"id\";i:5125;s:5:\"title\";s:11:\"Portfolio 6\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_8.png\";s:12:\"tmpl_created\";i:1520520597;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:223;s:11:\"trend_index\";i:236;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:153;a:14:{s:2:\"id\";i:11005;s:5:\"title\";s:50:\"Classic | Promotion | Love | Valentine&#8217;s Day\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/02/bear_small.png\";s:12:\"tmpl_created\";i:1550073303;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-promotion-love-valentines-day/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:628;s:11:\"trend_index\";i:609;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:154;a:14:{s:2:\"id\";i:5133;s:5:\"title\";s:12:\"Portfolio 18\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_9.png\";s:12:\"tmpl_created\";i:1520520599;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:170;s:11:\"trend_index\";i:149;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:155;a:14:{s:2:\"id\";i:5141;s:5:\"title\";s:12:\"Portfolio 10\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_10.png\";s:12:\"tmpl_created\";i:1520520601;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:371;s:11:\"trend_index\";i:454;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:156;a:14:{s:2:\"id\";i:5149;s:5:\"title\";s:11:\"Portfolio 2\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_10.png\";s:12:\"tmpl_created\";i:1520520602;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:365;s:11:\"trend_index\";i:546;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:157;a:14:{s:2:\"id\";i:5542;s:5:\"title\";s:6:\"CTA 19\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_1.png\";s:12:\"tmpl_created\";i:1520520681;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-19/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:159;s:11:\"trend_index\";i:212;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:158;a:14:{s:2:\"id\";i:5550;s:5:\"title\";s:6:\"CTA 33\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_1.png\";s:12:\"tmpl_created\";i:1520520682;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-33/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:249;s:11:\"trend_index\";i:268;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:159;a:14:{s:2:\"id\";i:5558;s:5:\"title\";s:5:\"CTA 1\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_2.png\";s:12:\"tmpl_created\";i:1520520684;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:135;s:11:\"trend_index\";i:146;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:160;a:14:{s:2:\"id\";i:5567;s:5:\"title\";s:5:\"CTA 2\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_2.png\";s:12:\"tmpl_created\";i:1520520685;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:146;s:11:\"trend_index\";i:80;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:161;a:14:{s:2:\"id\";i:11231;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/07/Post_small1.png\";s:12:\"tmpl_created\";i:1564642380;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/digital-agency/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:166;s:11:\"trend_index\";i:158;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:162;a:14:{s:2:\"id\";i:5583;s:5:\"title\";s:6:\"CTA 26\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_3.png\";s:12:\"tmpl_created\";i:1520520689;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-26/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:131;s:11:\"trend_index\";i:42;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:163;a:14:{s:2:\"id\";i:11220;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/08/Archive_small1.png\";s:12:\"tmpl_created\";i:1564642385;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/digital-agency-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:121;s:11:\"trend_index\";i:48;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:164;a:14:{s:2:\"id\";i:5591;s:5:\"title\";s:5:\"CTA 5\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_4.png\";s:12:\"tmpl_created\";i:1520520691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:128;s:11:\"trend_index\";i:179;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:165;a:14:{s:2:\"id\";i:11204;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/07/404_small.jpg\";s:12:\"tmpl_created\";i:1564642389;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/digital-agency-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:36:\"[\"404\",\"Digital Agency\",\"marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:327;s:11:\"trend_index\";i:237;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:166;a:14:{s:2:\"id\";i:5599;s:5:\"title\";s:5:\"CTA 6\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_4.png\";s:12:\"tmpl_created\";i:1520520693;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:251;s:11:\"trend_index\";i:234;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:167;a:14:{s:2:\"id\";i:11198;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-digital-marketing-agency.png\";s:12:\"tmpl_created\";i:1564642395;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/digital-agency-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:39:\"[\"Digital Agency\",\"header\",\"marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:46;s:11:\"trend_index\";i:17;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:168;a:14:{s:2:\"id\";i:5607;s:5:\"title\";s:6:\"CTA 13\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_5.png\";s:12:\"tmpl_created\";i:1520520695;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:51;s:11:\"trend_index\";i:9;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:169;a:14:{s:2:\"id\";i:11192;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/07/Footer_small.jpg\";s:12:\"tmpl_created\";i:1564642399;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/digital-agency-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:39:\"[\"Digital Agency\",\"footer\",\"marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:191;s:11:\"trend_index\";i:159;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:170;a:14:{s:2:\"id\";i:5634;s:5:\"title\";s:6:\"CTA 24\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_6.png\";s:12:\"tmpl_created\";i:1520520699;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-24/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:172;s:11:\"trend_index\";i:256;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:171;a:14:{s:2:\"id\";i:5642;s:5:\"title\";s:6:\"CTA 25\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_6.png\";s:12:\"tmpl_created\";i:1520520701;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-25/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:212;s:11:\"trend_index\";i:246;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:172;a:14:{s:2:\"id\";i:5650;s:5:\"title\";s:5:\"CTA 9\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_7.png\";s:12:\"tmpl_created\";i:1520520702;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:91;s:11:\"trend_index\";i:81;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:173;a:14:{s:2:\"id\";i:5658;s:5:\"title\";s:5:\"CTA 8\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_7.png\";s:12:\"tmpl_created\";i:1520520704;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:180;s:11:\"trend_index\";i:163;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:174;a:14:{s:2:\"id\";i:5667;s:5:\"title\";s:5:\"CTA 3\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_8.png\";s:12:\"tmpl_created\";i:1520520705;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:158;s:11:\"trend_index\";i:182;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:175;a:14:{s:2:\"id\";i:5675;s:5:\"title\";s:5:\"CTA 4\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_8.png\";s:12:\"tmpl_created\";i:1520520707;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:361;s:11:\"trend_index\";i:418;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:176;a:14:{s:2:\"id\";i:5860;s:5:\"title\";s:6:\"CTA 17\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_9.png\";s:12:\"tmpl_created\";i:1520520746;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:125;s:11:\"trend_index\";i:86;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:177;a:14:{s:2:\"id\";i:5869;s:5:\"title\";s:6:\"CTA 18\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_10.png\";s:12:\"tmpl_created\";i:1520520747;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:312;s:11:\"trend_index\";i:374;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:178;a:14:{s:2:\"id\";i:5877;s:5:\"title\";s:6:\"CTA 16\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_10.png\";s:12:\"tmpl_created\";i:1520520749;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:505;s:11:\"trend_index\";i:564;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:179;a:14:{s:2:\"id\";i:11468;s:5:\"title\";s:20:\"Classic | Sale | Gym\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/08/PopUp_Small.png\";s:12:\"tmpl_created\";i:1567393182;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/classic-sale-gym/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:643;s:11:\"trend_index\";i:676;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:180;a:14:{s:2:\"id\";i:5885;s:5:\"title\";s:6:\"CTA 15\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_11.png\";s:12:\"tmpl_created\";i:1520520751;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:270;s:11:\"trend_index\";i:402;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:181;a:14:{s:2:\"id\";i:11461;s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-gym-and-fitness.png\";s:12:\"tmpl_created\";i:1567393219;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:100:\"https://library.elementor.com/blocks/gym/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:16:\"[\"Gym\",\"header\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:228;s:11:\"trend_index\";i:124;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:182;a:14:{s:2:\"id\";i:5893;s:5:\"title\";s:6:\"CTA 21\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_12.png\";s:12:\"tmpl_created\";i:1520520752;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-21/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:250;s:11:\"trend_index\";i:326;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:183;a:14:{s:2:\"id\";i:11453;s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/08/Footer_Small.png\";s:12:\"tmpl_created\";i:1567393224;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/gym-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:16:\"[\"footer\",\"Gym\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:296;s:11:\"trend_index\";i:164;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:184;a:14:{s:2:\"id\";i:5904;s:5:\"title\";s:6:\"CTA 27\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_13.png\";s:12:\"tmpl_created\";i:1520520754;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-27/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:473;s:11:\"trend_index\";i:567;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:185;a:14:{s:2:\"id\";i:11445;s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/08/Post_Small.png\";s:12:\"tmpl_created\";i:1567393229;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/gym-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:432;s:11:\"trend_index\";i:428;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:186;a:14:{s:2:\"id\";i:5912;s:5:\"title\";s:6:\"CTA 28\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_11.png\";s:12:\"tmpl_created\";i:1520520755;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-28/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:602;s:11:\"trend_index\";i:662;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:187;a:14:{s:2:\"id\";i:11435;s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/08/Archiv_Small.png\";s:12:\"tmpl_created\";i:1567393296;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/gym-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:410;s:11:\"trend_index\";i:471;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:188;a:14:{s:2:\"id\";i:5921;s:5:\"title\";s:6:\"CTA 12\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_14.png\";s:12:\"tmpl_created\";i:1520520757;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:261;s:11:\"trend_index\";i:338;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:189;a:14:{s:2:\"id\";i:11424;s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/08/404_Small.png\";s:12:\"tmpl_created\";i:1567393309;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/gym-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:13:\"[\"404\",\"Gym\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:630;s:11:\"trend_index\";i:629;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:190;a:14:{s:2:\"id\";i:5930;s:5:\"title\";s:6:\"CTA 11\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_15.png\";s:12:\"tmpl_created\";i:1520520758;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:73;s:11:\"trend_index\";i:120;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:191;a:14:{s:2:\"id\";i:5939;s:5:\"title\";s:6:\"CTA 10\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_13-1.png\";s:12:\"tmpl_created\";i:1520520760;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:177;s:11:\"trend_index\";i:186;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:192;a:14:{s:2:\"id\";i:7596;s:5:\"title\";s:8:\"Header 1\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.12.jpg\";s:12:\"tmpl_created\";i:1521546999;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:10:\"[\"header\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:35;s:11:\"trend_index\";i:33;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:193;a:14:{s:2:\"id\";i:7615;s:5:\"title\";s:8:\"Header 2\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.1.jpg\";s:12:\"tmpl_created\";i:1521547237;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:10:\"[\"header\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:29;s:11:\"trend_index\";i:29;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:194;a:14:{s:2:\"id\";i:7627;s:5:\"title\";s:8:\"Footer 8\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/footer_hero_1.png\";s:12:\"tmpl_created\";i:1521547332;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/footer-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:10:\"[\"footer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:113;s:11:\"trend_index\";i:94;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:195;a:14:{s:2:\"id\";i:11822;s:5:\"title\";s:30:\"Full Screen | Menu | Portfolio\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/09/PopUp_small.png\";s:12:\"tmpl_created\";i:1569429896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/full-screen-menu-portfolio/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:606;s:11:\"trend_index\";i:628;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:196;a:14:{s:2:\"id\";i:7638;s:5:\"title\";s:8:\"Footer 9\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/footer_hero_2.png\";s:12:\"tmpl_created\";i:1521547502;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/footer-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:10:\"[\"footer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:120;s:11:\"trend_index\";i:136;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:197;a:14:{s:2:\"id\";i:11877;s:5:\"title\";s:27:\"Portfolio &#8211; Project 3\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Project3_small.png\";s:12:\"tmpl_created\";i:1569429954;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/portfolio-project-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:626;s:11:\"trend_index\";i:613;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:198;a:14:{s:2:\"id\";i:7663;s:5:\"title\";s:13:\"Single Post 2\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/single_post_2_v2.jpg\";s:12:\"tmpl_created\";i:1521547761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:24:\"[\"Blog\",\"Post\",\"Single\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:50;s:11:\"trend_index\";i:65;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:199;a:14:{s:2:\"id\";i:11870;s:5:\"title\";s:27:\"Portfolio &#8211; Project 2\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Project2_small.png\";s:12:\"tmpl_created\";i:1569429964;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/portfolio-project-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:604;s:11:\"trend_index\";i:619;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:200;a:14:{s:2:\"id\";i:7650;s:5:\"title\";s:13:\"Single Post 1\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/single_post_1_v2.jpg\";s:12:\"tmpl_created\";i:1521557736;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:24:\"[\"Blog\",\"Post\",\"Single\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:109;s:11:\"trend_index\";i:113;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:201;a:14:{s:2:\"id\";i:11861;s:5:\"title\";s:27:\"Portfolio &#8211; Project 1\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Project1_small.png\";s:12:\"tmpl_created\";i:1569429975;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/portfolio-project-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:593;s:11:\"trend_index\";i:703;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:202;a:14:{s:2:\"id\";i:7686;s:5:\"title\";s:12:\"Blog Posts 1\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2018/03/blog_posts.png\";s:12:\"tmpl_created\";i:1521558047;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/blog-posts-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:26:\"[\"archive\",\"Blog\",\"posts\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:124;s:11:\"trend_index\";i:193;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:203;a:14:{s:2:\"id\";i:11854;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/09/Post_small.png\";s:12:\"tmpl_created\";i:1569429983;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/portfolio/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:472;s:11:\"trend_index\";i:404;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:204;a:14:{s:2:\"id\";i:4676;s:5:\"title\";s:8:\"Footer 7\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/footer_7.png\";s:12:\"tmpl_created\";i:1522014215;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/footer_7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:10:\"[\"footer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:235;s:11:\"trend_index\";i:190;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:205;a:14:{s:2:\"id\";i:11847;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/09/Archiv_small.png\";s:12:\"tmpl_created\";i:1569430010;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:326;s:11:\"trend_index\";i:222;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:206;a:14:{s:2:\"id\";i:7997;s:5:\"title\";s:10:\"footer 014\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.1.jpg\";s:12:\"tmpl_created\";i:1524582343;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/footer-014/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:79;s:11:\"trend_index\";i:35;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:207;a:14:{s:2:\"id\";i:11839;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/09/Header_small.png\";s:12:\"tmpl_created\";i:1569430015;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:43:\"[\"creative portfolio\",\"header\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:280;s:11:\"trend_index\";i:176;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:208;a:14:{s:2:\"id\";i:7982;s:5:\"title\";s:10:\"footer 013\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.2.jpg\";s:12:\"tmpl_created\";i:1524582468;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/footer-013/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:219;s:11:\"trend_index\";i:126;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:209;a:14:{s:2:\"id\";i:11832;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/09/Footer_small.png\";s:12:\"tmpl_created\";i:1569430019;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-19/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:43:\"[\"creative portfolio\",\"footer\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:298;s:11:\"trend_index\";i:144;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:210;a:14:{s:2:\"id\";i:7959;s:5:\"title\";s:10:\"footer 012\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.3.jpg\";s:12:\"tmpl_created\";i:1524582605;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/footer-012/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:185;s:11:\"trend_index\";i:181;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:211;a:14:{s:2:\"id\";i:11807;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/09/404_small.png\";s:12:\"tmpl_created\";i:1569430070;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-20/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:40:\"[\"404\",\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:514;s:11:\"trend_index\";i:360;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:212;a:14:{s:2:\"id\";i:7950;s:5:\"title\";s:10:\"footer 011\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.4.jpg\";s:12:\"tmpl_created\";i:1524582631;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/footer-011/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:255;s:11:\"trend_index\";i:235;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:213;a:14:{s:2:\"id\";i:7937;s:5:\"title\";s:10:\"footer 010\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.5.jpg\";s:12:\"tmpl_created\";i:1524582665;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/footer-010/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:203;s:11:\"trend_index\";i:154;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:214;a:14:{s:2:\"id\";i:11897;s:5:\"title\";s:27:\"Portfolio &#8211; Project 2\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Project2_small.png\";s:12:\"tmpl_created\";i:1569494236;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/portfolio-project-2-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:683;s:11:\"trend_index\";i:583;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:215;a:14:{s:2:\"id\";i:7927;s:5:\"title\";s:9:\"footer 09\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.6.jpg\";s:12:\"tmpl_created\";i:1524582691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-09/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:174;s:11:\"trend_index\";i:141;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:216;a:14:{s:2:\"id\";i:11890;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-design-portfolio.png\";s:12:\"tmpl_created\";i:1571907344;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:43:\"[\"creative portfolio\",\"header\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:323;s:11:\"trend_index\";i:213;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:217;a:14:{s:2:\"id\";i:7917;s:5:\"title\";s:9:\"footer 08\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.7.jpg\";s:12:\"tmpl_created\";i:1524582788;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-08/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:97;s:11:\"trend_index\";i:110;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:218;a:14:{s:2:\"id\";i:7904;s:5:\"title\";s:9:\"footer 07\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.8.jpg\";s:12:\"tmpl_created\";i:1524582814;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-07/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:204;s:11:\"trend_index\";i:226;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:219;a:14:{s:2:\"id\";i:7837;s:5:\"title\";s:9:\"footer 01\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.14.jpg\";s:12:\"tmpl_created\";i:1524582852;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:448;s:11:\"trend_index\";i:489;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:220;a:14:{s:2:\"id\";i:7852;s:5:\"title\";s:9:\"footer 02\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.13.jpg\";s:12:\"tmpl_created\";i:1524582875;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-02/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:216;s:11:\"trend_index\";i:188;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:221;a:14:{s:2:\"id\";i:7862;s:5:\"title\";s:9:\"footer 03\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.12.jpg\";s:12:\"tmpl_created\";i:1524582903;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-03/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:143;s:11:\"trend_index\";i:128;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:222;a:14:{s:2:\"id\";i:12212;s:5:\"title\";s:28:\"Law Firm &#8211; Single Post\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2019/11/single.png\";s:12:\"tmpl_created\";i:1572846914;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/law-firm-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:364;s:11:\"trend_index\";i:272;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:223;a:14:{s:2:\"id\";i:7871;s:5:\"title\";s:9:\"footer 04\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.11.jpg\";s:12:\"tmpl_created\";i:1524582927;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-04/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:107;s:11:\"trend_index\";i:125;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:224;a:14:{s:2:\"id\";i:12203;s:5:\"title\";s:30:\"Law Firm &#8211; Search Archiv\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/11/search_result.png\";s:12:\"tmpl_created\";i:1572846925;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/law-firm-search-archiv/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:533;s:11:\"trend_index\";i:540;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:225;a:14:{s:2:\"id\";i:7884;s:5:\"title\";s:9:\"footer 05\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.10.jpg\";s:12:\"tmpl_created\";i:1524582944;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-05/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:84;s:11:\"trend_index\";i:172;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:226;a:14:{s:2:\"id\";i:12194;s:5:\"title\";s:23:\"Law Firm &#8211; Header\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-law-firm.png\";s:12:\"tmpl_created\";i:1572846935;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/law-firm-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:27:\"[\"header\",\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:126;s:11:\"trend_index\";i:28;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:227;a:14:{s:2:\"id\";i:7892;s:5:\"title\";s:9:\"footer 06\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.9.jpg\";s:12:\"tmpl_created\";i:1524583015;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-06/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:127;s:11:\"trend_index\";i:224;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:228;a:14:{s:2:\"id\";i:12179;s:5:\"title\";s:23:\"Law Firm &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2019/11/footer.png\";s:12:\"tmpl_created\";i:1572846958;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/law-firm-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:27:\"[\"footer\",\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:418;s:11:\"trend_index\";i:294;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:229;a:14:{s:2:\"id\";i:4212;s:5:\"title\";s:11:\"Services 23\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_1.png\";s:12:\"tmpl_created\";i:1520443248;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-23/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:130;s:11:\"trend_index\";i:109;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:230;a:14:{s:2:\"id\";i:7825;s:5:\"title\";s:9:\"header 12\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.11.jpg\";s:12:\"tmpl_created\";i:1524583273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/header-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:75;s:11:\"trend_index\";i:52;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:231;a:14:{s:2:\"id\";i:12170;s:5:\"title\";s:23:\"Law Firm &#8211; Archiv\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2019/11/archiv.png\";s:12:\"tmpl_created\";i:1572846967;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/law-firm-archiv/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:423;s:11:\"trend_index\";i:377;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:232;a:14:{s:2:\"id\";i:4227;s:5:\"title\";s:11:\"Services 30\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_1.png\";s:12:\"tmpl_created\";i:1520443250;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-30/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:329;s:11:\"trend_index\";i:431;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:233;a:14:{s:2:\"id\";i:7812;s:5:\"title\";s:9:\"header 11\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.10.jpg\";s:12:\"tmpl_created\";i:1524583298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/header-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:111;s:11:\"trend_index\";i:97;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:234;a:14:{s:2:\"id\";i:12164;s:5:\"title\";s:20:\"Law Firm &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/11/404.png\";s:12:\"tmpl_created\";i:1572846979;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/law-firm-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:24:\"[\"404\",\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:679;s:11:\"trend_index\";i:642;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:235;a:14:{s:2:\"id\";i:4235;s:5:\"title\";s:11:\"Services 18\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_2.png\";s:12:\"tmpl_created\";i:1520443251;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:282;s:11:\"trend_index\";i:342;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:236;a:14:{s:2:\"id\";i:7724;s:5:\"title\";s:8:\"header 4\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.3.jpg\";s:12:\"tmpl_created\";i:1524583367;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:31;s:11:\"trend_index\";i:19;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:237;a:14:{s:2:\"id\";i:4244;s:5:\"title\";s:11:\"Services 26\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_2.png\";s:12:\"tmpl_created\";i:1520443253;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-26/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:483;s:11:\"trend_index\";i:548;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:238;a:14:{s:2:\"id\";i:7734;s:5:\"title\";s:8:\"header 5\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.4.jpg\";s:12:\"tmpl_created\";i:1524583436;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:40;s:11:\"trend_index\";i:34;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:239;a:14:{s:2:\"id\";i:4252;s:5:\"title\";s:10:\"Services 9\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_3.png\";s:12:\"tmpl_created\";i:1520443255;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/services-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:42;s:11:\"trend_index\";i:27;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:240;a:14:{s:2:\"id\";i:7771;s:5:\"title\";s:8:\"header 8\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.7.jpg\";s:12:\"tmpl_created\";i:1524583540;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:100;s:11:\"trend_index\";i:118;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:241;a:14:{s:2:\"id\";i:4260;s:5:\"title\";s:11:\"Services 25\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_3.png\";s:12:\"tmpl_created\";i:1520443257;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-25/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:176;s:11:\"trend_index\";i:162;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:242;a:14:{s:2:\"id\";i:7787;s:5:\"title\";s:8:\"header 9\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.8.jpg\";s:12:\"tmpl_created\";i:1524583598;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:108;s:11:\"trend_index\";i:98;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:243;a:14:{s:2:\"id\";i:4268;s:5:\"title\";s:10:\"Services 8\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_4.png\";s:12:\"tmpl_created\";i:1520443259;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/services-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:167;s:11:\"trend_index\";i:252;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:244;a:14:{s:2:\"id\";i:7801;s:5:\"title\";s:9:\"header 10\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.9.jpg\";s:12:\"tmpl_created\";i:1524583659;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/header-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:55;s:11:\"trend_index\";i:73;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:245;a:14:{s:2:\"id\";i:4276;s:5:\"title\";s:11:\"Services 24\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_4.png\";s:12:\"tmpl_created\";i:1520443261;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-24/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:342;s:11:\"trend_index\";i:347;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:246;a:14:{s:2:\"id\";i:7754;s:5:\"title\";s:8:\"header 7\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.6.jpg\";s:12:\"tmpl_created\";i:1524583712;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:96;s:11:\"trend_index\";i:254;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:247;a:14:{s:2:\"id\";i:4284;s:5:\"title\";s:10:\"Services 7\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_5.png\";s:12:\"tmpl_created\";i:1520443263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/services-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:30;s:11:\"trend_index\";i:8;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:248;a:14:{s:2:\"id\";i:7713;s:5:\"title\";s:8:\"header 3\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.2.jpg\";s:12:\"tmpl_created\";i:1524584780;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:47;s:11:\"trend_index\";i:37;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:249;a:14:{s:2:\"id\";i:4293;s:5:\"title\";s:10:\"Services 6\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_6.png\";s:12:\"tmpl_created\";i:1520443265;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/services-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:276;s:11:\"trend_index\";i:267;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:250;a:14:{s:2:\"id\";i:7744;s:5:\"title\";s:8:\"Header 6\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.5.jpg\";s:12:\"tmpl_created\";i:1524584784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:61;s:11:\"trend_index\";i:100;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:251;a:14:{s:2:\"id\";i:4302;s:5:\"title\";s:10:\"Services 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_7.png\";s:12:\"tmpl_created\";i:1520443266;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/services-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:58;s:11:\"trend_index\";i:46;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:252;a:14:{s:2:\"id\";i:12229;s:5:\"title\";s:33:\"Slide In | Law Firm | Information\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2019/11/popup.png\";s:12:\"tmpl_created\";i:1572847842;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/slide-in-law-firm-information/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:532;s:11:\"trend_index\";i:485;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:253;a:14:{s:2:\"id\";i:4313;s:5:\"title\";s:11:\"Services 13\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_8.png\";s:12:\"tmpl_created\";i:1520443268;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:118;s:11:\"trend_index\";i:91;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:254;a:14:{s:2:\"id\";i:8523;s:5:\"title\";s:11:\"404 page 06\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/006.jpg\";s:12:\"tmpl_created\";i:1526415291;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-06/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:309;s:11:\"trend_index\";i:376;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:255;a:14:{s:2:\"id\";i:12550;s:5:\"title\";s:32:\"Fly-in | Sale | Travel and Tours\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_s.png\";s:12:\"tmpl_created\";i:1575960263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/flyin-sale-travel-and-tours/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:704;s:11:\"trend_index\";i:678;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:256;a:14:{s:2:\"id\";i:4324;s:5:\"title\";s:11:\"Services 14\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_9.png\";s:12:\"tmpl_created\";i:1520443270;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:286;s:11:\"trend_index\";i:248;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:257;a:14:{s:2:\"id\";i:8524;s:5:\"title\";s:11:\"404 page 07\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/007.jpg\";s:12:\"tmpl_created\";i:1526415337;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-07/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:318;s:11:\"trend_index\";i:386;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:258;a:14:{s:2:\"id\";i:12540;s:5:\"title\";s:33:\"Classic | Menu | Travel and tours\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_Menu_s.png\";s:12:\"tmpl_created\";i:1575960267;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/classic-menu-travel-and-tours/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:638;s:11:\"trend_index\";i:621;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:259;a:14:{s:2:\"id\";i:4332;s:5:\"title\";s:11:\"Services 22\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_10.png\";s:12:\"tmpl_created\";i:1520443272;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-22/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:139;s:11:\"trend_index\";i:160;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:260;a:14:{s:2:\"id\";i:8525;s:5:\"title\";s:11:\"404 page 08\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/008.jpg\";s:12:\"tmpl_created\";i:1526415374;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-08/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:491;s:11:\"trend_index\";i:364;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:261;a:14:{s:2:\"id\";i:12492;s:5:\"title\";s:14:\"Travel -Footer\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2019/12/Footer_s.png\";s:12:\"tmpl_created\";i:1575960358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/travel-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:27:\"[\"footer\",\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:477;s:11:\"trend_index\";i:469;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:262;a:14:{s:2:\"id\";i:4341;s:5:\"title\";s:11:\"Services 21\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_11.png\";s:12:\"tmpl_created\";i:1520443274;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-21/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:141;s:11:\"trend_index\";i:171;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:263;a:14:{s:2:\"id\";i:8513;s:5:\"title\";s:11:\"404 page 04\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/004.jpg\";s:12:\"tmpl_created\";i:1526415417;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-04/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:445;s:11:\"trend_index\";i:501;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:264;a:14:{s:2:\"id\";i:12500;s:5:\"title\";s:21:\"Travel &#8211; Header\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-travel-and-tours.png\";s:12:\"tmpl_created\";i:1575960371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/travel-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:27:\"[\"header\",\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:436;s:11:\"trend_index\";i:394;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:265;a:14:{s:2:\"id\";i:4349;s:5:\"title\";s:11:\"Services 29\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_11.png\";s:12:\"tmpl_created\";i:1520443275;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-29/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:316;s:11:\"trend_index\";i:410;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:266;a:14:{s:2:\"id\";i:8512;s:5:\"title\";s:11:\"404 page 03\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/003.jpg\";s:12:\"tmpl_created\";i:1526415449;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-03/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:481;s:11:\"trend_index\";i:474;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:267;a:14:{s:2:\"id\";i:12509;s:5:\"title\";s:18:\"Travel &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/12/404.png\";s:12:\"tmpl_created\";i:1575960378;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/travel-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:24:\"[\"404\",\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:692;s:11:\"trend_index\";i:0;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:268;a:14:{s:2:\"id\";i:4357;s:5:\"title\";s:11:\"Services 20\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_12.png\";s:12:\"tmpl_created\";i:1520443277;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-20/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:45;s:11:\"trend_index\";i:53;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:269;a:14:{s:2:\"id\";i:8526;s:5:\"title\";s:11:\"404 page 09\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/009.jpg\";s:12:\"tmpl_created\";i:1526415474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-09/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:484;s:11:\"trend_index\";i:535;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:270;a:14:{s:2:\"id\";i:12516;s:5:\"title\";s:27:\"Travel &#8211; Archive Blog\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2019/12/Archiv_s.png\";s:12:\"tmpl_created\";i:1575960387;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/travel-archive-blog/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:478;s:11:\"trend_index\";i:312;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:271;a:14:{s:2:\"id\";i:4368;s:5:\"title\";s:11:\"Services 16\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_13.png\";s:12:\"tmpl_created\";i:1520443279;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:64;s:11:\"trend_index\";i:74;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:272;a:14:{s:2:\"id\";i:8505;s:5:\"title\";s:11:\"404 page 01\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/001.jpg\";s:12:\"tmpl_created\";i:1526415501;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:585;s:11:\"trend_index\";i:647;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:273;a:14:{s:2:\"id\";i:12524;s:5:\"title\";s:26:\"Travel &#8211; Single Post\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/12/Single_Post_s.png\";s:12:\"tmpl_created\";i:1575960397;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/travel-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:555;s:11:\"trend_index\";i:571;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:274;a:14:{s:2:\"id\";i:4376;s:5:\"title\";s:11:\"Services 28\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_12.png\";s:12:\"tmpl_created\";i:1520443281;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-28/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:148;s:11:\"trend_index\";i:122;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:275;a:14:{s:2:\"id\";i:8511;s:5:\"title\";s:11:\"404 page 02\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/002.jpg\";s:12:\"tmpl_created\";i:1526415528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-02/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:377;s:11:\"trend_index\";i:576;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:276;a:14:{s:2:\"id\";i:12531;s:5:\"title\";s:31:\"Travel &#8211; Single Post Tour\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/12/Single_Tour_s.png\";s:12:\"tmpl_created\";i:1575960404;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/travel-single-post-tour/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:597;s:11:\"trend_index\";i:640;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:277;a:14:{s:2:\"id\";i:4391;s:5:\"title\";s:11:\"Services 17\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_14.png\";s:12:\"tmpl_created\";i:1520443283;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:153;s:11:\"trend_index\";i:165;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:278;a:14:{s:2:\"id\";i:8514;s:5:\"title\";s:11:\"404 Page 05\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/005.jpg\";s:12:\"tmpl_created\";i:1526415558;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-05/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:439;s:11:\"trend_index\";i:455;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:279;a:14:{s:2:\"id\";i:4400;s:5:\"title\";s:11:\"Services 27\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_13.png\";s:12:\"tmpl_created\";i:1520443285;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-27/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:266;s:11:\"trend_index\";i:381;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:280;a:14:{s:2:\"id\";i:8676;s:5:\"title\";s:13:\"single page 1\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.6.jpg\";s:12:\"tmpl_created\";i:1527682423;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:335;s:11:\"trend_index\";i:300;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:281;a:14:{s:2:\"id\";i:4411;s:5:\"title\";s:9:\"Contact 3\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_white_1.png\";s:12:\"tmpl_created\";i:1520443287;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/contact-3-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:101;s:11:\"trend_index\";i:150;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:282;a:14:{s:2:\"id\";i:8678;s:5:\"title\";s:13:\"single page 2\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.2.jpg\";s:12:\"tmpl_created\";i:1527682780;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:179;s:11:\"trend_index\";i:72;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:283;a:14:{s:2:\"id\";i:4420;s:5:\"title\";s:9:\"Contact 1\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_black_1.png\";s:12:\"tmpl_created\";i:1520443289;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/contact-1-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:184;s:11:\"trend_index\";i:259;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:284;a:14:{s:2:\"id\";i:8679;s:5:\"title\";s:13:\"single page 3\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.3.jpg\";s:12:\"tmpl_created\";i:1527682847;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:189;s:11:\"trend_index\";i:54;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:285;a:14:{s:2:\"id\";i:4428;s:5:\"title\";s:9:\"Contact 4\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_white_2.png\";s:12:\"tmpl_created\";i:1520443291;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:110;s:11:\"trend_index\";i:117;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:286;a:14:{s:2:\"id\";i:8680;s:5:\"title\";s:13:\"single page 4\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.1.jpg\";s:12:\"tmpl_created\";i:1527682896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:421;s:11:\"trend_index\";i:318;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:287;a:14:{s:2:\"id\";i:4436;s:5:\"title\";s:11:\"Contact  16\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_black_2.png\";s:12:\"tmpl_created\";i:1520443293;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/contact-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:165;s:11:\"trend_index\";i:177;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:288;a:14:{s:2:\"id\";i:8681;s:5:\"title\";s:13:\"single page 5\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.5.jpg\";s:12:\"tmpl_created\";i:1527682969;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:319;s:11:\"trend_index\";i:230;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:289;a:14:{s:2:\"id\";i:4444;s:5:\"title\";s:9:\"Contact 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_1.png\";s:12:\"tmpl_created\";i:1520443295;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:85;s:11:\"trend_index\";i:66;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:290;a:14:{s:2:\"id\";i:8682;s:5:\"title\";s:13:\"single page 6\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.4.jpg\";s:12:\"tmpl_created\";i:1527683026;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:454;s:11:\"trend_index\";i:299;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:291;a:14:{s:2:\"id\";i:4452;s:5:\"title\";s:9:\"Contact 6\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_black_1.png\";s:12:\"tmpl_created\";i:1520443296;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:138;s:11:\"trend_index\";i:107;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:292;a:14:{s:2:\"id\";i:8703;s:5:\"title\";s:13:\"single page 7\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.7.jpg\";s:12:\"tmpl_created\";i:1527683072;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:413;s:11:\"trend_index\";i:314;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:293;a:14:{s:2:\"id\";i:4460;s:5:\"title\";s:9:\"Contact 9\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_2.png\";s:12:\"tmpl_created\";i:1520443298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:104;s:11:\"trend_index\";i:82;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:294;a:14:{s:2:\"id\";i:8961;s:5:\"title\";s:9:\"archive 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.1.jpg\";s:12:\"tmpl_created\";i:1528639909;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:94;s:11:\"trend_index\";i:105;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:295;a:14:{s:2:\"id\";i:4468;s:5:\"title\";s:9:\"Contact 7\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_3.png\";s:12:\"tmpl_created\";i:1520443301;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"contact\",\"form\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:133;s:11:\"trend_index\";i:96;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:296;a:14:{s:2:\"id\";i:8969;s:5:\"title\";s:9:\"archive 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.2.jpg\";s:12:\"tmpl_created\";i:1528700014;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:252;s:11:\"trend_index\";i:496;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:297;a:14:{s:2:\"id\";i:12716;s:5:\"title\";s:30:\"Magazine &#8211; Single Post 3\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/01/Post4_s.png\";s:12:\"tmpl_created\";i:1579060659;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/blocks/magazine-single-post-3-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:536;s:11:\"trend_index\";i:396;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:298;a:14:{s:2:\"id\";i:4476;s:5:\"title\";s:10:\"Contact 15\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_4.png\";s:12:\"tmpl_created\";i:1520443303;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/contact-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"contact\",\"form\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:234;s:11:\"trend_index\";i:244;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:299;a:14:{s:2:\"id\";i:8973;s:5:\"title\";s:9:\"archive 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.3.jpg\";s:12:\"tmpl_created\";i:1528700205;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:188;s:11:\"trend_index\";i:215;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:300;a:14:{s:2:\"id\";i:12707;s:5:\"title\";s:30:\"Magazine &#8211; Single Post 3\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/01/Post1_s.png\";s:12:\"tmpl_created\";i:1579060669;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/magazine-single-post-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:512;s:11:\"trend_index\";i:330;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:301;a:14:{s:2:\"id\";i:4484;s:5:\"title\";s:9:\"Contact 8\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_black_3.png\";s:12:\"tmpl_created\";i:1520443305;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"contact\",\"form\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:324;s:11:\"trend_index\";i:397;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:302;a:14:{s:2:\"id\";i:8977;s:5:\"title\";s:9:\"archive 4\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.4.jpg\";s:12:\"tmpl_created\";i:1528700326;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:349;s:11:\"trend_index\";i:490;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:303;a:14:{s:2:\"id\";i:12699;s:5:\"title\";s:30:\"Magazine &#8211; Single Post 2\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/01/Post3_s.png\";s:12:\"tmpl_created\";i:1579060680;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/magazine-single-post-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:408;s:11:\"trend_index\";i:269;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:304;a:14:{s:2:\"id\";i:4492;s:5:\"title\";s:9:\"Contact 5\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_white_3.png\";s:12:\"tmpl_created\";i:1520443307;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/contact-5-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:38;s:11:\"trend_index\";i:23;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:305;a:14:{s:2:\"id\";i:8981;s:5:\"title\";s:9:\"archive 5\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.5.jpg\";s:12:\"tmpl_created\";i:1528700484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:321;s:11:\"trend_index\";i:393;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:306;a:14:{s:2:\"id\";i:12688;s:5:\"title\";s:30:\"Magazine &#8211; Single Post 1\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/01/Post2_s.png\";s:12:\"tmpl_created\";i:1579060692;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/magazine-single-post-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:400;s:11:\"trend_index\";i:243;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:307;a:14:{s:2:\"id\";i:4500;s:5:\"title\";s:9:\"Pricing 7\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_1.png\";s:12:\"tmpl_created\";i:1520443308;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:469;s:11:\"trend_index\";i:481;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:308;a:14:{s:2:\"id\";i:8985;s:5:\"title\";s:9:\"archive 6\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.6.jpg\";s:12:\"tmpl_created\";i:1528700612;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:211;s:11:\"trend_index\";i:250;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:309;a:14:{s:2:\"id\";i:12678;s:5:\"title\";s:23:\"Magazine &#8211; Header\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-magazine.png\";s:12:\"tmpl_created\";i:1579060701;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/magazine-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:28:\"[\"Blog\",\"header\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:313;s:11:\"trend_index\";i:240;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:310;a:14:{s:2:\"id\";i:4509;s:5:\"title\";s:9:\"Pricing 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_1.png\";s:12:\"tmpl_created\";i:1520443310;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:652;s:11:\"trend_index\";i:687;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:311;a:14:{s:2:\"id\";i:8989;s:5:\"title\";s:9:\"archive 7\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.7.jpg\";s:12:\"tmpl_created\";i:1528701063;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:205;s:11:\"trend_index\";i:290;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:312;a:14:{s:2:\"id\";i:12669;s:5:\"title\";s:23:\"Magazine &#8211; Footer\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/01/Footer_s.png\";s:12:\"tmpl_created\";i:1579060715;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/magazine-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:28:\"[\"Blog\",\"footer\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:463;s:11:\"trend_index\";i:336;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:313;a:14:{s:2:\"id\";i:4521;s:5:\"title\";s:9:\"Pricing 8\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_2.png\";s:12:\"tmpl_created\";i:1520443312;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:310;s:11:\"trend_index\";i:344;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:314;a:14:{s:2:\"id\";i:8996;s:5:\"title\";s:9:\"archive 8\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.8.jpg\";s:12:\"tmpl_created\";i:1528701290;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:215;s:11:\"trend_index\";i:452;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:315;a:14:{s:2:\"id\";i:12661;s:5:\"title\";s:23:\"Magazine &#8211; Search\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/01/Search_s.png\";s:12:\"tmpl_created\";i:1579060722;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/magazine-search/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:443;s:11:\"trend_index\";i:214;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:316;a:14:{s:2:\"id\";i:4529;s:5:\"title\";s:9:\"Pricing 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_2.png\";s:12:\"tmpl_created\";i:1520443314;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:568;s:11:\"trend_index\";i:553;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:317;a:14:{s:2:\"id\";i:9001;s:5:\"title\";s:9:\"archive 9\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.9.jpg\";s:12:\"tmpl_created\";i:1528701433;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:267;s:11:\"trend_index\";i:429;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:318;a:14:{s:2:\"id\";i:12652;s:5:\"title\";s:17:\"Magazine- Archiv2\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/01/Archiv2_s.png\";s:12:\"tmpl_created\";i:1579060730;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/magazine-archiv2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:525;s:11:\"trend_index\";i:516;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:319;a:14:{s:2:\"id\";i:4537;s:5:\"title\";s:9:\"Pricing 9\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_3.png\";s:12:\"tmpl_created\";i:1520443315;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:538;s:11:\"trend_index\";i:562;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:320;a:14:{s:2:\"id\";i:9119;s:5:\"title\";s:10:\"footer 015\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/Footer_GetStarted_350.png\";s:12:\"tmpl_created\";i:1532428138;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/blocks/demo/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:253;s:11:\"trend_index\";i:266;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:321;a:14:{s:2:\"id\";i:12643;s:5:\"title\";s:24:\"Magazine &#8211; Archiv1\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/01/Archiv1_s.png\";s:12:\"tmpl_created\";i:1579060737;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/magazine-archiv1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:386;s:11:\"trend_index\";i:287;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:322;a:14:{s:2:\"id\";i:4545;s:5:\"title\";s:9:\"Pricing 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_3.png\";s:12:\"tmpl_created\";i:1520443317;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:648;s:11:\"trend_index\";i:658;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:323;a:14:{s:2:\"id\";i:9127;s:5:\"title\";s:9:\"header 13\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2018/07/Header_get_started_1200V3.png\";s:12:\"tmpl_created\";i:1532428699;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/header-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:60;s:11:\"trend_index\";i:106;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:324;a:14:{s:2:\"id\";i:12635;s:5:\"title\";s:20:\"Magazine &#8211; 404\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/01/404_s.png\";s:12:\"tmpl_created\";i:1579060746;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/magazine-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:25:\"[\"404\",\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:611;s:11:\"trend_index\";i:528;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:325;a:14:{s:2:\"id\";i:4553;s:5:\"title\";s:10:\"Pricing 10\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_4.png\";s:12:\"tmpl_created\";i:1520443319;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/pricing-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:482;s:11:\"trend_index\";i:453;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:326;a:14:{s:2:\"id\";i:12736;s:5:\"title\";s:41:\"Slide In | Contact Us | Magazine and Blog\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_contact_s.png\";s:12:\"tmpl_created\";i:1579060978;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/slide-in-contact-us/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:691;s:11:\"trend_index\";i:670;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:327;a:14:{s:2:\"id\";i:4562;s:5:\"title\";s:9:\"Pricing 4\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_4.png\";s:12:\"tmpl_created\";i:1520443322;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:636;s:11:\"trend_index\";i:709;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:328;a:14:{s:2:\"id\";i:12726;s:5:\"title\";s:52:\"Classic | Newsletter | Subscribe | Magazine and Blog\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_Newsletter_s.png\";s:12:\"tmpl_created\";i:1579061019;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-newsletter-subscribe-magazine-and-blog/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:417;s:11:\"trend_index\";i:274;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:329;a:14:{s:2:\"id\";i:4572;s:5:\"title\";s:10:\"Pricing 11\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_5.png\";s:12:\"tmpl_created\";i:1520443324;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/pricing-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:308;s:11:\"trend_index\";i:310;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:330;a:14:{s:2:\"id\";i:9174;s:5:\"title\";s:17:\"single product 01\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/07/single_product01_350.png\";s:12:\"tmpl_created\";i:1532950125;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/single-product-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"single product\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:44;s:11:\"trend_index\";i:16;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:331;a:14:{s:2:\"id\";i:13089;s:5:\"title\";s:23:\"Photography &#8211; 404\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/02/404_s.png\";s:12:\"tmpl_created\";i:1582091623;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/photography-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:33:\"[\"404\",\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:681;s:11:\"trend_index\";i:580;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:332;a:14:{s:2:\"id\";i:4580;s:5:\"title\";s:10:\"Pricing 12\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_6.png\";s:12:\"tmpl_created\";i:1520443326;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/pricing-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:537;s:11:\"trend_index\";i:588;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:333;a:14:{s:2:\"id\";i:9178;s:5:\"title\";s:17:\"single product 02\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2018/07/single_product02_350new.png\";s:12:\"tmpl_created\";i:1532951997;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/single-product-02/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"single product\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:87;s:11:\"trend_index\";i:55;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:334;a:14:{s:2:\"id\";i:13096;s:5:\"title\";s:32:\"Photography &#8211; Archiv Media\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/02/Archiv_s.png\";s:12:\"tmpl_created\";i:1582091742;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/blocks/photography-archiv-media/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:609;s:11:\"trend_index\";i:447;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:335;a:14:{s:2:\"id\";i:4589;s:5:\"title\";s:9:\"Pricing 5\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_6.png\";s:12:\"tmpl_created\";i:1520443327;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:659;s:11:\"trend_index\";i:713;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:336;a:14:{s:2:\"id\";i:9180;s:5:\"title\";s:17:\"single product 03\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/07/single_product03_350.png\";s:12:\"tmpl_created\";i:1532952302;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/single-product-03/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"single product\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:129;s:11:\"trend_index\";i:61;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:337;a:14:{s:2:\"id\";i:13103;s:5:\"title\";s:26:\"Photography &#8211; Footer\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/02/Footer_s.png\";s:12:\"tmpl_created\";i:1582091903;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/photography-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:36:\"[\"footer\",\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:465;s:11:\"trend_index\";i:341;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:338;a:14:{s:2:\"id\";i:4597;s:5:\"title\";s:10:\"Pricing 13\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_7.png\";s:12:\"tmpl_created\";i:1520443330;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/pricing-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:561;s:11:\"trend_index\";i:715;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:339;a:14:{s:2:\"id\";i:9182;s:5:\"title\";s:17:\"single product 04\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/single_product040_350.png\";s:12:\"tmpl_created\";i:1532952606;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/single-product-04/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"single product\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:144;s:11:\"trend_index\";i:93;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:340;a:14:{s:2:\"id\";i:13120;s:5:\"title\";s:31:\"Photography &#8211; Single Post\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/02/Post_s.png\";s:12:\"tmpl_created\";i:1582092351;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/photography-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:650;s:11:\"trend_index\";i:590;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:341;a:14:{s:2:\"id\";i:4605;s:5:\"title\";s:9:\"Pricing 6\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_7.png\";s:12:\"tmpl_created\";i:1520443332;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:678;s:11:\"trend_index\";i:650;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:342;a:14:{s:2:\"id\";i:9239;s:5:\"title\";s:17:\"product archive 1\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/product-archive-350-1.png\";s:12:\"tmpl_created\";i:1532953482;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/product-archive-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:15:\"product archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:80;s:11:\"trend_index\";i:30;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:343;a:14:{s:2:\"id\";i:13112;s:5:\"title\";s:26:\"Photography &#8211; Header\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-photography-portfolio.png\";s:12:\"tmpl_created\";i:1582092483;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/photography-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:36:\"[\"header\",\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:347;s:11:\"trend_index\";i:199;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:344;a:14:{s:2:\"id\";i:4613;s:5:\"title\";s:10:\"Pricing 14\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_8.png\";s:12:\"tmpl_created\";i:1520443334;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/pricing-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:535;s:11:\"trend_index\";i:599;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:345;a:14:{s:2:\"id\";i:9247;s:5:\"title\";s:17:\"product archive 2\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/product-archive-350-2.png\";s:12:\"tmpl_created\";i:1532953793;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/product-archive-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:15:\"product archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:93;s:11:\"trend_index\";i:43;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:346;a:14:{s:2:\"id\";i:13129;s:5:\"title\";s:28:\"Classic | Menu | Photography\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/PopUp_s.png\";s:12:\"tmpl_created\";i:1582092645;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/popups/classic-menu-photography/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:616;s:11:\"trend_index\";i:699;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:347;a:14:{s:2:\"id\";i:9254;s:5:\"title\";s:17:\"product archive 3\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/product-archive-350-3.png\";s:12:\"tmpl_created\";i:1532954032;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/product-archive-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:15:\"product archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:103;s:11:\"trend_index\";i:39;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:348;a:14:{s:2:\"id\";i:9301;s:5:\"title\";s:13:\"Single Post 4\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3003.jpg\";s:12:\"tmpl_created\";i:1537440661;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:227;s:11:\"trend_index\";i:380;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:349;a:14:{s:2:\"id\";i:9296;s:5:\"title\";s:13:\"Single Post 3\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3002.jpg\";s:12:\"tmpl_created\";i:1537440673;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:202;s:11:\"trend_index\";i:295;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:350;a:14:{s:2:\"id\";i:9313;s:5:\"title\";s:13:\"Single Post 5\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3001.jpg\";s:12:\"tmpl_created\";i:1537440798;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:181;s:11:\"trend_index\";i:301;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:351;a:14:{s:2:\"id\";i:9343;s:5:\"title\";s:13:\"Single Post 6\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3004.jpg\";s:12:\"tmpl_created\";i:1537443531;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:208;s:11:\"trend_index\";i:385;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:352;a:14:{s:2:\"id\";i:9349;s:5:\"title\";s:13:\"Single Post 7\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3005.jpg\";s:12:\"tmpl_created\";i:1537443903;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:147;s:11:\"trend_index\";i:166;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:353;a:14:{s:2:\"id\";i:4690;s:5:\"title\";s:6:\"Team 7\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_1.png\";s:12:\"tmpl_created\";i:1520443348;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/team-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:233;s:11:\"trend_index\";i:204;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:354;a:14:{s:2:\"id\";i:4698;s:5:\"title\";s:7:\"Team 15\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_1.png\";s:12:\"tmpl_created\";i:1520443350;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:402;s:11:\"trend_index\";i:446;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:355;a:14:{s:2:\"id\";i:4706;s:5:\"title\";s:6:\"Team 5\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_2.png\";s:12:\"tmpl_created\";i:1520443352;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/team-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:142;s:11:\"trend_index\";i:119;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:356;a:14:{s:2:\"id\";i:4718;s:5:\"title\";s:6:\"Team 4\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_3.png\";s:12:\"tmpl_created\";i:1520443354;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/team-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:178;s:11:\"trend_index\";i:221;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:357;a:14:{s:2:\"id\";i:4727;s:5:\"title\";s:7:\"Team 13\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_2.png\";s:12:\"tmpl_created\";i:1520443356;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:360;s:11:\"trend_index\";i:369;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:358;a:14:{s:2:\"id\";i:4736;s:5:\"title\";s:7:\"Team 20\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_4.png\";s:12:\"tmpl_created\";i:1520443358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-20/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:140;s:11:\"trend_index\";i:114;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:359;a:14:{s:2:\"id\";i:4746;s:5:\"title\";s:7:\"Team 23\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_4.png\";s:12:\"tmpl_created\";i:1520443360;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-23/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:263;s:11:\"trend_index\";i:223;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:360;a:14:{s:2:\"id\";i:4759;s:5:\"title\";s:7:\"Team 22\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_5.png\";s:12:\"tmpl_created\";i:1520443362;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-22/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:290;s:11:\"trend_index\";i:422;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:361;a:14:{s:2:\"id\";i:4770;s:5:\"title\";s:7:\"Team 12\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_6.png\";s:12:\"tmpl_created\";i:1520443364;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/team-12-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:393;s:11:\"trend_index\";i:403;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:362;a:14:{s:2:\"id\";i:4781;s:5:\"title\";s:7:\"Team 16\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_7.png\";s:12:\"tmpl_created\";i:1520443365;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:258;s:11:\"trend_index\";i:479;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:363;a:14:{s:2:\"id\";i:9611;s:5:\"title\";s:16:\"Hello Bar | Sale\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2019/01/Top-Bar_Sale_small_01.png\";s:12:\"tmpl_created\";i:1546965350;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/popups/hello-bar-sale-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:571;s:11:\"trend_index\";i:463;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:364;a:14:{s:2:\"id\";i:13274;s:5:\"title\";s:38:\"Interior Design &#8211; Single Project\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/04/Single-Project-.png\";s:12:\"tmpl_created\";i:1586148723;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/blocks/interior-design-single-project/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:30:\"[\"business\",\"interior design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:619;s:11:\"trend_index\";i:497;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:365;a:14:{s:2:\"id\";i:4793;s:5:\"title\";s:7:\"Team 18\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_8.png\";s:12:\"tmpl_created\";i:1520443367;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:194;s:11:\"trend_index\";i:210;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:366;a:14:{s:2:\"id\";i:9622;s:5:\"title\";s:19:\"Classic | Promotion\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2019/01/classic_promotion_small_02.png\";s:12:\"tmpl_created\";i:1546965896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/classic-promotion-02/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:575;s:11:\"trend_index\";i:533;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:367;a:14:{s:2:\"id\";i:13267;s:5:\"title\";s:35:\"Interior Design &#8211; Single News\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/04/Post.png\";s:12:\"tmpl_created\";i:1586148728;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/blocks/interior-design-single-news/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:30:\"[\"business\",\"interior design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:544;s:11:\"trend_index\";i:491;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:368;a:14:{s:2:\"id\";i:4801;s:5:\"title\";s:7:\"Team 11\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_8.png\";s:12:\"tmpl_created\";i:1520443369;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:333;s:11:\"trend_index\";i:328;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:369;a:14:{s:2:\"id\";i:9631;s:5:\"title\";s:38:\"Slide-in | Sale | Register | Subscribe\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2019/01/Slide-in_Sale_small_01.png\";s:12:\"tmpl_created\";i:1546968270;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/slide-in-sale-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:601;s:11:\"trend_index\";i:618;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:370;a:14:{s:2:\"id\";i:13259;s:5:\"title\";s:36:\"Interior Design &#8211; News Archive\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/04/Archiv-Blog.png\";s:12:\"tmpl_created\";i:1586148733;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/interior-design-news-archive/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:30:\"[\"business\",\"interior design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:509;s:11:\"trend_index\";i:351;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:371;a:14:{s:2:\"id\";i:4809;s:5:\"title\";s:7:\"Team 19\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_9.png\";s:12:\"tmpl_created\";i:1520443371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-19/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:283;s:11:\"trend_index\";i:458;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:372;a:14:{s:2:\"id\";i:13251;s:5:\"title\";s:27:\"Interior Design &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/04/404.png\";s:12:\"tmpl_created\";i:1586148737;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/interior-design-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:30:\"[\"business\",\"interior design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:698;s:11:\"trend_index\";i:686;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:373;a:14:{s:2:\"id\";i:4818;s:5:\"title\";s:7:\"Team 21\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_9.png\";s:12:\"tmpl_created\";i:1520443373;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-21/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:466;s:11:\"trend_index\";i:520;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:374;a:14:{s:2:\"id\";i:13244;s:5:\"title\";s:30:\"Interior Design &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/04/Footer.png\";s:12:\"tmpl_created\";i:1586148742;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/interior-design-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:39:\"[\"business\",\"footer\",\"interior design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:405;s:11:\"trend_index\";i:219;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:375;a:14:{s:2:\"id\";i:5045;s:5:\"title\";s:11:\"Portfolio 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_2.png\";s:12:\"tmpl_created\";i:1520443423;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:578;s:11:\"trend_index\";i:684;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:376;a:14:{s:2:\"id\";i:9662;s:5:\"title\";s:33:\"Bottom Bar | Register | Subscribe\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2019/01/Bottom-Bar_Register_small_01.png\";s:12:\"tmpl_created\";i:1547009087;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/popups/bottom-bar-register-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:625;s:11:\"trend_index\";i:0;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:377;a:14:{s:2:\"id\";i:13236;s:5:\"title\";s:30:\"Interior Design &#8211; Header\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-interior-design.png\";s:12:\"tmpl_created\";i:1586148746;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/interior-design-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:39:\"[\"business\",\"header\",\"interior design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:222;s:11:\"trend_index\";i:78;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:378;a:14:{s:2:\"id\";i:5157;s:5:\"title\";s:11:\"Subscribe 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_white_1.png\";s:12:\"tmpl_created\";i:1520443448;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/subscribe-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"form\",\"subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:341;s:11:\"trend_index\";i:323;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:379;a:14:{s:2:\"id\";i:13281;s:5:\"title\";s:37:\"Hello Bar | Contact | Interior Design\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp.png\";s:12:\"tmpl_created\";i:1586148801;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/hello-bar-contact-interior-design/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:19:\"[\"interior design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:718;s:11:\"trend_index\";i:685;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:380;a:14:{s:2:\"id\";i:5165;s:5:\"title\";s:11:\"Subscribe 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_black_1.png\";s:12:\"tmpl_created\";i:1520443450;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/subscribe-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"form\",\"subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:498;s:11:\"trend_index\";i:505;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:381;a:14:{s:2:\"id\";i:5173;s:5:\"title\";s:11:\"Subscribe 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_white_2.png\";s:12:\"tmpl_created\";i:1520443452;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/subscribe-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"form\",\"subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:271;s:11:\"trend_index\";i:228;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:382;a:14:{s:2:\"id\";i:9690;s:5:\"title\";s:17:\"Classic | Contact\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2019/01/Classic_Contact_small_01.png\";s:12:\"tmpl_created\";i:1547011716;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/classic-contact-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:380;s:11:\"trend_index\";i:426;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:383;a:14:{s:2:\"id\";i:5181;s:5:\"title\";s:11:\"Subscribe 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_black_2.png\";s:12:\"tmpl_created\";i:1520443454;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/subscribe-2-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"form\",\"subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:426;s:11:\"trend_index\";i:440;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:384;a:14:{s:2:\"id\";i:9699;s:5:\"title\";s:33:\"Classic | Contact | Gym | Fitness\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2019/01/Classic_Contact_small_02.png\";s:12:\"tmpl_created\";i:1547015827;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/classic-contact-02/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:449;s:11:\"trend_index\";i:536;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:385;a:14:{s:2:\"id\";i:5189;s:5:\"title\";s:6:\"CTA 29\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_1.png\";s:12:\"tmpl_created\";i:1520443456;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-29/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:8:\"[\"form\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:435;s:11:\"trend_index\";i:475;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:386;a:14:{s:2:\"id\";i:5198;s:5:\"title\";s:6:\"CTA 30\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_black_1.png\";s:12:\"tmpl_created\";i:1520443458;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-30/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:8:\"[\"form\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:517;s:11:\"trend_index\";i:563;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:387;a:14:{s:2:\"id\";i:9571;s:5:\"title\";s:14:\"Fly In | Login\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2019/01/FlyIn_Login_01_small.png\";s:12:\"tmpl_created\";i:1547726151;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/fly-in-login-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:583;s:11:\"trend_index\";i:577;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:388;a:14:{s:2:\"id\";i:13395;s:5:\"title\";s:34:\"Online Course &#8211; Start Lesson\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/04/Lesson-Start.jpg\";s:12:\"tmpl_created\";i:1587474673;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/online-course-start-lesson/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:662;s:11:\"trend_index\";i:515;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:389;a:14:{s:2:\"id\";i:5206;s:5:\"title\";s:6:\"CTA 31\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_black_2.png\";s:12:\"tmpl_created\";i:1520443459;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-31/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:8:\"[\"form\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:548;s:11:\"trend_index\";i:550;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:390;a:14:{s:2:\"id\";i:13387;s:5:\"title\";s:32:\"Online Course &#8211; End Lesson\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/04/Lesson-End-.jpg\";s:12:\"tmpl_created\";i:1587474682;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/blocks/online-course-end-lesson/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:663;s:11:\"trend_index\";i:487;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:391;a:14:{s:2:\"id\";i:5214;s:5:\"title\";s:10:\"Contact 16\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_2.png\";s:12:\"tmpl_created\";i:1520443462;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/contact-16-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"contact\",\"form\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:196;s:11:\"trend_index\";i:152;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:392;a:14:{s:2:\"id\";i:13378;s:5:\"title\";s:28:\"Online Course &#8211; Header\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-education-online-courses.jpg\";s:12:\"tmpl_created\";i:1587474693;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/online-course-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:38:\"[\"Course Online\",\"Education\",\"header\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:519;s:11:\"trend_index\";i:359;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:393;a:14:{s:2:\"id\";i:5222;s:5:\"title\";s:11:\"Subscribe 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_black_3.png\";s:12:\"tmpl_created\";i:1520443464;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/subscribe-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"form\",\"subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:387;s:11:\"trend_index\";i:461;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:394;a:14:{s:2:\"id\";i:9740;s:5:\"title\";s:25:\"Classic | Promotion | App\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/app_small.png\";s:12:\"tmpl_created\";i:1547822836;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/classic-promotion-app/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:576;s:11:\"trend_index\";i:566;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:395;a:14:{s:2:\"id\";i:13369;s:5:\"title\";s:28:\"Online Course &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/04/Footer.jpg\";s:12:\"tmpl_created\";i:1587474701;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/online-course-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:38:\"[\"Course Online\",\"Education\",\"footer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:480;s:11:\"trend_index\";i:371;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:396;a:14:{s:2:\"id\";i:5230;s:5:\"title\";s:10:\"Contact 17\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_3.png\";s:12:\"tmpl_created\";i:1520443466;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/contact-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"contact\",\"form\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:325;s:11:\"trend_index\";i:356;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:397;a:14:{s:2:\"id\";i:13361;s:5:\"title\";s:25:\"Online Course &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/04/404.jpg\";s:12:\"tmpl_created\";i:1587474710;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/online-course-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:35:\"[\"404\",\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:677;s:11:\"trend_index\";i:435;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:398;a:14:{s:2:\"id\";i:5238;s:5:\"title\";s:7:\"Hero 12\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_4.png\";s:12:\"tmpl_created\";i:1520443468;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/hero-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:564;s:11:\"trend_index\";i:570;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:399;a:14:{s:2:\"id\";i:9762;s:5:\"title\";s:36:\"Classic | Register | Subscribe | Spa\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2019/01/spa_small_classic.png\";s:12:\"tmpl_created\";i:1547824145;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/classic-register-subscribe-spa/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:451;s:11:\"trend_index\";i:349;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:400;a:14:{s:2:\"id\";i:13413;s:5:\"title\";s:33:\"Classic | Contact | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Help.jpg\";s:12:\"tmpl_created\";i:1587474761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/classic-contact-online-course/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:590;s:11:\"trend_index\";i:407;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:401;a:14:{s:2:\"id\";i:5249;s:5:\"title\";s:6:\"CTA 32\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_black_4.png\";s:12:\"tmpl_created\";i:1520443470;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-32/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:8:\"[\"form\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:492;s:11:\"trend_index\";i:499;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:402;a:14:{s:2:\"id\";i:9772;s:5:\"title\";s:27:\"Hello bar | Promotion | App\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/app_hello_small.png\";s:12:\"tmpl_created\";i:1547824279;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/hello-bar-promotion-app/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:696;s:11:\"trend_index\";i:708;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:403;a:14:{s:2:\"id\";i:13402;s:5:\"title\";s:29:\"Classic | CTA | Online Course\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2020/04/Popup-Course-Completed.jpg\";s:12:\"tmpl_created\";i:1587474772;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/classic-cta-online-course/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:624;s:11:\"trend_index\";i:523;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:404;a:14:{s:2:\"id\";i:5257;s:5:\"title\";s:10:\"Contact 18\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_5.png\";s:12:\"tmpl_created\";i:1520443472;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/contact-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:8:\"[\"form\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:407;s:11:\"trend_index\";i:495;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:405;a:14:{s:2:\"id\";i:13422;s:5:\"title\";s:30:\"Classic | Menu | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Menu.jpg\";s:12:\"tmpl_created\";i:1587474782;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/classic-menu-online-course/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:572;s:11:\"trend_index\";i:519;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"1\";}i:406;a:14:{s:2:\"id\";i:5266;s:5:\"title\";s:9:\"Clients 4\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_1.png\";s:12:\"tmpl_created\";i:1520443474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/clients-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:98;s:11:\"trend_index\";i:92;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:407;a:14:{s:2:\"id\";i:9793;s:5:\"title\";s:13:\"Fly In | Sale\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2019/01/flyin_black_small.png\";s:12:\"tmpl_created\";i:1547831151;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/popups/fly-in-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:618;s:11:\"trend_index\";i:541;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:408;a:14:{s:2:\"id\";i:13621;s:5:\"title\";s:30:\"Barbershop &#8211; Single Post\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/05/Single-Page.jpg\";s:12:\"tmpl_created\";i:1589893137;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/barbershop-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:723;s:11:\"trend_index\";i:623;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:409;a:14:{s:2:\"id\";i:5275;s:5:\"title\";s:9:\"Clients 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_1.png\";s:12:\"tmpl_created\";i:1520443476;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/clients-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:322;s:11:\"trend_index\";i:258;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:410;a:14:{s:2:\"id\";i:13612;s:5:\"title\";s:25:\"Barbershop &#8211; Header\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2020/06/barber-shop-header.jpg\";s:12:\"tmpl_created\";i:1589893142;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/barbershop-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:37:\"[\"Barber Shop\",\"Barbershop\",\"header\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:476;s:11:\"trend_index\";i:225;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:411;a:14:{s:2:\"id\";i:5283;s:5:\"title\";s:9:\"Clients 1\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_2.png\";s:12:\"tmpl_created\";i:1520443478;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/clients-1-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:297;s:11:\"trend_index\";i:460;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:412;a:14:{s:2:\"id\";i:13604;s:5:\"title\";s:25:\"Barbershop &#8211; Footer\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/05/Footer-Small.jpg\";s:12:\"tmpl_created\";i:1589893147;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/barbershop-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:37:\"[\"Barber Shop\",\"Barbershop\",\"footer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:622;s:11:\"trend_index\";i:405;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:413;a:14:{s:2:\"id\";i:5290;s:5:\"title\";s:9:\"Clients 3\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_2.png\";s:12:\"tmpl_created\";i:1520443480;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/clients-3-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:518;s:11:\"trend_index\";i:565;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:414;a:14:{s:2:\"id\";i:13528;s:5:\"title\";s:22:\"Barbershop &#8211; 404\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/05/404-Page.jpg\";s:12:\"tmpl_created\";i:1589893152;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/barbershop-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:34:\"[\"404\",\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:727;s:11:\"trend_index\";i:675;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:415;a:14:{s:2:\"id\";i:5298;s:5:\"title\";s:10:\"Clients 15\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_3.png\";s:12:\"tmpl_created\";i:1520443482;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:437;s:11:\"trend_index\";i:506;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:416;a:14:{s:2:\"id\";i:9836;s:5:\"title\";s:21:\"Classic | Login | Pop\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/01/login_b_small.png\";s:12:\"tmpl_created\";i:1547835635;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/popups/classic-login/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:584;s:11:\"trend_index\";i:552;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:417;a:14:{s:2:\"id\";i:13518;s:5:\"title\";s:26:\"Barbershop &#8211; Archive\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/05/Blog-Page.jpg\";s:12:\"tmpl_created\";i:1589893157;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/barbershop-archive/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:717;s:11:\"trend_index\";i:649;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:418;a:14:{s:2:\"id\";i:5306;s:5:\"title\";s:10:\"Clients 10\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_3.png\";s:12:\"tmpl_created\";i:1520443484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:605;s:11:\"trend_index\";i:677;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:419;a:14:{s:2:\"id\";i:9847;s:5:\"title\";s:25:\"Fly In | Promotion | Lego\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2019/01/fly_in_promotion_tro.png\";s:12:\"tmpl_created\";i:1547836956;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/fly-in-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:686;s:11:\"trend_index\";i:692;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:420;a:14:{s:2:\"id\";i:5315;s:5:\"title\";s:10:\"Clients 12\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_4-1.png\";s:12:\"tmpl_created\";i:1520443486;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:485;s:11:\"trend_index\";i:568;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:421;a:14:{s:2:\"id\";i:9858;s:5:\"title\";s:27:\"Slide In | Promotion | Wine\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2019/01/slide-in_promotion_wine_small.png\";s:12:\"tmpl_created\";i:1547837100;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/slide-in-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:712;s:11:\"trend_index\";i:0;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:422;a:14:{s:2:\"id\";i:5324;s:5:\"title\";s:9:\"Clients 8\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_5-1.png\";s:12:\"tmpl_created\";i:1520443488;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/clients-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:511;s:11:\"trend_index\";i:603;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:423;a:14:{s:2:\"id\";i:5333;s:5:\"title\";s:10:\"Clients 13\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_6.png\";s:12:\"tmpl_created\";i:1520443489;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:238;s:11:\"trend_index\";i:324;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:424;a:14:{s:2:\"id\";i:5341;s:5:\"title\";s:10:\"Clients 11\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_4.png\";s:12:\"tmpl_created\";i:1520443491;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:566;s:11:\"trend_index\";i:646;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:425;a:14:{s:2:\"id\";i:5349;s:5:\"title\";s:9:\"Clients 7\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_7.png\";s:12:\"tmpl_created\";i:1520443493;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/clients-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:243;s:11:\"trend_index\";i:261;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:426;a:14:{s:2:\"id\";i:13538;s:5:\"title\";s:32:\"Fly-In | Newsletter | Barbershop\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/05/Pop-Up-Page-Small.jpg\";s:12:\"tmpl_created\";i:1589893364;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/fly-in-newsletter-barbershop/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:701;s:11:\"trend_index\";i:551;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:427;a:14:{s:2:\"id\";i:5357;s:5:\"title\";s:9:\"Clients 2\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_7.png\";s:12:\"tmpl_created\";i:1520443495;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/clients-2-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:330;s:11:\"trend_index\";i:320;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:428;a:14:{s:2:\"id\";i:5368;s:5:\"title\";s:9:\"Clients 9\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_8.png\";s:12:\"tmpl_created\";i:1520443497;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/clients-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:247;s:11:\"trend_index\";i:273;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:429;a:14:{s:2:\"id\";i:5381;s:5:\"title\";s:10:\"Clients 16\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_9.png\";s:12:\"tmpl_created\";i:1520443499;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:186;s:11:\"trend_index\";i:264;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:430;a:14:{s:2:\"id\";i:5389;s:5:\"title\";s:10:\"Clients 14\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_black_9.png\";s:12:\"tmpl_created\";i:1520443501;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:385;s:11:\"trend_index\";i:420;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:431;a:14:{s:2:\"id\";i:9944;s:5:\"title\";s:33:\"Slide In | Promotion | Headphones\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2019/01/slidein_head_small.png\";s:12:\"tmpl_created\";i:1547841939;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/slide-in-promotion-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:689;s:11:\"trend_index\";i:652;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:432;a:14:{s:2:\"id\";i:5397;s:5:\"title\";s:8:\"About 11\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_1.png\";s:12:\"tmpl_created\";i:1520443503;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:154;s:11:\"trend_index\";i:151;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:433;a:14:{s:2:\"id\";i:9955;s:5:\"title\";s:14:\"Fly In | Login\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2019/01/flyin_login_lock_small.png\";s:12:\"tmpl_created\";i:1547842065;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/popups/fly-in-login/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:524;s:11:\"trend_index\";i:522;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:434;a:14:{s:2:\"id\";i:5405;s:5:\"title\";s:8:\"About 12\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_1.png\";s:12:\"tmpl_created\";i:1520443505;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:224;s:11:\"trend_index\";i:348;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:435;a:14:{s:2:\"id\";i:9965;s:5:\"title\";s:30:\"Classic | Register | Subscribe\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2019/01/classic_moon_small.png\";s:12:\"tmpl_created\";i:1547842174;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-register-subscribe-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:539;s:11:\"trend_index\";i:606;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:436;a:14:{s:2:\"id\";i:5413;s:5:\"title\";s:8:\"About 21\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_2.png\";s:12:\"tmpl_created\";i:1520443507;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-21/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:92;s:11:\"trend_index\";i:38;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:437;a:14:{s:2:\"id\";i:14058;s:5:\"title\";s:36:\"Japanese restaurant &#8211; 404 page\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/06/404-Page.jpg\";s:12:\"tmpl_created\";i:1592290211;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/japanese-restaurant-404-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:38:\"[\"404\",\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:721;s:11:\"trend_index\";i:512;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:438;a:14:{s:2:\"id\";i:5421;s:5:\"title\";s:8:\"About 13\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_3.png\";s:12:\"tmpl_created\";i:1520443509;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:226;s:11:\"trend_index\";i:247;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:439;a:14:{s:2:\"id\";i:14050;s:5:\"title\";s:34:\"Japanese restaurant &#8211; Footer\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/06/Footer-Small.jpg\";s:12:\"tmpl_created\";i:1592290247;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/japanese-restaurant-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:41:\"[\"Food\",\"footer\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:522;s:11:\"trend_index\";i:147;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:440;a:14:{s:2:\"id\";i:5429;s:5:\"title\";s:8:\"About 16\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_4.png\";s:12:\"tmpl_created\";i:1520443510;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:74;s:11:\"trend_index\";i:56;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:441;a:14:{s:2:\"id\";i:9995;s:5:\"title\";s:27:\"Slide In | Sale | Christmas\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2019/01/slidein_christmas_small.png\";s:12:\"tmpl_created\";i:1547844802;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/slide-in-sale-christmas/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:719;s:11:\"trend_index\";i:693;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:442;a:14:{s:2:\"id\";i:14042;s:5:\"title\";s:34:\"Japanese restaurant &#8211; Header\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2020/06/japanese-restaurant-header.jpg\";s:12:\"tmpl_created\";i:1592290277;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/japanese-restaurant-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:41:\"[\"Food\",\"header\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:559;s:11:\"trend_index\";i:196;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:443;a:14:{s:2:\"id\";i:5438;s:5:\"title\";s:7:\"About 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_4.png\";s:12:\"tmpl_created\";i:1520443512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/about-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:182;s:11:\"trend_index\";i:148;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:444;a:14:{s:2:\"id\";i:5447;s:5:\"title\";s:7:\"About 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_5.png\";s:12:\"tmpl_created\";i:1520443514;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/about-3-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:54;s:11:\"trend_index\";i:47;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:445;a:14:{s:2:\"id\";i:10016;s:5:\"title\";s:16:\"Hello Bar | Sale\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2019/01/Hello-Bar_Promotion_bag_small.png\";s:12:\"tmpl_created\";i:1547845062;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/hello-bar-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:726;s:11:\"trend_index\";i:0;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:446;a:14:{s:2:\"id\";i:14067;s:5:\"title\";s:37:\"Slide In | Japanese restaurant | Menu\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/06/Menu-Pop-Up-Small.jpg\";s:12:\"tmpl_created\";i:1592290352;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/slide-in-japanese-restaurant-menu/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:675;s:11:\"trend_index\";i:476;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:447;a:14:{s:2:\"id\";i:5455;s:5:\"title\";s:8:\"About 20\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_6.png\";s:12:\"tmpl_created\";i:1520443516;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-20/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:137;s:11:\"trend_index\";i:169;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:448;a:14:{s:2:\"id\";i:10026;s:5:\"title\";s:46:\"Classic | Register | Subscribe | Gym | Fitness\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2019/01/classic_register_small.png\";s:12:\"tmpl_created\";i:1547845205;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-register-subscribe-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:556;s:11:\"trend_index\";i:620;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:449;a:14:{s:2:\"id\";i:5464;s:5:\"title\";s:8:\"About 17\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_6.png\";s:12:\"tmpl_created\";i:1520443518;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:229;s:11:\"trend_index\";i:249;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:450;a:14:{s:2:\"id\";i:10036;s:5:\"title\";s:43:\"Full Screen | Sale | Promotion | Headphones\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2019/01/full_sale_head_small.png\";s:12:\"tmpl_created\";i:1547845409;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/full-screen-sale-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:574;s:11:\"trend_index\";i:467;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:451;a:14:{s:2:\"id\";i:14111;s:5:\"title\";s:36:\"Classic | Japanese restaurant | Sale\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/06/Pop-Up-Page-Small.jpg\";s:12:\"tmpl_created\";i:1592300400;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-japanese-restaurant-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:715;s:11:\"trend_index\";i:587;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:452;a:14:{s:2:\"id\";i:5472;s:5:\"title\";s:7:\"About 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_7.png\";s:12:\"tmpl_created\";i:1520443520;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/about-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:214;s:11:\"trend_index\";i:178;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:453;a:14:{s:2:\"id\";i:5480;s:5:\"title\";s:7:\"About 4\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_7-1.png\";s:12:\"tmpl_created\";i:1520443522;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/about-4-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:424;s:11:\"trend_index\";i:417;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:454;a:14:{s:2:\"id\";i:10057;s:5:\"title\";s:48:\"Hello Bar | Register | Subscribe | Gym | Fitness\";s:9:\"thumbnail\";s:91:\"https://library.elementor.com/wp-content/uploads/2019/01/hello-bar_register_sport_small.png\";s:12:\"tmpl_created\";i:1547847938;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/hello-bar-register-subscribe/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:702;s:11:\"trend_index\";i:674;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:455;a:14:{s:2:\"id\";i:5488;s:5:\"title\";s:7:\"About 7\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_8.png\";s:12:\"tmpl_created\";i:1520443524;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/about-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:314;s:11:\"trend_index\";i:355;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:456;a:14:{s:2:\"id\";i:5496;s:5:\"title\";s:7:\"About 9\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_8-1.png\";s:12:\"tmpl_created\";i:1520443526;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/about-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:508;s:11:\"trend_index\";i:575;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:457;a:14:{s:2:\"id\";i:5504;s:5:\"title\";s:8:\"About 18\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_9.png\";s:12:\"tmpl_created\";i:1520443528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:112;s:11:\"trend_index\";i:161;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:458;a:14:{s:2:\"id\";i:10087;s:5:\"title\";s:25:\"Full Screen | Login | Spa\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2019/01/full-screen_login_spa_small.png\";s:12:\"tmpl_created\";i:1547848301;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/full-screen-login-spa/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:595;s:11:\"trend_index\";i:625;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:459;a:14:{s:2:\"id\";i:14772;s:5:\"title\";s:35:\"Luxury Real Estate &#8211; 404 page\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/07/404.png\";s:12:\"tmpl_created\";i:1595315728;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/blocks/luxury-real-estate-404-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:34:\"[\"404\",\"real estate\",\"realestate\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:728;s:11:\"trend_index\";i:626;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:460;a:14:{s:2:\"id\";i:5515;s:5:\"title\";s:8:\"About 19\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_9.png\";s:12:\"tmpl_created\";i:1520443530;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-19/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:275;s:11:\"trend_index\";i:280;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:461;a:14:{s:2:\"id\";i:10097;s:5:\"title\";s:37:\"Classic | Register | Subscribe | Lego\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2019/01/classic_lego_small.png\";s:12:\"tmpl_created\";i:1547848411;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-register-subscribe-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:633;s:11:\"trend_index\";i:632;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:462;a:14:{s:2:\"id\";i:14779;s:5:\"title\";s:33:\"Luxury Real Estate &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/07/Footer.png\";s:12:\"tmpl_created\";i:1595315743;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/luxury-real-estate-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:37:\"[\"footer\",\"real estate\",\"realestate\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:666;s:11:\"trend_index\";i:263;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:463;a:14:{s:2:\"id\";i:1190;s:5:\"title\";s:26:\"Landing Page &#8211; Hotel\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2017/03/lp2-l.png\";s:12:\"tmpl_created\";i:1490707391;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/landing-page-hotel/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:3;s:11:\"trend_index\";i:1;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:464;a:14:{s:2:\"id\";i:9816;s:5:\"title\";s:30:\"Classic | Sale | Gym | Fitness\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2019/01/classic_sale_sport_small.png\";s:12:\"tmpl_created\";i:1547991876;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:655;s:11:\"trend_index\";i:0;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:465;a:14:{s:2:\"id\";i:9602;s:5:\"title\";s:35:\"Bottom Bar | Announcement | Cookies\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2019/01/Bottombar_Announcement_small_01.png\";s:12:\"tmpl_created\";i:1546964559;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/bottom-bar-announcement-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:560;s:11:\"trend_index\";i:663;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:466;a:14:{s:2:\"id\";i:225;s:5:\"title\";s:27:\"Homepage &#8211; Restaurant\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0016.png\";s:12:\"tmpl_created\";i:1470829872;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/homepage-restaurant/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Homepage\",\"Restaurant\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:1;s:11:\"trend_index\";i:3;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:467;a:14:{s:2:\"id\";i:463;s:5:\"title\";s:22:\"Homepage &#8211; Study\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/10/0022.png\";s:12:\"tmpl_created\";i:1477388340;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/homepage-study/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Education\",\"Homepage\",\"Study\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:5;s:11:\"trend_index\";i:4;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:468;a:14:{s:2:\"id\";i:10277;s:5:\"title\";s:36:\"Bottom Bar | Promotion | Sale | Book\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/book_small.png\";s:12:\"tmpl_created\";i:1548055999;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/bottom-bar-promotion-book/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:674;s:11:\"trend_index\";i:654;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:469;a:14:{s:2:\"id\";i:11241;s:5:\"title\";s:36:\"Classic | Digital Agency | Marketing\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/07/PopUp_small.jpg\";s:12:\"tmpl_created\";i:1564643043;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-digital-agency-marketing/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:370;s:11:\"trend_index\";i:311;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:470;a:14:{s:2:\"id\";i:181;s:5:\"title\";s:23:\"Homepage &#8211; Agency\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0019.png\";s:12:\"tmpl_created\";i:1470826567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/homepage-agency/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Agency\",\"Creative\",\"Homepage\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:2;s:11:\"trend_index\";i:2;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:471;a:14:{s:2:\"id\";i:9903;s:5:\"title\";s:34:\"Bottom Bar | Promotion | Olive Oil\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2019/01/bottom-bar_promotion_olive_small.png\";s:12:\"tmpl_created\";i:1547838896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/bottom-bar-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:705;s:11:\"trend_index\";i:712;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:472;a:14:{s:2:\"id\";i:150;s:5:\"title\";s:19:\"Product &#8211; App\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0003.png\";s:12:\"tmpl_created\";i:1470829879;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/product-app/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:6;s:11:\"trend_index\";i:5;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:473;a:14:{s:2:\"id\";i:15158;s:5:\"title\";s:26:\"Psychologist &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/09/About.jpg\";s:12:\"tmpl_created\";i:1600157561;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/psychologist-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:474;a:14:{s:2:\"id\";i:10549;s:5:\"title\";s:33:\"Bottom Bar | Register | Subscribe\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/com_small.png\";s:12:\"tmpl_created\";i:1547967595;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/bottom-bar-register-subscribe/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:661;s:11:\"trend_index\";i:671;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:475;a:14:{s:2:\"id\";i:15197;s:5:\"title\";s:28:\"Psychologist &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/09/Contact-Us.jpg\";s:12:\"tmpl_created\";i:1600160499;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/psychologist-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:476;a:14:{s:2:\"id\";i:15142;s:5:\"title\";s:25:\"Psychologist &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/09/Home.jpg\";s:12:\"tmpl_created\";i:1600156308;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/psychologist-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:477;a:14:{s:2:\"id\";i:15188;s:5:\"title\";s:28:\"Psychologist &#8211; Pricing\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/09/Pricing.jpg\";s:12:\"tmpl_created\";i:1600159731;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/psychologist-pricing/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:478;a:14:{s:2:\"id\";i:10529;s:5:\"title\";s:36:\"Classic | Announcement | Maintenance\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/icon_small.png\";s:12:\"tmpl_created\";i:1548046309;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/classic-announcement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:452;s:11:\"trend_index\";i:408;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:479;a:14:{s:2:\"id\";i:15167;s:5:\"title\";s:29:\"Psychologist &#8211; Services\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/09/Services.jpg\";s:12:\"tmpl_created\";i:1600158206;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/psychologist-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:480;a:14:{s:2:\"id\";i:14932;s:5:\"title\";s:30:\"Flooring Company &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/08/About.png\";s:12:\"tmpl_created\";i:1597740110;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/flooring-company-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:642;s:11:\"trend_index\";i:102;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:481;a:14:{s:2:\"id\";i:14998;s:5:\"title\";s:32:\"Flooring Company &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/08/Contact-Us.png\";s:12:\"tmpl_created\";i:1597740222;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/flooring-company-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:676;s:11:\"trend_index\";i:116;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:482;a:14:{s:2:\"id\";i:14965;s:5:\"title\";s:32:\"Flooring Company &#8211; Gallery\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/08/Gallery.png\";s:12:\"tmpl_created\";i:1597740353;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/flooring-company-gallery/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:608;s:11:\"trend_index\";i:57;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:483;a:14:{s:2:\"id\";i:14947;s:5:\"title\";s:33:\"Flooring company &#8211; Services\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/08/Services.png\";s:12:\"tmpl_created\";i:1597740551;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/flooring-company-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:673;s:11:\"trend_index\";i:139;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:484;a:14:{s:2:\"id\";i:14901;s:5:\"title\";s:29:\"Flooring Company &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/08/Home.png\";s:12:\"tmpl_created\";i:1597740474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/flooring-company-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:639;s:11:\"trend_index\";i:131;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:485;a:14:{s:2:\"id\";i:14737;s:5:\"title\";s:32:\"Luxury Real Estate &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/07/About.png\";s:12:\"tmpl_created\";i:1595313527;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/luxury-real-estate-about-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"real estate\",\"realestate\"]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:627;s:11:\"trend_index\";i:302;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:486;a:14:{s:2:\"id\";i:10413;s:5:\"title\";s:28:\"Classic | Content Lock | Pop\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/hot_small.png\";s:12:\"tmpl_created\";i:1547961774;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/classic-content-lock/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:687;s:11:\"trend_index\";i:680;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:487;a:14:{s:2:\"id\";i:14756;s:5:\"title\";s:34:\"Luxury Real Estate &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/07/Contact-Us.png\";s:12:\"tmpl_created\";i:1595313519;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/luxury-real-estate-contact-us-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"real estate\",\"realestate\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:658;s:11:\"trend_index\";i:303;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:488;a:14:{s:2:\"id\";i:14716;s:5:\"title\";s:31:\"Luxury Real Estate &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/07/Home.png\";s:12:\"tmpl_created\";i:1595313512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/luxury-real-estate-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"real estate\",\"realestate\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:569;s:11:\"trend_index\";i:201;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:489;a:14:{s:2:\"id\";i:10223;s:5:\"title\";s:15:\"Classic | Login\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/01/welcome_small.png\";s:12:\"tmpl_created\";i:1547887343;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/classic-login-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:471;s:11:\"trend_index\";i:437;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:490;a:14:{s:2:\"id\";i:10559;s:5:\"title\";s:33:\"Bottom Bar | Register | Subscribe\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/fly_small.png\";s:12:\"tmpl_created\";i:1547967711;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/bottom-bar-register-subscribe-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:645;s:11:\"trend_index\";i:704;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:491;a:14:{s:2:\"id\";i:14763;s:5:\"title\";s:31:\"Luxury Real Estate &#8211; News\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/07/news-Archive.png\";s:12:\"tmpl_created\";i:1595313273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/luxury-real-estate-news-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"real estate\",\"realestate\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:589;s:11:\"trend_index\";i:168;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:492;a:14:{s:2:\"id\";i:10403;s:5:\"title\";s:15:\"Classic | Login\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/hello_small.png\";s:12:\"tmpl_created\";i:1548056371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/classic-login-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:570;s:11:\"trend_index\";i:635;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:493;a:14:{s:2:\"id\";i:13960;s:5:\"title\";s:32:\"Japanese restaurant &#8211; Home\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/06/Home-Page.jpg\";s:12:\"tmpl_created\";i:1592289775;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/japanese-restaurant-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:603;s:11:\"trend_index\";i:270;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:494;a:14:{s:2:\"id\";i:9913;s:5:\"title\";s:27:\"Classic | Login | Christmas\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/log_small.png\";s:12:\"tmpl_created\";i:1547841430;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/classic-login-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:530;s:11:\"trend_index\";i:451;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:495;a:14:{s:2:\"id\";i:13993;s:5:\"title\";s:45:\"Japanese restaurant &#8211; Chef&#8217;s Menu\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2020/06/Chef_s-Menu-Page.jpg\";s:12:\"tmpl_created\";i:1592289691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/japanese-restaurant-chefs-menu/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:654;s:11:\"trend_index\";i:504;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:496;a:14:{s:2:\"id\";i:14012;s:5:\"title\";s:36:\"Japanese restaurant &#8211; Bar Menu\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2020/06/Bar-Menu-Page.jpg\";s:12:\"tmpl_created\";i:1592289665;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/japanese-restaurant-bar-menu/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:700;s:11:\"trend_index\";i:526;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:497;a:14:{s:2:\"id\";i:13917;s:5:\"title\";s:33:\"Japanese restaurant &#8211; About\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/06/About-Page.jpg\";s:12:\"tmpl_created\";i:1592289629;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/japanese-restaurant-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:656;s:11:\"trend_index\";i:375;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:498;a:14:{s:2:\"id\";i:13937;s:5:\"title\";s:35:\"Japanese restaurant &#8211; Gallery\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/06/Gallery-Page.jpg\";s:12:\"tmpl_created\";i:1592289748;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/japanese-restaurant-gallery/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:670;s:11:\"trend_index\";i:395;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:499;a:14:{s:2:\"id\";i:14030;s:5:\"title\";s:34:\"Japanese restaurant &#8211; Events\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/06/Events-Page.jpg\";s:12:\"tmpl_created\";i:1592289713;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/japanese-restaurant-events/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:711;s:11:\"trend_index\";i:473;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:500;a:14:{s:2:\"id\";i:9592;s:5:\"title\";s:26:\"Classic | Promotion | Sale\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2019/01/Classic_Promotion_small_01.png\";s:12:\"tmpl_created\";i:1546963720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/classic-promotion-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:607;s:11:\"trend_index\";i:601;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:501;a:14:{s:2:\"id\";i:13984;s:5:\"title\";s:40:\"Japanese restaurant &#8211; Reservations\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/06/reservations.jpg\";s:12:\"tmpl_created\";i:1592294757;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/japanese-restaurant-reservations/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:699;s:11:\"trend_index\";i:494;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:502;a:14:{s:2:\"id\";i:10210;s:5:\"title\";s:29:\"Classic | Promotion | Webinar\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/web_small-1.png\";s:12:\"tmpl_created\";i:1547886103;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/classic-promotion-webinar/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:27;s:16:\"popularity_index\";i:720;s:11:\"trend_index\";i:696;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:503;a:14:{s:2:\"id\";i:13479;s:5:\"title\";s:23:\"Barbershop &#8211; Home\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/05/Home-Page.jpg\";s:12:\"tmpl_created\";i:1589893275;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/barbershop-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:27;s:16:\"popularity_index\";i:644;s:11:\"trend_index\";i:592;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:504;a:14:{s:2:\"id\";i:13503;s:5:\"title\";s:24:\"Barbershop &#8211; About\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/05/About-Page.jpg\";s:12:\"tmpl_created\";i:1589893289;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/barbershop-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:697;s:11:\"trend_index\";i:631;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:505;a:14:{s:2:\"id\";i:13548;s:5:\"title\";s:27:\"Barbershop &#8211; Services\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2020/05/Services-Page.jpg\";s:12:\"tmpl_created\";i:1589893298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/barbershop-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:709;s:11:\"trend_index\";i:710;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:506;a:14:{s:2:\"id\";i:13560;s:5:\"title\";s:26:\"Barbershop &#8211; Gallery\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/05/Gallery-Page.jpg\";s:12:\"tmpl_created\";i:1589893307;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/barbershop-gallery/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:30;s:16:\"popularity_index\";i:707;s:11:\"trend_index\";i:672;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:507;a:14:{s:2:\"id\";i:10047;s:5:\"title\";s:15:\"Classic | Login\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/yellow_small.png\";s:12:\"tmpl_created\";i:1547847757;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/classic-login-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:30;s:16:\"popularity_index\";i:503;s:11:\"trend_index\";i:450;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:508;a:14:{s:2:\"id\";i:9879;s:5:\"title\";s:38:\"Classic | Register | Subscribe | Leads\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/dog_small.png\";s:12:\"tmpl_created\";i:1547838416;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/classic-register-subscribe/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:612;s:11:\"trend_index\";i:657;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:509;a:14:{s:2:\"id\";i:13587;s:5:\"title\";s:26:\"Barbershop &#8211; Contact\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/05/Contact-Us-Page.jpg\";s:12:\"tmpl_created\";i:1589893315;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/barbershop-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:703;s:11:\"trend_index\";i:706;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:510;a:14:{s:2:\"id\";i:13307;s:5:\"title\";s:26:\"Online Course &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/04/Home.jpg\";s:12:\"tmpl_created\";i:1587474541;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/online-course-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:311;s:11:\"trend_index\";i:101;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:511;a:14:{s:2:\"id\";i:13328;s:5:\"title\";s:27:\"Online Course &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/04/About.jpg\";s:12:\"tmpl_created\";i:1587474558;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/online-course-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:33;s:16:\"popularity_index\";i:540;s:11:\"trend_index\";i:293;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:512;a:14:{s:2:\"id\";i:13338;s:5:\"title\";s:33:\"Online Course &#8211; Course Page\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/04/Course-Page.png\";s:12:\"tmpl_created\";i:1587474574;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/online-course-course-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:384;s:11:\"trend_index\";i:203;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:513;a:14:{s:2:\"id\";i:10297;s:5:\"title\";s:14:\"Classic | Sale\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/01/s_yellow_small.png\";s:12:\"tmpl_created\";i:1548056099;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:547;s:11:\"trend_index\";i:612;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:514;a:14:{s:2:\"id\";i:13352;s:5:\"title\";s:29:\"Online Course &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/Contact-Us.jpg\";s:12:\"tmpl_created\";i:1587474591;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/online-course-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:562;s:11:\"trend_index\";i:279;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:515;a:14:{s:2:\"id\";i:10393;s:5:\"title\";s:14:\"Classic | Sale\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/blue_small.png\";s:12:\"tmpl_created\";i:1548056682;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:36;s:16:\"popularity_index\";i:621;s:11:\"trend_index\";i:714;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:516;a:14:{s:2:\"id\";i:13187;s:5:\"title\";s:33:\"Interior Design &#8211; Home Page\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/04/Home.png\";s:12:\"tmpl_created\";i:1586148661;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/interior-design-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"business\",\"interior design\"]\";s:10:\"menu_order\";i:36;s:16:\"popularity_index\";i:376;s:11:\"trend_index\";i:340;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:517;a:14:{s:2:\"id\";i:13199;s:5:\"title\";s:29:\"Interior Design &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/04/About.png\";s:12:\"tmpl_created\";i:1586148666;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/interior-design-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"business\",\"interior design\"]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:362;s:11:\"trend_index\";i:202;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:518;a:14:{s:2:\"id\";i:10579;s:5:\"title\";s:14:\"Classic | Sale\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/sale1_small.png\";s:12:\"tmpl_created\";i:1547967887;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:38;s:16:\"popularity_index\";i:657;s:11:\"trend_index\";i:608;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:519;a:14:{s:2:\"id\";i:13214;s:5:\"title\";s:32:\"Interior Design &#8211; Projects\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/04/portfolio_s.jpg\";s:12:\"tmpl_created\";i:1586148672;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/interior-design-projects/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"business\",\"interior design\"]\";s:10:\"menu_order\";i:38;s:16:\"popularity_index\";i:406;s:11:\"trend_index\";i:229;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:520;a:14:{s:2:\"id\";i:13229;s:5:\"title\";s:31:\"Interior Design &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/Contact-Us.png\";s:12:\"tmpl_created\";i:1586148677;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/interior-design-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"business\",\"interior design\"]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:434;s:11:\"trend_index\";i:231;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:521;a:14:{s:2:\"id\";i:12948;s:5:\"title\";s:29:\"Photography &#8211; Home Page\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/02/Home_s.png\";s:12:\"tmpl_created\";i:1582093442;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/photography-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:40;s:16:\"popularity_index\";i:292;s:11:\"trend_index\";i:143;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:522;a:14:{s:2:\"id\";i:12798;s:5:\"title\";s:25:\"Photography &#8211; About\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/About_s.png\";s:12:\"tmpl_created\";i:1582093446;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/photography-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:488;s:11:\"trend_index\";i:480;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:523;a:14:{s:2:\"id\";i:12868;s:5:\"title\";s:27:\"Photography &#8211; Contact\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/02/Contact_s.png\";s:12:\"tmpl_created\";i:1582093450;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/photography-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:523;s:11:\"trend_index\";i:390;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:524;a:14:{s:2:\"id\";i:10180;s:5:\"title\";s:21:\"Fly In | Announcement\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/glass_small.png\";s:12:\"tmpl_created\";i:1548045309;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/fly-in-announcement-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:43;s:16:\"popularity_index\";i:623;s:11:\"trend_index\";i:682;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:525;a:14:{s:2:\"id\";i:13056;s:5:\"title\";s:28:\"Photography &#8211; Wildlife\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/02/Wildlife_s.png\";s:12:\"tmpl_created\";i:1582093454;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/photography-wildlife/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:43;s:16:\"popularity_index\";i:550;s:11:\"trend_index\";i:472;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:526;a:14:{s:2:\"id\";i:12922;s:5:\"title\";s:37:\"Photography &#8211; Glowing Jellyfish\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/02/Jellyfish_S.png\";s:12:\"tmpl_created\";i:1582093457;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/photography-glowing-jellyfish/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:44;s:16:\"popularity_index\";i:591;s:11:\"trend_index\";i:321;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:527;a:14:{s:2:\"id\";i:12875;s:5:\"title\";s:36:\"Photography &#8211; Fluttering Birds\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/Birds_s.png\";s:12:\"tmpl_created\";i:1582093461;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/photography-fluttering-birds/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:45;s:16:\"popularity_index\";i:653;s:11:\"trend_index\";i:637;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:528;a:14:{s:2:\"id\";i:9731;s:5:\"title\";s:26:\"Classic | Sale | Promotion\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/01/icecream_small.png\";s:12:\"tmpl_created\";i:1547976166;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/popups/classic-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:587;s:11:\"trend_index\";i:543;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:529;a:14:{s:2:\"id\";i:12962;s:5:\"title\";s:26:\"Photography &#8211; Nature\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/02/Nature_s.png\";s:12:\"tmpl_created\";i:1582093465;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/photography-nature/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:567;s:11:\"trend_index\";i:434;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:530;a:14:{s:2:\"id\";i:12833;s:5:\"title\";s:38:\"Photography &#8211; Blossoming Flowers\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/02/Flowers_s.png\";s:12:\"tmpl_created\";i:1582093469;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/photography-blossoming-flowers/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:47;s:16:\"popularity_index\";i:577;s:11:\"trend_index\";i:358;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:531;a:14:{s:2:\"id\";i:12898;s:5:\"title\";s:36:\"Photography &#8211; Forest Mushrooms\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/02/Mushrooms_s.png\";s:12:\"tmpl_created\";i:1582093473;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/photography-forest-mushrooms/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:48;s:16:\"popularity_index\";i:629;s:11:\"trend_index\";i:574;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:532;a:14:{s:2:\"id\";i:12994;s:5:\"title\";s:24:\"Photography &#8211; Pets\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/02/Pets_s.png\";s:12:\"tmpl_created\";i:1582093477;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/photography-pets/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:49;s:16:\"popularity_index\";i:592;s:11:\"trend_index\";i:488;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:533;a:14:{s:2:\"id\";i:12805;s:5:\"title\";s:38:\"Photography &#8211; B&#038;W Portraits\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/Black_s.png\";s:12:\"tmpl_created\";i:1582093481;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/photography-bw-portraits/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:50;s:16:\"popularity_index\";i:660;s:11:\"trend_index\";i:555;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:534;a:14:{s:2:\"id\";i:13031;s:5:\"title\";s:33:\"Photography &#8211; Vivid Parrots\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/02/Parrots_s.png\";s:12:\"tmpl_created\";i:1582093484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/photography-vivid-parrots/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:51;s:16:\"popularity_index\";i:613;s:11:\"trend_index\";i:518;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:535;a:14:{s:2:\"id\";i:12621;s:5:\"title\";s:26:\"Magazine &#8211; Home Page\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/01/Home_s.png\";s:12:\"tmpl_created\";i:1579060604;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/magazine-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:52;s:16:\"popularity_index\";i:199;s:11:\"trend_index\";i:77;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:536;a:14:{s:2:\"id\";i:12352;s:5:\"title\";s:24:\"Travel &#8211; Home Page\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2019/12/Home_s.png\";s:12:\"tmpl_created\";i:1575960464;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/travel-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:53;s:16:\"popularity_index\";i:294;s:11:\"trend_index\";i:211;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:537;a:14:{s:2:\"id\";i:12400;s:5:\"title\";s:20:\"Travel &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2019/12/About.png\";s:12:\"tmpl_created\";i:1575960441;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/travel-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:54;s:16:\"popularity_index\";i:412;s:11:\"trend_index\";i:367;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:538;a:14:{s:2:\"id\";i:10005;s:5:\"title\";s:38:\"Fly In | Promotion | Spa | Body Lotion\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2019/01/Flyin_lotion_small.png\";s:12:\"tmpl_created\";i:1547844909;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/fly-in-promotion-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:54;s:16:\"popularity_index\";i:694;s:11:\"trend_index\";i:0;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:539;a:14:{s:2:\"id\";i:10424;s:5:\"title\";s:21:\"Fly In | Announcement\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/flower_small.png\";s:12:\"tmpl_created\";i:1547961866;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/fly-in-announcement-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:610;s:11:\"trend_index\";i:702;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:540;a:14:{s:2:\"id\";i:12479;s:5:\"title\";s:20:\"Travel &#8211; Tours\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/12/Tours_s.png\";s:12:\"tmpl_created\";i:1575960474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/travel-tours/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:499;s:11:\"trend_index\";i:412;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:541;a:14:{s:2:\"id\";i:9975;s:5:\"title\";s:24:\"Fly In | Promotion | App\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2019/01/flyin_webinar_app_small.png\";s:12:\"tmpl_created\";i:1547842284;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/popups/fly-in-promotion-webinar/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:714;s:11:\"trend_index\";i:0;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:542;a:14:{s:2:\"id\";i:12466;s:5:\"title\";s:27:\"Travel &#8211; Testimonials\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/12/Testimonials.png\";s:12:\"tmpl_created\";i:1575960469;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/travel-testimonials/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:507;s:11:\"trend_index\";i:507;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:543;a:14:{s:2:\"id\";i:10067;s:5:\"title\";s:31:\"Fly In | Announcement | Cookies\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2019/01/fly-in_cookie_yellow_small.png\";s:12:\"tmpl_created\";i:1547848075;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/fly-in-announcement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:546;s:11:\"trend_index\";i:493;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:544;a:14:{s:2:\"id\";i:12443;s:5:\"title\";s:22:\"Travel &#8211; Gallery\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/12/Gallery.png\";s:12:\"tmpl_created\";i:1575960459;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/travel-gallery/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:57;s:16:\"popularity_index\";i:446;s:11:\"trend_index\";i:531;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:545;a:14:{s:2:\"id\";i:12431;s:5:\"title\";s:18:\"Travel &#8211; FAQ\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/12/FAQ.png\";s:12:\"tmpl_created\";i:1575960453;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:100:\"https://library.elementor.com/travel-faq/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:58;s:16:\"popularity_index\";i:495;s:11:\"trend_index\";i:384;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:546;a:14:{s:2:\"id\";i:10329;s:5:\"title\";s:25:\"Fly In | Sale | Promotion\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/01/organic_small.png\";s:12:\"tmpl_created\";i:1547893478;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/fly-in-sale-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:59;s:16:\"popularity_index\";i:722;s:11:\"trend_index\";i:0;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:547;a:14:{s:2:\"id\";i:12421;s:5:\"title\";s:27:\"Travel &#8211; Contact Page\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/12/Contsct-Us.png\";s:12:\"tmpl_created\";i:1575960445;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/travel-contact-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:59;s:16:\"popularity_index\";i:531;s:11:\"trend_index\";i:482;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:548;a:14:{s:2:\"id\";i:11763;s:5:\"title\";s:27:\"Portfolio &#8211; Home Page\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Homepage_small.png\";s:12:\"tmpl_created\";i:1569428959;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/portfolio-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:293;s:11:\"trend_index\";i:319;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:549;a:14:{s:2:\"id\";i:9650;s:5:\"title\";s:36:\"Fly In | Register | Subscribe | Sale\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2019/01/Fly-In_Register_small_01a.png\";s:12:\"tmpl_created\";i:1547007598;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/popups/fly-in-register_big-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:708;s:11:\"trend_index\";i:701;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:550;a:14:{s:2:\"id\";i:11781;s:5:\"title\";s:23:\"Portfolio &#8211; About\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/09/About_small.png\";s:12:\"tmpl_created\";i:1569428955;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/portfolio-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:61;s:16:\"popularity_index\";i:352;s:11:\"trend_index\";i:361;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:551;a:14:{s:2:\"id\";i:11793;s:5:\"title\";s:26:\"Portfolio &#8211; Projects\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Projects_small.png\";s:12:\"tmpl_created\";i:1569428951;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/portfolio-projects/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:62;s:16:\"popularity_index\";i:415;s:11:\"trend_index\";i:335;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:552;a:14:{s:2:\"id\";i:10200;s:5:\"title\";s:33:\"Full Screen | Content Lock | Wine\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/lock_wine_small.png\";s:12:\"tmpl_created\";i:1548055635;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/popups/full-screen-content-lock/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:63;s:16:\"popularity_index\";i:665;s:11:\"trend_index\";i:667;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:553;a:14:{s:2:\"id\";i:11800;s:5:\"title\";s:25:\"Portfolio &#8211; Contact\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/09/Contact_small.png\";s:12:\"tmpl_created\";i:1569428946;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/portfolio-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:63;s:16:\"popularity_index\";i:467;s:11:\"trend_index\";i:547;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:554;a:14:{s:2:\"id\";i:10287;s:5:\"title\";s:34:\"Full Screen | Register | Subscribe\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2019/01/glass_pink_small.png\";s:12:\"tmpl_created\";i:1547994301;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/full-screen-login-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:64;s:16:\"popularity_index\";i:553;s:11:\"trend_index\";i:643;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:555;a:14:{s:2:\"id\";i:11163;s:5:\"title\";s:32:\"Digital Agency &#8211; Home Page\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/07/Home_small.png\";s:12:\"tmpl_created\";i:1564641877;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/digital-agency-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"marketing\"]\";s:10:\"menu_order\";i:64;s:16:\"popularity_index\";i:69;s:11:\"trend_index\";i:26;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:556;a:14:{s:2:\"id\";i:9139;s:5:\"title\";s:25:\"Homepage &#8211; Business\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/07/Get_Started_250.png\";s:12:\"tmpl_created\";i:1532949924;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/homepage-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:167:\"[\"Agency\",\"bootstrap\",\"business\",\"corporate\",\"Landing Page\",\"marketing campaign\",\"marketing landing page\",\"product launch\",\"software\",\"Startup\",\"startup landing page\"]\";s:10:\"menu_order\";i:65;s:16:\"popularity_index\";i:7;s:11:\"trend_index\";i:7;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:557;a:14:{s:2:\"id\";i:1634;s:5:\"title\";s:33:\"Landing Page &#8211; Chiropractor\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Chiropractor.png\";s:12:\"tmpl_created\";i:1494352119;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/landing-page-chiropractor/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:66;s:16:\"popularity_index\";i:207;s:11:\"trend_index\";i:208;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:558;a:14:{s:2:\"id\";i:9889;s:5:\"title\";s:28:\"Full Screen | Login | Cactus\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/cac_small.png\";s:12:\"tmpl_created\";i:1547838722;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/popups/full-screen-login/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:66;s:16:\"popularity_index\";i:684;s:11:\"trend_index\";i:0;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:559;a:14:{s:2:\"id\";i:12143;s:5:\"title\";s:22:\"Law Firm &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2019/11/about.png\";s:12:\"tmpl_created\";i:1572847069;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/law-firm-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:67;s:16:\"popularity_index\";i:375;s:11:\"trend_index\";i:284;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:560;a:14:{s:2:\"id\";i:10077;s:5:\"title\";s:29:\"Fly In | Register | Subscribe\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2019/01/flyin_register_blue_small.png\";s:12:\"tmpl_created\";i:1547848197;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/fly-in-register-subscribe/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:67;s:16:\"popularity_index\";i:506;s:11:\"trend_index\";i:585;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:561;a:14:{s:2:\"id\";i:12091;s:5:\"title\";s:21:\"Law Firm &#8211; Team\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2019/11/team.png\";s:12:\"tmpl_created\";i:1572847113;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/law-firm-team/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:68;s:16:\"popularity_index\";i:354;s:11:\"trend_index\";i:241;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:562;a:14:{s:2:\"id\";i:10362;s:5:\"title\";s:32:\"Full Screen | Login | Restaurant\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/vip_small.png\";s:12:\"tmpl_created\";i:1548056253;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/full-screen-login-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:69;s:16:\"popularity_index\";i:565;s:11:\"trend_index\";i:366;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:563;a:14:{s:2:\"id\";i:11129;s:5:\"title\";s:28:\"Digital Agency &#8211; About\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/07/About_small.png\";s:12:\"tmpl_created\";i:1564641889;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/digital-agency-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"marketing\"]\";s:10:\"menu_order\";i:69;s:16:\"popularity_index\";i:193;s:11:\"trend_index\";i:112;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:564;a:14:{s:2:\"id\";i:11572;s:5:\"title\";s:19:\"Gym &#8211; Trainer\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Trainer_Small.png\";s:12:\"tmpl_created\";i:1567392934;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/gym-trainer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:70;s:16:\"popularity_index\";i:534;s:11:\"trend_index\";i:589;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:565;a:14:{s:2:\"id\";i:1504;s:5:\"title\";s:33:\"Landing Page &#8211; Mobile App 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-app2.png\";s:12:\"tmpl_created\";i:1494352112;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/landing-page-mobile-app-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:71;s:16:\"popularity_index\";i:163;s:11:\"trend_index\";i:253;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:566;a:14:{s:2:\"id\";i:10454;s:5:\"title\";s:29:\"Full Screen | Promotion | App\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/appy_small.png\";s:12:\"tmpl_created\";i:1548056896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/full-screen-promotion-app/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:71;s:16:\"popularity_index\";i:713;s:11:\"trend_index\";i:0;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:567;a:14:{s:2:\"id\";i:12133;s:5:\"title\";s:24:\"Law Firm &#8211; Careers\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/11/careers.png\";s:12:\"tmpl_created\";i:1572847078;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/law-firm-careers/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:72;s:16:\"popularity_index\";i:558;s:11:\"trend_index\";i:545;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:568;a:14:{s:2:\"id\";i:9803;s:5:\"title\";s:41:\"Full Screen | Register | Contact | Meetup\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2019/01/designme_full_small.png\";s:12:\"tmpl_created\";i:1547831298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/full-screen-register-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:72;s:16:\"popularity_index\";i:641;s:11:\"trend_index\";i:645;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:569;a:14:{s:2:\"id\";i:10611;s:5:\"title\";s:18:\"Full Screen | Sale\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/fla_small.png\";s:12:\"tmpl_created\";i:1547968868;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/full-screen-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:73;s:16:\"popularity_index\";i:716;s:11:\"trend_index\";i:705;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:570;a:14:{s:2:\"id\";i:12155;s:5:\"title\";s:26:\"Law Firm &#8211; Home Page\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2019/11/home.png\";s:12:\"tmpl_created\";i:1572847054;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/law-firm-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:73;s:16:\"popularity_index\";i:218;s:11:\"trend_index\";i:245;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:571;a:14:{s:2:\"id\";i:12080;s:5:\"title\";s:24:\"Law Firm &#8211; Partner\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/11/partner-1.png\";s:12:\"tmpl_created\";i:1572847120;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/law-firm-partner/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:74;s:16:\"popularity_index\";i:541;s:11:\"trend_index\";i:478;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:572;a:14:{s:2:\"id\";i:10508;s:5:\"title\";s:25:\"Full Screen | Welcome Mat\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/hand_small-1.png\";s:12:\"tmpl_created\";i:1547964711;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/full-screen-welcome-mat-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:75;s:16:\"popularity_index\";i:647;s:11:\"trend_index\";i:659;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:573;a:14:{s:2:\"id\";i:11074;s:5:\"title\";s:31:\"Digital Agency &#8211; Services\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/07/Services_small.png\";s:12:\"tmpl_created\";i:1564641872;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/digital-agency-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"marketing\"]\";s:10:\"menu_order\";i:75;s:16:\"popularity_index\";i:169;s:11:\"trend_index\";i:108;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:574;a:14:{s:2:\"id\";i:11506;s:5:\"title\";s:19:\"Gym &#8211; Classes\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Classes_Small.png\";s:12:\"tmpl_created\";i:1567392930;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/gym-classes/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:76;s:16:\"popularity_index\";i:516;s:11:\"trend_index\";i:538;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:575;a:14:{s:2:\"id\";i:9934;s:5:\"title\";s:38:\"Full Screen | Welcome Mat | Teddy Bear\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2019/01/full_mat_teddy_small.png\";s:12:\"tmpl_created\";i:1547841787;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/full-screen-welcome-mat/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:76;s:16:\"popularity_index\";i:617;s:11:\"trend_index\";i:665;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:576;a:14:{s:2:\"id\";i:1503;s:5:\"title\";s:33:\"Landing Page &#8211; Mobile App 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-app1.png\";s:12:\"tmpl_created\";i:1494352113;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/landing-page-mobile-app-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:77;s:16:\"popularity_index\";i:162;s:11:\"trend_index\";i:187;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:577;a:14:{s:2:\"id\";i:12044;s:5:\"title\";s:24:\"Law Firm &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/11/contsct_us.png\";s:12:\"tmpl_created\";i:1572847130;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/law-firm-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:78;s:16:\"popularity_index\";i:441;s:11:\"trend_index\";i:400;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:578;a:14:{s:2:\"id\";i:9709;s:5:\"title\";s:25:\"Full Screen | Welcome Mat\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2019/01/Full-Screen_Welcome-Mat_01_small-1.png\";s:12:\"tmpl_created\";i:1547023834;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/full-screen-welcome-mat-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:78;s:16:\"popularity_index\";i:667;s:11:\"trend_index\";i:634;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:579;a:14:{s:2:\"id\";i:12124;s:5:\"title\";s:25:\"Law Firm &#8211; Services\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2019/11/services.png\";s:12:\"tmpl_created\";i:1572847096;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/law-firm-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:79;s:16:\"popularity_index\";i:422;s:11:\"trend_index\";i:316;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:580;a:14:{s:2:\"id\";i:9671;s:5:\"title\";s:34:\"Hello Bar | Announcement | Cookies\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2019/01/Top-Bar_Announcement_small_01.png\";s:12:\"tmpl_created\";i:1547010259;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/hello-bar-announcement-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:79;s:16:\"popularity_index\";i:588;s:11:\"trend_index\";i:633;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:581;a:14:{s:2:\"id\";i:10234;s:5:\"title\";s:38:\"Hello Bar | Announcement | Maintenance\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/pink_small.png\";s:12:\"tmpl_created\";i:1548055049;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/popups/hello-bar-announcement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:80;s:16:\"popularity_index\";i:693;s:11:\"trend_index\";i:697;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:582;a:14:{s:2:\"id\";i:11056;s:5:\"title\";s:35:\"Digital Agency &#8211; Social Media\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2019/07/Social-Media_small.png\";s:12:\"tmpl_created\";i:1564641867;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/digital-agency-social-media/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"marketing\"]\";s:10:\"menu_order\";i:80;s:16:\"popularity_index\";i:295;s:11:\"trend_index\";i:184;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:583;a:14:{s:2:\"id\";i:11536;s:5:\"title\";s:19:\"Gym &#8211; Fitness\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Fitness_Small.png\";s:12:\"tmpl_created\";i:1567392927;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/gym-fitness/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:81;s:16:\"popularity_index\";i:582;s:11:\"trend_index\";i:596;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:584;a:14:{s:2:\"id\";i:11545;s:5:\"title\";s:21:\"Gym &#8211; Home Page\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/08/Home_Small.png\";s:12:\"tmpl_created\";i:1567392943;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/gym-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:82;s:16:\"popularity_index\";i:317;s:11:\"trend_index\";i:345;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:585;a:14:{s:2:\"id\";i:12116;s:5:\"title\";s:24:\"Law Firm &#8211; Service\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/11/family_law.png\";s:12:\"tmpl_created\";i:1572847105;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/law-firm-service/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:83;s:16:\"popularity_index\";i:474;s:11:\"trend_index\";i:406;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:586;a:14:{s:2:\"id\";i:9869;s:5:\"title\";s:28:\"Hello Bar | Promotion | Sale\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2019/01/ru_small.png\";s:12:\"tmpl_created\";i:1547837269;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/hello-bar-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:83;s:16:\"popularity_index\";i:706;s:11:\"trend_index\";i:707;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:587;a:14:{s:2:\"id\";i:10539;s:5:\"title\";s:19:\"Hello Bar | Contact\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2019/01/hello_pink_small.png\";s:12:\"tmpl_created\";i:1548056994;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/hello-bar-register-subscribe-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:84;s:16:\"popularity_index\";i:664;s:11:\"trend_index\";i:0;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:588;a:14:{s:2:\"id\";i:11094;s:5:\"title\";s:30:\"Digital Agency &#8211; Clients\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/07/Clients_small.png\";s:12:\"tmpl_created\";i:1564641885;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/digital-agency-clients/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"marketing\"]\";s:10:\"menu_order\";i:84;s:16:\"popularity_index\";i:404;s:11:\"trend_index\";i:365;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:589;a:14:{s:2:\"id\";i:11478;s:5:\"title\";s:17:\"Gym &#8211; About\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/08/About_Small.png\";s:12:\"tmpl_created\";i:1567392939;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:99:\"https://library.elementor.com/gym-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:85;s:16:\"popularity_index\";i:462;s:11:\"trend_index\";i:391;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:590;a:14:{s:2:\"id\";i:11563;s:5:\"title\";s:19:\"Gym &#8211; Pricing\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Pricing_Small.png\";s:12:\"tmpl_created\";i:1567392923;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/gym-pricing/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:86;s:16:\"popularity_index\";i:542;s:11:\"trend_index\";i:561;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:591;a:14:{s:2:\"id\";i:11034;s:5:\"title\";s:30:\"Digital Agency &#8211; Contact\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2019/07/Contsct-Us_small.png\";s:12:\"tmpl_created\";i:1564641881;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/contact-digital-agency/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"marketing\"]\";s:10:\"menu_order\";i:87;s:16:\"popularity_index\";i:198;s:11:\"trend_index\";i:123;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:592;a:14:{s:2:\"id\";i:11528;s:5:\"title\";s:19:\"Gym &#8211; Contact\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Contact_Small.png\";s:12:\"tmpl_created\";i:1567392917;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/gym-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:88;s:16:\"popularity_index\";i:493;s:11:\"trend_index\";i:424;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:593;a:14:{s:2:\"id\";i:519;s:5:\"title\";s:24:\"Homepage &#8211; Fitness\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/10/0023.png\";s:12:\"tmpl_created\";i:1477388808;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/homepage-fitness/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:45:\"[\"Fitness\",\"Gym\",\"Health\",\"Homepage\",\"Sport\"]\";s:10:\"menu_order\";i:89;s:16:\"popularity_index\";i:10;s:11:\"trend_index\";i:32;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:594;a:14:{s:2:\"id\";i:10147;s:5:\"title\";s:34:\"Hello Bar | Sale | Promotion | Pop\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/donut_small.png\";s:12:\"tmpl_created\";i:1548055522;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/popups/hello-bar-sale-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:89;s:16:\"popularity_index\";i:710;s:11:\"trend_index\";i:700;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:595;a:14:{s:2:\"id\";i:487;s:5:\"title\";s:29:\"Landing Page &#8211; Vacation\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/10/0021.png\";s:12:\"tmpl_created\";i:1477388357;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/landing-page-vacation/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:90;s:16:\"popularity_index\";i:25;s:11:\"trend_index\";i:76;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:596;a:14:{s:2:\"id\";i:9923;s:5:\"title\";s:23:\"Slide In | Announcement\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2019/01/slide-in_ann_italian_small.png\";s:12:\"tmpl_created\";i:1547841537;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/slide-in-announcement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:90;s:16:\"popularity_index\";i:634;s:11:\"trend_index\";i:611;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:597;a:14:{s:2:\"id\";i:855;s:5:\"title\";s:37:\"Landing Page &#8211; Personal Trainer\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2017/02/Landing-Page-Personal-Trainer.png\";s:12:\"tmpl_created\";i:1494352061;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/landing-page-personal-trainer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:91;s:16:\"popularity_index\";i:264;s:11:\"trend_index\";i:373;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:598;a:14:{s:2:\"id\";i:10117;s:5:\"title\";s:23:\"Slide In | Announcement\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/white_small.png\";s:12:\"tmpl_created\";i:1548066998;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/slide-in-announcement-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:91;s:16:\"popularity_index\";i:668;s:11:\"trend_index\";i:0;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:599;a:14:{s:2:\"id\";i:955;s:5:\"title\";s:31:\"Landing Page &#8211; Law Office\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2017/02/Landing-Page-Law-Office.png\";s:12:\"tmpl_created\";i:1494352069;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/landing-page-law-office/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:31:\"[\"Landing Page\",\"Law\",\"Office\"]\";s:10:\"menu_order\";i:92;s:16:\"popularity_index\";i:175;s:11:\"trend_index\";i:331;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:600;a:14:{s:2:\"id\";i:9826;s:5:\"title\";s:33:\"Slide In | Announcement | webinar\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/web_small-2.png\";s:12:\"tmpl_created\";i:1547835513;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/slide-in-announcement-webinar/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:92;s:16:\"popularity_index\";i:682;s:11:\"trend_index\";i:711;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:601;a:14:{s:2:\"id\";i:10478;s:5:\"title\";s:18:\"Slide In | Contact\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/slide_wow_small.png\";s:12:\"tmpl_created\";i:1548056829;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/slide-in-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:93;s:16:\"popularity_index\";i:552;s:11:\"trend_index\";i:508;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:602;a:14:{s:2:\"id\";i:9373;s:5:\"title\";s:33:\"Landing Page &#8211; Conference 5\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/11/conference-250.png\";s:12:\"tmpl_created\";i:1542811219;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/landing-page-conference-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:93;s:16:\"popularity_index\";i:256;s:11:\"trend_index\";i:378;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:603;a:14:{s:2:\"id\";i:974;s:5:\"title\";s:28:\"Landing Page &#8211; Stylist\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2017/03/Landing-Page-Stylist.png\";s:12:\"tmpl_created\";i:1494352071;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/landing-page-stylist/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:146:\"[\"cosmetics\",\"fashion\",\"girly\",\"hairdresser\",\"lifestyle\",\"makeup\",\"manicure\",\"pedicure\",\"products\",\"salon\",\"Shop\",\"skincare\",\"stylist\",\"wellness\"]\";s:10:\"menu_order\";i:94;s:16:\"popularity_index\";i:302;s:11:\"trend_index\";i:382;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:604;a:14:{s:2:\"id\";i:11948;s:5:\"title\";s:18:\"Maintenance Mode 3\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/10/mm3.png\";s:12:\"tmpl_created\";i:1572153978;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/maintenance-mode-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:20:\"[\"Maintenance mode\"]\";s:10:\"menu_order\";i:95;s:16:\"popularity_index\";i:206;s:11:\"trend_index\";i:79;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:605;a:14:{s:2:\"id\";i:754;s:5:\"title\";s:25:\"Services &#8211; Interior\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2017/01/Interior-Services.png\";s:12:\"tmpl_created\";i:1485269691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/services-interior/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:96;s:16:\"popularity_index\";i:239;s:11:\"trend_index\";i:285;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:606;a:14:{s:2:\"id\";i:10685;s:5:\"title\";s:32:\"Hello Bar | Register | Subscribe\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/env_small.png\";s:12:\"tmpl_created\";i:1547974729;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/hello-bar-register-subscribe-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:96;s:16:\"popularity_index\";i:651;s:11:\"trend_index\";i:690;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:607;a:14:{s:2:\"id\";i:752;s:5:\"title\";s:24:\"Contact &#8211; Interior\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2017/01/interior-contact.png\";s:12:\"tmpl_created\";i:1485269737;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/contact-interior/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:97;s:16:\"popularity_index\";i:307;s:11:\"trend_index\";i:557;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:608;a:14:{s:2:\"id\";i:753;s:5:\"title\";s:22:\"About &#8211; Interior\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2017/01/Interior-About.png\";s:12:\"tmpl_created\";i:1485269710;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/about-interior/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:98;s:16:\"popularity_index\";i:291;s:11:\"trend_index\";i:441;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:609;a:14:{s:2:\"id\";i:9985;s:5:\"title\";s:20:\"Slide In | Promotion\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2019/01/slidein_promotion_av_small.png\";s:12:\"tmpl_created\";i:1547844661;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/slide-in-promotion-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:98;s:16:\"popularity_index\";i:695;s:11:\"trend_index\";i:691;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:610;a:14:{s:2:\"id\";i:751;s:5:\"title\";s:25:\"Homepage &#8211; Interior\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/01/interior-home.png\";s:12:\"tmpl_created\";i:1485269743;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/homepage-interior/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:99;s:16:\"popularity_index\";i:248;s:11:\"trend_index\";i:372;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:611;a:14:{s:2:\"id\";i:2402;s:5:\"title\";s:32:\"Homepage &#8211; Interior Design\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2017/09/Interior.png\";s:12:\"tmpl_created\";i:1506441447;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/homepage-interior-design/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:193:\"[\"Architecture\",\"building\",\"business\",\"Creative\",\"exterior design\",\"furniture design\",\"Gallery\",\"garden design\",\"house\",\"interior design\",\"landscape design\",\"multipurpose\",\"portfolio\",\"studio\"]\";s:10:\"menu_order\";i:100;s:16:\"popularity_index\";i:105;s:11:\"trend_index\";i:275;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:612;a:14:{s:2:\"id\";i:3626;s:5:\"title\";s:30:\"Snowboard Site &#8211; Contact\";s:9:\"thumbnail\";s:62:\"https://library.elementor.com/wp-content/uploads/2017/12/3.png\";s:12:\"tmpl_created\";i:1513513193;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/snowboard-site-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:101;s:16:\"popularity_index\";i:260;s:11:\"trend_index\";i:353;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:613;a:14:{s:2:\"id\";i:11966;s:5:\"title\";s:18:\"Maintenance mode 4\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/10/mm4.png\";s:12:\"tmpl_created\";i:1572154274;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/maintenance-mode-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:20:\"[\"Maintenance mode\"]\";s:10:\"menu_order\";i:102;s:16:\"popularity_index\";i:502;s:11:\"trend_index\";i:413;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:614;a:14:{s:2:\"id\";i:3632;s:5:\"title\";s:31:\"Snowboard Site &#8211; Services\";s:9:\"thumbnail\";s:62:\"https://library.elementor.com/wp-content/uploads/2017/12/2.png\";s:12:\"tmpl_created\";i:1513513171;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/snowboard-site-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:103;s:16:\"popularity_index\";i:201;s:11:\"trend_index\";i:362;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:615;a:14:{s:2:\"id\";i:3619;s:5:\"title\";s:31:\"Snowboard Site &#8211; Homepage\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2017/12/home.png\";s:12:\"tmpl_created\";i:1513513137;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/snowboard-site-homepage/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:104;s:16:\"popularity_index\";i:217;s:11:\"trend_index\";i:438;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:616;a:14:{s:2:\"id\";i:9425;s:5:\"title\";s:38:\"Black Friday &#8211;  80&#8217;s style\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/11/unnamed-file.png\";s:12:\"tmpl_created\";i:1542901234;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/black-friday-80s-style/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:105;s:16:\"popularity_index\";i:338;s:11:\"trend_index\";i:332;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:617;a:14:{s:2:\"id\";i:9559;s:5:\"title\";s:16:\"Slide In | Login\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2019/01/slidein_login_01_small.png\";s:12:\"tmpl_created\";i:1546946547;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/popups/slide-in-login-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:105;s:16:\"popularity_index\";i:554;s:11:\"trend_index\";i:636;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:618;a:14:{s:2:\"id\";i:11973;s:5:\"title\";s:18:\"Maintenance mode 5\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/10/mm5.png\";s:12:\"tmpl_created\";i:1572154523;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/maintenance-mode-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:20:\"[\"Maintenance mode\"]\";s:10:\"menu_order\";i:106;s:16:\"popularity_index\";i:447;s:11:\"trend_index\";i:289;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:619;a:14:{s:2:\"id\";i:11981;s:5:\"title\";s:18:\"Maintenance mode 6\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/10/mm6.png\";s:12:\"tmpl_created\";i:1572155125;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/maintenance-mode-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:20:\"[\"Maintenance mode\"]\";s:10:\"menu_order\";i:107;s:16:\"popularity_index\";i:444;s:11:\"trend_index\";i:260;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:620;a:14:{s:2:\"id\";i:9752;s:5:\"title\";s:27:\"Slide In | Sale | Promotion\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/rush_small.png\";s:12:\"tmpl_created\";i:1547823982;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/slide-in-sale-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:107;s:16:\"popularity_index\";i:680;s:11:\"trend_index\";i:655;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:621;a:14:{s:2:\"id\";i:147;s:5:\"title\";s:20:\"Homepage &#8211; App\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0004.png\";s:12:\"tmpl_created\";i:1470829868;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/homepage-app/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"App\",\"Homepage\"]\";s:10:\"menu_order\";i:109;s:16:\"popularity_index\";i:4;s:11:\"trend_index\";i:21;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:622;a:14:{s:2:\"id\";i:777;s:5:\"title\";s:28:\"Homepage &#8211; Coffee Shop\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/01/rest-home.jpg\";s:12:\"tmpl_created\";i:1485273092;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/homepage-coffee-shop/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:41:\"[\"Coffee\",\"Homepage\",\"Restaurant\",\"Shop\"]\";s:10:\"menu_order\";i:110;s:16:\"popularity_index\";i:156;s:11:\"trend_index\";i:276;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:623;a:14:{s:2:\"id\";i:2404;s:5:\"title\";s:24:\"Homepage &#8211; Product\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2017/09/product.png\";s:12:\"tmpl_created\";i:1506441452;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/homepage-product/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:103:\"[\"business\",\"colorful\",\"ecommerce\",\"flat\",\"mobile\",\"modern\",\"responsive\",\"retina\",\"Shop\",\"woocommerce\"]\";s:10:\"menu_order\";i:111;s:16:\"popularity_index\";i:149;s:11:\"trend_index\";i:325;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:624;a:14:{s:2:\"id\";i:10169;s:5:\"title\";s:37:\"Slide In | Register | Subscribe | App\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2019/01/slideinapp_small.png\";s:12:\"tmpl_created\";i:1547852334;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/slide-in-register-subscribe-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:112;s:16:\"popularity_index\";i:461;s:11:\"trend_index\";i:656;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:625;a:14:{s:2:\"id\";i:492;s:5:\"title\";s:25:\"Homepage &#8211; Law firm\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/10/0024.png\";s:12:\"tmpl_created\";i:1477388365;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/homepage-law-firm/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:25:\"[\"Firm\",\"Homepage\",\"Law\"]\";s:10:\"menu_order\";i:112;s:16:\"popularity_index\";i:13;s:11:\"trend_index\";i:58;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:626;a:14:{s:2:\"id\";i:3451;s:5:\"title\";s:39:\"Homepage &#8211; Goodness meal services\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2017/11/goodness-featured-image.png\";s:12:\"tmpl_created\";i:1512054116;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/homepage-goodness-meal-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:113;s:16:\"popularity_index\";i:236;s:11:\"trend_index\";i:357;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:627;a:14:{s:2:\"id\";i:2152;s:5:\"title\";s:26:\"Homepage &#8211; Cake Shop\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/07/cake-home.png\";s:12:\"tmpl_created\";i:1499774132;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/homepage-cake-shop/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Cake\",\"Homepage\",\"Restaurant\",\"Shop\"]\";s:10:\"menu_order\";i:114;s:16:\"popularity_index\";i:348;s:11:\"trend_index\";i:477;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:628;a:14:{s:2:\"id\";i:1068;s:5:\"title\";s:27:\"Homepage &#8211; Copywriter\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2017/03/copywriter.png\";s:12:\"tmpl_created\";i:1488805928;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/homepage-copywriter/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:25:\"[\"Copywriter\",\"Homepage\"]\";s:10:\"menu_order\";i:115;s:16:\"popularity_index\";i:221;s:11:\"trend_index\";i:415;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:629;a:14:{s:2:\"id\";i:9680;s:5:\"title\";s:23:\"Slide In | Content Lock\";s:9:\"thumbnail\";s:91:\"https://library.elementor.com/wp-content/uploads/2019/01/Slide-in_Content-lock_small_01.png\";s:12:\"tmpl_created\";i:1547010967;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/popups/slide-in-content-lock-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:115;s:16:\"popularity_index\";i:671;s:11:\"trend_index\";i:668;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:630;a:14:{s:2:\"id\";i:2813;s:5:\"title\";s:32:\"Homepage &#8211; Creative Agency\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2017/11/Creative-Agency-–-Home-Page.png\";s:12:\"tmpl_created\";i:1509615049;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/homepage-creative-agency/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Agency\",\"Creative\",\"Homepage\"]\";s:10:\"menu_order\";i:116;s:16:\"popularity_index\";i:117;s:11:\"trend_index\";i:217;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:631;a:14:{s:2:\"id\";i:728;s:5:\"title\";s:33:\"Homepage &#8211; Delivery Company\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2017/01/delivery-company-home-page.jpg\";s:12:\"tmpl_created\";i:1485269993;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/homepage-delivery-company/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Delivery\",\"Homepage\"]\";s:10:\"menu_order\";i:117;s:16:\"popularity_index\";i:288;s:11:\"trend_index\";i:529;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:632;a:14:{s:2:\"id\";i:9783;s:5:\"title\";s:31:\"Slide In | Register | Subscribe\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2019/01/slidein_yellow_small.png\";s:12:\"tmpl_created\";i:1547831059;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/slide-in-register-subscribe/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:117;s:16:\"popularity_index\";i:500;s:11:\"trend_index\";i:579;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:633;a:14:{s:2:\"id\";i:2403;s:5:\"title\";s:29:\"Homepage &#8211; Luxury Hotel\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2017/09/Hotel.png\";s:12:\"tmpl_created\";i:1506441428;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/homepage-luxury-hotel/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:118;s:16:\"popularity_index\";i:277;s:11:\"trend_index\";i:339;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:634;a:14:{s:2:\"id\";i:1903;s:5:\"title\";s:20:\"One Page &#8211; Spa\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2017/06/spa.png\";s:12:\"tmpl_created\";i:1496822325;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/one-page-spa/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:132:\"[\"beauty\",\"care\",\"girly\",\"hair\",\"Health\",\"hospitality\",\"massage\",\"medical\",\"parlor\",\"physiotherapy\",\"salon\",\"spa\",\"wellness\",\"yoga\"]\";s:10:\"menu_order\";i:119;s:16:\"popularity_index\";i:187;s:11:\"trend_index\";i:227;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:635;a:14:{s:2:\"id\";i:2123;s:5:\"title\";s:33:\"One Page &#8211; Architect Office\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/06/architect.png\";s:12:\"tmpl_created\";i:1499772989;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/one-page-architect-office/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:120;s:16:\"popularity_index\";i:11;s:11:\"trend_index\";i:20;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:636;a:14:{s:2:\"id\";i:1888;s:5:\"title\";s:32:\"One Page &#8211; Creative Meetup\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2017/06/creative-meetup.png\";s:12:\"tmpl_created\";i:1496822319;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/one-page-creative-meetup/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:121;s:16:\"popularity_index\";i:284;s:11:\"trend_index\";i:502;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:637;a:14:{s:2:\"id\";i:1891;s:5:\"title\";s:35:\"One Page &#8211; Textile Convention\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2017/06/textile-meetup.png\";s:12:\"tmpl_created\";i:1496822323;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/one-page-textile-convention/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:122;s:16:\"popularity_index\";i:427;s:11:\"trend_index\";i:594;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:638;a:14:{s:2:\"id\";i:1880;s:5:\"title\";s:24:\"One Page &#8211; Wedding\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2017/06/wedding.png\";s:12:\"tmpl_created\";i:1496822317;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/one-page-wedding/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:82:\"[\"bride\",\"ceremony\",\"cute\",\"event\",\"fancy\",\"girly\",\"groom\",\"guestbook\",\"marriage\"]\";s:10:\"menu_order\";i:123;s:16:\"popularity_index\";i:468;s:11:\"trend_index\";i:614;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:639;a:14:{s:2:\"id\";i:1885;s:5:\"title\";s:29:\"One Page &#8211; Yacht Rental\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2017/06/yacht-home.png\";s:12:\"tmpl_created\";i:1496822321;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/one-page-yacht-rental/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:124;s:16:\"popularity_index\";i:210;s:11:\"trend_index\";i:409;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:640;a:14:{s:2:\"id\";i:2723;s:5:\"title\";s:34:\"Portfolio &#8211; Graphic Designer\";s:9:\"thumbnail\";s:91:\"https://library.elementor.com/wp-content/uploads/2017/11/Graphic-Designer-–-Portfolio.png\";s:12:\"tmpl_created\";i:1509633883;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/portfolio-graphic-designer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:125;s:16:\"popularity_index\";i:190;s:11:\"trend_index\";i:282;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:641;a:14:{s:2:\"id\";i:2145;s:5:\"title\";s:30:\"About &#8211; Delivery Company\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2017/07/delivery-about.png\";s:12:\"tmpl_created\";i:1499774125;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/about-delivery-company/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:10:\"[\"moving\"]\";s:10:\"menu_order\";i:126;s:16:\"popularity_index\";i:355;s:11:\"trend_index\";i:630;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:642;a:14:{s:2:\"id\";i:2155;s:5:\"title\";s:23:\"About &#8211; Cake Shop\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2017/07/cake-about.png\";s:12:\"tmpl_created\";i:1499774130;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/about-cake-shop/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:8:\"[\"Food\"]\";s:10:\"menu_order\";i:127;s:16:\"popularity_index\";i:403;s:11:\"trend_index\";i:584;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:643;a:14:{s:2:\"id\";i:1085;s:5:\"title\";s:21:\"About &#8211; Startup\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2017/03/Startup.png\";s:12:\"tmpl_created\";i:1488810874;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/about-startup/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:19:\"[\"About\",\"Startup\"]\";s:10:\"menu_order\";i:128;s:16:\"popularity_index\";i:8;s:11:\"trend_index\";i:10;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:644;a:14:{s:2:\"id\";i:143;s:5:\"title\";s:22:\"About &#8211; Personal\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0010.png\";s:12:\"tmpl_created\";i:1470820447;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/about-personal/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:20:\"[\"About\",\"Personal\"]\";s:10:\"menu_order\";i:129;s:16:\"popularity_index\";i:24;s:11:\"trend_index\";i:68;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:645;a:14:{s:2:\"id\";i:101;s:5:\"title\";s:16:\"About &#8211; CV\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0018.png\";s:12:\"tmpl_created\";i:1470829785;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:98:\"https://library.elementor.com/about-cv/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:77:\"[\"creative portfolio\",\"Personal\",\"portfolio\",\"professional\",\"resume\",\"vcard\"]\";s:10:\"menu_order\";i:130;s:16:\"popularity_index\";i:49;s:11:\"trend_index\";i:173;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:646;a:14:{s:2:\"id\";i:140;s:5:\"title\";s:25:\"About &#8211; Art Gallery\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0009.png\";s:12:\"tmpl_created\";i:1470820463;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/about-art-gallery/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:25:\"[\"About\",\"Art\",\"Gallery\"]\";s:10:\"menu_order\";i:131;s:16:\"popularity_index\";i:18;s:11:\"trend_index\";i:41;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:647;a:14:{s:2:\"id\";i:213;s:5:\"title\";s:26:\"About &#8211; Architecture\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0008.png\";s:12:\"tmpl_created\";i:1470829766;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/about-architecture/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:24:\"[\"About\",\"Architecture\"]\";s:10:\"menu_order\";i:132;s:16:\"popularity_index\";i:19;s:11:\"trend_index\";i:59;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:648;a:14:{s:2:\"id\";i:2802;s:5:\"title\";s:38:\"Portfolio &#8211; Fashion Photographer\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2017/11/Fashion-photographer-–-Portfolio.png\";s:12:\"tmpl_created\";i:1509615440;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/portfolio-fashion-photographer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:133;s:16:\"popularity_index\";i:225;s:11:\"trend_index\";i:483;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:649;a:14:{s:2:\"id\";i:2828;s:5:\"title\";s:35:\"Landing Page &#8211; Law Convention\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2017/11/Law-Convention-–-Landing-Page.png\";s:12:\"tmpl_created\";i:1509631636;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/landing-page-law-convention/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:35:\"[\"Convention\",\"Landing Page\",\"Law\"]\";s:10:\"menu_order\";i:134;s:16:\"popularity_index\";i:367;s:11:\"trend_index\";i:560;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:650;a:14:{s:2:\"id\";i:1461;s:5:\"title\";s:28:\"Landing Page &#8211; Ebook 1\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Ebook-1.png\";s:12:\"tmpl_created\";i:1494352121;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/landing-page-ebook-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:127:\"[\"App\",\"author\",\"book\",\"brochure\",\"download\",\"e-book\",\"ebook\",\"marketing\",\"product\",\"publisher\",\"sell online\",\"seo\",\"showcase\"]\";s:10:\"menu_order\";i:135;s:16:\"popularity_index\";i:353;s:11:\"trend_index\";i:554;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:651;a:14:{s:2:\"id\";i:1460;s:5:\"title\";s:28:\"Landing Page &#8211; Ebook 2\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Ebook-2.png\";s:12:\"tmpl_created\";i:1494352124;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/landing-page-ebook-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:136;s:16:\"popularity_index\";i:373;s:11:\"trend_index\";i:444;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:652;a:14:{s:2:\"id\";i:1459;s:5:\"title\";s:28:\"Landing Page &#8211; Ebook 3\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Ebook-3.png\";s:12:\"tmpl_created\";i:1494352125;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/landing-page-ebook-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:137;s:16:\"popularity_index\";i:242;s:11:\"trend_index\";i:283;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:653;a:14:{s:2:\"id\";i:1052;s:5:\"title\";s:33:\"Landing Page &#8211; Mobile App 1\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2017/03/app.png\";s:12:\"tmpl_created\";i:1488810873;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/landing-page-mobile-app/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:138;s:16:\"popularity_index\";i:37;s:11:\"trend_index\";i:84;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:654;a:14:{s:2:\"id\";i:1505;s:5:\"title\";s:33:\"Landing Page &#8211; Mobile App 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-app3.png\";s:12:\"tmpl_created\";i:1494352110;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/landing-page-mobile-app-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:139;s:16:\"popularity_index\";i:395;s:11:\"trend_index\";i:598;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:655;a:14:{s:2:\"id\";i:726;s:5:\"title\";s:33:\"Landing Page &#8211; Conference 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2017/01/convention-landing-page.jpg\";s:12:\"tmpl_created\";i:1485270062;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/landing-page-conference/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:140;s:16:\"popularity_index\";i:438;s:11:\"trend_index\";i:539;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:656;a:14:{s:2:\"id\";i:1613;s:5:\"title\";s:33:\"Landing Page &#8211; Conference 2\";s:9:\"thumbnail\";s:109:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-International-Womens-Day-Conference.png\";s:12:\"tmpl_created\";i:1494352129;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/landing-page-conference-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:141;s:16:\"popularity_index\";i:453;s:11:\"trend_index\";i:462;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:657;a:14:{s:2:\"id\";i:1612;s:5:\"title\";s:33:\"Landing Page &#8211; Conference 3\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Tech-Conference.png\";s:12:\"tmpl_created\";i:1494352127;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/landing-page-conference-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:142;s:16:\"popularity_index\";i:479;s:11:\"trend_index\";i:673;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:658;a:14:{s:2:\"id\";i:1614;s:5:\"title\";s:33:\"Landing Page &#8211; Conference 4\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Sustainability-Conference.png\";s:12:\"tmpl_created\";i:1494352131;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/landing-page-conference-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:143;s:16:\"popularity_index\";i:382;s:11:\"trend_index\";i:532;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:659;a:14:{s:2:\"id\";i:906;s:5:\"title\";s:29:\"Landing Page &#8211;  Coacher\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2017/02/Landin-Page-Coacher.png\";s:12:\"tmpl_created\";i:1494352066;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/landing-page-coacher/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:144;s:16:\"popularity_index\";i:279;s:11:\"trend_index\";i:379;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:660;a:14:{s:2:\"id\";i:879;s:5:\"title\";s:41:\"Landing Page &#8211; Financial Consultant\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2017/02/Landing-Page-Financial-consultant.png\";s:12:\"tmpl_created\";i:1494352064;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/landing-page-financial-consultant/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:145;s:16:\"popularity_index\";i:287;s:11:\"trend_index\";i:370;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:661;a:14:{s:2:\"id\";i:926;s:5:\"title\";s:33:\"Landing Page &#8211; Private Chef\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2017/02/Landing-Page-Private-Chef.png\";s:12:\"tmpl_created\";i:1494352068;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/landing-page-private-chef/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:146;s:16:\"popularity_index\";i:401;s:11:\"trend_index\";i:542;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:662;a:14:{s:2:\"id\";i:1032;s:5:\"title\";s:27:\"Landing Page &#8211; Agency\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2017/03/Agency.png\";s:12:\"tmpl_created\";i:1488810866;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/landing-page-agency/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:147;s:16:\"popularity_index\";i:398;s:11:\"trend_index\";i:558;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:663;a:14:{s:2:\"id\";i:730;s:5:\"title\";s:24:\"Landing Page &#8211; App\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2017/01/app.-landing-page.jpg\";s:12:\"tmpl_created\";i:1485273430;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/landing-page-app/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:148;s:16:\"popularity_index\";i:358;s:11:\"trend_index\";i:525;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:664;a:14:{s:2:\"id\";i:643;s:5:\"title\";s:29:\"Landing Page &#8211; Festival\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2016/12/festival.jpg\";s:12:\"tmpl_created\";i:1481549290;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/landing-page-festival/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:149;s:16:\"popularity_index\";i:450;s:11:\"trend_index\";i:569;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:665;a:14:{s:2:\"id\";i:542;s:5:\"title\";s:28:\"Landing Page &#8211; Wedding\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/10/0025.png\";s:12:\"tmpl_created\";i:1477388484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/landing-page-wedding/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:150;s:16:\"popularity_index\";i:102;s:11:\"trend_index\";i:322;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:666;a:14:{s:2:\"id\";i:1187;s:5:\"title\";s:32:\"Landing Page &#8211; Photography\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2017/03/lp1-l.png\";s:12:\"tmpl_created\";i:1490707385;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/landing-page-photography/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:151;s:16:\"popularity_index\";i:48;s:11:\"trend_index\";i:95;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:667;a:14:{s:2:\"id\";i:641;s:5:\"title\";s:28:\"Landing Page &#8211; Fashion\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2016/12/fashion-landing-page.jpg\";s:12:\"tmpl_created\";i:1481549264;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/landing-page-fashion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:152;s:16:\"popularity_index\";i:328;s:11:\"trend_index\";i:457;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:668;a:14:{s:2:\"id\";i:189;s:5:\"title\";s:30:\"Landing Page &#8211; Tourism 1\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0005.png\";s:12:\"tmpl_created\";i:1470820715;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/landing-page-tourism/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:153;s:16:\"popularity_index\";i:15;s:11:\"trend_index\";i:44;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:669;a:14:{s:2:\"id\";i:1547;s:5:\"title\";s:30:\"Landing Page &#8211; Tourism 2\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Truism-1.png\";s:12:\"tmpl_created\";i:1494352115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/landing-page-tourism-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:154;s:16:\"popularity_index\";i:345;s:11:\"trend_index\";i:617;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:670;a:14:{s:2:\"id\";i:1546;s:5:\"title\";s:30:\"Landing Page &#8211; Tourism 3\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Truism-2.png\";s:12:\"tmpl_created\";i:1494352116;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/landing-page-tourism-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:155;s:16:\"popularity_index\";i:475;s:11:\"trend_index\";i:644;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:671;a:14:{s:2:\"id\";i:1545;s:5:\"title\";s:30:\"Landing Page &#8211; Tourism 4\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Truism-3.png\";s:12:\"tmpl_created\";i:1494352118;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/landing-page-tourism-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:156;s:16:\"popularity_index\";i:374;s:11:\"trend_index\";i:449;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:672;a:14:{s:2:\"id\";i:2714;s:5:\"title\";s:30:\"Landing Page &#8211; Tourism 5\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2017/11/Vacation-–-Landing-Page.png\";s:12:\"tmpl_created\";i:1509631782;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/landing-page-tourism-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:157;s:16:\"popularity_index\";i:366;s:11:\"trend_index\";i:544;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:673;a:14:{s:2:\"id\";i:195;s:5:\"title\";s:28:\"Landing Page &#8211; Product\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0006.png\";s:12:\"tmpl_created\";i:1470820765;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/landing-page-product/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:158;s:16:\"popularity_index\";i:57;s:11:\"trend_index\";i:180;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:674;a:14:{s:2:\"id\";i:197;s:5:\"title\";s:34:\"Landing Page &#8211; Real Estate 1\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0007.png\";s:12:\"tmpl_created\";i:1470825711;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/landing-page-real-estate/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:159;s:16:\"popularity_index\";i:136;s:11:\"trend_index\";i:383;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:675;a:14:{s:2:\"id\";i:1193;s:5:\"title\";s:34:\"Landing Page &#8211; Real Estate 2\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2017/03/lp3-l.png\";s:12:\"tmpl_created\";i:1490707422;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/landing-page-real-estate-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:160;s:16:\"popularity_index\";i:70;s:11:\"trend_index\";i:153;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:676;a:14:{s:2:\"id\";i:1415;s:5:\"title\";s:34:\"Landing Page &#8211; Real Estate 3\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Real-Estate-1.png\";s:12:\"tmpl_created\";i:1494352106;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/landing-page-real-estate-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:161;s:16:\"popularity_index\";i:356;s:11:\"trend_index\";i:695;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:677;a:14:{s:2:\"id\";i:1414;s:5:\"title\";s:34:\"Landing Page &#8211; Real Estate 4\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Real-Estate-2.png\";s:12:\"tmpl_created\";i:1494352107;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/landing-page-real-estate-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:162;s:16:\"popularity_index\";i:497;s:11:\"trend_index\";i:641;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:678;a:14:{s:2:\"id\";i:1413;s:5:\"title\";s:34:\"Landing Page &#8211; Real Estate 5\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Real-Estate-3.png\";s:12:\"tmpl_created\";i:1494352109;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/landing-page-real-estate-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:134:\"[\"Agent\",\"business\",\"clean\",\"corporate\",\"flat\",\"google maps\",\"homes\",\"listing\",\"modern\",\"real estate\",\"realestate\",\"realtor\",\"realty\"]\";s:10:\"menu_order\";i:163;s:16:\"popularity_index\";i:433;s:11:\"trend_index\";i:442;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:679;a:14:{s:2:\"id\";i:1573;s:5:\"title\";s:29:\"Landing Page &#8211; Coupon 1\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/05/Coupon-02.png\";s:12:\"tmpl_created\";i:1494352133;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/landing-page-coupon-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:164;s:16:\"popularity_index\";i:526;s:11:\"trend_index\";i:622;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:680;a:14:{s:2:\"id\";i:1572;s:5:\"title\";s:29:\"Landing Page &#8211; Coupon 2\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/05/Coupon-03.png\";s:12:\"tmpl_created\";i:1494352134;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/landing-page-coupon-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:165;s:16:\"popularity_index\";i:557;s:11:\"trend_index\";i:582;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:681;a:14:{s:2:\"id\";i:1570;s:5:\"title\";s:29:\"Landing Page &#8211; Coupon 3\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/05/Coupon-01.png\";s:12:\"tmpl_created\";i:1494352136;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/landing-page-coupon-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:166;s:16:\"popularity_index\";i:600;s:11:\"trend_index\";i:559;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:682;a:14:{s:2:\"id\";i:1571;s:5:\"title\";s:29:\"Landing Page &#8211; Coupon 4\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/05/Coupon-04.png\";s:12:\"tmpl_created\";i:1494352138;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/landing-page-coupon-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:167;s:16:\"popularity_index\";i:573;s:11:\"trend_index\";i:605;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:683;a:14:{s:2:\"id\";i:192;s:5:\"title\";s:28:\"Landing Page &#8211; Webinar\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0015.png\";s:12:\"tmpl_created\";i:1470820734;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/landing-page-webinar/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:168;s:16:\"popularity_index\";i:122;s:11:\"trend_index\";i:262;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:684;a:14:{s:2:\"id\";i:2141;s:5:\"title\";s:32:\"Contact &#8211; Delivery Company\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2017/07/delivery-contact.png\";s:12:\"tmpl_created\";i:1499774122;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/contact-delivery-company/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:169;s:16:\"popularity_index\";i:331;s:11:\"trend_index\";i:470;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:685;a:14:{s:2:\"id\";i:137;s:5:\"title\";s:22:\"Contact &#8211; Modern\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0013.png\";s:12:\"tmpl_created\";i:1470829828;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/contact-modern/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:170;s:16:\"popularity_index\";i:52;s:11:\"trend_index\";i:127;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:686;a:14:{s:2:\"id\";i:256;s:5:\"title\";s:26:\"Contact &#8211; Restaurant\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0011.png\";s:12:\"tmpl_created\";i:1470829796;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/contact-restaurant/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:171;s:16:\"popularity_index\";i:132;s:11:\"trend_index\";i:307;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:687;a:14:{s:2:\"id\";i:2150;s:5:\"title\";s:25:\"Contact &#8211; Cake Shop\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2017/07/cake-contact.png\";s:12:\"tmpl_created\";i:1499774127;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/contact-cake-shop/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:172;s:16:\"popularity_index\";i:68;s:11:\"trend_index\";i:183;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:688;a:14:{s:2:\"id\";i:223;s:5:\"title\";s:21:\"Contact &#8211; Hotel\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0002.png\";s:12:\"tmpl_created\";i:1470820471;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/contact-hotel/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:173;s:16:\"popularity_index\";i:134;s:11:\"trend_index\";i:185;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:689;a:14:{s:2:\"id\";i:24;s:5:\"title\";s:25:\"Contact &#8211; Corporate\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0012.png\";s:12:\"tmpl_created\";i:1470248619;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/contact-corporate/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:174;s:16:\"popularity_index\";i:12;s:11:\"trend_index\";i:15;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:690;a:14:{s:2:\"id\";i:184;s:5:\"title\";s:23:\"Services &#8211; Moving\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0017.png\";s:12:\"tmpl_created\";i:1470829889;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/services-moving/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:175;s:16:\"popularity_index\";i:23;s:11:\"trend_index\";i:50;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:691;a:14:{s:2:\"id\";i:625;s:5:\"title\";s:31:\"Services &#8211; Cake Shop Menu\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2016/12/cake-shop-menu.jpg\";s:12:\"tmpl_created\";i:1481549196;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/services-cake-shop-menu/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:176;s:16:\"popularity_index\";i:563;s:11:\"trend_index\";i:653;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:692;a:14:{s:2:\"id\";i:187;s:5:\"title\";s:20:\"Services &#8211; Fun\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0001.png\";s:12:\"tmpl_created\";i:1470829892;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/services-fun/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:177;s:16:\"popularity_index\";i:81;s:11:\"trend_index\";i:232;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:693;a:14:{s:2:\"id\";i:238;s:5:\"title\";s:27:\"Services &#8211; Consulting\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0014.png\";s:12:\"tmpl_created\";i:1470829865;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/services-consulting/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:178;s:16:\"popularity_index\";i:21;s:11:\"trend_index\";i:40;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:694;a:14:{s:2:\"id\";i:647;s:5:\"title\";s:33:\"Services &#8211; Coffee Shop Menu\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2016/12/restaurant-menu.jpg\";s:12:\"tmpl_created\";i:1481549320;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/services-coffee-shop-menu/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:179;s:16:\"popularity_index\";i:464;s:11:\"trend_index\";i:607;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:695;a:14:{s:2:\"id\";i:2138;s:5:\"title\";s:33:\"Services &#8211; Delivery Company\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2017/07/delivery-services.png\";s:12:\"tmpl_created\";i:1499774119;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/services-delivery-company/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:180;s:16:\"popularity_index\";i:392;s:11:\"trend_index\";i:581;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:696;a:14:{s:2:\"id\";i:823;s:5:\"title\";s:19:\"Pricing &#8211; App\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2017/01/pricing-app.jpg\";s:12:\"tmpl_created\";i:1485272966;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/pricing-app-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:181;s:16:\"popularity_index\";i:357;s:11:\"trend_index\";i:498;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:697;a:14:{s:2:\"id\";i:824;s:5:\"title\";s:24:\"Pricing &#8211; Software\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2017/01/pricing-software.png\";s:12:\"tmpl_created\";i:1485272900;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/pricing-software-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:182;s:16:\"popularity_index\";i:368;s:11:\"trend_index\";i:468;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:698;a:14:{s:2:\"id\";i:825;s:5:\"title\";s:24:\"Product &#8211; Speakers\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2017/01/product-page.jpg\";s:12:\"tmpl_created\";i:1485272513;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/product-speakers/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:183;s:16:\"popularity_index\";i:388;s:11:\"trend_index\";i:595;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:699;a:14:{s:2:\"id\";i:245;s:5:\"title\";s:21:\"Product &#8211; Clean\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0020.png\";s:12:\"tmpl_created\";i:1470829876;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/product-clean/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:48:\"[\"fast\",\"minimal\",\"minimalistic\",\"seo\",\"simple\"]\";s:10:\"menu_order\";i:184;s:16:\"popularity_index\";i:88;s:11:\"trend_index\";i:132;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:700;a:14:{s:2:\"id\";i:1075;s:5:\"title\";s:19:\"Shop &#8211; Sweets\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2017/03/Sweets.png\";s:12:\"tmpl_created\";i:1488810871;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/shop-sweets/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:154:\"[\"bakery\",\"beverage\",\"business\",\"cafe\",\"candy bar\",\"catering\",\"delivery service\",\"Food\",\"online shop\",\"pastry\",\"Restaurant\",\"store\",\"sweet shop\",\"sweets\"]\";s:10:\"menu_order\";i:185;s:16:\"popularity_index\";i:59;s:11:\"trend_index\";i:104;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:701;a:14:{s:2:\"id\";i:1051;s:5:\"title\";s:24:\"Blog Post &#8211; Launch\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2017/03/post-cloud.png\";s:12:\"tmpl_created\";i:1488810869;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blog-post-launch/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:210:\"[\"Agency\",\"bootstrap\",\"business\",\"corporate\",\"Landing Page\",\"launch\",\"marketing campaign\",\"marketing landing page\",\"marketing template landing page\",\"product launch\",\"software\",\"Startup\",\"startup landing page\"]\";s:10:\"menu_order\";i:186;s:16:\"popularity_index\";i:17;s:11:\"trend_index\";i:22;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:702;a:14:{s:2:\"id\";i:1245;s:5:\"title\";s:13:\"Coming Soon 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/03/Coming-Soon-1.png\";s:12:\"tmpl_created\";i:1491207184;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/coming-soon-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:187;s:16:\"popularity_index\";i:259;s:11:\"trend_index\";i:286;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:703;a:14:{s:2:\"id\";i:1247;s:5:\"title\";s:13:\"Coming Soon 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/03/Coming-Soon-2.png\";s:12:\"tmpl_created\";i:1491207138;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/coming-soon-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:188;s:16:\"popularity_index\";i:32;s:11:\"trend_index\";i:31;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:704;a:14:{s:2:\"id\";i:1248;s:5:\"title\";s:13:\"Coming Soon 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/03/Coming-Soon-3.png\";s:12:\"tmpl_created\";i:1491207050;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/coming-soon-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:189;s:16:\"popularity_index\";i:389;s:11:\"trend_index\";i:597;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:705;a:14:{s:2:\"id\";i:1249;s:5:\"title\";s:13:\"Coming Soon 4\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/03/Coming-Soon-4.png\";s:12:\"tmpl_created\";i:1491207380;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/coming-soon-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:190;s:16:\"popularity_index\";i:429;s:11:\"trend_index\";i:500;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:706;a:14:{s:2:\"id\";i:1250;s:5:\"title\";s:13:\"Coming Soon 5\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/03/Coming-Soon-5.png\";s:12:\"tmpl_created\";i:1491207450;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/coming-soon-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:191;s:16:\"popularity_index\";i:72;s:11:\"trend_index\";i:134;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:707;a:14:{s:2:\"id\";i:1260;s:5:\"title\";s:18:\"Maintenance Mode 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/03/Coming-Soon-6.png\";s:12:\"tmpl_created\";i:1491207507;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/maintenance-mode-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:20:\"[\"Maintenance mode\"]\";s:10:\"menu_order\";i:192;s:16:\"popularity_index\";i:457;s:11:\"trend_index\";i:432;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:708;a:14:{s:2:\"id\";i:1261;s:5:\"title\";s:18:\"Maintenance Mode 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/04/Coming-Soon-7.png\";s:12:\"tmpl_created\";i:1491207584;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/maintenance-mode-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:20:\"[\"Maintenance mode\"]\";s:10:\"menu_order\";i:193;s:16:\"popularity_index\";i:78;s:11:\"trend_index\";i:200;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:709;a:14:{s:2:\"id\";i:1272;s:5:\"title\";s:13:\"Coming Soon 8\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/03/Coming-Soon-8.png\";s:12:\"tmpl_created\";i:1491207674;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/coming-soon-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:194;s:16:\"popularity_index\";i:289;s:11:\"trend_index\";i:354;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:710;a:14:{s:2:\"id\";i:1279;s:5:\"title\";s:13:\"Coming Soon 9\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/03/Coming-Soon-9.png\";s:12:\"tmpl_created\";i:1491207756;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/coming-soon-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:195;s:16:\"popularity_index\";i:145;s:11:\"trend_index\";i:206;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:711;a:14:{s:2:\"id\";i:1745;s:5:\"title\";s:14:\"Coming Soon 10\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/05/login-002.png\";s:12:\"tmpl_created\";i:1494849745;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/coming-soon-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:196;s:16:\"popularity_index\";i:278;s:11:\"trend_index\";i:297;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:712;a:14:{s:2:\"id\";i:1742;s:5:\"title\";s:12:\"Login Page 1\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/05/login-003.png\";s:12:\"tmpl_created\";i:1494849744;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:100:\"https://library.elementor.com/login-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:197;s:16:\"popularity_index\";i:420;s:11:\"trend_index\";i:388;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:713;a:14:{s:2:\"id\";i:1748;s:5:\"title\";s:12:\"Login Page 2\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/05/login-001.png\";s:12:\"tmpl_created\";i:1494849742;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/login-page-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:198;s:16:\"popularity_index\";i:299;s:11:\"trend_index\";i:363;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:714;a:14:{s:2:\"id\";i:3963;s:5:\"title\";s:32:\"Restaurant Site &#8211; Homepage\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/01/R.HomepageThumb.png\";s:12:\"tmpl_created\";i:1516284821;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/restaurant-site-homepage/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:109:\"[\"bar\",\"cafe\",\"cooking\",\"drink\",\"events\",\"fast food\",\"Food\",\"menu\",\"modern\",\"reservation\",\"Shop\",\"snack bar\"]\";s:10:\"menu_order\";i:199;s:16:\"popularity_index\";i:237;s:11:\"trend_index\";i:298;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:715;a:14:{s:2:\"id\";i:3969;s:5:\"title\";s:28:\"Restaurant Site &#8211; Menu\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/01/R.MenuThumb.png\";s:12:\"tmpl_created\";i:1516284829;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/restaurant-site-menu/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:109:\"[\"bar\",\"cafe\",\"cooking\",\"drink\",\"events\",\"fast food\",\"Food\",\"menu\",\"modern\",\"reservation\",\"Shop\",\"snack bar\"]\";s:10:\"menu_order\";i:200;s:16:\"popularity_index\";i:390;s:11:\"trend_index\";i:627;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:716;a:14:{s:2:\"id\";i:3966;s:5:\"title\";s:29:\"Restaurant Site &#8211; About\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/01/R.AboutThumb.png.png\";s:12:\"tmpl_created\";i:1516284839;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/restaurant-site-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:109:\"[\"bar\",\"cafe\",\"cooking\",\"drink\",\"events\",\"fast food\",\"Food\",\"menu\",\"modern\",\"reservation\",\"Shop\",\"snack bar\"]\";s:10:\"menu_order\";i:201;s:16:\"popularity_index\";i:257;s:11:\"trend_index\";i:305;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:717;a:14:{s:2:\"id\";i:3972;s:5:\"title\";s:31:\"Restaurant Site &#8211; Contact\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/01/R.ContactThumb.png\";s:12:\"tmpl_created\";i:1516284847;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/restaurant-site-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:109:\"[\"bar\",\"cafe\",\"cooking\",\"drink\",\"events\",\"fast food\",\"Food\",\"menu\",\"modern\",\"reservation\",\"Shop\",\"snack bar\"]\";s:10:\"menu_order\";i:202;s:16:\"popularity_index\";i:363;s:11:\"trend_index\";i:464;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:718;a:14:{s:2:\"id\";i:2080;s:5:\"title\";s:27:\"Ski Resort &#8211; Homepage\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2017/10/Ski-Resort-Home-Page.png\";s:12:\"tmpl_created\";i:1508161124;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/ski-resort-homepage/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:203;s:16:\"popularity_index\";i:340;s:11:\"trend_index\";i:387;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:719;a:14:{s:2:\"id\";i:2088;s:5:\"title\";s:24:\"Ski Resort &#8211; About\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2017/10/Ski-Resort-About.png\";s:12:\"tmpl_created\";i:1508161129;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/ski-resort-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:204;s:16:\"popularity_index\";i:425;s:11:\"trend_index\";i:513;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:720;a:14:{s:2:\"id\";i:2085;s:5:\"title\";s:27:\"Ski Resort &#8211; Services\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2017/10/Ski-Resort-Services.png\";s:12:\"tmpl_created\";i:1508161134;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/ski-resort-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:205;s:16:\"popularity_index\";i:551;s:11:\"trend_index\";i:689;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:721;a:14:{s:2:\"id\";i:2462;s:5:\"title\";s:23:\"Architect &#8211; About\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2017/10/architect-–-about.png\";s:12:\"tmpl_created\";i:1508243317;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/architect-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:206;s:16:\"popularity_index\";i:334;s:11:\"trend_index\";i:616;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:722;a:14:{s:2:\"id\";i:2362;s:5:\"title\";s:26:\"Architect &#8211; Projects\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2017/10/Architect-Projects.png\";s:12:\"tmpl_created\";i:1508243335;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/architect-projects/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:207;s:16:\"popularity_index\";i:399;s:11:\"trend_index\";i:572;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:723;a:14:{s:2:\"id\";i:614;s:5:\"title\";s:25:\"Architect &#8211; Contact\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2016/12/architect-contact.jpg\";s:12:\"tmpl_created\";i:1481549169;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/architect-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:208;s:16:\"popularity_index\";i:303;s:11:\"trend_index\";i:392;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:724;a:14:{s:2:\"id\";i:2126;s:5:\"title\";s:37:\"Construction Company &#8211; Homepage\";s:9:\"thumbnail\";s:91:\"https://library.elementor.com/wp-content/uploads/2017/10/Construction-Company-Home-Page.png\";s:12:\"tmpl_created\";i:1508325849;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/construction-company-homepage/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:209;s:16:\"popularity_index\";i:274;s:11:\"trend_index\";i:333;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:725;a:14:{s:2:\"id\";i:2129;s:5:\"title\";s:34:\"Construction Company &#8211; About\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2017/10/Construction-Company-About.png\";s:12:\"tmpl_created\";i:1508325881;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/construction-company-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:210;s:16:\"popularity_index\";i:306;s:11:\"trend_index\";i:521;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:726;a:14:{s:2:\"id\";i:2135;s:5:\"title\";s:36:\"Construction Company &#8211; Contact\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2017/10/Construction-Company-Contact.png\";s:12:\"tmpl_created\";i:1508325922;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/construction-company-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:211;s:16:\"popularity_index\";i:350;s:11:\"trend_index\";i:414;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:727;a:14:{s:2:\"id\";i:2094;s:5:\"title\";s:28:\"Plants Shop &#8211; Homepage\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2017/11/Plants-Shop-Home.png\";s:12:\"tmpl_created\";i:1509621053;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/plants-shop-homepage/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:212;s:16:\"popularity_index\";i:273;s:11:\"trend_index\";i:189;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:728;a:14:{s:2:\"id\";i:2120;s:5:\"title\";s:25:\"Plants Shop &#8211; About\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2017/11/Plants-Shop-About.png\";s:12:\"tmpl_created\";i:1509631820;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/plants-shop-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:213;s:16:\"popularity_index\";i:351;s:11:\"trend_index\";i:352;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:729;a:14:{s:2:\"id\";i:3153;s:5:\"title\";s:14:\"Halloween Pack\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/10/halloween.png\";s:12:\"tmpl_created\";i:1508950132;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/halloween-pack/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:214;s:16:\"popularity_index\";i:614;s:11:\"trend_index\";i:0;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:730;a:14:{s:2:\"id\";i:3338;s:5:\"title\";s:31:\"Black Friday &#8211; Nature Set\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2017/11/black-friday-1.png\";s:12:\"tmpl_created\";i:1511203351;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/black-friday-nature-set/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:215;s:16:\"popularity_index\";i:545;s:11:\"trend_index\";i:683;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:731;a:14:{s:2:\"id\";i:3339;s:5:\"title\";s:35:\"Black Friday &#8211; Pop-Styled Set\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2017/11/black-friday-2.png\";s:12:\"tmpl_created\";i:1511203636;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/black-friday-pop-styled-set/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:216;s:16:\"popularity_index\";i:487;s:11:\"trend_index\";i:679;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:732;a:14:{s:2:\"id\";i:3335;s:5:\"title\";s:31:\"Black Friday &#8211; Retail Set\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2017/11/black-friday-4.png\";s:12:\"tmpl_created\";i:1511203246;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/black-friday-retail-set/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:217;s:16:\"popularity_index\";i:489;s:11:\"trend_index\";i:602;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:733;a:14:{s:2:\"id\";i:3340;s:5:\"title\";s:41:\"Black Friday &#8211; Software Product Set\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2017/11/black-friday-3.png\";s:12:\"tmpl_created\";i:1511203713;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/black-friday-software-product-set/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:218;s:16:\"popularity_index\";i:460;s:11:\"trend_index\";i:639;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:734;a:14:{s:2:\"id\";i:3517;s:5:\"title\";s:27:\"Christmas &#8211; Gift Shop\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/12/XmasThumb.png\";s:12:\"tmpl_created\";i:1513877937;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/christmas-gift-shop/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:219;s:16:\"popularity_index\";i:543;s:11:\"trend_index\";i:593;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:735;a:14:{s:2:\"id\";i:3734;s:5:\"title\";s:28:\"Christmas &#8211; Car Agency\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2017/12/cover-lib-v3.png\";s:12:\"tmpl_created\";i:1514197794;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/christmas-car-agency/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:220;s:16:\"popularity_index\";i:521;s:11:\"trend_index\";i:604;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:736;a:14:{s:2:\"id\";i:3764;s:5:\"title\";s:33:\"Christmas &#8211; Interior Design\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2017/12/cover-lib-v6.png\";s:12:\"tmpl_created\";i:1514198234;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/christmas-interior-design/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:221;s:16:\"popularity_index\";i:494;s:11:\"trend_index\";i:669;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:737;a:14:{s:2:\"id\";i:3565;s:5:\"title\";s:27:\"Christmas &#8211; Tree Shop\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/12/XmasTreeThumb.png\";s:12:\"tmpl_created\";i:1514204382;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/christmas-tree-shop/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:222;s:16:\"popularity_index\";i:419;s:11:\"trend_index\";i:527;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:738;a:14:{s:2:\"id\";i:3862;s:5:\"title\";s:35:\"Christmas &#8211; Design Conference\";s:9:\"thumbnail\";s:63:\"https://library.elementor.com/wp-content/uploads/2017/12/q1.png\";s:12:\"tmpl_created\";i:1514206745;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/christmas-design-conference/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:223;s:16:\"popularity_index\";i:411;s:11:\"trend_index\";i:651;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:739;a:14:{s:2:\"id\";i:3777;s:5:\"title\";s:39:\"Christmas &#8211; Snowboard Competition\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2017/12/cover-lib-v7.png\";s:12:\"tmpl_created\";i:1514205420;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/christmas-snowboard-competition/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:224;s:16:\"popularity_index\";i:458;s:11:\"trend_index\";i:688;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:740;a:14:{s:2:\"id\";i:420;s:5:\"title\";s:11:\"Hero UI Kit\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2016/09/library-ui-kit-cover.png\";s:12:\"tmpl_created\";i:1475067229;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/hero-ui-kit/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:225;s:16:\"popularity_index\";i:20;s:11:\"trend_index\";i:62;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}}}", "no");
INSERT INTO `puy_options` VALUES("155", "elementor_remote_info_feed_data", "a:5:{i:0;a:5:{s:5:\"title\";s:47:\"Elementor Sites of the Month — September 2020\";s:7:\"excerpt\";s:325:\"Get ready to see some of the best magazine and blog websites built with Elementor. This month’s showcase explores the top ten magazine or blog websites from our user community, and shows prime examples for how to design your next blog or magazine site, with many unique options for layout, color schemes, motifs, and so on.\";s:7:\"created\";i:1602495962;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:123:\"https://elementor.com/blog/showcase-september-2020/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:1;a:5:{s:5:\"title\";s:36:\"The Complete WordPress Sidebar Guide\";s:7:\"excerpt\";s:150:\"Learn how sidebars can improve your site navigation and help you convert more of your traffic with the aid of the right widgets and good use of space.\";s:7:\"created\";i:1602398496;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:123:\"https://elementor.com/blog/wordpress-sidebar-guide/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:2;a:5:{s:5:\"title\";s:50:\"How to Write a Great Website Brief + Free Template\";s:7:\"excerpt\";s:152:\"A good website design brief is paramount to a successful web design project. Make sure that your project is a success with a well-crafted design brief. \";s:7:\"created\";i:1601540958;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:120:\"https://elementor.com/blog/create-website-brief/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:3;a:5:{s:5:\"title\";s:34:\"Introducing Design System Features\";s:7:\"excerpt\";s:211:\"Elementor 3.0 is finally here, and it brings a whole new way to build sites. Get ready for a special 3-in-1 release that includes: Design System Features, New Theme Builder and major performance improvements.​\";s:7:\"created\";i:1601465340;s:5:\"badge\";s:11:\"New Feature\";s:3:\"url\";s:137:\"https://elementor.com/blog/elementor-3-new-professional-features/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:4;a:5:{s:5:\"title\";s:60:\"WordPress Troubleshooting: Common Errors and How to Fix Them\";s:7:\"excerpt\";s:157:\"Have you come across an error and are unsure how to fix it? Follow this comprehensive guide to the most common WordPress errors and learn how to fix them.​\";s:7:\"created\";i:1601378179;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:132:\"https://elementor.com/blog/troubleshooting-wordpress-errors/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}}", "no");
INSERT INTO `puy_options` VALUES("164", "_elementor_installed_time", "1593694613", "yes");
INSERT INTO `puy_options` VALUES("181", "current_theme", "Hdigital Theme", "yes");
INSERT INTO `puy_options` VALUES("182", "theme_mods_hello-elementor", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1593694787;s:4:\"data\";a:1:{s:19:\"wp_inactive_widgets\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}}}}", "yes");
INSERT INTO `puy_options` VALUES("183", "theme_switched", "", "yes");
INSERT INTO `puy_options` VALUES("185", "theme_mods_hdigital-theme-child", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:11:\"custom_logo\";i:31;}", "yes");
INSERT INTO `puy_options` VALUES("189", "recently_activated", "a:0:{}", "yes");
INSERT INTO `puy_options` VALUES("194", "elementor_pro_version", "3.0.3", "yes");
INSERT INTO `puy_options` VALUES("195", "widget_elementor-library", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `puy_options` VALUES("196", "_elementor_pro_installed_time", "1593694862", "yes");
INSERT INTO `puy_options` VALUES("197", "elementor_connect_site_key", "e71ce283d673b54896c421d9823bde81", "yes");
INSERT INTO `puy_options` VALUES("198", "elementor_allow_tracking", "yes", "yes");
INSERT INTO `puy_options` VALUES("199", "elementor_tracker_last_send", "1602334610", "yes");
INSERT INTO `puy_options` VALUES("200", "elementor_pro_license_key", "0d334b1a59294c25656424ef1d796c4d", "yes");
INSERT INTO `puy_options` VALUES("206", "new_admin_email", "matan@hdigital.co.il", "yes");
INSERT INTO `puy_options` VALUES("214", "elementor_custom_icon_sets_config", "a:0:{}", "yes");
INSERT INTO `puy_options` VALUES("215", "elementor_fonts_manager_font_types", "a:0:{}", "yes");
INSERT INTO `puy_options` VALUES("216", "elementor_fonts_manager_fonts", "a:0:{}", "yes");
INSERT INTO `puy_options` VALUES("218", "elementor_log", "a:32:{s:32:\"cef7747d32689a674283a8fc46863a09\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2020-07-02 16:03:23\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:13:\"Elementor Pro\";s:4:\"from\";s:5:\"2.6.2\";s:2:\"to\";s:6:\"2.10.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2020-07-02 16:03:23\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:13:\"Elementor Pro\";s:4:\"from\";s:5:\"2.6.2\";s:2:\"to\";s:6:\"2.10.3\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"ec4cb96b6c156a7d37b26fd62ff2a1f2\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0file\";s:134:\"/home/pltempur/domains/c-serv.co.il/private_html/wp-content/plugins/elementor-pro/modules/theme-builder/classes/conditions-manager.php\";s:7:\"\0*\0line\";i:259;s:7:\"\0*\0date\";s:19:\"2020-07-02 16:31:49\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:1027:\"Uncaught Error: Call to a member function update_meta() on null in /home/pltempur/domains/c-serv.co.il/private_html/wp-content/plugins/elementor-pro/modules/theme-builder/classes/conditions-manager.php:259\nStack trace:\n#0 /home/pltempur/domains/c-serv.co.il/private_html/wp-content/plugins/elementor-pro/modules/theme-builder/classes/conditions-manager.php(180): ElementorPro\\Modules\\ThemeBuilder\\Classes\\Conditions_Manager-&gt;save_conditions(28, Array)\n#1 [internal function]: ElementorPro\\Modules\\ThemeBuilder\\Classes\\Conditions_Manager-&gt;ajax_save_theme_template_conditions(Array, Object(Elementor\\Core\\Common\\Modules\\Ajax\\Module))\n#2 /home/pltempur/domains/c-serv.co.il/private_html/wp-content/plugins/elementor/core/common/modules/ajax/module.php(171): call_user_func(Array, Array, Object(Elementor\\Core\\Common\\Modules\\Ajax\\Module))\n#3 /home/pltempur/domains/c-serv.co.il/private_html/wp-includes/class-wp-hook.php(287): Elementor\\Core\\Common\\Modules\\Ajax\\Module-&gt;handle_ajax_request(&#039;&#039;)\n#4 /home/cservuss/\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2020-07-02 16:31:49\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:5:\"error\";s:7:\"message\";s:1008:\"Uncaught Error: Call to a member function update_meta() on null in /home/pltempur/domains/c-serv.co.il/private_html/wp-content/plugins/elementor-pro/modules/theme-builder/classes/conditions-manager.php:259\nStack trace:\n#0 /home/pltempur/domains/c-serv.co.il/private_html/wp-content/plugins/elementor-pro/modules/theme-builder/classes/conditions-manager.php(180): ElementorPro\\Modules\\ThemeBuilder\\Classes\\Conditions_Manager->save_conditions(28, Array)\n#1 [internal function]: ElementorPro\\Modules\\ThemeBuilder\\Classes\\Conditions_Manager->ajax_save_theme_template_conditions(Array, Object(Elementor\\Core\\Common\\Modules\\Ajax\\Module))\n#2 /home/pltempur/domains/c-serv.co.il/private_html/wp-content/plugins/elementor/core/common/modules/ajax/module.php(171): call_user_func(Array, Array, Object(Elementor\\Core\\Common\\Modules\\Ajax\\Module))\n#3 /home/pltempur/domains/c-serv.co.il/private_html/wp-includes/class-wp-hook.php(287): Elementor\\Core\\Common\\Modules\\Ajax\\Module->handle_ajax_request(\'\')\n#4 /home/cservuss/\";s:4:\"file\";s:134:\"/home/pltempur/domains/c-serv.co.il/private_html/wp-content/plugins/elementor-pro/modules/theme-builder/classes/conditions-manager.php\";s:4:\"line\";i:259;s:5:\"trace\";b:1;}}s:32:\"b7d5fbff5d9ff810102ab747fd4f0ff8\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:4:\"1825\";s:7:\"\0*\0file\";s:281:\"https://www.c-serv.co.il/wp-admin/load-scripts.php?c=0&loadchunk_0=underscore,jquery-core,jquery-migrate,backbone,jquery-ui-core,jquery-ui-widget,jquery-ui-mouse,shortcode,utils,wp-util,wp-backbo&loadchunk_1=ne,media-models,moxiejs,plupload,wp-plupload,jquery-ui-sortable&ver=5.4.2\";s:7:\"\0*\0line\";s:1:\"4\";s:7:\"\0*\0date\";s:19:\"2020-07-02 16:27:57\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:104:\"cannot call methods on resizable prior to initialization; attempted to call method \\&#039;destroy\\&#039;\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2020-07-02 16:27:57\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1593707277\";s:7:\"message\";s:94:\"cannot call methods on resizable prior to initialization; attempted to call method \\\'destroy\\\'\";s:3:\"url\";s:281:\"https://www.c-serv.co.il/wp-admin/load-scripts.php?c=0&loadchunk_0=underscore,jquery-core,jquery-migrate,backbone,jquery-ui-core,jquery-ui-widget,jquery-ui-mouse,shortcode,utils,wp-util,wp-backbo&loadchunk_1=ne,media-models,moxiejs,plupload,wp-plupload,jquery-ui-sortable&ver=5.4.2\";s:4:\"line\";s:1:\"4\";s:6:\"column\";s:4:\"1825\";}}s:32:\"6f1cbcc026fb9f7e9d90b59a8bb4e172\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:5:\"48448\";s:7:\"\0*\0file\";s:96:\"https://www.c-serv.co.il/wp-content/plugins/elementor/assets/js/editor-modules.min.js?ver=2.9.13\";s:7:\"\0*\0line\";s:1:\"2\";s:7:\"\0*\0date\";s:19:\"2020-07-07 15:11:48\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:43:\"n.attributes[e.name].each is not a function\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:2;s:14:\"\0*\0times_dates\";a:2:{i:0;s:19:\"2020-07-07 15:11:48\";i:1;s:19:\"2020-07-07 15:12:00\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1594134708\";s:7:\"message\";s:43:\"n.attributes[e.name].each is not a function\";s:3:\"url\";s:96:\"https://www.c-serv.co.il/wp-content/plugins/elementor/assets/js/editor-modules.min.js?ver=2.9.13\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:5:\"48448\";}}s:32:\"9028f1293428ef4708379c8cd0462c6e\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0file\";s:134:\"/home/pltempur/domains/c-serv.co.il/private_html/wp-content/plugins/elementor-pro/modules/theme-builder/classes/conditions-manager.php\";s:7:\"\0*\0line\";i:259;s:7:\"\0*\0date\";s:19:\"2020-07-27 12:10:02\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:1027:\"Uncaught Error: Call to a member function update_meta() on boolean in /home/pltempur/domains/c-serv.co.il/private_html/wp-content/plugins/elementor-pro/modules/theme-builder/classes/conditions-manager.php:259\nStack trace:\n#0 /home/pltempur/domains/c-serv.co.il/private_html/wp-content/plugins/elementor-pro/modules/theme-builder/classes/conditions-manager.php(180): ElementorPro\\Modules\\ThemeBuilder\\Classes\\Conditions_Manager-&gt;save_conditions(NULL, Array)\n#1 [internal function]: ElementorPro\\Modules\\ThemeBuilder\\Classes\\Conditions_Manager-&gt;ajax_save_theme_template_conditions(Array, Object(Elementor\\Core\\Common\\Modules\\Ajax\\Module))\n#2 /home/pltempur/domains/c-serv.co.il/private_html/wp-content/plugins/elementor/core/common/modules/ajax/module.php(171): call_user_func(Array, Array, Object(Elementor\\Core\\Common\\Modules\\Ajax\\Module))\n#3 /home/pltempur/domains/c-serv.co.il/private_html/wp-includes/class-wp-hook.php(287): Elementor\\Core\\Common\\Modules\\Ajax\\Module-&gt;handle_ajax_request(&#039;&#039;)\n#4 /home/cser\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2020-07-27 12:10:02\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:5:\"error\";s:7:\"message\";s:1008:\"Uncaught Error: Call to a member function update_meta() on boolean in /home/pltempur/domains/c-serv.co.il/private_html/wp-content/plugins/elementor-pro/modules/theme-builder/classes/conditions-manager.php:259\nStack trace:\n#0 /home/pltempur/domains/c-serv.co.il/private_html/wp-content/plugins/elementor-pro/modules/theme-builder/classes/conditions-manager.php(180): ElementorPro\\Modules\\ThemeBuilder\\Classes\\Conditions_Manager->save_conditions(NULL, Array)\n#1 [internal function]: ElementorPro\\Modules\\ThemeBuilder\\Classes\\Conditions_Manager->ajax_save_theme_template_conditions(Array, Object(Elementor\\Core\\Common\\Modules\\Ajax\\Module))\n#2 /home/pltempur/domains/c-serv.co.il/private_html/wp-content/plugins/elementor/core/common/modules/ajax/module.php(171): call_user_func(Array, Array, Object(Elementor\\Core\\Common\\Modules\\Ajax\\Module))\n#3 /home/pltempur/domains/c-serv.co.il/private_html/wp-includes/class-wp-hook.php(287): Elementor\\Core\\Common\\Modules\\Ajax\\Module->handle_ajax_request(\'\')\n#4 /home/cser\";s:4:\"file\";s:134:\"/home/pltempur/domains/c-serv.co.il/private_html/wp-content/plugins/elementor-pro/modules/theme-builder/classes/conditions-manager.php\";s:4:\"line\";i:259;s:5:\"trace\";b:1;}}s:32:\"428ad4c944bb09363cd55579e6a5481b\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2020-07-29 12:10:42\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"אלמנטור\";s:4:\"from\";s:6:\"2.9.13\";s:2:\"to\";s:6:\"2.9.14\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2020-07-29 12:10:42\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"אלמנטור\";s:4:\"from\";s:6:\"2.9.13\";s:2:\"to\";s:6:\"2.9.14\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"6e1eebc6135164c6215a4ddfe1e9c319\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:6:\"195519\";s:7:\"\0*\0file\";s:97:\"https://www.c-serv.co.il/wp-content/plugins/elementor/assets/js/editor-document.min.js?ver=2.9.14\";s:7:\"\0*\0line\";s:1:\"2\";s:7:\"\0*\0date\";s:19:\"2020-08-20 09:54:31\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:51:\"Cannot read property \\&#039;map\\&#039; of undefined\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2020-08-20 09:54:31\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1597917271\";s:7:\"message\";s:41:\"Cannot read property \\\'map\\\' of undefined\";s:3:\"url\";s:97:\"https://www.c-serv.co.il/wp-content/plugins/elementor/assets/js/editor-document.min.js?ver=2.9.14\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:6:\"195519\";}}s:32:\"7521b9ac92ac5f3c0d7747111fd660b9\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2020-08-30 12:55:36\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2020-08-30 12:55:36\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"ca26d475877939436400b8ecd2edad9d\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2020-08-30 12:55:36\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:70:\"אלמנטור/Upgrades - _v_3_0_0_move_general_settings_to_kit Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2020-08-30 12:55:36\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:70:\"אלמנטור/Upgrades - _v_3_0_0_move_general_settings_to_kit Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"5c30387c3e9af5420211206a045cb904\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2020-08-30 12:55:36\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:72:\"אלמנטור/Upgrades - _v_3_0_0_move_general_settings_to_kit Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2020-08-30 12:55:36\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:72:\"אלמנטור/Upgrades - _v_3_0_0_move_general_settings_to_kit Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"74037327971283a8e42099328fafb94a\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2020-08-30 12:55:36\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:68:\"אלמנטור/Upgrades - _v_3_0_0_move_default_colors_to_kit Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2020-08-30 12:55:36\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:68:\"אלמנטור/Upgrades - _v_3_0_0_move_default_colors_to_kit Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"8ee72d331c35cc4dd2d145b45503af42\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2020-08-30 12:55:36\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:70:\"אלמנטור/Upgrades - _v_3_0_0_move_default_colors_to_kit Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2020-08-30 12:55:36\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:70:\"אלמנטור/Upgrades - _v_3_0_0_move_default_colors_to_kit Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"e4625da6312949db005a11e233d53212\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2020-08-30 12:55:36\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:66:\"אלמנטור/Upgrades - _v_3_0_0_move_saved_colors_to_kit Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2020-08-30 12:55:36\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:66:\"אלמנטור/Upgrades - _v_3_0_0_move_saved_colors_to_kit Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"07fe1d1fdbfafdb01bedca498e64362a\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2020-08-30 12:55:36\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:68:\"אלמנטור/Upgrades - _v_3_0_0_move_saved_colors_to_kit Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2020-08-30 12:55:36\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:68:\"אלמנטור/Upgrades - _v_3_0_0_move_saved_colors_to_kit Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"bd1ed8c75d7c2d78cf315c4e1a7b08b2\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2020-08-30 12:55:36\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:72:\"אלמנטור/Upgrades - _v_3_0_0_move_default_typography_to_kit Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2020-08-30 12:55:36\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:72:\"אלמנטור/Upgrades - _v_3_0_0_move_default_typography_to_kit Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"00d7dba0c30dd531ad6c6ca357958c87\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2020-08-30 12:55:36\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:74:\"אלמנטור/Upgrades - _v_3_0_0_move_default_typography_to_kit Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2020-08-30 12:55:36\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:74:\"אלמנטור/Upgrades - _v_3_0_0_move_default_typography_to_kit Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"ba8ccb163bd5f41449bca0bcb07f3434\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2020-08-30 12:55:36\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"אלמנטור\";s:4:\"from\";s:6:\"2.9.14\";s:2:\"to\";s:5:\"3.0.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2020-08-30 12:55:36\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"אלמנטור\";s:4:\"from\";s:6:\"2.9.14\";s:2:\"to\";s:5:\"3.0.3\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"b6cd985d375f622e6882155df24f1cb4\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2020-08-30 12:55:36\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"אלמנטור\";s:4:\"from\";s:6:\"2.9.14\";s:2:\"to\";s:5:\"3.0.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2020-08-30 12:55:36\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"אלמנטור\";s:4:\"from\";s:6:\"2.9.14\";s:2:\"to\";s:5:\"3.0.3\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"162b630b43c25da6c3e81f37cbf0a5a6\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:6:\"310780\";s:7:\"\0*\0file\";s:87:\"https://www.c-serv.co.il/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.0.3\";s:7:\"\0*\0line\";s:1:\"2\";s:7:\"\0*\0date\";s:19:\"2020-08-30 10:01:41\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:52:\"Cannot read property \\&#039;urls\\&#039; of undefined\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:19;s:14:\"\0*\0times_dates\";a:19:{i:0;s:19:\"2020-08-30 10:01:41\";i:1;s:19:\"2020-08-30 10:11:12\";i:2;s:19:\"2020-08-30 11:15:04\";i:3;s:19:\"2020-08-30 11:16:07\";i:4;s:19:\"2020-08-30 12:15:48\";i:5;s:19:\"2020-09-01 07:34:12\";i:6;s:19:\"2020-09-01 07:34:32\";i:7;s:19:\"2020-09-01 07:35:49\";i:8;s:19:\"2020-09-01 07:36:14\";i:9;s:19:\"2020-09-01 07:40:19\";i:10;s:19:\"2020-09-02 06:35:39\";i:11;s:19:\"2020-09-03 07:52:37\";i:12;s:19:\"2020-09-03 07:55:55\";i:13;s:19:\"2020-09-03 07:56:46\";i:14;s:19:\"2020-09-03 08:59:57\";i:15;s:19:\"2020-09-03 09:00:36\";i:16;s:19:\"2020-09-03 09:06:52\";i:17;s:19:\"2020-09-04 15:36:59\";i:18;s:19:\"2020-09-06 12:23:19\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1598781701\";s:7:\"message\";s:42:\"Cannot read property \\\'urls\\\' of undefined\";s:3:\"url\";s:87:\"https://www.c-serv.co.il/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.0.3\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:6:\"310780\";}}s:32:\"0f9de13ef05690a01d4b5ebfb414b861\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2020-09-01 10:35:47\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:21:\"אלמנטור פרו\";s:4:\"from\";s:6:\"2.10.3\";s:2:\"to\";s:5:\"3.0.2\";}s:8:\"\0*\0times\";i:2;s:14:\"\0*\0times_dates\";a:2:{i:0;s:19:\"2020-09-01 10:35:47\";i:1;s:19:\"2020-09-01 10:35:47\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:21:\"אלמנטור פרו\";s:4:\"from\";s:6:\"2.10.3\";s:2:\"to\";s:5:\"3.0.2\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"fc693dc94c8b47c84e6da3a23246c62a\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2020-09-01 10:35:47\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2020-09-01 10:35:47\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"b340396db092f5fdf2243b308e94a8ea\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2020-09-01 10:35:47\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:78:\"אלמנטור/Upgrades - _v_3_0_5_re_move_space_between_widgets_to_kit Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2020-09-01 10:35:47\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:78:\"אלמנטור/Upgrades - _v_3_0_5_re_move_space_between_widgets_to_kit Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"10cab46ee51a1e90af86f158d4027c60\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2020-09-01 10:35:47\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:80:\"אלמנטור/Upgrades - _v_3_0_5_re_move_space_between_widgets_to_kit Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2020-09-01 10:35:47\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:80:\"אלמנטור/Upgrades - _v_3_0_5_re_move_space_between_widgets_to_kit Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"bb11f58a89508e65ac66f274b9551e8e\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2020-09-01 10:35:47\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"אלמנטור\";s:4:\"from\";s:5:\"3.0.3\";s:2:\"to\";s:5:\"3.0.5\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2020-09-01 10:35:47\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"אלמנטור\";s:4:\"from\";s:5:\"3.0.3\";s:2:\"to\";s:5:\"3.0.5\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"ce51a7b8d91ad6c1fee27986233884e8\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2020-09-01 10:35:47\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"אלמנטור\";s:4:\"from\";s:5:\"3.0.3\";s:2:\"to\";s:5:\"3.0.5\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2020-09-01 10:35:47\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"אלמנטור\";s:4:\"from\";s:5:\"3.0.3\";s:2:\"to\";s:5:\"3.0.5\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"c7aafb306270dea2feadf8bae322a413\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2020-09-01 10:35:48\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"אלמנטור\";s:4:\"from\";s:5:\"3.0.3\";s:2:\"to\";s:5:\"3.0.5\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2020-09-01 10:35:48\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"אלמנטור\";s:4:\"from\";s:5:\"3.0.3\";s:2:\"to\";s:5:\"3.0.5\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"fa6aa9484601e5821ab5634ff7b402e4\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2020-09-03 12:00:28\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:21:\"אלמנטור פרו\";s:4:\"from\";s:5:\"3.0.2\";s:2:\"to\";s:5:\"3.0.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2020-09-03 12:00:28\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:21:\"אלמנטור פרו\";s:4:\"from\";s:5:\"3.0.2\";s:2:\"to\";s:5:\"3.0.3\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"773e6ddf10f67aa1eb544be3788aebc7\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2020-09-07 08:48:27\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2020-09-07 08:48:27\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"e8c54235602f101a6b8a0a8fed5d27aa\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2020-09-07 08:48:27\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:78:\"אלמנטור/Upgrades - _v_3_0_5_re_move_space_between_widgets_to_kit Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2020-09-07 08:48:27\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:78:\"אלמנטור/Upgrades - _v_3_0_5_re_move_space_between_widgets_to_kit Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"61d5b5cf5e5caedf820cf1aedefd8937\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2020-09-07 08:48:27\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:80:\"אלמנטור/Upgrades - _v_3_0_5_re_move_space_between_widgets_to_kit Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2020-09-07 08:48:27\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:80:\"אלמנטור/Upgrades - _v_3_0_5_re_move_space_between_widgets_to_kit Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"f1c2d0b7acba61fc9bd8d48d06d4c220\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2020-09-07 08:48:27\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"אלמנטור\";s:4:\"from\";s:5:\"3.0.5\";s:2:\"to\";s:5:\"3.0.6\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2020-09-07 08:48:27\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"אלמנטור\";s:4:\"from\";s:5:\"3.0.5\";s:2:\"to\";s:5:\"3.0.6\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"2cc3fadf832176ee6086ee0cb2692535\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0file\";s:112:\"/home/pltempur/domains/c-serv.co.il/public_html/wp-content/plugins/elementor/core/common/modules/ajax/module.php\";s:7:\"\0*\0line\";i:171;s:7:\"\0*\0date\";s:19:\"2020-09-16 10:28:15\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:21:\"Undefined index: data\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:3;s:14:\"\0*\0times_dates\";a:3:{i:0;s:19:\"2020-09-16 10:28:15\";i:1;s:19:\"2020-09-22 11:38:32\";i:2;s:19:\"2020-10-05 13:23:48\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:21:\"Undefined index: data\";s:4:\"file\";s:112:\"/home/pltempur/domains/c-serv.co.il/public_html/wp-content/plugins/elementor/core/common/modules/ajax/module.php\";s:4:\"line\";i:171;s:5:\"trace\";b:1;}}}", "no");
INSERT INTO `puy_options` VALUES("219", "_elementor_pro_license_data_fallback", "a:2:{s:7:\"timeout\";i:1602636161;s:5:\"value\";s:329:\"{\"expires\":\"2021-10-11 09:26:25\",\"payment_id\":7442624,\"customer_name\":\"Asi Cohen\",\"customer_email\":\"asi@hdigital.co.il\",\"price_id\":3,\"license_limit\":1000,\"site_count\":244,\"activations_left\":756,\"success\":true,\"license\":\"valid\",\"item_id\":6630548,\"item_name\":\"Elementor Pro - Expert\",\"subscriptions\":\"enable\",\"checksum\":\"checksum\"}\";}", "yes");
INSERT INTO `puy_options` VALUES("220", "_elementor_pro_license_data", "a:2:{s:7:\"timeout\";i:1602592961;s:5:\"value\";s:329:\"{\"expires\":\"2021-10-11 09:26:25\",\"payment_id\":7442624,\"customer_name\":\"Asi Cohen\",\"customer_email\":\"asi@hdigital.co.il\",\"price_id\":3,\"license_limit\":1000,\"site_count\":244,\"activations_left\":756,\"success\":true,\"license\":\"valid\",\"item_id\":6630548,\"item_name\":\"Elementor Pro - Expert\",\"subscriptions\":\"enable\",\"checksum\":\"checksum\"}\";}", "yes");
INSERT INTO `puy_options` VALUES("221", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `puy_options` VALUES("222", "elementor_scheme_color", "a:4:{i:1;s:7:\"#6ec1e4\";i:2;s:7:\"#54595f\";i:3;s:7:\"#7a7a7a\";i:4;s:7:\"#61ce70\";}", "yes");
INSERT INTO `puy_options` VALUES("223", "elementor_scheme_typography", "a:4:{i:1;a:2:{s:11:\"font_family\";s:9:\"Assistant\";s:11:\"font_weight\";s:3:\"600\";}i:2;a:2:{s:11:\"font_family\";s:9:\"Assistant\";s:11:\"font_weight\";s:3:\"400\";}i:3;a:2:{s:11:\"font_family\";s:9:\"Assistant\";s:11:\"font_weight\";s:3:\"400\";}i:4;a:2:{s:11:\"font_family\";s:9:\"Assistant\";s:11:\"font_weight\";s:3:\"500\";}}", "yes");
INSERT INTO `puy_options` VALUES("224", "elementor_scheme_color-picker", "a:12:{i:1;s:7:\"#6ec1e4\";i:2;s:7:\"#54595f\";i:3;s:7:\"#7a7a7a\";i:4;s:7:\"#61ce70\";i:5;s:7:\"#4054b2\";i:6;s:7:\"#23a455\";i:7;s:4:\"#000\";i:8;s:4:\"#fff\";i:9;s:7:\"#000346\";i:10;s:7:\"#D60109\";i:11;s:7:\"#FF4B4B\";i:12;s:7:\"#053359\";}", "yes");
INSERT INTO `puy_options` VALUES("225", "elementor_active_kit", "28", "yes");
INSERT INTO `puy_options` VALUES("226", "elementor_controls_usage", "a:6:{s:7:\"wp-page\";a:16:{s:7:\"heading\";a:2:{s:5:\"count\";i:71;s:8:\"controls\";a:4:{s:7:\"content\";a:1:{s:13:\"section_title\";a:7:{s:5:\"title\";i:71;s:12:\"align_mobile\";i:39;s:5:\"align\";i:54;s:12:\"align_tablet\";i:35;s:11:\"header_size\";i:24;s:4:\"link\";i:3;s:4:\"size\";i:7;}}s:5:\"style\";a:1:{s:19:\"section_title_style\";a:6:{s:11:\"title_color\";i:71;s:21:\"typography_typography\";i:60;s:20:\"typography_font_size\";i:60;s:22:\"typography_font_weight\";i:44;s:27:\"typography_font_size_mobile\";i:22;s:27:\"typography_font_size_tablet\";i:3;}}s:8:\"advanced\";a:4:{s:14:\"_section_style\";a:4:{s:8:\"_padding\";i:16;s:14:\"_margin_tablet\";i:1;s:15:\"_padding_tablet\";i:2;s:7:\"_margin\";i:3;}s:19:\"_section_background\";a:2:{s:22:\"_background_background\";i:8;s:17:\"_background_color\";i:8;}s:18:\"section_custom_css\";a:0:{}s:19:\"_section_responsive\";a:0:{}}s:7:\"general\";a:1:{s:11:\"__dynamic__\";a:1:{s:5:\"count\";i:1;}}}}s:6:\"button\";a:2:{s:5:\"count\";i:26;s:8:\"controls\";a:4:{s:7:\"content\";a:1:{s:14:\"section_button\";a:7:{s:4:\"text\";i:26;s:5:\"align\";i:26;s:4:\"link\";i:26;s:12:\"align_mobile\";i:7;s:4:\"size\";i:3;s:13:\"selected_icon\";i:3;s:11:\"icon_indent\";i:3;}}s:5:\"style\";a:1:{s:13:\"section_style\";a:16:{s:21:\"typography_typography\";i:26;s:20:\"typography_font_size\";i:26;s:17:\"button_text_color\";i:26;s:16:\"background_color\";i:26;s:29:\"button_background_hover_color\";i:23;s:13:\"border_radius\";i:26;s:27:\"typography_font_size_mobile\";i:10;s:13:\"border_border\";i:5;s:12:\"border_width\";i:5;s:27:\"typography_font_size_tablet\";i:12;s:22:\"typography_line_height\";i:4;s:12:\"text_padding\";i:4;s:26:\"typography_text_decoration\";i:3;s:11:\"hover_color\";i:3;s:15:\"hover_animation\";i:3;s:19:\"text_padding_mobile\";i:2;}}s:8:\"advanced\";a:1:{s:14:\"_section_style\";a:4:{s:15:\"_padding_mobile\";i:2;s:14:\"_margin_tablet\";i:12;s:7:\"_margin\";i:9;s:8:\"_padding\";i:8;}}s:7:\"general\";a:1:{s:11:\"__dynamic__\";a:1:{s:5:\"count\";i:15;}}}}s:6:\"column\";a:2:{s:5:\"count\";i:160;s:8:\"controls\";a:3:{s:6:\"layout\";a:1:{s:6:\"layout\";a:6:{s:12:\"_inline_size\";i:159;s:21:\"space_between_widgets\";i:50;s:19:\"_inline_size_tablet\";i:50;s:19:\"_inline_size_mobile\";i:52;s:28:\"space_between_widgets_tablet\";i:2;s:28:\"space_between_widgets_mobile\";i:4;}}s:8:\"advanced\";a:2:{s:16:\"section_advanced\";a:6:{s:7:\"padding\";i:52;s:6:\"margin\";i:33;s:14:\"padding_mobile\";i:32;s:13:\"margin_mobile\";i:28;s:13:\"margin_tablet\";i:2;s:14:\"padding_tablet\";i:14;}s:18:\"section_custom_css\";a:1:{s:10:\"custom_css\";i:6;}}s:5:\"style\";a:1:{s:13:\"section_style\";a:2:{s:16:\"background_color\";i:35;s:21:\"background_background\";i:12;}}}}s:7:\"section\";a:2:{s:5:\"count\";i:100;s:8:\"controls\";a:3:{s:6:\"layout\";a:2:{s:14:\"section_layout\";a:13:{s:6:\"height\";i:16;s:13:\"custom_height\";i:12;s:16:\"content_position\";i:11;s:15:\"stretch_section\";i:15;s:20:\"custom_height_mobile\";i:12;s:19:\"custom_height_inner\";i:3;s:13:\"content_width\";i:13;s:6:\"layout\";i:9;s:3:\"gap\";i:1;s:8:\"html_tag\";i:1;s:8:\"overflow\";i:3;s:20:\"custom_height_tablet\";i:1;s:15:\"column_position\";i:1;}s:17:\"section_structure\";a:1:{s:9:\"structure\";i:53;}}s:5:\"style\";a:3:{s:18:\"section_background\";a:18:{s:21:\"background_background\";i:47;s:16:\"background_image\";i:22;s:17:\"background_repeat\";i:16;s:15:\"background_size\";i:16;s:19:\"background_position\";i:14;s:26:\"background_position_mobile\";i:16;s:22:\"background_size_mobile\";i:4;s:26:\"background_position_tablet\";i:14;s:16:\"background_color\";i:32;s:22:\"background_xpos_tablet\";i:1;s:23:\"background_image_mobile\";i:2;s:24:\"background_repeat_mobile\";i:2;s:23:\"background_image_tablet\";i:1;s:24:\"background_repeat_tablet\";i:1;s:22:\"background_size_tablet\";i:1;s:18:\"background_color_b\";i:1;s:25:\"background_gradient_angle\";i:1;s:19:\"background_bg_width\";i:1;}s:26:\"section_background_overlay\";a:6:{s:24:\"background_overlay_color\";i:14;s:26:\"background_overlay_opacity\";i:14;s:24:\"background_overlay_image\";i:13;s:29:\"background_overlay_background\";i:20;s:23:\"background_overlay_size\";i:4;s:27:\"background_overlay_position\";i:2;}s:14:\"section_border\";a:3:{s:13:\"border_border\";i:6;s:12:\"border_width\";i:6;s:12:\"border_color\";i:6;}}s:8:\"advanced\";a:2:{s:19:\"_section_responsive\";a:4:{s:20:\"reverse_order_mobile\";i:3;s:11:\"hide_mobile\";i:4;s:12:\"hide_desktop\";i:4;s:11:\"hide_tablet\";i:4;}s:16:\"section_advanced\";a:7:{s:7:\"padding\";i:47;s:6:\"margin\";i:21;s:14:\"padding_tablet\";i:5;s:14:\"padding_mobile\";i:11;s:13:\"margin_tablet\";i:4;s:13:\"margin_mobile\";i:5;s:11:\"_element_id\";i:1;}}}}s:7:\"divider\";a:2:{s:5:\"count\";i:29;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:15:\"section_divider\";a:6:{s:5:\"width\";i:29;s:5:\"align\";i:29;s:12:\"align_mobile\";i:19;s:12:\"align_tablet\";i:18;s:4:\"look\";i:1;s:4:\"text\";i:1;}}s:5:\"style\";a:2:{s:21:\"section_divider_style\";a:3:{s:5:\"color\";i:29;s:6:\"weight\";i:28;s:3:\"gap\";i:24;}s:18:\"section_text_style\";a:3:{s:10:\"text_color\";i:1;s:21:\"typography_typography\";i:1;s:20:\"typography_font_size\";i:1;}}s:8:\"advanced\";a:1:{s:14:\"_section_style\";a:0:{}}}}s:11:\"text-editor\";a:2:{s:5:\"count\";i:59;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:14:\"section_editor\";a:1:{s:6:\"editor\";i:59;}}s:5:\"style\";a:1:{s:13:\"section_style\";a:10:{s:5:\"align\";i:32;s:10:\"text_color\";i:51;s:21:\"typography_typography\";i:50;s:20:\"typography_font_size\";i:50;s:27:\"typography_font_size_mobile\";i:18;s:22:\"typography_line_height\";i:5;s:27:\"typography_font_size_tablet\";i:9;s:22:\"typography_font_weight\";i:8;s:12:\"align_mobile\";i:8;s:12:\"align_tablet\";i:1;}}s:8:\"advanced\";a:1:{s:14:\"_section_style\";a:4:{s:8:\"_padding\";i:9;s:15:\"_padding_mobile\";i:7;s:14:\"_margin_mobile\";i:1;s:15:\"_padding_tablet\";i:1;}}}}s:5:\"image\";a:2:{s:5:\"count\";i:46;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:13:\"section_image\";a:7:{s:5:\"image\";i:46;s:10:\"image_size\";i:44;s:7:\"link_to\";i:8;s:4:\"link\";i:8;s:12:\"align_mobile\";i:16;s:5:\"align\";i:14;s:12:\"align_tablet\";i:8;}}s:5:\"style\";a:1:{s:19:\"section_style_image\";a:4:{s:5:\"width\";i:29;s:5:\"space\";i:23;s:12:\"width_mobile\";i:24;s:12:\"space_mobile\";i:24;}}s:8:\"advanced\";a:4:{s:14:\"_section_style\";a:4:{s:7:\"_margin\";i:18;s:8:\"_padding\";i:12;s:14:\"_margin_mobile\";i:16;s:15:\"_padding_mobile\";i:16;}s:17:\"_section_position\";a:10:{s:14:\"_element_width\";i:8;s:9:\"_position\";i:8;s:21:\"_element_width_tablet\";i:8;s:21:\"_element_width_mobile\";i:8;s:28:\"_element_custom_width_tablet\";i:8;s:28:\"_element_custom_width_mobile\";i:8;s:9:\"_offset_x\";i:8;s:16:\"_offset_x_mobile\";i:8;s:9:\"_offset_y\";i:8;s:16:\"_offset_y_mobile\";i:8;}s:19:\"_section_responsive\";a:1:{s:11:\"hide_mobile\";i:8;}s:15:\"section_effects\";a:2:{s:27:\"motion_fx_mouseTrack_effect\";i:6;s:10:\"_animation\";i:6;}}}}s:5:\"table\";a:2:{s:5:\"count\";i:6;s:8:\"controls\";a:3:{s:7:\"content\";a:2:{s:14:\"section_header\";a:2:{s:12:\"header_cells\";i:6;s:8:\"sortable\";i:1;}s:15:\"section_content\";a:1:{s:4:\"rows\";i:6;}}s:5:\"style\";a:4:{s:18:\"section_rows_style\";a:3:{s:16:\"row_border_width\";i:6;s:16:\"row_border_color\";i:6;s:14:\"row_background\";i:6;}s:19:\"section_cells_style\";a:8:{s:26:\"cell_typography_typography\";i:6;s:25:\"cell_typography_font_size\";i:6;s:10:\"cell_align\";i:6;s:17:\"cell_align_mobile\";i:6;s:18:\"cell_border_border\";i:6;s:17:\"cell_border_width\";i:6;s:17:\"cell_border_color\";i:6;s:10:\"cell_color\";i:5;}s:20:\"section_header_style\";a:5:{s:19:\"mobile_headers_size\";i:6;s:28:\"header_typography_typography\";i:6;s:27:\"header_typography_font_size\";i:6;s:17:\"header_cell_color\";i:6;s:22:\"header_cell_background\";i:6;}s:21:\"section_columns_style\";a:1:{s:5:\"rules\";i:6;}}s:8:\"advanced\";a:1:{s:14:\"_section_style\";a:1:{s:12:\"_css_classes\";i:5;}}}}s:4:\"form\";a:2:{s:5:\"count\";i:10;s:8:\"controls\";a:2:{s:7:\"content\";a:8:{s:19:\"section_form_fields\";a:4:{s:9:\"form_name\";i:10;s:11:\"form_fields\";i:10;s:11:\"show_labels\";i:10;s:10:\"input_size\";i:8;}s:15:\"section_buttons\";a:3:{s:11:\"button_text\";i:8;s:15:\"step_next_label\";i:10;s:19:\"step_previous_label\";i:10;}s:13:\"section_email\";a:5:{s:8:\"email_to\";i:10;s:13:\"email_subject\";i:10;s:10:\"email_from\";i:10;s:13:\"form_metadata\";i:2;s:18:\"email_content_type\";i:1;}s:19:\"section_integration\";a:1:{s:14:\"submit_actions\";i:2;}s:15:\"section_webhook\";a:2:{s:22:\"webhooks_advanced_data\";i:2;s:8:\"webhooks\";i:1;}s:15:\"section_email_2\";a:2:{s:15:\"email_subject_2\";i:10;s:12:\"email_from_2\";i:10;}s:20:\"section_form_options\";a:5:{s:15:\"success_message\";i:10;s:13:\"error_message\";i:10;s:22:\"required_field_message\";i:10;s:15:\"invalid_message\";i:10;s:15:\"custom_messages\";i:1;}s:13:\"section_popup\";a:2:{s:12:\"popup_action\";i:1;s:21:\"popup_action_popup_id\";i:1;}}s:5:\"style\";a:4:{s:19:\"section_field_style\";a:6:{s:16:\"field_text_color\";i:10;s:27:\"field_typography_typography\";i:10;s:26:\"field_typography_font_size\";i:10;s:18:\"field_border_width\";i:2;s:19:\"field_border_radius\";i:10;s:28:\"field_typography_font_weight\";i:2;}s:20:\"section_button_style\";a:6:{s:28:\"button_typography_typography\";i:10;s:27:\"button_typography_font_size\";i:10;s:29:\"button_typography_font_weight\";i:2;s:23:\"button_background_color\";i:10;s:29:\"button_background_hover_color\";i:2;s:19:\"button_text_padding\";i:10;}s:18:\"section_form_style\";a:2:{s:11:\"label_color\";i:1;s:10:\"html_color\";i:1;}s:22:\"section_messages_style\";a:3:{s:21:\"success_message_color\";i:1;s:19:\"error_message_color\";i:1;s:20:\"inline_message_color\";i:1;}}}}s:8:\"icon-box\";a:2:{s:5:\"count\";i:8;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:12:\"section_icon\";a:4:{s:13:\"selected_icon\";i:8;s:10:\"title_text\";i:8;s:16:\"description_text\";i:8;s:8:\"position\";i:8;}}s:5:\"style\";a:2:{s:18:\"section_style_icon\";a:1:{s:13:\"primary_color\";i:8;}s:21:\"section_style_content\";a:6:{s:10:\"text_align\";i:8;s:17:\"text_align_mobile\";i:8;s:11:\"title_color\";i:8;s:27:\"title_typography_typography\";i:8;s:26:\"title_typography_font_size\";i:8;s:28:\"title_typography_font_weight\";i:8;}}}}s:9:\"shortcode\";a:2:{s:5:\"count\";i:2;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:17:\"section_shortcode\";a:1:{s:9:\"shortcode\";i:2;}}s:8:\"advanced\";a:1:{s:14:\"_section_style\";a:2:{s:14:\"_margin_mobile\";i:2;s:15:\"_padding_mobile\";i:2;}}}}s:13:\"ee-google-map\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:3:{s:7:\"content\";a:4:{s:12:\"section_pins\";a:1:{s:4:\"pins\";i:1;}s:18:\"section_navigation\";a:3:{s:8:\"all_text\";i:1;s:10:\"navigation\";i:1;s:18:\"navigation_hide_on\";i:1;}s:11:\"section_map\";a:3:{s:8:\"map_type\";i:1;s:15:\"clickable_icons\";i:1;s:18:\"streetview_control\";i:1;}s:13:\"section_route\";a:1:{s:13:\"route_markers\";i:1;}}s:5:\"style\";a:3:{s:18:\"section_style_pins\";a:2:{s:8:\"pin_size\";i:1;s:21:\"pin_position_vertical\";i:1;}s:17:\"section_style_map\";a:2:{s:14:\"map_style_type\";i:1;s:14:\"map_style_json\";i:1;}s:24:\"section_style_navigation\";a:10:{s:19:\"navigation_position\";i:1;s:36:\"navigation_links_separator_thickness\";i:1;s:27:\"navigation_links_text_align\";i:1;s:22:\"navigation_links_color\";i:1;s:32:\"navigation_links_separator_color\";i:1;s:27:\"navigation_links_background\";i:1;s:28:\"navigation_links_color_hover\";i:1;s:38:\"navigation_links_separator_color_hover\";i:1;s:33:\"navigation_links_background_hover\";i:1;s:35:\"navigation_links_background_current\";i:1;}}s:8:\"advanced\";a:2:{s:14:\"_section_style\";a:2:{s:7:\"_margin\";i:1;s:8:\"_padding\";i:1;}s:18:\"section_custom_css\";a:1:{s:10:\"custom_css\";i:1;}}}}s:4:\"icon\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:12:\"section_icon\";a:1:{s:13:\"selected_icon\";i:1;}}}}s:14:\"image-carousel\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:22:\"section_image_carousel\";a:7:{s:8:\"carousel\";i:1;s:14:\"thumbnail_size\";i:1;s:14:\"slides_to_show\";i:1;s:21:\"slides_to_show_mobile\";i:1;s:10:\"navigation\";i:1;s:21:\"slides_to_show_tablet\";i:1;s:16:\"slides_to_scroll\";i:1;}}s:5:\"style\";a:2:{s:24:\"section_style_navigation\";a:2:{s:15:\"arrows_position\";i:1;s:12:\"arrows_color\";i:1;}s:19:\"section_style_image\";a:4:{s:29:\"gallery_vertical_align_mobile\";i:1;s:13:\"image_spacing\";i:1;s:20:\"image_spacing_custom\";i:1;s:22:\"gallery_vertical_align\";i:1;}}}}s:6:\"toggle\";a:2:{s:5:\"count\";i:6;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:14:\"section_toggle\";a:3:{s:4:\"tabs\";i:6;s:13:\"selected_icon\";i:6;s:20:\"selected_active_icon\";i:6;}}s:5:\"style\";a:4:{s:20:\"section_toggle_style\";a:5:{s:12:\"border_color\";i:6;s:13:\"space_between\";i:6;s:12:\"border_width\";i:6;s:26:\"box_shadow_box_shadow_type\";i:6;s:21:\"box_shadow_box_shadow\";i:6;}s:26:\"section_toggle_style_title\";a:4:{s:11:\"title_color\";i:6;s:16:\"tab_active_color\";i:6;s:27:\"title_typography_typography\";i:6;s:26:\"title_typography_font_size\";i:6;}s:25:\"section_toggle_style_icon\";a:4:{s:10:\"icon_align\";i:6;s:10:\"icon_color\";i:6;s:10:\"icon_space\";i:6;s:17:\"icon_active_color\";i:6;}s:28:\"section_toggle_style_content\";a:5:{s:13:\"content_color\";i:6;s:29:\"content_typography_typography\";i:6;s:28:\"content_typography_font_size\";i:6;s:24:\"content_background_color\";i:6;s:15:\"content_padding\";i:6;}}}}s:9:\"icon-list\";a:2:{s:5:\"count\";i:2;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:12:\"section_icon\";a:1:{s:9:\"icon_list\";i:2;}}s:5:\"style\";a:3:{s:17:\"section_icon_list\";a:2:{s:13:\"space_between\";i:2;s:10:\"icon_align\";i:2;}s:18:\"section_icon_style\";a:3:{s:10:\"icon_color\";i:2;s:16:\"icon_color_hover\";i:2;s:9:\"icon_size\";i:2;}s:18:\"section_text_style\";a:4:{s:10:\"text_color\";i:2;s:16:\"text_color_hover\";i:2;s:26:\"icon_typography_typography\";i:2;s:25:\"icon_typography_font_size\";i:2;}}}}}s:6:\"single\";a:9:{s:7:\"heading\";a:2:{s:5:\"count\";i:21;s:8:\"controls\";a:4:{s:7:\"content\";a:1:{s:13:\"section_title\";a:5:{s:5:\"title\";i:21;s:11:\"header_size\";i:14;s:4:\"link\";i:1;s:12:\"align_mobile\";i:6;s:5:\"align\";i:3;}}s:5:\"style\";a:1:{s:19:\"section_title_style\";a:6:{s:11:\"title_color\";i:21;s:21:\"typography_typography\";i:21;s:22:\"typography_font_weight\";i:20;s:20:\"typography_font_size\";i:6;s:27:\"typography_font_size_mobile\";i:6;s:27:\"typography_font_size_tablet\";i:3;}}s:8:\"advanced\";a:2:{s:14:\"_section_style\";a:3:{s:14:\"_margin_tablet\";i:1;s:15:\"_padding_tablet\";i:2;s:7:\"_margin\";i:3;}s:17:\"_section_position\";a:1:{s:14:\"_element_width\";i:15;}}s:7:\"general\";a:1:{s:11:\"__dynamic__\";a:1:{s:5:\"count\";i:8;}}}}s:6:\"column\";a:2:{s:5:\"count\";i:20;s:8:\"controls\";a:2:{s:6:\"layout\";a:1:{s:6:\"layout\";a:8:{s:12:\"_inline_size\";i:19;s:5:\"align\";i:7;s:12:\"align_mobile\";i:1;s:21:\"space_between_widgets\";i:2;s:28:\"space_between_widgets_tablet\";i:2;s:19:\"_inline_size_tablet\";i:1;s:19:\"_inline_size_mobile\";i:3;s:28:\"space_between_widgets_mobile\";i:4;}}s:8:\"advanced\";a:1:{s:16:\"section_advanced\";a:4:{s:7:\"padding\";i:3;s:14:\"padding_tablet\";i:3;s:13:\"margin_mobile\";i:2;s:14:\"padding_mobile\";i:3;}}}}s:7:\"section\";a:2:{s:5:\"count\";i:15;s:8:\"controls\";a:3:{s:6:\"layout\";a:2:{s:14:\"section_layout\";a:6:{s:6:\"height\";i:2;s:8:\"overflow\";i:2;s:13:\"content_width\";i:1;s:20:\"custom_height_tablet\";i:1;s:13:\"custom_height\";i:1;s:15:\"column_position\";i:1;}s:17:\"section_structure\";a:1:{s:9:\"structure\";i:4;}}s:5:\"style\";a:1:{s:18:\"section_background\";a:13:{s:21:\"background_background\";i:2;s:16:\"background_image\";i:2;s:17:\"background_repeat\";i:2;s:15:\"background_size\";i:2;s:23:\"background_image_mobile\";i:2;s:19:\"background_position\";i:2;s:26:\"background_position_mobile\";i:2;s:24:\"background_repeat_mobile\";i:2;s:22:\"background_size_mobile\";i:2;s:23:\"background_image_tablet\";i:1;s:26:\"background_position_tablet\";i:1;s:24:\"background_repeat_tablet\";i:1;s:22:\"background_size_tablet\";i:1;}}s:8:\"advanced\";a:2:{s:19:\"_section_responsive\";a:3:{s:11:\"hide_mobile\";i:1;s:12:\"hide_desktop\";i:1;s:11:\"hide_tablet\";i:1;}s:16:\"section_advanced\";a:4:{s:7:\"padding\";i:2;s:14:\"padding_mobile\";i:3;s:6:\"margin\";i:1;s:13:\"margin_mobile\";i:1;}}}}s:16:\"theme-post-title\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:4:{s:7:\"general\";a:1:{s:11:\"__dynamic__\";a:1:{s:5:\"count\";i:1;}}s:7:\"content\";a:1:{s:13:\"section_title\";a:3:{s:5:\"title\";i:1;s:12:\"align_mobile\";i:1;s:5:\"align\";i:1;}}s:5:\"style\";a:1:{s:19:\"section_title_style\";a:1:{s:11:\"title_color\";i:1;}}s:8:\"advanced\";a:2:{s:14:\"_section_style\";a:1:{s:8:\"_padding\";i:1;}s:19:\"_section_background\";a:2:{s:22:\"_background_background\";i:1;s:17:\"_background_color\";i:1;}}}}s:7:\"divider\";a:2:{s:5:\"count\";i:7;s:8:\"controls\";a:1:{s:5:\"style\";a:1:{s:21:\"section_divider_style\";a:1:{s:3:\"gap\";i:7;}}}}s:4:\"icon\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:4:{s:7:\"general\";a:1:{s:11:\"__dynamic__\";a:1:{s:5:\"count\";i:1;}}s:7:\"content\";a:1:{s:12:\"section_icon\";a:2:{s:13:\"selected_icon\";i:1;s:4:\"link\";i:1;}}s:5:\"style\";a:1:{s:18:\"section_style_icon\";a:2:{s:4:\"size\";i:1;s:13:\"primary_color\";i:1;}}s:8:\"advanced\";a:1:{s:17:\"_section_position\";a:3:{s:14:\"_element_width\";i:1;s:21:\"_element_custom_width\";i:1;s:21:\"_element_width_mobile\";i:1;}}}}s:11:\"google_maps\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:2:{s:7:\"general\";a:1:{s:11:\"__dynamic__\";a:1:{s:5:\"count\";i:1;}}s:7:\"content\";a:1:{s:11:\"section_map\";a:3:{s:7:\"address\";i:1;s:4:\"zoom\";i:1;s:6:\"height\";i:1;}}}}s:6:\"button\";a:2:{s:5:\"count\";i:6;s:8:\"controls\";a:4:{s:7:\"general\";a:1:{s:11:\"__dynamic__\";a:1:{s:5:\"count\";i:6;}}s:7:\"content\";a:1:{s:14:\"section_button\";a:4:{s:4:\"text\";i:6;s:5:\"align\";i:6;s:4:\"link\";i:6;s:12:\"align_mobile\";i:3;}}s:5:\"style\";a:1:{s:13:\"section_style\";a:10:{s:21:\"typography_typography\";i:6;s:20:\"typography_font_size\";i:6;s:17:\"button_text_color\";i:6;s:16:\"background_color\";i:6;s:29:\"button_background_hover_color\";i:6;s:13:\"border_radius\";i:6;s:27:\"typography_font_size_tablet\";i:3;s:22:\"typography_line_height\";i:1;s:12:\"text_padding\";i:1;s:27:\"typography_font_size_mobile\";i:3;}}s:8:\"advanced\";a:1:{s:14:\"_section_style\";a:3:{s:14:\"_margin_tablet\";i:3;s:7:\"_margin\";i:3;s:8:\"_padding\";i:2;}}}}s:18:\"theme-post-content\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:0:{}}}s:5:\"popup\";a:6:{s:15:\"theme-site-logo\";a:2:{s:5:\"count\";i:3;s:8:\"controls\";a:2:{s:7:\"general\";a:1:{s:11:\"__dynamic__\";a:1:{s:5:\"count\";i:6;}}s:7:\"content\";a:1:{s:13:\"section_image\";a:5:{s:12:\"align_tablet\";i:3;s:12:\"align_mobile\";i:3;s:7:\"link_to\";i:3;s:5:\"image\";i:3;s:4:\"link\";i:3;}}}}s:11:\"text-editor\";a:2:{s:5:\"count\";i:3;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:14:\"section_editor\";a:1:{s:6:\"editor\";i:3;}}s:5:\"style\";a:1:{s:13:\"section_style\";a:3:{s:10:\"text_color\";i:3;s:21:\"typography_typography\";i:3;s:20:\"typography_font_size\";i:3;}}}}s:4:\"form\";a:2:{s:5:\"count\";i:3;s:8:\"controls\";a:2:{s:7:\"content\";a:7:{s:19:\"section_form_fields\";a:2:{s:9:\"form_name\";i:3;s:11:\"form_fields\";i:3;}s:15:\"section_buttons\";a:2:{s:15:\"step_next_label\";i:3;s:19:\"step_previous_label\";i:3;}s:19:\"section_integration\";a:0:{}s:15:\"section_webhook\";a:2:{s:8:\"webhooks\";i:3;s:22:\"webhooks_advanced_data\";i:3;}s:20:\"section_form_options\";a:5:{s:15:\"success_message\";i:3;s:13:\"error_message\";i:3;s:22:\"required_field_message\";i:3;s:15:\"invalid_message\";i:3;s:15:\"custom_messages\";i:3;}s:13:\"section_email\";a:3:{s:8:\"email_to\";i:3;s:13:\"email_subject\";i:3;s:10:\"email_from\";i:3;}s:15:\"section_email_2\";a:2:{s:15:\"email_subject_2\";i:3;s:12:\"email_from_2\";i:3;}}s:5:\"style\";a:4:{s:18:\"section_form_style\";a:4:{s:13:\"label_spacing\";i:3;s:11:\"label_color\";i:3;s:27:\"label_typography_typography\";i:3;s:26:\"label_typography_font_size\";i:3;}s:19:\"section_field_style\";a:6:{s:16:\"field_text_color\";i:3;s:27:\"field_typography_typography\";i:3;s:26:\"field_typography_font_size\";i:3;s:18:\"field_border_color\";i:3;s:18:\"field_border_width\";i:3;s:19:\"field_border_radius\";i:3;}s:20:\"section_button_style\";a:5:{s:28:\"button_typography_typography\";i:3;s:27:\"button_typography_font_size\";i:3;s:29:\"button_typography_font_weight\";i:3;s:23:\"button_background_color\";i:3;s:19:\"button_text_padding\";i:3;}s:22:\"section_messages_style\";a:5:{s:29:\"message_typography_typography\";i:3;s:28:\"message_typography_font_size\";i:3;s:21:\"success_message_color\";i:3;s:19:\"error_message_color\";i:3;s:20:\"inline_message_color\";i:3;}}}}s:6:\"column\";a:2:{s:5:\"count\";i:4;s:8:\"controls\";a:1:{s:6:\"layout\";a:1:{s:6:\"layout\";a:1:{s:12:\"_inline_size\";i:4;}}}}s:7:\"section\";a:2:{s:5:\"count\";i:4;s:8:\"controls\";a:1:{s:6:\"layout\";a:1:{s:14:\"section_layout\";a:1:{s:13:\"content_width\";i:3;}}}}s:7:\"heading\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:13:\"section_title\";a:2:{s:5:\"title\";i:1;s:5:\"align\";i:1;}}s:5:\"style\";a:1:{s:19:\"section_title_style\";a:5:{s:21:\"typography_typography\";i:1;s:22:\"typography_font_family\";i:1;s:27:\"typography_font_size_tablet\";i:1;s:27:\"typography_font_size_mobile\";i:1;s:22:\"typography_font_weight\";i:1;}}}}}s:6:\"header\";a:6:{s:15:\"theme-site-logo\";a:2:{s:5:\"count\";i:2;s:8:\"controls\";a:3:{s:7:\"general\";a:1:{s:11:\"__dynamic__\";a:1:{s:5:\"count\";i:4;}}s:7:\"content\";a:1:{s:13:\"section_image\";a:3:{s:5:\"align\";i:2;s:5:\"image\";i:2;s:4:\"link\";i:2;}}s:5:\"style\";a:1:{s:19:\"section_style_image\";a:4:{s:5:\"width\";i:2;s:5:\"space\";i:2;s:12:\"width_mobile\";i:1;s:12:\"space_mobile\";i:1;}}}}s:6:\"column\";a:2:{s:5:\"count\";i:10;s:8:\"controls\";a:2:{s:6:\"layout\";a:1:{s:6:\"layout\";a:3:{s:12:\"_inline_size\";i:10;s:21:\"space_between_widgets\";i:1;s:19:\"_inline_size_mobile\";i:4;}}s:8:\"advanced\";a:1:{s:16:\"section_advanced\";a:4:{s:6:\"margin\";i:5;s:7:\"padding\";i:5;s:13:\"margin_mobile\";i:2;s:14:\"padding_mobile\";i:4;}}}}s:7:\"section\";a:2:{s:5:\"count\";i:7;s:8:\"controls\";a:3:{s:8:\"advanced\";a:2:{s:16:\"section_advanced\";a:5:{s:6:\"margin\";i:2;s:7:\"padding\";i:4;s:14:\"padding_tablet\";i:1;s:13:\"margin_mobile\";i:3;s:14:\"padding_mobile\";i:3;}s:19:\"_section_responsive\";a:3:{s:11:\"hide_mobile\";i:1;s:12:\"hide_desktop\";i:1;s:11:\"hide_tablet\";i:1;}}s:6:\"layout\";a:2:{s:14:\"section_layout\";a:2:{s:16:\"content_position\";i:4;s:8:\"html_tag\";i:2;}s:17:\"section_structure\";a:1:{s:9:\"structure\";i:3;}}s:5:\"style\";a:2:{s:14:\"section_border\";a:4:{s:13:\"border_border\";i:2;s:12:\"border_width\";i:2;s:12:\"border_color\";i:2;s:19:\"border_width_mobile\";i:1;}s:18:\"section_background\";a:2:{s:21:\"background_background\";i:1;s:16:\"background_color\";i:1;}}}}s:8:\"nav-menu\";a:2:{s:5:\"count\";i:2;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:14:\"section_layout\";a:6:{s:7:\"pointer\";i:2;s:9:\"indicator\";i:2;s:8:\"dropdown\";i:2;s:10:\"full_width\";i:2;s:10:\"text_align\";i:2;s:12:\"toggle_align\";i:1;}}s:5:\"style\";a:3:{s:23:\"section_style_main-menu\";a:7:{s:26:\"menu_typography_typography\";i:2;s:27:\"menu_typography_font_family\";i:2;s:25:\"menu_typography_font_size\";i:2;s:27:\"menu_typography_font_weight\";i:2;s:15:\"color_menu_item\";i:2;s:32:\"menu_typography_font_size_tablet\";i:1;s:35:\"padding_horizontal_menu_item_tablet\";i:1;}s:22:\"section_style_dropdown\";a:9:{s:19:\"color_dropdown_item\";i:2;s:30:\"background_color_dropdown_item\";i:2;s:30:\"dropdown_typography_typography\";i:1;s:29:\"dropdown_typography_font_size\";i:1;s:36:\"background_color_dropdown_item_hover\";i:1;s:37:\"background_color_dropdown_item_active\";i:1;s:35:\"dropdown_box_shadow_box_shadow_type\";i:1;s:37:\"padding_vertical_dropdown_item_mobile\";i:1;s:28:\"dropdown_top_distance_mobile\";i:1;}s:12:\"style_toggle\";a:5:{s:12:\"toggle_color\";i:1;s:23:\"toggle_background_color\";i:1;s:11:\"toggle_size\";i:1;s:18:\"toggle_color_hover\";i:1;s:20:\"toggle_border_radius\";i:1;}}s:8:\"advanced\";a:1:{s:18:\"section_custom_css\";a:1:{s:10:\"custom_css\";i:2;}}}}s:12:\"social-icons\";a:2:{s:5:\"count\";i:2;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:19:\"section_social_icon\";a:3:{s:16:\"social_icon_list\";i:2;s:5:\"shape\";i:2;s:5:\"align\";i:2;}}s:5:\"style\";a:1:{s:20:\"section_social_style\";a:2:{s:9:\"icon_size\";i:2;s:16:\"icon_size_mobile\";i:1;}}}}s:6:\"button\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:14:\"section_button\";a:4:{s:4:\"text\";i:1;s:4:\"link\";i:1;s:12:\"align_mobile\";i:1;s:13:\"selected_icon\";i:1;}}s:5:\"style\";a:1:{s:13:\"section_style\";a:7:{s:21:\"typography_typography\";i:1;s:27:\"typography_font_size_mobile\";i:1;s:22:\"typography_font_weight\";i:1;s:17:\"button_text_color\";i:1;s:16:\"background_color\";i:1;s:11:\"hover_color\";i:1;s:19:\"text_padding_mobile\";i:1;}}}}}s:4:\"page\";a:7:{s:7:\"heading\";a:2:{s:5:\"count\";i:2;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:13:\"section_title\";a:5:{s:5:\"title\";i:2;s:12:\"align_mobile\";i:1;s:12:\"align_tablet\";i:1;s:5:\"align\";i:2;s:11:\"header_size\";i:1;}}s:5:\"style\";a:1:{s:19:\"section_title_style\";a:5:{s:11:\"title_color\";i:2;s:21:\"typography_typography\";i:2;s:20:\"typography_font_size\";i:2;s:22:\"typography_font_weight\";i:1;s:27:\"typography_font_size_mobile\";i:1;}}}}s:5:\"image\";a:2:{s:5:\"count\";i:3;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:13:\"section_image\";a:5:{s:5:\"image\";i:3;s:10:\"image_size\";i:3;s:12:\"align_mobile\";i:2;s:5:\"align\";i:1;s:12:\"align_tablet\";i:1;}}s:5:\"style\";a:1:{s:19:\"section_style_image\";a:4:{s:5:\"width\";i:2;s:12:\"width_mobile\";i:3;s:5:\"space\";i:2;s:12:\"space_mobile\";i:3;}}s:8:\"advanced\";a:3:{s:14:\"_section_style\";a:2:{s:14:\"_margin_mobile\";i:2;s:15:\"_padding_mobile\";i:2;}s:17:\"_section_position\";a:10:{s:14:\"_element_width\";i:1;s:9:\"_position\";i:1;s:21:\"_element_width_tablet\";i:1;s:21:\"_element_width_mobile\";i:1;s:28:\"_element_custom_width_tablet\";i:1;s:28:\"_element_custom_width_mobile\";i:1;s:9:\"_offset_x\";i:1;s:16:\"_offset_x_mobile\";i:1;s:9:\"_offset_y\";i:1;s:16:\"_offset_y_mobile\";i:1;}s:19:\"_section_responsive\";a:1:{s:11:\"hide_mobile\";i:1;}}}}s:6:\"column\";a:2:{s:5:\"count\";i:7;s:8:\"controls\";a:3:{s:6:\"layout\";a:1:{s:6:\"layout\";a:4:{s:12:\"_inline_size\";i:7;s:19:\"_inline_size_mobile\";i:5;s:19:\"_inline_size_tablet\";i:4;s:21:\"space_between_widgets\";i:3;}}s:8:\"advanced\";a:1:{s:16:\"section_advanced\";a:4:{s:13:\"margin_mobile\";i:2;s:14:\"padding_mobile\";i:3;s:6:\"margin\";i:1;s:7:\"padding\";i:1;}}s:5:\"style\";a:1:{s:13:\"section_style\";a:1:{s:16:\"background_color\";i:2;}}}}s:7:\"section\";a:2:{s:5:\"count\";i:4;s:8:\"controls\";a:3:{s:6:\"layout\";a:2:{s:17:\"section_structure\";a:1:{s:9:\"structure\";i:3;}s:14:\"section_layout\";a:4:{s:6:\"layout\";i:1;s:6:\"height\";i:1;s:13:\"custom_height\";i:1;s:20:\"custom_height_mobile\";i:1;}}s:5:\"style\";a:2:{s:18:\"section_background\";a:8:{s:21:\"background_background\";i:3;s:16:\"background_color\";i:2;s:16:\"background_image\";i:1;s:19:\"background_position\";i:1;s:26:\"background_position_tablet\";i:1;s:26:\"background_position_mobile\";i:1;s:17:\"background_repeat\";i:1;s:15:\"background_size\";i:1;}s:26:\"section_background_overlay\";a:4:{s:24:\"background_overlay_color\";i:1;s:26:\"background_overlay_opacity\";i:1;s:29:\"background_overlay_background\";i:2;s:24:\"background_overlay_image\";i:1;}}s:8:\"advanced\";a:1:{s:16:\"section_advanced\";a:1:{s:7:\"padding\";i:2;}}}}s:11:\"text-editor\";a:2:{s:5:\"count\";i:2;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:14:\"section_editor\";a:1:{s:6:\"editor\";i:2;}}s:5:\"style\";a:1:{s:13:\"section_style\";a:7:{s:5:\"align\";i:2;s:10:\"text_color\";i:2;s:21:\"typography_typography\";i:2;s:20:\"typography_font_size\";i:2;s:22:\"typography_font_weight\";i:1;s:12:\"align_mobile\";i:1;s:27:\"typography_font_size_mobile\";i:1;}}}}s:4:\"form\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:2:{s:7:\"content\";a:5:{s:19:\"section_form_fields\";a:4:{s:9:\"form_name\";i:1;s:11:\"form_fields\";i:1;s:10:\"input_size\";i:1;s:11:\"show_labels\";i:1;}s:15:\"section_buttons\";a:3:{s:15:\"step_next_label\";i:1;s:19:\"step_previous_label\";i:1;s:11:\"button_text\";i:1;}s:13:\"section_email\";a:3:{s:8:\"email_to\";i:1;s:13:\"email_subject\";i:1;s:10:\"email_from\";i:1;}s:15:\"section_email_2\";a:2:{s:15:\"email_subject_2\";i:1;s:12:\"email_from_2\";i:1;}s:20:\"section_form_options\";a:4:{s:15:\"success_message\";i:1;s:13:\"error_message\";i:1;s:22:\"required_field_message\";i:1;s:15:\"invalid_message\";i:1;}}s:5:\"style\";a:2:{s:19:\"section_field_style\";a:4:{s:16:\"field_text_color\";i:1;s:27:\"field_typography_typography\";i:1;s:26:\"field_typography_font_size\";i:1;s:19:\"field_border_radius\";i:1;}s:20:\"section_button_style\";a:4:{s:28:\"button_typography_typography\";i:1;s:27:\"button_typography_font_size\";i:1;s:23:\"button_background_color\";i:1;s:19:\"button_text_padding\";i:1;}}}}s:8:\"icon-box\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:12:\"section_icon\";a:4:{s:13:\"selected_icon\";i:1;s:10:\"title_text\";i:1;s:16:\"description_text\";i:1;s:8:\"position\";i:1;}}s:5:\"style\";a:2:{s:18:\"section_style_icon\";a:1:{s:13:\"primary_color\";i:1;}s:21:\"section_style_content\";a:6:{s:10:\"text_align\";i:1;s:17:\"text_align_mobile\";i:1;s:11:\"title_color\";i:1;s:27:\"title_typography_typography\";i:1;s:26:\"title_typography_font_size\";i:1;s:28:\"title_typography_font_weight\";i:1;}}}}}s:6:\"footer\";a:6:{s:7:\"heading\";a:2:{s:5:\"count\";i:4;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:13:\"section_title\";a:4:{s:5:\"title\";i:4;s:4:\"link\";i:1;s:11:\"header_size\";i:1;s:5:\"align\";i:1;}}s:5:\"style\";a:1:{s:19:\"section_title_style\";a:4:{s:11:\"title_color\";i:4;s:21:\"typography_typography\";i:4;s:20:\"typography_font_size\";i:4;s:22:\"typography_font_weight\";i:4;}}}}s:7:\"divider\";a:2:{s:5:\"count\";i:3;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:15:\"section_divider\";a:2:{s:5:\"width\";i:3;s:5:\"align\";i:3;}}s:5:\"style\";a:1:{s:21:\"section_divider_style\";a:3:{s:5:\"color\";i:3;s:6:\"weight\";i:3;s:3:\"gap\";i:3;}}}}s:9:\"icon-list\";a:2:{s:5:\"count\";i:2;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:12:\"section_icon\";a:1:{s:9:\"icon_list\";i:2;}}s:5:\"style\";a:3:{s:17:\"section_icon_list\";a:2:{s:13:\"space_between\";i:2;s:10:\"icon_align\";i:2;}s:18:\"section_icon_style\";a:2:{s:10:\"icon_color\";i:2;s:9:\"icon_size\";i:2;}s:18:\"section_text_style\";a:3:{s:10:\"text_color\";i:2;s:26:\"icon_typography_typography\";i:2;s:25:\"icon_typography_font_size\";i:2;}}}}s:6:\"column\";a:2:{s:5:\"count\";i:5;s:8:\"controls\";a:2:{s:6:\"layout\";a:1:{s:6:\"layout\";a:3:{s:12:\"_inline_size\";i:5;s:19:\"_inline_size_mobile\";i:3;s:21:\"space_between_widgets\";i:4;}}s:8:\"advanced\";a:1:{s:16:\"section_advanced\";a:2:{s:6:\"margin\";i:1;s:7:\"padding\";i:1;}}}}s:11:\"text-editor\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:14:\"section_editor\";a:1:{s:6:\"editor\";i:1;}}s:5:\"style\";a:1:{s:13:\"section_style\";a:3:{s:10:\"text_color\";i:1;s:21:\"typography_typography\";i:1;s:20:\"typography_font_size\";i:1;}}}}s:7:\"section\";a:2:{s:5:\"count\";i:3;s:8:\"controls\";a:3:{s:6:\"layout\";a:2:{s:17:\"section_structure\";a:1:{s:9:\"structure\";i:1;}s:14:\"section_layout\";a:2:{s:6:\"layout\";i:1;s:8:\"html_tag\";i:1;}}s:5:\"style\";a:1:{s:18:\"section_background\";a:5:{s:21:\"background_background\";i:3;s:16:\"background_color\";i:2;s:16:\"background_image\";i:1;s:17:\"background_repeat\";i:1;s:15:\"background_size\";i:1;}}s:8:\"advanced\";a:1:{s:16:\"section_advanced\";a:5:{s:6:\"margin\";i:3;s:7:\"padding\";i:3;s:14:\"padding_tablet\";i:1;s:14:\"padding_mobile\";i:3;s:13:\"margin_mobile\";i:1;}}}}}}", "no");
INSERT INTO `puy_options` VALUES("227", "elementor_pro_theme_builder_conditions", "a:3:{s:6:\"single\";a:2:{i:325;a:1:{i:0;s:25:\"include/singular/branches\";}i:94;a:1:{i:0;s:21:\"include/singular/page\";}}s:6:\"footer\";a:1:{i:47;a:2:{i:0;s:15:\"include/general\";i:1;s:25:\"exclude/singular/page/297\";}}s:6:\"header\";a:1:{i:27;a:1:{i:0;s:15:\"include/general\";}}}", "yes");
INSERT INTO `puy_options` VALUES("231", "elementor_library_category_children", "a:0:{}", "yes");
INSERT INTO `puy_options` VALUES("232", "_elementor_scheme_last_updated", "1593706476", "yes");
INSERT INTO `puy_options` VALUES("323", "elementor_extras_do_activation_redirect", "1", "yes");
INSERT INTO `puy_options` VALUES("324", "elementor_extras_widgets", "", "yes");
INSERT INTO `puy_options` VALUES("325", "elementor_extras_extensions", "", "yes");
INSERT INTO `puy_options` VALUES("326", "elementor_extras_apis", "a:4:{s:19:\"google_maps_api_key\";s:39:\"AIzaSyBTUCJITma5_yUiGzLTA8yzS_i9lcE7C_I\";s:19:\"snazzy_maps_api_key\";s:0:\"\";s:20:\"snazzy_maps_endpoint\";s:7:\"explore\";s:22:\"instagram_access_token\";s:0:\"\";}", "yes");
INSERT INTO `puy_options` VALUES("327", "elementor_extras_advanced", "", "yes");
INSERT INTO `puy_options` VALUES("510", "acf_pro_license", "YToyOntzOjM6ImtleSI7czo3NjoiYjNKa1pYSmZhV1E5TVRBeE1ETTBmSFI1Y0dVOVpHVjJaV3h2Y0dWeWZHUmhkR1U5TWpBeE55MHdNeTB3TWlBeU1EbzFORG93TWc9PSI7czozOiJ1cmwiO3M6MjQ6Imh0dHBzOi8vd3d3LmMtc2Vydi5jby5pbCI7fQ==", "yes");
INSERT INTO `puy_options` VALUES("511", "acf_version", "5.8.12", "yes");
INSERT INTO `puy_options` VALUES("527", "elementor_clear_cache", "", "yes");
INSERT INTO `puy_options` VALUES("528", "elementor_reset_api_data", "", "yes");
INSERT INTO `puy_options` VALUES("530", "elementor_enable_inspector", "", "yes");
INSERT INTO `puy_options` VALUES("531", "elementor_replace_url", "", "yes");
INSERT INTO `puy_options` VALUES("532", "elementor_rollback", "", "yes");
INSERT INTO `puy_options` VALUES("533", "elementor_rollback_pro_separator", "", "yes");
INSERT INTO `puy_options` VALUES("534", "elementor_rollback_pro", "", "yes");
INSERT INTO `puy_options` VALUES("535", "elementor_beta", "no", "yes");
INSERT INTO `puy_options` VALUES("536", "elementor_maintenance_mode_mode", "", "yes");
INSERT INTO `puy_options` VALUES("537", "elementor_maintenance_mode_exclude_mode", "logged_in", "yes");
INSERT INTO `puy_options` VALUES("538", "elementor_maintenance_mode_exclude_roles", "a:0:{}", "yes");
INSERT INTO `puy_options` VALUES("539", "elementor_maintenance_mode_template_id", "", "yes");
INSERT INTO `puy_options` VALUES("633", "edd_sl_5eb31cae0d7a62b4e5f10a6f9d170a4e", "a:2:{s:7:\"timeout\";i:1599244546;s:5:\"value\";s:192557:\"{\"new_version\":\"2.2.37\",\"stable_version\":\"2.2.37\",\"name\":\"Elementor Extras\",\"slug\":\"elementor-extras\",\"url\":\"https:\\/\\/shop.namogo.com\\/product\\/extras-elementor\\/?changelog=1\",\"last_updated\":\"11 hours ago\",\"homepage\":\"https:\\/\\/shop.namogo.com\\/product\\/elementor-extras\",\"package\":\"https:\\/\\/shop.namogo.com\\/edd-sl\\/package_download\\/MTU5OTUwMzc0NDo5NDJmN2M1NDk1YTYxZjlmMzM0OWNjMGRhZWZlYzg5MjoxOToyOWI0NDYzYzZlN2RiYTZlZTlhN2QyYTVlZjFlY2U1ODpodHRwc0AvL3d3dy5jLXNlcnYuY28uaWw6MA==\",\"download_link\":\"https:\\/\\/shop.namogo.com\\/edd-sl\\/package_download\\/MTU5OTUwMzc0NDo5NDJmN2M1NDk1YTYxZjlmMzM0OWNjMGRhZWZlYzg5MjoxOToyOWI0NDYzYzZlN2RiYTZlZTlhN2QyYTVlZjFlY2U1ODpodHRwc0AvL3d3dy5jLXNlcnYuY28uaWw6MA==\",\"sections\":{\"description\":\"<p>Extras is one of the first premium Wordpress plugin for Elementor. It extends its capability with many unique widgets and extensions that make Elementor even more powerful.<\\/p>\\n<h4> Copyright and licensing <\\/h4>\\n<p>Copyright (C) 2016-2019 Elementor Ltd.<\\/p>\\n<p>This program is free software: you can redistribute it and\\/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.<\\/p>\\n<p>This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.<\\/p>\\n<p>You should have received a copy of the GNU General Public License along with this program. If not, see <a href=\\\"https:\\/\\/www.gnu.org\\/licenses\\/\\\">https:\\/\\/www.gnu.org\\/licenses\\/<\\/a>.<\\/p>\\n<h4> Third Party Code <\\/h4>\\n<p>Extras for Elementor incorporates code from:<\\/p>\\n<ul>\\n<li><strong>jquery-circle-progress<\\/strong> v1.2.2, Copyright Rostyslav Bryzgunov Licenses: MIT Source: link <a href=\\\"http:\\/\\/kottenator.github.io\\/jquery-circle-progress\\/\\\">http:\\/\\/kottenator.github.io\\/jquery-circle-progress\\/<\\/a><\\/li>\\n<li><strong>jQuery appear plugin<\\/strong> v0.3.6, Copyright 2012 Andrey Sidorov Licenses: MIT Source: link <a href=\\\"https:\\/\\/github.com\\/morr\\/jquery.appear\\/\\\">https:\\/\\/github.com\\/morr\\/jquery.appear\\/<\\/a><\\/li>\\n<li><strong>LongShadow jQuery Plugin<\\/strong> v1.1.0, Copyright 2013 - 2016 Dang Van Thanh Licenses: MIT Source: link git:\\/\\/github.com\\/dangvanthanh\\/jquery.longShadow.git<\\/li>\\n<li><strong>HC-Sticky<\\/strong> v2.2.3, Copyright Some Web Media License: MIT Source: link <a href=\\\"https:\\/\\/github.com\\/somewebmedia\\/hc-sticky\\\">https:\\/\\/github.com\\/somewebmedia\\/hc-sticky<\\/a><\\/li>\\n<li><strong>jQuery Mobile<\\/strong> v1.4.3, Copyright 2010, 2014 jQuery Foundation, Inc. Licenses: jquery.org\\/license<\\/li>\\n<li><strong>jquery-visible<\\/strong>, Copyright 2012, Digital Fusion, License: <a href=\\\"http:\\/\\/teamdf.com\\/jquery-plugins\\/license\\/\\\">http:\\/\\/teamdf.com\\/jquery-plugins\\/license\\/<\\/a> Source: <a href=\\\"http:\\/\\/teamdf.com\\/jquery-plugins\\/license\\/\\\">http:\\/\\/teamdf.com\\/jquery-plugins\\/license\\/<\\/a><\\/li>\\n<li><strong>Parallax Background<\\/strong> v1.2, by Eren Suleymanoglu Licenses: MIT Source: link <a href=\\\"https:\\/\\/github.com\\/erensuleymanoglu\\/parallax-background\\\">https:\\/\\/github.com\\/erensuleymanoglu\\/parallax-background<\\/a><\\/li>\\n<li><strong>TableSorter<\\/strong> v2.0.5b, Copyright 2007 Christian Bach Licenses: Dual licensed under the MIT and GPL licenses Source: link <a href=\\\"http:\\/\\/tablesorter.com\\\">http:\\/\\/tablesorter.com<\\/a><\\/li>\\n<li><strong>Isotope<\\/strong> PACKAGED v3.0.6, Copyright 2017 Metafizzy License: GPLv3 Source: link <a href=\\\"http:\\/\\/isotope.metafizzy.co\\\">http:\\/\\/isotope.metafizzy.co<\\/a><\\/li>\\n<li><strong>Infinite Scroll<\\/strong> PACKAGED v3.0.2, Copyright 2017 Metafizzy License: GPLv3 Source: link <a href=\\\"https:\\/\\/infinite-scroll.com\\\">https:\\/\\/infinite-scroll.com<\\/a><\\/li>\\n<li><strong>Packery layout mode<\\/strong> PACKAGED v2.0.0 Copyright 2017 Metafizzy License: GPLv3 Source: link <a href=\\\"http:\\/\\/isotope.metafizzy.co\\\">http:\\/\\/isotope.metafizzy.co<\\/a><\\/li>\\n<li><strong>javascript-detect-element-resize<\\/strong> v0.5.3 Copyright (c) 2013 Sebasti\\u00e1n D\\u00e9cima License: MIT Source: link <a href=\\\"https:\\/\\/github.com\\/sdecima\\/javascript-detect-element-resize\\\">https:\\/\\/github.com\\/sdecima\\/javascript-detect-element-resize<\\/a><\\/li>\\n<li><strong>tilt.js<\\/strong> 1.2.1, Copyright (c) 2017 Gijs Rog\\u00e9 License: MIT Source: link <a href=\\\"https:\\/\\/github.com\\/gijsroge\\/tilt.js\\\">https:\\/\\/github.com\\/gijsroge\\/tilt.js<\\/a><\\/li>\\n<li><strong>CLNDR<\\/strong> v1.4.7, Copyright Kyle Stetz (github.com\\/kylestetz) License: MIT Source: link <a href=\\\"https:\\/\\/github.com\\/kylestetz\\/CLNDR\\\">https:\\/\\/github.com\\/kylestetz\\/CLNDR<\\/a><\\/li>\\n<li><strong>GMAP3 Plugin for jQuery<\\/strong> v7.2 Copyright DEMONTE Jean-Baptiste License: GPL-3.0+ Source: link <a href=\\\"http:\\/\\/gmap3.net\\\">http:\\/\\/gmap3.net<\\/a><\\/li>\\n<li><strong>Moment.js<\\/strong> v2.22.2 License: MIT Source: link <a href=\\\"https:\\/\\/github.com\\/moment\\/moment\\/\\\">https:\\/\\/github.com\\/moment\\/moment\\/<\\/a><\\/li>\\n<li><strong>Slidebars<\\/strong> v2 Copyright Adam Charles Smith License: MIT <a href=\\\"http:\\/\\/www.adchsm.com\\/slidebars\\/license\\/\\\">http:\\/\\/www.adchsm.com\\/slidebars\\/license\\/<\\/a> Source: link <a href=\\\"http:\\/\\/www.adchsm.com\\/slidebars\\/\\\">http:\\/\\/www.adchsm.com\\/slidebars\\/<\\/a><\\/li>\\n<li><strong>Splittext.js<\\/strong> Copyright (c) 2008-2016, GreenSock<\\/li>\\n<li><strong>Magnific Popup<\\/strong> v1.1.0 License: MIT Copyright 2016 Dmitry Semenov Soruce: link <a href=\\\"http:\\/\\/dimsemenov.com\\/plugins\\/magnific-popup\\/\\\">http:\\/\\/dimsemenov.com\\/plugins\\/magnific-popup\\/<\\/a><\\/li>\\n<\\/ul>\\n<h4> Important Links <\\/h4>\\n<p><a href=\\\"https:\\/\\/shop.namogo.com\\/docs\\/elementor-extras\\/getting-started\\/#update-official\\\">Updating Extras<\\/a>\\n<a href=\\\"https:\\/\\/shop.namogo.com\\/topic\\/elementor-extras\\/\\\">Documentation<\\/a>\\n<a href=\\\"https:\\/\\/shop.namogo.com\\/account\\/\\\">Your Account<\\/a>\\n<a href=\\\"https:\\/\\/shop.namogo.com\\/account\\/support\\/\\\">Support<\\/a>\\n<a href=\\\"https:\\/\\/shop.namogo.com\\/docs\\/elementor-extras\\/frequently-asked-questions\\/\\\">FAQ<\\/a><\\/p>\",\"changelog\":\"<h4> 2.2.37 <\\/h4>\\n<ul>\\n<li>Added: Scroll Indicator \\u2014 Allow scroll offset option for all skins<\\/li>\\n<li>Fixed: Gallery \\u2014 Vertical spacing control not applying spacing when images are not linked<\\/li>\\n<li>Fixed: Posts \\u2014 Pagination bug with WP 5.5<\\/li>\\n<li>Tweak: Search Form \\u2014 Allow search without query<\\/li>\\n<\\/ul>\\n<h4> 2.2.36 <\\/h4>\\n<ul>\\n<li>Tweak: Revert support for Elementor Pro to 2.8.0<\\/li>\\n<\\/ul>\\n<h4> 2.2.35 <\\/h4>\\n<ul>\\n<li>Fixed: Compatibility with Elementor 3.0<\\/li>\\n<li>Fixed: Search Form \\u2014 CSS height align bug with expand skin<\\/li>\\n<li>Increased minimum required Elementor version to 3.0<\\/li>\\n<li>Increased minimum required Elementor Pro version to 3.0<\\/li>\\n<\\/ul>\\n<h4> 2.2.34 <\\/h4>\\n<ul>\\n<li>Fixed: Posts \\u2014 Temporary fix for posts pagination due to bug introduced in Wordpress 5.5<\\/li>\\n<li>Fixed: Posts \\u2014 Carousel RTL arrows misplacement<\\/li>\\n<li>Fixed: Display Conditions \\u2013 Day of week condition not including timezone<\\/li>\\n<li>Fixed: Display Conditions \\u2013 Wrong index for Sunday<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Panel header being printed even if no title or close enabled<\\/li>\\n<li>Fixed: Search Form \\u2014 Taxonomy term not excluded if taxonomy has only one term<\\/li>\\n<li>Fixed: Table \\u2014 Inline editing bugs<\\/li>\\n<\\/ul>\\n<h4> 2.2.33 <\\/h4>\\n<ul>\\n<li>Added: Display Conditions \\u2014 Support for ACF options page fields<\\/li>\\n<li>Fixed: Lightbox in post skin slides through all instances inside loop<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Edge case width calculation bug<\\/li>\\n<li>Fixed: Offcanvas \\u2014 CSS overriding default body margin and padding<\\/li>\\n<li>Fixed: Timeline \\u2014 Dynamic tags support in default skin not working<\\/li>\\n<li>Fixed: Search Form \\u2014 Safari back button keeps form fields disabled<\\/li>\\n<\\/ul>\\n<h4> 2.2.32 <\\/h4>\\n<ul>\\n<li>Added: Toggle Element \\u2014 Show element by url hash<\\/li>\\n<li>Added: Toggle Element \\u2014 Change url hash when toggling elements<\\/li>\\n<li>Added: Posts Extra \\u2014 Option to try to force equal height on post skins<\\/li>\\n<li>Added: Audio Player \\u2014 Support for m4a files<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Added missing prefix and suffix fields to translatable fields<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Edge case js error with empty slider controls size values<\\/li>\\n<li>Fixed: Swiper destroy on element remove fails with multiple instances on page<\\/li>\\n<li>Fixed: Slide Menu \\u2014 Sibling submenu items showing behind current active submenu<\\/li>\\n<li>Fixed: Slide Menu \\u2013 Removed default browser padding for ul<\\/li>\\n<li>Fixed: Search Form \\u2014 Edge case where restrictions not being passed if page is loaded using back browser button<\\/li>\\n<\\/ul>\\n<h4> 2.2.31 <\\/h4>\\n<ul>\\n<li>Added: Toggle Element \\u2014 Option to enable refreshing elements inside template when toggling<\\/li>\\n<li>Fixed: Toggle Element \\u2014 Recalculate swipers inside templates<\\/li>\\n<li>Fixed: Ensure loop template data attributes<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Compatibility with usage inside looped template<\\/li>\\n<li>Fixed: Circle Progress \\u2013 Decimal point applied to all widget instances<\\/li>\\n<li>Fixed: Offcanvas \\u2014 JS error on Offcanvas anchor navigation on links with dynamic tags enabled<\\/li>\\n<li>Tweak: Remove focus outline from swiper arrows<\\/li>\\n<li>Tweak: Circle Progress \\u2014 Remove limit for max value when using absolute<\\/li>\\n<\\/ul>\\n<h4> 2.2.30 <\\/h4>\\n<ul>\\n<li>Fixed: Gallery Slider \\u2014 Active thumbnail index for multiple widgets on same page<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Remove buggy auto-height control for thumbnails carousel<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Bug with overlay and reveal animations on same page<\\/li>\\n<li>Fixed: Audio Player \\u2013 Reset user agent padding on playlist<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Exclude em and rem from terms typography control<\\/li>\\n<\\/ul>\\n<h4> 2.2.29 <\\/h4>\\n<ul>\\n<li>Added: Gallery Slider \\u2014 Possibility to add multiple caption types<\\/li>\\n<li>Added: Gallery Slider \\u2014 Ken Burns effect option with. advanced controls<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Missing preview captions text align control<\\/li>\\n<li>Fixed: Display Conditions \\u2014 ACF Choice field check fails<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 Remove fade effect on thumbnails carousel<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 Condition image fit control to work only for slide effect<\\/li>\\n<\\/ul>\\n<h4> 2.2.28 <\\/h4>\\n<ul>\\n<li>Added: Toggle Element \\u2014 Padding control for labels<\\/li>\\n<li>Added: Breadcrumbs \\u2014 Control to disable structured data attributes<\\/li>\\n<li>Added: Gallery Slider, Gallery Extra, Switcher \\u2014 Option to disable slideshow in lightbox<\\/li>\\n<li>Added: Posts \\u2014 Wordpress filters for post and post wrapper classes<\\/li>\\n<li>Added: Video Player \\u2014 Control to remove Chrome\'s download option in fullscreen mode<\\/li>\\n<li>Fixed: Gallery Slider, Gallery Extra, Random Image, Switcher \\u2014 Missing lightbox captions<\\/li>\\n<li>Fixed: Toggle Element \\u2014 Low CSS specificity for ul and li elements causing themes override<\\/li>\\n<li>Fixed: Popup \\u2014 Exit intent not working correctly<\\/li>\\n<li>Tweak: Updated translations .pot file<\\/li>\\n<\\/ul>\\n<h4> 2.2.27 <\\/h4>\\n<ul>\\n<li>Added: Display Conditions \\u2014 Shortcode output condition<\\/li>\\n<li>Added: Display Conditions \\u2014 Post meta condition<\\/li>\\n<li>Added: Posts Extra \\u2014 Control to stack filters responsively<\\/li>\\n<li>Added: Posts Extra \\u2014 Option to trigger a window resize events after each carousel slide to fix displaying issues of certain widgets when using custom post skins<\\/li>\\n<li>Added: Gallery Slider \\u2014 Option to contain centre fit images inside preview slider when custom height is set<\\/li>\\n<li>Fixed: Incorrect Breadcrumbs and Slide Menu WPML integration<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Filters not changing active class when using masonry<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Load more button not hidden when no pagination available<\\/li>\\n<li>Fixed: Video Player \\u2014 Trigger window resize to position correctly elements with motion effects enabled after the video is loaded<\\/li>\\n<li>Fixed: Global Tooltips \\u2014 Removed label_block from slider control that broke controls<\\/li>\\n<\\/ul>\\n<h4> 2.2.26 <\\/h4>\\n<ul>\\n<li>Fixed: Posts Extra \\u2014 Carousel pagination selector breaks pagination when multiple carousels on same page<\\/li>\\n<li>Fixed: Search Form \\u2014 Submit button icon spacing control bug<\\/li>\\n<li>Fixed: Search Form \\u2014 Beautified option fields icons not displaying properly<\\/li>\\n<li>Fixed: Gallery Slider \\u2013 Figure line height causing caption display issues<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Distance control for thumbnails carousel arrows not working<\\/li>\\n<\\/ul>\\n<h4> 2.2.25 <\\/h4>\\n<ul>\\n<li>Added: Display Conditions \\u2014 If no condition value is set check to see if field is set to any value<\\/li>\\n<li>Added: Gallery Slider \\u2014 Options to set max. width and horizontal and vertical alignment for thumbnails carousel<\\/li>\\n<li>Added: Gallery Slider \\u2014 Option to set custom height for preview slides<\\/li>\\n<li>Added: Popup \\u2014 Option to disable refreshing frontend functionality for elements inside the popup<\\/li>\\n<li>Added: Offcanvas \\u2014 Option to disable refreshing frontend functionality for elements inside the panel<\\/li>\\n<li>Added: Calendar \\u2014 Typography control for header week days<\\/li>\\n<li>Added: Google Map \\u2014 Option to set zoom level when navigating to a location<\\/li>\\n<li>Fixed: Bug where one swiper slider\'s arrows control all swiper sliders on the same page<\\/li>\\n<li>Fixed: Calendar \\u2014 Separator style for header not working<\\/li>\\n<li>Fixed: Gallery \\u2014 Instagram lightbox not working for my photos<\\/li>\\n<li>Fixed: Gallery \\u2014 Instagram links bug for hashtag posts<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Filters with masonry enabled when two widgets on page breaks filtering<\\/li>\\n<li>Tweak: Circle Progress \\u2014 Allow 0 value to be shown<\\/li>\\n<\\/ul>\\n<h4> 2.2.24 <\\/h4>\\n<ul>\\n<li>Added: Gallery Slider \\u2014 Option to enable carousel on thumbnails<\\/li>\\n<li>Added: Posts Extra \\u2014 More swiper settings<\\/li>\\n<li>Fixed: Circle Progress \\u2014 Compatibility with display conditions<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Dynamic tag background styles<\\/li>\\n<li>Fixed: Don\'t include Elementor form widget in refreshable widgets due to reCaptcha reinitialisation uncaught error<\\/li>\\n<li>Fixed: Timeline \\u2014 Date entrance animation on left right and overlay alignments<\\/li>\\n<\\/ul>\\n<h4> 2.2.23 <\\/h4>\\n<ul>\\n<li>Added: Popup \\u2014 Margin control for close icon<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Instagram compatibility with new API changes<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Carousel compatibility with Elementor 2.9.4 swiper.js changes<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Allow -1 as posts per page value for specific query source<\\/li>\\n<li>Fixed: Display Conditions \\u2014 Use wp_timezone instead of timezone_string in case timezone is set as offset<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Filter post count style controls conditions<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Carousel remove deprecated Columns control<\\/li>\\n<li>Tweak: Google Map \\u2014 Convert description control from text to WYSIWYG type<\\/li>\\n<\\/ul>\\n<h4> 2.2.22 <\\/h4>\\n<ul>\\n<li>Fixed: Timeline \\u2014 Points and dates not showing when animate cards is on<\\/li>\\n<li>Fixed: Unfold \\u2014 Bug error showing button since last update<\\/li>\\n<\\/ul>\\n<h4> 2.2.21 <\\/h4>\\n<ul>\\n<li>Added: Display Conditions \\u2014 Current Date &amp; Time condition<\\/li>\\n<li>Added: Timeline \\u2014 New option to reverse position of cards<\\/li>\\n<li>Added: Text Divider \\u2014 Margin control for the text<\\/li>\\n<li>Added: Toggle Element \\u2014 Option to hide all elements by default<\\/li>\\n<li>Added: Timeline \\u2014 Controls for overriding text colour in custom mode<\\/li>\\n<li>Fixed: EE widget indicator in editor panel font<\\/li>\\n<li>Fixed: Unfold \\u2014 Removed elementor-button class from button which was adding a lot of padding<\\/li>\\n<li>Fixed: Unfold \\u2014 Editor preview spacing in js template<\\/li>\\n<li>Fixed: Query control width<\\/li>\\n<li>Fixed: PHP error on updater transient data<\\/li>\\n<li>Fixed: Video Player \\u2014 Stop play when played once in viewport<\\/li>\\n<li>Fixed: Timeline \\u2014 Correct dates when using custom post skin with a template that uses Posts Extra<\\/li>\\n<li>Fixed: Tooltips \\u2014 Tooltips not closing on mobile with touchstart event<\\/li>\\n<li>Fixed: Timeline \\u2014 Entrance animation triggering on page load instead of scroll to element<\\/li>\\n<li>Fixed: Timeline \\u2014 Query section not hidden if Source is Custom<\\/li>\\n<li>Fixed: Multiple SELECT2 controls width bug (missing css) after Elementor update<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Masonry layout broken when using custom size values in manual mode<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Changing filters disrupts any Elementor entrance animations placed after widget<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Run ready triggers for section and columns on infinite scroll<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Refresh elements even if infinite scroll button is off<\\/li>\\n<li>Fixed: ACF fields not showing inside templates when ACF Extended plugin is active<\\/li>\\n<li>Tweak: Unfold \\u2014 Hide button when there is no content or visible lines exceeds number of existing lines<\\/li>\\n<li>Tweak: Tooltips \\u2014 Integrate Elementor breakpoints<\\/li>\\n<li>Tweak: Gallery Extra \\u2014 Improved buggy responsive custom sizing method<\\/li>\\n<li>Revert: Display Conditions \\u2014 Added time to Current Date conditions\' date control<\\/li>\\n<\\/ul>\\n<h4> 2.2.20 <\\/h4>\\n<ul>\\n<li>Added: Display Conditions \\u2014 \'Current User\' condition<\\/li>\\n<li>Added: Display Conditions \\u2014 Added time to Current Date conditions\' date control<\\/li>\\n<li>Fixed: Some icon controls hidden due to Elementor changing label_block control attribute<\\/li>\\n<li>Fixed: Popup \\u2014 Close button control conditions<\\/li>\\n<li>Fixed: Popup \\u2014 Close icon not hiding on frontend<\\/li>\\n<\\/ul>\\n<h4> 2.2.19 <\\/h4>\\n<ul>\\n<li>Added: Popup \\u2014 Option to set max number of times a non-persistent popup should open<\\/li>\\n<li>Fixed: Posts \\u2014 Carousel compatibility with Elementor 2.9.0 swiper js upgrade<\\/li>\\n<li>Fixed: Switcher \\u2014 Title direction on RTL<\\/li>\\n<\\/ul>\\n<h4> 2.2.18 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Filters infinite scroll warning<\\/li>\\n<li>Added: Popup \\u2014 Border controls for iframe and image<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 PHP warning<\\/li>\\n<li>Fixed: Buttons \\u2014 Theme CSS override for anchors<\\/li>\\n<li>Fixed: Popup \\u2014 PHP warning when using placeholder image<\\/li>\\n<li>Fixed: Popup \\u2014 Overflow hidden missing from popup content<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Restrict refreshing widget inside offcanvas panel to refreshable list<\\/li>\\n<li>Fixed: Scroll Indicator \\u2014 Clicking bullets on mobile doesn\'t scroll to section when tooltips are enabled<\\/li>\\n<li>Tweak: Scroll Indicator \\u2014 Separate control for enabling opening of tooltips on focus for better integration<\\/li>\\n<li>Tweak: Switcher \\u2014 Convert description textarea field to WYSIWYG<\\/li>\\n<li>Tweak: Slide Menu \\u2014 More specific selector typography control<\\/li>\\n<li>Tweak: Popup \\u2014 Default close button size for iframe<\\/li>\\n<li>Tweak: Make license renewal reminder dismissable<\\/li>\\n<\\/ul>\\n<h4> 2.2.17 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Option to open in new tab for Title link<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Run ready triggers for widgets inside panel when opening<\\/li>\\n<li>Tweak: Posts \\u2014 Hide Media area if no thumbnail or placeholder even if it has content parts<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 Default thumbs spacing to 24<\\/li>\\n<li>Tweak: Update TweenMax version<\\/li>\\n<\\/ul>\\n<h4> 2.2.16 <\\/h4>\\n<ul>\\n<li>Added: Scroll Indicator \\u2014 Offset for scrolling to section<\\/li>\\n<li>Added: Gallery Slider \\u2014 Lazy load images in preview<\\/li>\\n<li>Added: Slide Menu \\u2014 \'elementor_extras\\/widgets\\/slide_menu\\/nav_menu\\/walker_start_el\' filter for walker_nav_menu_start_el hook<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Tilt perspective issue<\\/li>\\n<li>Fixed: Gallery \\u2014 Tilt captions depth not working<\\/li>\\n<li>Fixed: Global Tooltips \\u2014 Distance for repositioned tooltips<\\/li>\\n<li>Fixed: Global Tooltips \\u2014 Multiple tooltips appearing only in edit mode when changing tooltip position<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Remove posts per page setting for current query<\\/li>\\n<li>Fixed: Display Conditions \\u2014 GET and POST not returning true for any value<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Minor PHP warning<\\/li>\\n<li>Fixed: Random Image \\u2014 Error when using only one image<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Duplicate images in Elementor lightbox when infinite loop is enabled<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Include &quot;related&quot; source in Price position control conditions<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Meta Key not showing when Order By is set to Meta Value (number)<\\/li>\\n<li>Fixed: Timeline \\u2014 Meta Key not showing when Order By is set to Meta Value (number)<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Disable add to cart button when used inside a linked Media area<\\/li>\\n<li>Tweak: Timeline \\u2014 Responsive entrance animation<\\/li>\\n<\\/ul>\\n<h4> 2.2.15 <\\/h4>\\n<ul>\\n<li>Fixed: Popup \\u2014 Date comparison fail for non-persistent interval setting<\\/li>\\n<li>Fixed: Tooltips \\u2014 Tooltips empty in some cases after last update<\\/li>\\n<li>Fixed: Calendar \\u2014 Support for ACF date time picker fields<\\/li>\\n<li>Tweak: Hotspots \\u2014 Better css method for disabling pulse effect<\\/li>\\n<li>Tweak: Posts Extra \\u2014 New &quot;hide&quot; icon for content parts positioning<\\/li>\\n<li>Tweak: Nicons<\\/li>\\n<\\/ul>\\n<h4> 2.2.14 <\\/h4>\\n<ul>\\n<li>Fixed: Audio Player \\u2014 Edge case bug when stopping a player inside a section stuck with Elementor sticky setting<\\/li>\\n<li>Fixed: Switcher \\u2014 Loader thickness not working in Firefox<\\/li>\\n<li>Fixed: Offcanvas \\u2014 WPML not fetching content boxes repeater fields<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Masonry missing on frontend after last update<\\/li>\\n<li>Tweak: Tooltips \\u2014 Use append method to add content to the tooltip<\\/li>\\n<\\/ul>\\n<h4> 2.2.13 <\\/h4>\\n<ul>\\n<li>Fixed: Posts Extra \\u2014 Media left right alignment not working<\\/li>\\n<\\/ul>\\n<h4> 2.2.12 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Post border radius control<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Safari layout bug on infinite scroll and masonry layout<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Carousel slides to scroll on tablet bug<\\/li>\\n<li>Fixed: Timeline \\u2014 Date options not showing for custom post skin option<\\/li>\\n<li>Fixed: Sticky Elements \\u2014 Force sticky sections to flex align to start for Safari flex stretch bug<\\/li>\\n<\\/ul>\\n<h4> 2.2.11 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Infinite scroll fields for WPML<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Better support for post type archive links on archive pages<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Flexbox causing horizontal media layout issue on mobile<\\/li>\\n<li>Fixed: Circle Progress \\u2014 Compatibility with wordpress 5.3<\\/li>\\n<li>Tweak: Offcanvas \\u2014 Mode container background colour control from site settings to widget settings<\\/li>\\n<\\/ul>\\n<h4> 2.2.10 <\\/h4>\\n<ul>\\n<li>Added: Popup \\u2014 Option to open url inside popup<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Check for existing non built-in custom post types before iteration<\\/li>\\n<li>Fixed: Display Conditions \\u2014 ACF Date support for custom locale<\\/li>\\n<li>Fixed: Calendar \\u2014 ACF Date support for custom locale<\\/li>\\n<li>Fixed: Switcher \\u2014 Description not available for translation<\\/li>\\n<li>Fixed: Gallery \\u2014 Safari backface-visibility bug<\\/li>\\n<\\/ul>\\n<h4> 2.2.9 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Align media vertically on horizontal post layouts<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Text separator not displaying<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Default horizontal layout width control to 30<\\/li>\\n<\\/ul>\\n<h4> 2.2.8 <\\/h4>\\n<ul>\\n<li>Added: Breadcrumbs \\u2014 Granular controls for crumbs settings on archive and single pages<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Moved images loaded container selector to ajax response<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Show all filters option not working<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Infinite scroll pagination html output rendering more links than needed<\\/li>\\n<li>Fixed: PHP notice for licensing admin notification<\\/li>\\n<li>Fixed: Switcher \\u2014 Border radius control CSS selector<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Cleanup on pagination html output needed for infinite scroll<\\/li>\\n<\\/ul>\\n<h4> 2.2.7 <\\/h4>\\n<ul>\\n<li>Fixed: Compatibility with third-party plugin<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Edge case bug when calculating anchor position<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Notices<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Overlapping items on infinite scroll when filters active<\\/li>\\n<\\/ul>\\n<h4> 2.2.6 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Global \'elementor_extras\\/widgets\\/posts\\/link\' filter<\\/li>\\n<li>Added: Offcanvas \\u2014 Typography control for content boxes<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Infinite Scroll stopping before all posts load<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Panel background selector<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Page jump when navigating to anchor<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Edge case js error in nouislider script<\\/li>\\n<li>Fixed: Templates Control \\u2014 Restrict global query override for templates inside loops<\\/li>\\n<li>Fixed: Slide Menu \\u2014 Nav menu item classes don\'t work when coming from template control<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Wrong order for hierarchical taxonomies<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Flicker when performing infinite scroll on filtered posts<\\/li>\\n<li>Fixed: Sticky Elements \\u2014 Additional padding in some cases below sticky element<\\/li>\\n<li>Fixed: Display Conditions \\u2014 Missing day of week condition<\\/li>\\n<li>Fixed: Hotspots \\u2014 Better handling of icon vertical alignment in css<\\/li>\\n<\\/ul>\\n<h4> 2.2.5 <\\/h4>\\n<ul>\\n<li>Added: Toggle Element \\u2014 Control to hide items without any content<\\/li>\\n<li>Added: Popup \\u2014 Support for usage within Posts Extra custom post skin<\\/li>\\n<li>Added: Audio Player \\u2014 Option to disable preloading of audio files<\\/li>\\n<li>Added: Calendar \\u2014 Search custom fields by field name<\\/li>\\n<li>Added: Offcanvas \\u2014 Options in widgets\' settings to fix page jump issue<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Certain actions not working<\\/li>\\n<li>Fixed: Calendar \\u2014 Pods controls not fetching fields<\\/li>\\n<li>Fixed: Calendar \\u2014 Toolset controls not fetching fields<\\/li>\\n<li>Fixed: Query Control \\u2014 Return only matching queries for pods and toolset<\\/li>\\n<li>Fixed: Calendar \\u2014 Placeholder functionality<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Edge case where css width selectors get overridden by defaults<\\/li>\\n<li>Tweak: Posts Extra \\u2013 Default css order value for parts and areas in frontend css<\\/li>\\n<li>Tweak: Popup \\u2014 Replaced multiple template selection control with single control. IMPORTANT: Settings review required!<\\/li>\\n<li>Tweak: Breadcrumbs \\u2014 Refactor widget code<\\/li>\\n<\\/ul>\\n<h4> 2.2.4 <\\/h4>\\n<ul>\\n<li>Added: Dynamic background image support for custom post skin<\\/li>\\n<li>Added: Breadcrumbs \\u2014 Filter for home breadcrumb link<\\/li>\\n<li>Fixed: Timeline \\u2014 Wrong card content selector for transition control<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Broken selectors after last offcanvas update<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Remove default border around posts<\\/li>\\n<\\/ul>\\n<h4> 2.2.3 <\\/h4>\\n<ul>\\n<li>Added: Offcanvas \\u2014 Compatibility with templates in loops in Posts Extra and other plugins<\\/li>\\n<li>Added: Posts Extra \\u2014 Refresh all widgets scripts on appended infinite scroll items<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Button style gone when placed in linked media area<\\/li>\\n<li>Fixed: Sticky Elements \\u2014 Bug when sticky section inside page body within theme builder header template<\\/li>\\n<li>Fixed: Scroll Indicator \\u2014 Tooltips not working with bullets skin<\\/li>\\n<\\/ul>\\n<h4> 2.2.2 <\\/h4>\\n<ul>\\n<li>Fixed: Scroll Indicator \\u2014 Bug when tooltips disabled on bullets skin<\\/li>\\n<li>Fixed: Timeline \\u2014 Option to hide thumbnail not working in posts mode<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Bug with before parent category filters<\\/li>\\n<li>Fixed: Bug with third party elementor addon that enqueue editor scripts on plugin load<\\/li>\\n<li>Fixed: Posts \\u2014 Default metas control to include price for previous saved settings<\\/li>\\n<li>Added: Search Form \\u2014 Compatibility with Relevanssi search results on custom templates with search form id condition<\\/li>\\n<li>Added: Timeline \\u2014 Option to set a dynamic tag instead of date, title and excerpt in posts mode<\\/li>\\n<li>Added: Timeline \\u2014 Option to set HTML element for title in posts mode<\\/li>\\n<li>Added: Posts Extra \\u2014 Filter for the media area link<\\/li>\\n<li>Added: Posts Extra \\u2014 Option to open media and button links in new tab<\\/li>\\n<li>Added: Table \\u2014 WPML translation of header cells text<\\/li>\\n<li>Tweak: Sticky Elements \\u2014 Additional listeners for recalculating sticky<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Less restrictive css selector for the woocommerce add to cart button<\\/li>\\n<\\/ul>\\n<h4> 2.2.1 <\\/h4>\\n<ul>\\n<li>Added: Scroll Indicator \\u2014 Option to offset start and end positions<\\/li>\\n<li>Added: Posts Extra \\u2014 Responsive media width control<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Missing custom field order options<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Avatar meta showing even if removed from metas list<\\/li>\\n<li>Fixed: Display Conditions \\u2014 ACF Choice fails for radio field<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Bug with left aligned media flex width on mobile<\\/li>\\n<\\/ul>\\n<h4> 2.2.0 <\\/h4>\\n<ul>\\n<li>Added: Google Map \\u2014 Route travel mode options<\\/li>\\n<li>Added: Global Tooltips \\u2014 Compatibility with usage inside post skin templates for Posts Extra<\\/li>\\n<li>Added: Global Tooltips \\u2014 z-index control in both element and global settings<\\/li>\\n<li>Added: Display Conditions \\u2014 Term archive condition<\\/li>\\n<li>Added: Display Conditions \\u2014 ACF conditions<\\/li>\\n<li>Added: Display Conditions \\u2014 POST and GET variable conditions<\\/li>\\n<li>Added: Timeline \\u2014 Custom Post Skin via Elementor templates<\\/li>\\n<li>Added: Timeline \\u2014 Replaced default query controls with related query controls<\\/li>\\n<li>Added: Timeline \\u2014 Trim custom excerpt control<\\/li>\\n<li>Added: Timeline \\u2014 Custom post skin<\\/li>\\n<li>Added: Posts Extra \\u2014 Date formatting controls<\\/li>\\n<li>Added: Posts Extra \\u2014 Actions and filters<\\/li>\\n<li>Added: Calendar \\u2014 Actions and filters<\\/li>\\n<li>Added: Devices \\u2014 Actions<\\/li>\\n<li>Added: Breadcrumbs \\u2014 Actions and filters<\\/li>\\n<li>Added: Scroll Indicator \\u2014 Custom html tags for title and subtitle in list skin<\\/li>\\n<li>Added: Custom implementation for Template controls<\\/li>\\n<li>Fixed: Toggle Element \\u2014 Support for slick slider based widgets inside elements<\\/li>\\n<li>Fixed: Switcher \\u2014 Missing image link control<\\/li>\\n<li>Fixed: Timeline \\u2014 Markup improvement to allow for simpler border radius around cards<\\/li>\\n<li>Fixed: Timeline \\u2014 Custom icon replaces global if global is set<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Separator vertical alignment bug<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Icon migration markup issue<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Update elementor nerd box classes<\\/li>\\n<li>Fixed: Posts Extra \\u2014 ACF fields for custom skins used on archive pages<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Wrong access type for _query property<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Price conditions issue for area and editor panel section display<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Author and avatar metas additional controls conditions<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Removed infinite scroll pages loaded limit<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Handle multiple paginations control condition bug<\\/li>\\n<li>Fixed: Scroll Indicator \\u2014 Custom height control condition<\\/li>\\n<li>Fixed: Popup \\u2014 Compatibility with usage inside post skin templates for Posts Extra<\\/li>\\n<li>Fixed: Buttons \\u2014 Flip effect back is hidden during transition<\\/li>\\n<li>Tweak: Breadcrumbs \\u2014 Remove useless icon and icon class filters<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Update button text filters to include \\/posts\\/<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Default taxonomy order for filters<\\/li>\\n<\\/ul>\\n<h4> 2.1.8 <\\/h4>\\n<ul>\\n<li>Fixed: Missing elementor pro active condition<\\/li>\\n<\\/ul>\\n<h4> 2.1.7 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Order posts by custom fields<\\/li>\\n<li>Fixed: Calendar \\u2014 No events fetched when acf date field return format is different that display format<\\/li>\\n<li>Tweak: Better notices and plugin activation prevention for dependencies<\\/li>\\n<\\/ul>\\n<h4> 2.1.6 <\\/h4>\\n<ul>\\n<li>Fixed: Posts Extra \\u2014 Exclude category pages from previous current query fix<\\/li>\\n<li>Fixed: Posts Extra \\u2014 ACF fields for custom post skins used on archive pages<\\/li>\\n<\\/ul>\\n<h4> 2.1.5 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Filter for button link<\\/li>\\n<li>Added: Posts Extra \\u2014 Apply both \'button\' and \'add_to_cart\' filters to button<\\/li>\\n<li>Added: Audio Player \\u2014 Autoplay option<\\/li>\\n<li>Added: Support for new icon library in Elementor 2.6 in all widgets<\\/li>\\n<li>Added: Support for scaling SVG icon library assets when added to widgets<\\/li>\\n<li>Added: Breadcrumbs \\u2014 Option to hide current page<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Template control not fetching results after Elementor Pro 2.6.0 update<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Body order on horizontal posts<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Default query args prevent correct number of results on search templates<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Show all filters initially not working<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Wrong hierarchical taxonomies order when using custom post types<\\/li>\\n<li>Fixed: Calendar \\u2014 Border radius overflow issue<\\/li>\\n<li>Fixed: Circle Progress \\u2014 Progress not showing when shown below<\\/li>\\n<li>Fixed: Timeline \\u2014 Text align on tablet for RTL<\\/li>\\n<li>Fixed: Switcher \\u2014 Remove link image option when using overlay skin<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Edge case where page scrolls up when panel closed on firefox<\\/li>\\n<li>Fixed: Video Player \\u2014 Play button not centered in edge cases<\\/li>\\n<li>Tweak: Search Form \\u2014 Tax query verification<\\/li>\\n<\\/ul>\\n<h4> 2.1.4 <\\/h4>\\n<ul>\\n<li>Fixed: Audio Player \\u2014 External URL not. accepting dynamic tag in URL category<\\/li>\\n<li>Fixed: Video Player \\u2014 External URL not. accepting dynamic tag in URL category<\\/li>\\n<li>Fixed: Search Form \\u2014 Undefined index notice<\\/li>\\n<li>Added: Offcanvas \\u2014 Custom select for the close button<\\/li>\\n<li>Tweak: Offcanvas \\u2014 Separate control sections for title and close settings<\\/li>\\n<\\/ul>\\n<h4> 2.1.3 <\\/h4>\\n<ul>\\n<li>Fixed: Posts Extra \\u2014 Add to cart button alignment<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Pagination links on single templates<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Deprecated certain filters<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Added button text filter<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Added add to cart text filter<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Changed skin source terminology<\\/li>\\n<li>Tweak: Dissmisable admin licensing notices<\\/li>\\n<\\/ul>\\n<h4> 2.1.2 <\\/h4>\\n<ul>\\n<li>Added: Display Conditions \\u2014 New Term Archive condition<\\/li>\\n<li>Added: Posts Extra \\u2014 Area ordering controls<\\/li>\\n<li>Added: Posts Extra \\u2014 Add to cart button<\\/li>\\n<li>Added: Posts Extra \\u2014 Option to use Elementor templates as custom skin for posts<\\/li>\\n<li>Added: Timeline \\u2014 Separate controls for dates in hover and focused state<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Force square avatar image<\\/li>\\n<li>Fixed: Timeline \\u2014 Remove empty image wrapper when no image exists<\\/li>\\n<li>Fixed: Timeline \\u2014 Hover background color of arrow when focused<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Show price if source is current query<\\/li>\\n<li>Tweak: Timeline \\u2014 Allow Elementor custom image size<\\/li>\\n<li>Tweak: Timeline \\u2014 Responsive color controls<\\/li>\\n<\\/ul>\\n<h4> 2.1.1 <\\/h4>\\n<ul>\\n<li>Added: Tooltips \\u2014 Event for closing the tooltip by clicking anywhere<\\/li>\\n<li>Fixed: Buttons \\u2014 Text align when min width is set<\\/li>\\n<li>Tweak: Scroll Indicator \\u2014 Added options to select progress start and end calculation on scroll for sections<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Moved Infinite Scroll, Pagination and Filters activation controls to their respective sections.<\\/li>\\n<li>Tweak: Licensing \\u2014 Increase remote post request timeout value<\\/li>\\n<\\/ul>\\n<h4> 2.1.0 <\\/h4>\\n<ul>\\n<li>New Widget: Search Form \\u2014 Form widget with restrictions and filters<\\/li>\\n<li>New Widget: Scroll Indicator \\u2014 Create different types of scroll navigation indicators<\\/li>\\n<li>New Feature: Instagram \\u2014 Pull instagram feed to the Gallery widget<\\/li>\\n<li>Added: Posts Extra \\u2014 Vertical carousel<\\/li>\\n<li>Added: Posts Extra \\u2014 New control to select breakpoint for collapsing horizontal post layouts<\\/li>\\n<li>Added: Posts Extra \\u2014 Keep control to define page number limit for infinite scroll<\\/li>\\n<li>Added: Posts Extra \\u2014 Option to not show the &quot;All&quot; filter<\\/li>\\n<li>Added: Posts Extra \\u2014 New control for Slides to Show and deprecated old control [ Settings Review Required ]<\\/li>\\n<li>Added: Posts Extra \\u2014 Exclude taxonomy terms from filters<\\/li>\\n<li>Added: Gallery \\u2014 New spacing control specifically for mixed masonry layout. [ Settings Review Required ]<\\/li>\\n<li>Added: Gallery Slider \\u2014 Control to hide thumbnails<\\/li>\\n<li>Added: Tooltips \\u2014 Mobile event listeners [ Settings Review Required ]<\\/li>\\n<li>Added: Tooltips \\u2014 Responsive triggers and hide events [ Settings Review Required ]<\\/li>\\n<li>Added: Tooltips \\u2014 Separate events for closing the tooltip [ Settings Review Required ]<\\/li>\\n<li>Added: Tooltips \\u2014 New offset control to adjust alignment of arrow tip to target<\\/li>\\n<li>Added: Devices \\u2014 Option for video to cover screen<\\/li>\\n<li>Added: Breadcrumbs \\u2014 Hover colors controls<\\/li>\\n<li>Added: Calendar \\u2014 Disable links to posts<\\/li>\\n<li>Added: Calendar \\u2014 Add nofollow and open in new window on posts source<\\/li>\\n<li>Added: Buttons \\u2014 General padding control<\\/li>\\n<li>Added: Popup \\u2014 Horizontal align for inline trigger and popup close button<\\/li>\\n<li>Added: Notice for license domain mismatch<\\/li>\\n<li>Fixed: Circle Progress \\u2014 Wrong absolute max values<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Infinite scroll loading same posts<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Aligned column breakpoints to elementor default values<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Better override default theme padding on post item<\\/li>\\n<li>Fixed: Timeline \\u2014 CSS bug with overflow<\\/li>\\n<li>Fixed: Timeline \\u2014 Arrow color not working on frontend<\\/li>\\n<li>Fixed: Timeline \\u2014 Invalid code being generated in post css<\\/li>\\n<li>Fixed: Calendar \\u2014 Link target and nofollow<\\/li>\\n<li>Fixed: Devices \\u2014 Video controls conditions<\\/li>\\n<li>Fixed: Parallax Background \\u2014 Conflict with Elementor Pro scrolling effect<\\/li>\\n<li>Fixed: Popup \\u2014 Dynamic css selector for trigger not working<\\/li>\\n<li>Fixed: Calendar \\u2014 Link attributes in compact mode not working<\\/li>\\n<li>Fixed: Google Map \\u2014 Wrong value for default description tag<\\/li>\\n<li>Fixed: Google Map \\u2013 Set overflow to hidden to allow for advanced border radius setting<\\/li>\\n<li>Fixed: Switcher \\u2014 Rename effects section for compatibility with motion effects section name<\\/li>\\n<li>Fixed: Switcher \\u2014 Link to control should not be responsive<\\/li>\\n<li>Fixed: Unfold \\u2014 Bug with closing without focusing<\\/li>\\n<li>Fixed: Random Image \\u2014 Wrong caption<\\/li>\\n<li>Fixed: Display Conditions \\u2014 Check correct condition value<\\/li>\\n<li>Fixed: Toggle Element \\u2014 Text Label align controls<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Safari 12.1 CSS bug<\\/li>\\n<li>Fixed: Gallery \\u2014 Hover effects on mixed layout<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Edge case js error<\\/li>\\n<li>Fixed: Remove duplicate empty template messages from editor panel<\\/li>\\n<li>Fixed: Check license data before mismatch check<\\/li>\\n<li>Fixed: Tooltips \\u2014 Bug with hide event prevent default<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Allow horizontal post layout independent of columns value<\\/li>\\n<li>Tweak: Gallery \\u2014 Better controls conditions<\\/li>\\n<li>Tweak: Gallery \\u2014 Moved settings in their own sections under Content<\\/li>\\n<li>Tweak: Gallery \\u2014 Control conditions<\\/li>\\n<li>Tweak: Gallery \\u2014 Better markup, controls and css optimisation<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 Better markup, controls and css optimisation<\\/li>\\n<li>Tweak: Better license management, notifications and performance<\\/li>\\n<li>Tweak: Remove extension default enable for sticky and parallax background<\\/li>\\n<li>Tweak: Remove custom panel alert classes and revert to elementor ones<\\/li>\\n<li>Tweak: Update docs and support links in extras admin pages<\\/li>\\n<li>Tweak: Streamline get_image_caption across all modules to avoid code redundancy<\\/li>\\n<li>Tweak: Toggle Element \\u2014 Better Label alignment controls<\\/li>\\n<li>Tweak: Popup \\u2014 Empty trigger css adjustments<\\/li>\\n<li>Tweak: Admin pages styles<\\/li>\\n<\\/ul>\\n<h4> 2.0.17 <\\/h4>\\n<ul>\\n<li>Added: Timeline \\u2014 Overlay horizontal alignment option<\\/li>\\n<li>Fixed: Timeline \\u2014 Icon showing twice<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Default horizontal alignment to left<\\/li>\\n<\\/ul>\\n<h4> 2.0.16 <\\/h4>\\n<ul>\\n<li>Fixed: Include admin script only on extras pages<\\/li>\\n<li>Fixed: Posts Extra \\u2014 RTL margins and arrows<\\/li>\\n<li>Fixed: Calendar \\u2014 RTL arrows<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Override current query posts per page with control setting<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Carousel style section condition<\\/li>\\n<li>Added: Text Divider \\u2014 Control for alignment of text<\\/li>\\n<li>Added: Unfold \\u2014 Columns settings for content<\\/li>\\n<li>Added: Timeline \\u2014 New alignment controls to allow selecting layouts per breakpoint<\\/li>\\n<li>Added: Posts Extra \\u2014 Option to align posts horizontally<\\/li>\\n<li>Tweak: Admin settings RTL<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Responsive alignment controls<\\/li>\\n<li>Tweak: Timeline \\u2014 Responsive defaults for alignment controls<\\/li>\\n<\\/ul>\\n<h4> 2.0.15 <\\/h4>\\n<ul>\\n<li>IMPORTANT: This version requires Elementor 2.5 or above<\\/li>\\n<li>IMPORTANT: If you have Elementor Pro, this version requires version 2.5 or above<\\/li>\\n<li>Added: Posts Extra \\u2014 Elementor Pro new related posts module with include \\/ exclude and date range<\\/li>\\n<li>Added: Circle Progress \\u2014 Option to turn off animation<\\/li>\\n<li>Added: Display Conditions \\u2014 Day of week condition<\\/li>\\n<li>Added: Video Player &amp; Devices \\u2014 Option to not hide bar when video is playing<\\/li>\\n<li>Fixed: Sticky Elements \\u2014 Unstick for 768px wide tablets<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Compatibility with Elementor Pro 2.5<\\/li>\\n<li>Fixed: Timeline \\u2014 Compatibility with Elementor Pro 2.5<\\/li>\\n<li>Fixed: Sticky Elements \\u2014 Adjust on resize in editor<\\/li>\\n<li>Fixed: Calendar \\u2014 Query compatibility with WPML<\\/li>\\n<li>Fixed: Hotspots \\u2014 Check spaces in hotspot links<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Edge case where images don\'t display entirely<\\/li>\\n<li>Fixed: Timeline \\u2014 Correctly render dynamic tags<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Isotope on loading more posts when filter active<\\/li>\\n<li>Tweak: Video Player \\u2014 Automatically hide bar on mobile when playing<\\/li>\\n<\\/ul>\\n<h4> 2.0.14 <\\/h4>\\n<ul>\\n<li>Added: Toggle Element \\u2014 Option to select which item is active by default<\\/li>\\n<li>Fixed: Table \\u2014 Restrict cell max-width to msie<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Wrong arranging in some cases<\\/li>\\n<li>Fixed: Media Player text indicators wrapping<\\/li>\\n<\\/ul>\\n<h4> 2.0.13 <\\/h4>\\n<ul>\\n<li>Fixed: Posts Extra \\u2014 Carousel js error<\\/li>\\n<\\/ul>\\n<h4> 2.0.12 <\\/h4>\\n<ul>\\n<li>Added: Unfold \\u2014 Options to keep focus on content when folding or unfolding<\\/li>\\n<li>Fixed: Toggle Element \\u2014 Make sure Gallery Extra is initiated when toggling<\\/li>\\n<li>Fixed: Table \\u2014 Min-width breakpoint bug<\\/li>\\n<li>Fixed: Sticky Elements \\u2014 Compatibility with Elementor 2.5<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Z-index issues for panel<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Allow scroll on page not working<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Rare selector for anchors with link issue<\\/li>\\n<li>Fixed: Hotspots \\u2014 Rename css pulse animation<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Editor defaultView error<\\/li>\\n<li>Fixed: Sticky Elements \\u2014 Adjust breakpoint values<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Fallback to default wp posts per page option<\\/li>\\n<li>Tweak: Offcanvas \\u2014 Make sure html element has auto height<\\/li>\\n<li>Tweak: Better wpml classes check<\\/li>\\n<\\/ul>\\n<h4> 2.0.11 <\\/h4>\\n<ul>\\n<li>Fixed: Offcanvas \\u2014 Trigger not closing after open<\\/li>\\n<li>Fixed: Posts \\u2014 Grid overlapping on safari when infinite scroll is enabled<\\/li>\\n<li>Fixed: Table \\u2014 Restrict IE hack to tablet and up<\\/li>\\n<li>Fixed: Get element settings on frontend in edit mode<\\/li>\\n<li>Fixed: Google Map \\u2014 Require resize plugin<\\/li>\\n<li>Added: Posts Extra \\u2014 Button border controls<\\/li>\\n<\\/ul>\\n<h4> 2.0.10 <\\/h4>\\n<ul>\\n<li>Added: Parallax Elements \\u2014 Option to allow moving elements when they aren\'t visible inside viewport<\\/li>\\n<li>Fixed: Google Map \\u2014 Centering with dynamic tags not working<\\/li>\\n<li>Fixed: Calendar \\u2014 Don\'t limit number of posts fetched<\\/li>\\n<li>Fixed: Display Conditions \\u2014 Chrome check failing<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Responsive item aligning<\\/li>\\n<li>Fixed: Parallax Background \\u2014 Custom size control compatibility + tweaks<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Type control condition<\\/li>\\n<li>Tweak: Google Map \\u2014 Disable fitting and centering when route is enabled<\\/li>\\n<\\/ul>\\n<h4> 2.0.9 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Handle multiple paginated loops<\\/li>\\n<li>Added: Posts Extra \\u2014 Nothing found message<\\/li>\\n<li>Added: Image Comparison \\u2014 Option to turn off animation on entrance<\\/li>\\n<li>Added: Posts Extra \\u2014 Query ID filter on top of elementor pro one<\\/li>\\n<li>Added: Offcanvas \\u2014 Control to enable page scroll when offcanvas panel is open<\\/li>\\n<li>Fixed: Table \\u2014 IE cell text wrapping<\\/li>\\n<li>Fixed: Circle Progress \\u2014 Wrong absolute value when multiple widget instances on same page<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Wrong thumbnail order<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Z-index issues<\\/li>\\n<li>Fixed: Calendar \\u2014 Convert timestamp to integer<\\/li>\\n<li>Fixed: Gallery module attachment check<\\/li>\\n<li>Tweak: Timeline \\u2014 Rename timeline script<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Responsive row spacing control<\\/li>\\n<li>Tweak: Parallax Background \\u2014 Compatibility with Elementor 2.4<\\/li>\\n<\\/ul>\\n<h4> 2.0.8 <\\/h4>\\n<ul>\\n<li>Fixed: Text Divider \\u2014 Selector for link color<\\/li>\\n<li>Fixed: Timeline \\u2014 Notice<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Escape jquery expression<\\/li>\\n<li>Fixed: Google Map \\u2014 Handle invalid or undefined snazzy map style<\\/li>\\n<\\/ul>\\n<h4> 2.0.7 <\\/h4>\\n<ul>\\n<li>Fixed: Offcanvas \\u2014 Anchor navigation scroll calculation<\\/li>\\n<li>Added: Timeline \\u2014 Allow post content to be shown instead of excerpt<\\/li>\\n<li>Added: Timeline \\u2014 Control to set line progress position relative to viewport<\\/li>\\n<li>Tweak: Offcanvas \\u2014 Anchor condition<\\/li>\\n<\\/ul>\\n<h4> 2.0.6 <\\/h4>\\n<ul>\\n<li>Fixed: Popup \\u2014 Duplicate tab control name<\\/li>\\n<li>Fixed: Popup \\u2014 Remove rtl suffix<\\/li>\\n<li>Added: Offcanvas \\u2014 Global control for offcanvas container background color<\\/li>\\n<\\/ul>\\n<h4> 2.0.5 <\\/h4>\\n<ul>\\n<li>Added: Editor panel labels for widgets<\\/li>\\n<li>Added: Calendar \\u2014 Control to customise month names<\\/li>\\n<li>Added: Offcanvas \\u2014 Link navigate to anchors on page<\\/li>\\n<li>Added: Popup \\u2014 Text trigger styling controls<\\/li>\\n<li>Fixed: Inline SVG \\u2014 Multiple svgs have same settings<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 No parent custom taxonomy terms render all terms<\\/li>\\n<li>Fixed: Posts Extra \\u2014 PHP notice<\\/li>\\n<li>Tweak: Updated language file<\\/li>\\n<\\/ul>\\n<h4> 2.0.4 <\\/h4>\\n<ul>\\n<li>Fixed: Display Conditions \\u2014 Editor section for sections actions<\\/li>\\n<li>Fixed: Display Conditions \\u2014 Conditions evaluation per element<\\/li>\\n<\\/ul>\\n<h4> 2.0.3 <\\/h4>\\n<ul>\\n<li>Fixed: Popup Display Conditions \\u2014 Check widget visibility before opening automatically<\\/li>\\n<li>Fixed: Table \\u2014 First row has no classes<\\/li>\\n<li>Fixed: Google Map \\u2014 Handle no snazzy maps selection<\\/li>\\n<li>Fixed: Display Conditions \\u2014 Wrong default keys resulting in wrong display<\\/li>\\n<li>Fixed: Audio Player \\u2014 Border type selector<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Position structured data property<\\/li>\\n<li>Fixed: Parallax Element \\u2014 Parallax column affecting child columns<\\/li>\\n<li>Fixed: Devices \\u2014 Image extending outside the widget area<\\/li>\\n<li>Fixed: Popup \\u2014 Move font family to pseudo-element<\\/li>\\n<li>Fixed: Slide Menu \\u2014 Sub-menu links not working with link navigation turned on<\\/li>\\n<li>Tweak: Rename infinite-scroll script<\\/li>\\n<li>Tweak: Breadcrumbs \\u2014 Increase typography selector specificity<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Additional conditions for areas style sections<\\/li>\\n<li>Remove widget disabling admin notif<\\/li>\\n<li>Update Wordpress stable tag to 5.0.0<\\/li>\\n<\\/ul>\\n<h4> 2.0.2 <\\/h4>\\n<ul>\\n<li>Added: New Query Control<\\/li>\\n<li>Added: Display Conditions \\u2014 Ajax powered fields<\\/li>\\n<li>Added: Display Conditions \\u2014 Current post condition<\\/li>\\n<li>Fixed: Switcher \\u2013 Autoplay not working without entrance animation<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Custom taxonomy archive crumbs<\\/li>\\n<li>Tweak: Audio Player \\u2014 Added option for external sources<\\/li>\\n<\\/ul>\\n<h4> 2.0.1 <\\/h4>\\n<ul>\\n<li>Fixed: Google Map \\u2014 Navigation z-index<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Default button position to hidden<\\/li>\\n<li>Fixed: Devices \\u2014 Video in window frame not displaying<\\/li>\\n<li>Fixed: Google Map \\u2014 JSON incorrectly reported as invalid<\\/li>\\n<li>Fixed: Switcher \\u2014 Cover picture tag with CSS<\\/li>\\n<li>Fixed: Devices \\u2014 Video css for browser frame<\\/li>\\n<li>Added: Posts Extra \\u2014 Infinite load button transition control<\\/li>\\n<li>Added: Posts Extra \\u2014 Infinite load button border control<\\/li>\\n<li>Added: Hotspots \\u2014 Individual hover controls for each hotspot<\\/li>\\n<li>Added: Audio Player \\u2014 Option to loop playlist<\\/li>\\n<li>Tweak: Google Map \\u2014 Make fields dynamic<\\/li>\\n<li>Tweak: Audio Player \\u2014 Added custom js events<\\/li>\\n<li>Tweak: Audio Player \\u2014 Separate control for play icon size<\\/li>\\n<li>Tweak: Video Player \\u2014 Added custom js events<\\/li>\\n<\\/ul>\\n<h4> 2.0.0 <\\/h4>\\n<ul>\\n<li>New Extension: Display Conditions<\\/li>\\n<li>New Widget: Google Map<\\/li>\\n<li>New Widget: Popup<\\/li>\\n<li>New Widget: Age Gate<\\/li>\\n<li>New Widget: Toggle Element<\\/li>\\n<li>New Widget: Calendar<\\/li>\\n<li>New Widget: Audio Player<\\/li>\\n<li>New Widget: Offcanvas<\\/li>\\n<li>New Widget: Slide Menu<\\/li>\\n<li>New Widget: Random Image<\\/li>\\n<li>Added: Posts Extra \\u2014 Support for terms from multiple taxonomies<\\/li>\\n<li>Added: Breadcrumbs \\u2014 Include blog posts page in breadcrumbs<\\/li>\\n<li>Added: Switcher \\u2014 New option to add description<\\/li>\\n<li>Added: Sticky Elements \\u2014 Completely rewritten code<\\/li>\\n<li>Added: Sticky Elements \\u2014 Offset bottom control<\\/li>\\n<li>Added: Global Tooltips \\u2014 Control to disable on breakpoint<\\/li>\\n<li>Added: Breadcrumbs \\u2014 Option to show taxonomy terms for custom post types instead of CPT name<\\/li>\\n<li>Added: Tooltips \\u2014 New trigger on page load<\\/li>\\n<li>Added: Switcher \\u2014 Events to update when inside toggle element<\\/li>\\n<li>Added: Posts Extra \\u2014 Price meta for woocommerce products<\\/li>\\n<li>Added: Posts Extra \\u2014 Button content part replaces read more<\\/li>\\n<li>Added: Posts Extra \\u2014 Post count for filters<\\/li>\\n<li>Added: Breadcrumbs \\u2014 Schema.org properties<\\/li>\\n<li>Fixed: Tooltips \\u2014 Add option to disable on breakpoint<\\/li>\\n<li>Fixed: Global Tooltips \\u2014 Destroy on editor mode<\\/li>\\n<li>Fixed: Parallax Background \\u2014 Out of view sections have wrong background image positions<\\/li>\\n<li>Fixed: Global Tooltips \\u2014 Settings not being saved<\\/li>\\n<li>Fixed: Parallax Element \\u2014 Start position option not applying<\\/li>\\n<li>Fixed: Hotspots \\u2014 Image display block<\\/li>\\n<li>Fixed: Unfold \\u2014 Button alignment<\\/li>\\n<li>Fixed: Unfold \\u2014 Button icon position and indent<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Check for woocommerce for price fields<\\/li>\\n<li>Fixed: Video Player \\u2014 Volume size undefined error<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 RTL behviour on clicking thumbs<\\/li>\\n<li>Fixed: Inline SVG \\u2014 ACF image field<\\/li>\\n<li>Fixed: Update to getEditModel method<\\/li>\\n<li>Fixed: Compatibility with Elementor 2.3.0<\\/li>\\n<li>Fixed: License not deactivating if expired<\\/li>\\n<li>Fixed: Image Comparison \\u2014 Distance for top-aligned labels<\\/li>\\n<li>Fixed: Devices + Hotspots \\u2014 Compatibility with Elementor 2.3.0<\\/li>\\n<li>Fixed: Switcher \\u2014 Astra theme images css conflict<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Multiple hierarchical categories not showing<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Filtered posts not found message<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Wrong grid item width when filters are active and multiple instances on page<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Controls conditions<\\/li>\\n<li>Fixed: Breacrumbs \\u2014 Wrap crumbs automatically<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Hide fields not available for Current Query option<\\/li>\\n<li>Tweak: Hotspots \\u2014 Default hotspots for better ux<\\/li>\\n<li>Tweak: Video Player + Devices \\u2014 Better behaviour and interactions for video player<\\/li>\\n<li>Tweak: Video Player + Devices \\u2014 Better selection of video source files<\\/li>\\n<li>Tweak: Video Player + Devices \\u2014 Added playback speed option<\\/li>\\n<li>Tweak: Timeline \\u2014 Support for point numbers and letter for posts<\\/li>\\n<li>Tweak: Table \\u2014 Remove render template to improve editing performance<\\/li>\\n<li>Tweak: Buttons \\u2014 Add bottom margin to custom spacing control<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Increase options for carousel rows and slides to scroll<\\/li>\\n<li>Tweak: Enable docs link in admin settings page<\\/li>\\n<li>Tweak: Switcher \\u2014 Make description field dynamic<\\/li>\\n<li>Tweak: Google Maps \\u2013 Adjust controls structure<\\/li>\\n<li>Tweak: Table \\u2014 Control names<\\/li>\\n<li>Tweak: Text Divider \\u2014 Controls position<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Added read more to translatable fields for WPML<\\/li>\\n<\\/ul>\\n<h4> 1.9.16 <\\/h4>\\n<ul>\\n<li>Fixed: Elementor 2.3.0 compatibility<\\/li>\\n<\\/ul>\\n<h4> 1.9.15 <\\/h4>\\n<ul>\\n<li>Fixed: Posts Extra \\u2014 Load more button for multiple widget instances<\\/li>\\n<li>Fixed: Parallax Background \\u2014 Responsive speed options<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Columns above 9 don\'t become full width<\\/li>\\n<li>Tweak: Improve Elementor Pro version dependency and posts widget compatibility<\\/li>\\n<li>Tweak: Timeline \\u2014 Enable dynamic fields for custom source<\\/li>\\n<li>Tweak: Circle Progress \\u2014 Handling of divisions operation in value control<\\/li>\\n<li>Tweak: Circle Progress \\u2014 Option to allow numbers with decimals instead of percetanges<\\/li>\\n<li>Tweak: Circle Progress \\u2014 Options to allow for absolute values to be shown<\\/li>\\n<li>Tweak: Hotspots \\u2014 Make hotspots size and opacity control responsive<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Remove swiper slide overflow hidden<\\/li>\\n<li>Tweak: Added option to enable updates to beta versions or Extras<\\/li>\\n<\\/ul>\\n<h4> 1.9.14 <\\/h4>\\n<ul>\\n<li>Fixed: Rename resize script to avoid potential conflicts<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Carousel flickering when used in Tabs widget and switching tabs<\\/li>\\n<li>Fixed: Timeline \\u2014 Date showing current date instead of post date<\\/li>\\n<li>Fixed: Extras admin page conflict with Jetpack<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Link not accessible for preview images with caption<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Added query id control for server side filtering of widget queries<\\/li>\\n<li>Tweak: Hotspots \\u2014 HTML valid structure issue<\\/li>\\n<li>Tweak: Table \\u2014 Minor terminology improvements<\\/li>\\n<\\/ul>\\n<h4> 1.9.13 <\\/h4>\\n<ul>\\n<li>Fixed: Posts Extra \\u2014 Infinite scroll loading same posts<\\/li>\\n<li>Fixed: Inline SVG \\u2014 Space under image<\\/li>\\n<li>Fixed: Extensions not showing when Elementor Pro not active<\\/li>\\n<\\/ul>\\n<h4> 1.9.12 <\\/h4>\\n<ul>\\n<li>Added: CSS filter controls for widgets<\\/li>\\n<li>Added: Global Tooltips \\u2014 Support for shortcodes and dynamic fields<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Load more button causing error when not paginated<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Content inside media not showing when no thumbnail available<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Media area display conditions<\\/li>\\n<li>Fixed: Posts Extra \\u2014 PHP warning when excerpt length is empty<\\/li>\\n<li>Fixed: Posts Extra \\u2014 RTL alignment of posts in masonry mode<\\/li>\\n<li>Fixed: Circle Progress \\u2014 Default control value to string<\\/li>\\n<li>Fixed: Circle Progress \\u2014 Dynamic fields values not working<\\/li>\\n<li>Fixed: Parallax Elements \\u2014 Window height calculation<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Repeater fields conditions<\\/li>\\n<li>Fixed: Parallax Background \\u2014 Breaks when dynamic field is used<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Allow offset to be used in current query<\\/li>\\n<li>Tweak: Timeline \\u2014 Allow drafts and scheduled posts to be included<\\/li>\\n<\\/ul>\\n<h4> 1.9.11 <\\/h4>\\n<ul>\\n<li>Fixed: Posts Extra \\u2014 Sticky posts compatibility with pagination<\\/li>\\n<li>Fixed: Compatibility with new Swiper version in Elementor 2.1<\\/li>\\n<li>Tweak: Timeline \\u2014 Responsive date padding and margin controls<\\/li>\\n<\\/ul>\\n<h4> 1.9.10 <\\/h4>\\n<ul>\\n<li>Fixed: Sticky Elements \\u2014 Options appear twice<\\/li>\\n<li>Tweak: Remove group control sticky<\\/li>\\n<\\/ul>\\n<h4> 1.9.9 <\\/h4>\\n<ul>\\n<li>Fixed: Timeline \\u2014 Points and line not aligned on mobile and tablet if size defined only on desktop<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Default placeholder image overriding post thumbnail<\\/li>\\n<li>Fixed: Sticky Elements no longer working<\\/li>\\n<li>Fixed: Additional check for active Elementor Pro<\\/li>\\n<li>Tweak: Moved Extras advanced section behind Custom CSS section<\\/li>\\n<\\/ul>\\n<h4> 1.9.8 <\\/h4>\\n<ul>\\n<li>Added: Gallery Slider \\u2014 Arrows controls for preview<\\/li>\\n<li>Added: Posts Extra \\u2014 Option to show all filters when using infinite scroll<\\/li>\\n<li>Fixed: Unfold \\u2014 Icon right align not working<\\/li>\\n<li>Fixed: Compatibility with Elementor 2.1 beta<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Allow excerpt in media area<\\/li>\\n<li>Tweak: Timeline \\u2014 More specific color selectors<\\/li>\\n<li>Tweak: Timeline \\u2014 Text align dates to the right for right hand items<\\/li>\\n<\\/ul>\\n<h4> 1.9.7 <\\/h4>\\n<ul>\\n<li>Fixed: Gallery Extra \\u2014 Implemented work-around for warning caused by Elementor bug<\\/li>\\n<li>Fixed: Posts Extra \\u2014 IE 10 images bug<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Time not showing<\\/li>\\n<li>Fixed: Buttons \\u2014 Wrap buttons by default<\\/li>\\n<li>Fixed: Remove too broad css declaration<\\/li>\\n<li>Fixed: Parallax background \\u2014 Correct element resize function name<\\/li>\\n<\\/ul>\\n<h4> 1.9.6 <\\/h4>\\n<ul>\\n<li>Fixed: Parallax Elements \\u2014 Breaks if pan distance is undefined<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Read more typography control conditions<\\/li>\\n<li>Fixed: Unfold \\u2014 Force icon to show hide as inline block<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Stretch body to align all footers to bottom<\\/li>\\n<li>Fixed: Posts Extra \\u2014 IE 10 horizontal layout for posts<\\/li>\\n<li>Fixed: Renamed jquery resize plugin function<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 CSS overflow fix<\\/li>\\n<\\/ul>\\n<h4> 1.9.5 <\\/h4>\\n<ul>\\n<li>Added: Dynamic fields support for all widgets<\\/li>\\n<li>Fixed: Global Tooltips \\u2014 Position not being overriden<\\/li>\\n<li>Fixed: Timeline \\u2014 Pointer cursor not showing on linked cards<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Image bottom spacing on some themes<\\/li>\\n<li>Tweak: Gallery Extra \\u2014 Added unique classes to each item<\\/li>\\n<li>Tweak: HTML5 Video \\u2014 Added control to enable muted video for autoplay<\\/li>\\n<li>Tweak: HTML5 Video \\u2014 Added controls to enable or disable all elements inside the bar<\\/li>\\n<\\/ul>\\n<h4> 1.9.4 <\\/h4>\\n<ul>\\n<li>Added: Timeline \\u2014 Control to center images<\\/li>\\n<li>Added: Posts Extra \\u2014 New filters for post title, excerpt, comments and date<\\/li>\\n<li>Added: HTML5 Video \\u2014 Control to stop all other video players when current one is played.<\\/li>\\n<li>Fixed: Fixed: Column widths in post-css are rendered in the wrong order<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Posts per page doesn\'t take into account sticky posts<\\/li>\\n<li>Fixed: Buttons \\u2014 Item typography group control not working<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Responsive horizontal alignment for filters<\\/li>\\n<li>Fixed: Hotspots \\u2014 Tooltip position not being overriden at hotspot level<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Control conditions<\\/li>\\n<li>Tweak: Updated isotope version to 3.0.6 to fix 1px grid gap<\\/li>\\n<li>Tweak: Remove default webkit left padding from list navs<\\/li>\\n<li>Tweak: Parallax Background \\u2014 Increase plugin timeout reinit<\\/li>\\n<li>Tweak: Posts \\u2014 Increase excerpt length filter priority<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Added option to show only sticky posts<\\/li>\\n<\\/ul>\\n<h4> 1.9.3 <\\/h4>\\n<ul>\\n<li>Added: Sticky Elements \\u2014 Compatibility with the Lazy Loader wordpress plugin<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Safari &lt; 10.2 layout glitch layout glitch on mobile<\\/li>\\n<li>Fixed: HTML5 Video \\u2014 m4v files condition<\\/li>\\n<li>Fixed: Sticky \\u2014 Sticks only when resizing browser window<\\/li>\\n<li>Fixed: Sticky \\u2014 Not working correctly with Stretched parent<\\/li>\\n<li>Fixed: HTML5 Video \\u2014 m4v format not sufficient<\\/li>\\n<li>Fixed: Image Comparison \\u2013 Allow 0 percent values<\\/li>\\n<li>Tweak: HTML5 Video \\u2014 Render attributes<\\/li>\\n<li>Tweak: HTML5 Video \\u2014 Control conditions<\\/li>\\n<\\/ul>\\n<h4> 1.9.2 <\\/h4>\\n<ul>\\n<li>Fixed: Switcher \\u2014 Bug with arrow loader position and stroke width in older versions of Safari<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Compatibility with IE 11<\\/li>\\n<li>Fixed: Parallax Elements \\u2014 Control value undefined check<\\/li>\\n<\\/ul>\\n<h4> 1.9.1 <\\/h4>\\n<ul>\\n<li>Fixed: Parallax Elements \\u2014 Max distance not taking into account scroll position<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Filters not stacking on responsive.<\\/li>\\n<li>Fixed: Switcher \\u2014 Arrow loader not displaying in firefox<\\/li>\\n<li>Fixed: Parallax Elements \\u2014 Wrong position for scroll with start position<\\/li>\\n<li>Fixed: GSAP dependencies<\\/li>\\n<\\/ul>\\n<h4> 1.9.0 <\\/h4>\\n<ul>\\n<li>Added: New Switcher Widget! \\u2014 Switch photos and text using powerful javascript driven transitions. Features menu and arrows navigation, autoplay with progress loader, entrance animations, page background color switcher, two skins (default and overlay) and much more.<\\/li>\\n<li>Added: New Feature for Parallax Elements! \\u2014 Option to parallax columns and widgets on mouse move<\\/li>\\n<li>Added: Posts Extra \\u2014 Controls to style only sticky posts<\\/li>\\n<li>Added: Image Comparison \\u2014 Option to enable clicking on labels to uncover images<\\/li>\\n<li>Added: Hotspots \\u2014 Separate color controls for each hotspot<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Sticky posts not working when a category is selected in the query<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Invisible gallery when preview position is top on desktop<\\/li>\\n<li>Fixed: Image Comparison \\u2014 Remove labels if no text is present<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Hide carousel until properly rendered<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Added alt and title tags to image element<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Issue with negative margin resulting in right whitespace for the gallery<\\/li>\\n<li>Fixed: Timeline \\u2014 Controls conditions<\\/li>\\n<li>Fixed: Timeline \\u2014 Item point color override<\\/li>\\n<li>Fixed: Timeline \\u2014 Properly override point content<\\/li>\\n<li>Tweak: Parallax Elements \\u2014 Removed group control<\\/li>\\n<li>Tweak: Gallery Extra, Gallery Slider, Posts Extra \\u2014 Added notice with link to blend mode browser support for blend mode controls<\\/li>\\n<li>Tweak: Timeline \\u2014 Added repeater setting key method to card render function<\\/li>\\n<\\/ul>\\n<h4> 1.8.8 <\\/h4>\\n<ul>\\n<li>Added: Gallery Extra \\u2014 Control width and ratio of each individual image in manual mode<\\/li>\\n<li>Added: Timeline \\u2014 Option for automatic numbering and letters instead of icons to points<\\/li>\\n<li>Added: Timeline \\u2014 New control to set excerpt length<\\/li>\\n<li>Added: Unfold \\u2014 Option to change icon when unfolded<\\/li>\\n<li>Added: Sticky Elements \\u2014 Option to turn off bottoming of elements inside the parent<\\/li>\\n<li>Added: Posts Extra \\u2014 Option to enable sticky posts in query<\\/li>\\n<li>Added: Posts Extra \\u2014 Arrows sizing controls<\\/li>\\n<li>Added: Posts Extra \\u2014 Transition control for carousel arrows and pagination<\\/li>\\n<li>Added: Posts Extra \\u2014 Option to set how many slides to scroll<\\/li>\\n<li>Added: Image Comparison \\u2014 Control to define initial position of separator<\\/li>\\n<li>Added: Image Comparison \\u2014 Option to enable moving separator by clicking anywhere on the image<\\/li>\\n<li>Added: Buttons \\u2014 Control for label min width<\\/li>\\n<li>Added: Hotspots \\u2014 Control to disable pulsating animation<\\/li>\\n<li>Fixed: Sticky Elements \\u2014 Controls not showing on inner sections<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Images wider than 100% on mobile in manual mixed masonry layout mode<\\/li>\\n<li>Fixed: HTML5 Video \\u2014 CSS bottom whitespace<\\/li>\\n<li>Fixed: Buttons \\u2014 Remove block label for buttons icon, id and class controls<\\/li>\\n<li>Tweak: Timeline \\u2014 Take sticky posts into consideration in query<\\/li>\\n<li>Tweak: Unfold \\u2014 Organise controls<\\/li>\\n<li>Tweak: WPML Compatibility \\u2014 Change method to fix fields not saving<\\/li>\\n<\\/ul>\\n<h4> 1.8.7 <\\/h4>\\n<ul>\\n<li>Fixed: Posts Extra \\u2014 Filtering one widget\'s posts affects all other widgets<\\/li>\\n<li>Fixed: Hotspots \\u2014 Tooltips have an extra space at the bottom when first hovering<\\/li>\\n<li>Fixed: HTML5 Video \\u2014 Volume functionality breaks when controls are hidden<\\/li>\\n<li>Fixed: HTML5 Video \\u2014 Video reloading after each loop<\\/li>\\n<li>Added: Global Tooltips \\u2014 Global controls for distance and width<\\/li>\\n<li>Tweak: HTML5 Video \\u2014 Added width and horizontal alignment control to player<\\/li>\\n<li>Tweak: Global Tooltips \\u2014 Remove default global styling values after Elementor enqueue fix in 1.9.5<\\/li>\\n<\\/ul>\\n<h4> 1.8.6 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Term slug classes to filters and post terms<\\/li>\\n<li>Fixed: Replaced create_function with anonymous function for PHP 7.2 support<\\/li>\\n<li>Fixed: Inline SVG \\u2014 Handle internal CSS in non color overriding situations<\\/li>\\n<li>Fixed: Hotspots \\u2014 Tooltips showing even if they have no content<\\/li>\\n<li>Tweak: Sticky Elements \\u2014 Prevent sticky on a section that is stretched with js<\\/li>\\n<li>Tweak: Buttons \\u2014 Move typography control above tabs<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Move hover animation controls to separate section for better ux<\\/li>\\n<li>Tweak: Gallery Extra \\u2014 Moved hover controls to separate section<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 Moved hover controls to separate section<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 Default font size for thumbnail captions<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Fix condition<\\/li>\\n<li>Tweak: Hotspots \\u2014 Show label for tooltip content in editor<\\/li>\\n<\\/ul>\\n<h4> 1.8.5 <\\/h4>\\n<ul>\\n<li>Fixed: Gallery Extra \\u2014 Missing js dependency<\\/li>\\n<\\/ul>\\n<h4> 1.8.4 <\\/h4>\\n<ul>\\n<li>Fixed: Gallery Extra \\u2014 Random ordering not working<\\/li>\\n<li>Fixed: Timeline \\u2014 RTL optimisation<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Custom image size not working on manual mode<\\/li>\\n<li>Tweak: Add dismissible notice for recommended php version<\\/li>\\n<li>Tweak: Gallery Extra \\u2014 Add title and description caption types<\\/li>\\n<li>Tweak: Timeline \\u2014 Add link control description to avoid linking cards when content already contains links<\\/li>\\n<\\/ul>\\n<h4> 1.8.3 <\\/h4>\\n<ul>\\n<li>Fixed: HTML5 Video \\u2014 Video not playing on Safari and some mobile environments<\\/li>\\n<li>Fixed: Buttons \\u2014 Safari buttons vertical alignment<\\/li>\\n<li>Fixed: Devices \\u2014 device not displaying on Safari when portrait mode is enabled<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Grid broken on Safari<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 reinit masonry when images done loading<\\/li>\\n<li>Tweak: Move all Extras admin settings into Elementor menu<\\/li>\\n<li>Tweak: Image Comparison \\u2014 Remove default value for width control<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 default mobile and tablet gallery columns to larger numbers<\\/li>\\n<\\/ul>\\n<h4> 1.8.2 <\\/h4>\\n<ul>\\n<li>Added: Parallax Background \\u2014 Support for section resize in elementor preview mode<\\/li>\\n<li>Fixed: Parallax Background \\u2014 Compatibility with stretched section<\\/li>\\n<li>Fixed: HTML5 Video \\u2014 Interface style controls conditions<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Right side white-space after thumbnails on top preview position<\\/li>\\n<li>Fixed: Unfold \\u2014 Page stops responding when entering invalid html in text editor mode<\\/li>\\n<li>Tweak: Unfold \\u2014 Allow accordions, tabs and all resizing elements inside content<\\/li>\\n<\\/ul>\\n<h4> 1.8.1 <\\/h4>\\n<ul>\\n<li>Fixed: Posts Extra \\u2014 Masonry broken when infinite scroll is enabled<\\/li>\\n<\\/ul>\\n<h4> 1.8.0 <\\/h4>\\n<ul>\\n<li>New extension: Global Tooltips \\u2014 Add a tooltip to any widget<\\/li>\\n<li>New: Disable Widgets &amp; Extensions \\u2014 You can now disable Extras widgets and extensions via the admin settings page<\\/li>\\n<li>Added: WPML compatibility \\u2014 String Translation and Translation Editor support for all widgets<\\/li>\\n<li>Added: Circle Progress \\u2014 Icon support inside circle<\\/li>\\n<li>Added: Update .pot translation file<\\/li>\\n<li>Added: Buttons \\u2014 Tooltips duration control<\\/li>\\n<li>Added: Global settings for Extras tooltips<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Widget not available on multisite installations<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Infinite scroll breaks when using multiple widgets on same page<\\/li>\\n<li>Fixed: Parallax Background \\u2014 Conflict with Anywhere Elementor Pro featured image background<\\/li>\\n<li>Tweak: Parallax Background \\u2014 requestAnimationFrame method for better performance<\\/li>\\n<li>Tweak: Buttons \\u2014 Rename text align label<\\/li>\\n<li>Tweak: Update nicons font<\\/li>\\n<\\/ul>\\n<h4> 1.7.4 <\\/h4>\\n<ul>\\n<li>Fixed: Gallery Extra \\u2014 Custom link broken and attributes not added<\\/li>\\n<\\/ul>\\n<h4> 1.7.3 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Column vertical alignment controls for carousel<\\/li>\\n<li>Added: Timeline \\u2014  Color controls for post title and excerpt<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Carousel rows number control not impacting preview<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Avatar vertical alignment on stretched media content<\\/li>\\n<li>Fixed: Sticky Elements \\u2014 Incorrect spacer height<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Improve editing flow by with advanced controls conditioning<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Controls position<\\/li>\\n<li>Tweak: Sticky Elements \\u2014 Remove popover from group control<\\/li>\\n<li>Tweak: Parallax Elements \\u2014 Remove popover from group control<\\/li>\\n<\\/ul>\\n<h4> 1.7.2 <\\/h4>\\n<ul>\\n<li>Added: Gallery Slider \\u2014 Overlay captions for preview and thumbnails<\\/li>\\n<li>Added: Gallery Slider \\u2014 Controls for caption effects, layout and hover properties<\\/li>\\n<li>Added: Gallery Slider \\u2014 Controls for active thumbs caption<\\/li>\\n<li>Fixed: Buttons \\u2014 Removed popover control on effects<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 Improved carousel adapt on preview resize<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 Improved thumbnails grid<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 Better controls for stacking and position of preview<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 Replace background color with background control for preview captions and overlay<\\/li>\\n<li>Tweak: Gallery Slider + Gallery Extra \\u2014 Better BEM classes<\\/li>\\n<\\/ul>\\n<h4> 1.7.1 <\\/h4>\\n<ul>\\n<li>Added: Gallery Extra \\u2014 Caption horizontal and vertical alignment and hover effects<\\/li>\\n<li>Added: Gallery Extra \\u2014 Ratio and alignment controls to masonry layout<\\/li>\\n<li>Added: Gallery Extra \\u2014 New border and border radius controls for captions<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Bring image to front when hovered<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Images not displaying on infinite load on iOS Safari and Chrome<\\/li>\\n<li>Tweak: Image Comparison \\u2014 Force override of modified image max-width attribute<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Added extra classes to media elements<\\/li>\\n<\\/ul>\\n<h4> 1.7.0 <\\/h4>\\n<ul>\\n<li>Added: Gallery Extra \\u2014 Masonry layout with mixed mode<\\/li>\\n<li>Added: Gallery Extra \\u2014 Tilt effect<\\/li>\\n<li>Added: Gallery Extra \\u2014 Caption horizontal and vertical alignment and hover effects<\\/li>\\n<li>Added: Gallery Extra \\u2014 Overlay, caption and image transition controls<\\/li>\\n<li>Added: Gallery Extra \\u2014 Overlay blend mode control<\\/li>\\n<li>Added: Gallery Extra \\u2014 Image scale controls for default and hover states<\\/li>\\n<li>Added: Gallery Extra \\u2014 Overlay margin controls for default and hover states<\\/li>\\n<li>Added: Gallery Extra \\u2014 Manual mode that allows entering of every image manually and linking it to any URL<\\/li>\\n<li>Added: Inline SVG widget<\\/li>\\n<li>Added: Posts Extra \\u2014 Controls to disable linking for post title, media and terms<\\/li>\\n<li>Added: Posts Extra \\u2014 Control to select default applied filter for filter bar<\\/li>\\n<li>Added: Timeline \\u2014 New controls for post title typography and spacing, post excerpt typography and padding<\\/li>\\n<li>Added: Image Comparison \\u2014 Image size control<\\/li>\\n<li>Added: New css transition control for Gallery Extra, Gallery Slider, Hotspots, Posts Extra, Timeline, Table and Inline SVG widgets<\\/li>\\n<li>Added: HTML5 Video \\u2014 M4V format support<\\/li>\\n<li>Added: Devices \\u2014 M4V format support for video<\\/li>\\n<li>Fixed: Buttons \\u2014 Flicker on flip effect<\\/li>\\n<li>Fixed: Timeline \\u2014 CSS class conflict<\\/li>\\n<li>Fixed: Table \\u2014 ID and class don\'t apply to header<\\/li>\\n<li>Tweak: Improved Elementor 1.9 compatibility for Extras group controls<\\/li>\\n<li>Tweak: Update TweenMax to latest version (1.20.2)<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Simplified CSS<\\/li>\\n<li>Tweak: Unfold \\u2014 Disconnect button and content from control alignment logic<\\/li>\\n<\\/ul>\\n<h4> 1.6.3 <\\/h4>\\n<ul>\\n<li>Fixed: Breadcrumbs \\u2014 Display correctly when used within an Elementor library template<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Condition terms separator<\\/li>\\n<li>Tweak: Breadcrumbs \\u2014 Avoid naming conflict with Elementor Pro widget<\\/li>\\n<\\/ul>\\n<h4> 1.6.2 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 New autoplay, autoheight and fade effect controls<\\/li>\\n<li>Added: Posts Extra \\u2014 &quot;Top&quot; option to media position on horizontal layout<\\/li>\\n<li>Added: Posts Extra \\u2014 Allowed media to be positioned horizontally on 2 columns layouts<\\/li>\\n<li>Added: Posts Extra \\u2014 New border controls for media<\\/li>\\n<li>Added: Table \\u2014 Allow table responsive behaviour to be turned off<\\/li>\\n<li>Tweak: Buttons \\u2014 Default button content alignment to justify<\\/li>\\n<li>Fix: Timeline \\u2014 Potential fatal error<\\/li>\\n<li>Fix: Posts Extra \\u2014 Post media position controls conditions<\\/li>\\n<li>Fix: Buttons \\u2014 Delay on transitioned properties<\\/li>\\n<li>Fix: Posts Extra \\u2014 Wrong tablet breakpoint set for number of columns<\\/li>\\n<li>Fix: Parallax Background \\u2014 Remove initial background image once parallax is activated<\\/li>\\n<\\/ul>\\n<h4> 1.6.1 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Link author name and avatar to author posts pages<\\/li>\\n<li>Added: Posts Extra \\u2014 Read more link to excerpt<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Added separate hide option for Position for better UX <\\/li>\\n<li>Tweak: Posts Extra \\u2014 Improved position icons<\\/li>\\n<\\/ul>\\n<h4> 1.6.0 <\\/h4>\\n<ul>\\n<li>New Widget \\u2014 Posts Extra - Create ANY layout for posts with masonry, infinite load, filtering and custom post type support. Works only with Elementor Pro<\\/li>\\n<li>Tweak: Breadcrumbs \\u2014 Added horizontal position and text alignment controls<\\/li>\\n<li>Tweak: Buttons \\u2014 Improved CSS and better alignment and stacking options<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Error outputting separator<\\/li>\\n<li>Fixed: Buttons \\u2014 Transition on button content when effects are turned on<\\/li>\\n<\\/ul>\\n<h4> 1.5.6 <\\/h4>\\n<ul>\\n<li>Fixed: Parallax Background \\u2014 Replaced parallax class name to avoid future conflicts<\\/li>\\n<li>Fixed: Timeline \\u2014 Remove flex from left aligned timeline and allow image spacing for horizontal layouts<\\/li>\\n<li>Fixed: PHP fatal error<\\/li>\\n<li>Tweak: Unfold \\u2014 Switched Settings with Content sections in editor for better UX<\\/li>\\n<\\/ul>\\n<h4> 1.5.5 <\\/h4>\\n<ul>\\n<li>Added: Buttons \\u2014 Inline editing<\\/li>\\n<li>Added: Breadcrumbs \\u2014 Inline editing<\\/li>\\n<li>Added: Circle Progress \\u2014 Inline editing<\\/li>\\n<li>Added: Hotspots \\u2014 Inline editing<\\/li>\\n<li>Added: Image Comparison \\u2014 Inline editing<\\/li>\\n<li>Added: Table \\u2014 Inline editing<\\/li>\\n<li>Added: Text Divider \\u2014 Inline editing<\\/li>\\n<li>Added: Timeline \\u2014 Inline editing<\\/li>\\n<li>Added: Unfold \\u2014 Inline editing<\\/li>\\n<li>Fixed: Tooltips \\u2014 Error &quot;size&quot; of undefined appears for delay_in in some cases<\\/li>\\n<li>Fixed: Unfold \\u2014 Issue that resulted in wrong calculation of unfolded height<\\/li>\\n<li>Tweak: Default to text cursor for text where inline editing is available<\\/li>\\n<\\/ul>\\n<h4> 1.5.4 <\\/h4>\\n<ul>\\n<li>Added: HTML5 Video \\u2014 Option to end video at last frame<\\/li>\\n<li>Tweak: HTML5 Video \\u2014 Removed auto pausing when interacting with progress bar<\\/li>\\n<\\/ul>\\n<h4> 1.5.3 <\\/h4>\\n<ul>\\n<li>Fixed: Unfold \\u2014 Content folds back automatically when scrolling on mobile browsers that vertically resize the viewport<\\/li>\\n<\\/ul>\\n<h4> 1.5.2 <\\/h4>\\n<ul>\\n<li>Added: Gallery Extra \\u2014 Allow gallery navigation in lightbox<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Image box shadow not applying<\\/li>\\n<li>Fixed: Buttons \\u2014 Issue with transition delays on buttons without effects<\\/li>\\n<\\/ul>\\n<h4> 1.5.1 <\\/h4>\\n<ul>\\n<li>Added: Table \\u2014 Control to show header on mobile as a block or a column<\\/li>\\n<li>Added: Table \\u2014 Border control for table rows<\\/li>\\n<li>Added: Table \\u2014 Option to automatically try to fetch correct headers for mobile with override possibility<\\/li>\\n<li>Added: Table \\u2014 Control to set width for mobile headers<\\/li>\\n<li>Tweak: Table \\u2014 Remove column rules from mobile<\\/li>\\n<li>Tweak: Table \\u2014 Removed first \\/ last child border rules from mobile<\\/li>\\n<li>Tweak: Table \\u2014 Added pointer cursor on sortable header cells<\\/li>\\n<li>Tweak: Table \\u2014 Moved padding to text for better handling of responsive layout and removed negative margin technique<\\/li>\\n<li>Tweak: Table \\u2014 Responsive cells and header cells padding controls<\\/li>\\n<li>Tweak: Table \\u2014 Move cell header control to top<\\/li>\\n<li>Tweak: Table \\u2014 Added option to hide headers completely on mobile<\\/li>\\n<li>Tweak: Table \\u2014 Hide mobile headers that have no content<\\/li>\\n<li>Tweak: Sticky \\u2014 Set default z-index to 1 for stickable elements<\\/li>\\n<li>Fixed: Image Comparison \\u2014 Separator not showing<\\/li>\\n<li>Fixed: Image Comparison \\u2014 Remove space between images and widget container<\\/li>\\n<li>Fixed: Table \\u2014 PHP Warning when allowing empty on repeater fields<\\/li>\\n<li>Fixed: Table \\u2014 Width and alignment not working<\\/li>\\n<li>Fixed: Table \\u2014 Added missing custom class and id from markup<\\/li>\\n<\\/ul>\\n<h4> 1.5.0 <\\/h4>\\n<ul>\\n<li>New Widget: Table<\\/li>\\n<li>Fixed: Prefix CSS helper classes to avoid potential conflicts<\\/li>\\n<\\/ul>\\n<h4> 1.4.0 <\\/h4>\\n<ul>\\n<li>New: Buttons Effects<\\/li>\\n<li>Added: Breadcrumbs \\u2014 Control to manually specify which post or page to generate breadcrumbs for<\\/li>\\n<li>Fixed: Devices \\u2014 Horizontal orientation image not visible<\\/li>\\n<\\/ul>\\n<h4> 1.3.1 <\\/h4>\\n<ul>\\n<li>Fixed: Parallax Background \\u2014 Wrong position when loading page off viewport<\\/li>\\n<li>Fixed: Timeline \\u2014 Enlarged points not aligned to line on tablet and mobile<\\/li>\\n<li>Added: Timeline \\u2014 Responsive controls for point size and icon size<\\/li>\\n<\\/ul>\\n<h4> 1.3.0 <\\/h4>\\n<ul>\\n<li>Added: New Widget! \\u2014 HTML5 Video<\\/li>\\n<li>Added: Devices \\u2014 Added HTML5 Video controls<\\/li>\\n<li>Added: Devices \\u2014 Added option to stretch the video to fit into the device screen<\\/li>\\n<li>Added: Devices \\u2014 Added option to choose wether or not to stop the video when leaving viewport<\\/li>\\n<li>Added: Timeline \\u2014 Hover properties for points<\\/li>\\n<li>Added: Timeline \\u2014 More style override options for each card<\\/li>\\n<li>Added: Gallery Slider \\u2014 More responsive controls for preview position and spacing<\\/li>\\n<li>Fixed: Timeline \\u2014 Removed unnecessary z-index from cards<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Preview spacing doesn\'t work on mobile when the layout is vertical<\\/li>\\n<li>Fixed: Devices \\u2014 Replaced SVG IDs with classes to avoid code invalidation<\\/li>\\n<li>Fixed: Circle Progress \\u2014 Canvas distorted on responsive<\\/li>\\n<li>Fixed: Hotspots \\u2014 Links concatenating from one repeater field to another<\\/li>\\n<li>Fixed: Parallax Background \\u2014 Images move up after scrolling up and down multiple times<\\/li>\\n<li>Fixed: Parallax Background \\u2014 Background position is off when section Stretch is turned on<\\/li>\\n<li>Fixed: Hotspots \\u2014 Links inside tooltips appear outside of the tooltip<\\/li>\\n<li>Tweak: Timeline \\u2014 Changed &quot;Size Ratio&quot; name to &quot;Scale&quot;<\\/li>\\n<li>Tweak: Gallery Extras \\u2014 Bring 3D items to front on hover<\\/li>\\n<li>Tweak: Hotspots \\u2014 Moved tooltip content outside hotspot to avoid invalid nodes<\\/li>\\n<li>Tweak: Hotspots \\u2014 Don\'t activate tooltips that have no content set<\\/li>\\n<\\/ul>\\n<h4> 1.2.5 <\\/h4>\\n<ul>\\n<li>Tweak: Replaced text align icons with horizontal align icons where appropriate<\\/li>\\n<li>Fixed: Sticky elements not bottoming out correctly when using custom parent selector<\\/li>\\n<li>Fixed: Removing unstick for any breakpoint would break sticky functionality<\\/li>\\n<\\/ul>\\n<h4> 1.2.4 <\\/h4>\\n<ul>\\n<li>Added: Sticky \\u2014 Custom selector for sticky parent to allow for elements to stick in any parent element<\\/li>\\n<li>Tweak: Timeline \\u2014 Responsive padding controls<\\/li>\\n<li>Tweak: Timeline \\u2014 Refactoring and improved performance and accuracy on progress bar<\\/li>\\n<li>Tweak: Image Comparison \\u2014 Adjust spacing method for labels and vertical alignment improvements<\\/li>\\n<li>Tweak: Image Comparison \\u2014 Allow for widget border radius control to affect images<\\/li>\\n<li>Fixed: Parallax Background \\u2014 Scroll breaks on mobile when hiding a parallaxed section<\\/li>\\n<li>Fixed: Timeline \\u2014 Cards not animating when first in view<\\/li>\\n<li>Fixed: Timeline \\u2014 Content wrapper present even if no card content is set<\\/li>\\n<\\/ul>\\n<h4> 1.2.3 <\\/h4>\\n<ul>\\n<li>Fixed: Parallax Background \\u2014 Section background not reverting after parallax turned on again<\\/li>\\n<li>Fixed: Parallax Background \\u2014 Calculating wrong dimensions when using Elementor JS stretch option<\\/li>\\n<li>Fixed: Issue where updating Elementor when Extras is active would result in an error<\\/li>\\n<li>Tweak: Hotspots \\u2014 Adjusted default tooltip width<\\/li>\\n<\\/ul>\\n<h4> 1.2.2 <\\/h4>\\n<ul>\\n<li>Fixed: Heading Extra \\u2014 Complete html support<\\/li>\\n<\\/ul>\\n<h4> 1.2.1 <\\/h4>\\n<ul>\\n<li>Fixed: Heading Extra \\u2014 Gradient would show only for the first line<\\/li>\\n<li>Fixed: Parallax Background \\u2014 When using padding on sections, image position calculation would not be correct<\\/li>\\n<\\/ul>\\n<h4> 1.2.0 <\\/h4>\\n<ul>\\n<li>Added: New Feature! \\u2014 Parallax Background \\u2014 Now you can parallax section backgrounds and have it move up, down, left or right while scrolling<\\/li>\\n<li>Added: New Widget! \\u2014 Unfold \\u2014 Lets you hide content and reveal it on demand<\\/li>\\n<li>Added: New Widget! \\u2014 Breadcrumbs<\\/li>\\n<li>Added: Parallax Elements \\u2014 Allow to select whether to parallax an element relative to its own position or the middle of the viewport<\\/li>\\n<li>Added: Hotspots \\u2014 Ability to add links to hotspots if tooltips are triggered on hover<\\/li>\\n<li>Added: Tooltips \\u2014 Added left and right tooltips for both Hotspots and Button Groups<\\/li>\\n<li>Added: Tooltips \\u2014 Better handling of repositioning tooltips when they flow outside of the viewport<\\/li>\\n<li>Added: Tooltips \\u2014 Ability to override tooltip position for each button of hotspot individually<\\/li>\\n<li>Added: Heading Extra \\u2014 Text fill now supports clipped images<\\/li>\\n<li>Tweak: Heading Extra \\u2014 Allow to have both text shadow and long shadow on the same text<\\/li>\\n<li>Tweak: Text Divider \\u2014 Responsive alignment and spacing controls<\\/li>\\n<li>Tweak: Text Divider \\u2014 Proper horizontal alignment of text and separators<\\/li>\\n<li>Fixed: Heading Extra \\u2014 Multiple z-index related issues<\\/li>\\n<li>Fixed: Parallax Elements \\u2014 Fix issue where elements would jump when scrolling<\\/li>\\n<\\/ul>\\n<h4> 1.1.4 <\\/h4>\\n<ul>\\n<li>Added: Sticky sections!<\\/li>\\n<li>Added: Sticky \\u2014 New controls to unstick for mobile and tablet<\\/li>\\n<li>Added: Parallax Elements \\u2014 New controls to set different speeds for different breakpoints<\\/li>\\n<li>Added: Gallery Slider \\u2014 Links on images and support for the new Elementor lightbox feature<\\/li>\\n<li>Tweak: Improved shortcode support for all widgets, especially tooltips<\\/li>\\n<li>Tweak: Parallax Elements \\u2014 Greatly improved performance for parallaxed items<\\/li>\\n<li>Tweak: Parallax Elements \\u2014 Changed speed control logic to allow for reverse parallax<\\/li>\\n<li>Tweak: Created custom group controls for Sticky and Parallax features<\\/li>\\n<li>Fixed: Removed z-index from sticky elements to allow z-index setting from Elementor controls<\\/li>\\n<li>Fixed: Gallery Extras \\u2014 Some styling controls were conditioned by the &quot;Link to&quot; control<\\/li>\\n<li>Fixed: Removed potentially buggy call to Elementor class<\\/li>\\n<\\/ul>\\n<h4> 1.1.3 <\\/h4>\\n<ul>\\n<li>Tweak: Devices \\u2014 Refactored and cleaned up code for editor functionality<\\/li>\\n<li>Tweak: Gallery Extra \\u2014 Moved distance control after parallax controls<\\/li>\\n<li>Added: Controls to add parallax to any widget or column<\\/li>\\n<li>Added: Global control for turning off parallax functionality for tablet and mobile<\\/li>\\n<li>Added: Gallery Extra \\u2014 Control for settings horizontal overlap of images<\\/li>\\n<li>Added: Image Comparison \\u2014 Separator between images<\\/li>\\n<li>Added: Global \\u2014 Implemented the new Text Shadow controls for all widgets<\\/li>\\n<li>Added: Button Groups \\u2014 Responsive control of spacing for stacked buttons<\\/li>\\n<li>Fixed: Devices \\u2014 Issue where frames would not properly change in editor mode<\\/li>\\n<li>Fixed: Changed license page capability to \'manage_options\'<\\/li>\\n<li>Fixed: Compatibility with Elementor 1.6<\\/li>\\n<\\/ul>\\n<h4> 1.1.2 <\\/h4>\\n<ul>\\n<li>Fixed: Class namespace change in Elementor Pro 1.5.7 resulting in fatal error<\\/li>\\n<\\/ul>\\n<h4> 1.1.1 <\\/h4>\\n<ul>\\n<li>Fixed: Devices \\u2014 Overlay not visible for laptop and desktop<\\/li>\\n<li>Fixed: Timeline \\u2014 PHP empty function fatal error<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Width remained 50% even if vertical layout selected<\\/li>\\n<\\/ul>\\n<h4> 1.1.0 <\\/h4>\\n<ul>\\n<li>Added: New Widget! \\u2014 Gallery Extra \\u2014 We\'ve taken aside the parallax functionality and created a whole new widget with nots of posibilities.<\\/li>\\n<li>Added: New Widget! \\u2014 Gallery Slider \\u2014 A gallery layout with inline preview.<\\/li>\\n<li>Added: New Feature! \\u2014 Button tooltips \\u2014 You can now use the Button Groups widget to add buttons with tooltips.<\\/li>\\n<li>Added: New Feature! \\u2014 Timeline \\u2014 Integration with Woocommerce products.<\\/li>\\n<li>Added: New Feature! \\u2014 Hotspots \\u2014 Added support for icons inside hotspots.<\\/li>\\n<li>Added: New Feature! \\u2014 Hotspots \\u2014 Ability to set the delay for both entrance close animations.<\\/li>\\n<li>Added: Circle Progress \\u2014 Control too choose start angle for the circle progress.<\\/li>\\n<li>Added: Devices \\u2014 Support for multiple video formats<\\/li>\\n<li>Added: Timeline \\u2014 Add featured images from separate control.<\\/li>\\n<li>Added: Elementor Portfolio Widget \\u2014 Speed control for parallax feature.<\\/li>\\n<li>Added: Timeline \\u2014 Turn on and off for excerpts, content, title and featured image.<\\/li>\\n<li>Fixed: Image Comparison \\u2014 Handle now goes all the way until the end of the image.<\\/li>\\n<li>Fixed: Timeline \\u2014 Date color wasn\'t changing properly.<\\/li>\\n<li>Fixed: Issue where disabling and changing license was not possible.<\\/li>\\n<li>Fixed: Sticky - Issue where in preview mode wrong height of the element was calculated.<\\/li>\\n<li>Fixed: Image Gallery \\u2014 Issue with displaying on Firefox.<\\/li>\\n<li>Fixed: Image Comparison \\u2014 Handle jumps when using multiple widgets on same page.<\\/li>\\n<li>Fixed: Timeline \\u2014 Scheme style override issue for points.<\\/li>\\n<li>Fixed: Devices \\u2014 Video would not play on iOS devices<\\/li>\\n<\\/ul>\\n<h4> 1.0.5 <\\/h4>\\n<ul>\\n<li>Added: Button Groups \\u2014 Box shadow control.<\\/li>\\n<li>Fixed: Ensured compatibility with other jquery appear plugins.<\\/li>\\n<li>Fixed: Issue where disabling and changing license was not possible.<\\/li>\\n<\\/ul>\\n<h4> 1.0.4 <\\/h4>\\n<ul>\\n<li>Added: Added translation support<\\/li>\\n<li>Fixed: Devices \\u2014 Issue where controls would always display as a white rectangular shape.<\\/li>\\n<\\/ul>\\n<h4> 1.0.3 <\\/h4>\\n<ul>\\n<li>Fixed: Image Galleries \\u2014 Issue where galleries with no links would break the layout<\\/li>\\n<li>Fixed: Hotspots \\u2014 When using multiple hotspots widgets on the same page additional widgets would show the first widget\'s tooltips instead of their own<\\/li>\\n<\\/ul>\\n<h4> 1.0.2 <\\/h4>\\n<ul>\\n<li>Added: Hotspots \\u2014 New controls: text align, padding, border and typography<\\/li>\\n<li>Fixed: Hotspots \\u2014 Hide arrow control not working<\\/li>\\n<li>Fixed: Hotspots \\u2014 Issue where tooltips don\'t remain open on click trigger option and thus preventing clicking off links inside tooltips<\\/li>\\n<li>Fixed: Button Groups \\u2014 Replaced custom border controls with border group control<\\/li>\\n<li>Fixed: Extended Heading \\u2014 Compability with Elementor 1.5<\\/li>\\n<li>Fixed: Extended Heading \\u2014 Heading size not working<\\/li>\\n<li>Fixed: Image Comparison \\u2014 Issue where colors of labels would not change colors for printed templates<\\/li>\\n<\\/ul>\\n<h4> 1.0.1 <\\/h4>\\n<ul>\\n<li>Fixed: Image Comparison \\u2014 Issue where dragging the handle on mobile would not work<\\/li>\\n<\\/ul>\\n<h4> 1.0.0 <\\/h4>\\n<ul>\\n<li>Added: New &quot;Timeline&quot; widget with posts support for Elementor Pro<\\/li>\\n<li>Added: Image Comparison \\u2014 Different colors for both labels<\\/li>\\n<li>Tweak: Image Comparison \\u2014 Moved alignment &amp; scaling options to widget wrapper<\\/li>\\n<li>Tweak: Aligned default widgets colors to selected color scheme<\\/li>\\n<li>Tweak: Removed sticky from sections temporarily<\\/li>\\n<li>Tweak: Removed parallax scrolling from section backgrounds<\\/li>\\n<li>Tweak: Button Groups \\u2014 Reorganized repeater controls under tabs<\\/li>\\n<li>Tweak: Full compatibility with global color schemes for all widgets<\\/li>\\n<li>Tweak: Hotspots \\u2014 Reorganized repeater controls under tabs<\\/li>\\n<li>Fixed: Timeline \\u2014 Issue where arrow colors would not apply<\\/li>\\n<li>Fixed: Extended Heading \\u2014 Entrace animation hides the shadow when animation is complete<\\/li>\\n<li>Fixed: Devices \\u2014 Border type not present in hover state for video controls<\\/li>\\n<li>Fixed: Image Comparison \\u2014 Removed small space after widget<\\/li>\\n<li>Fixed: Hotspots \\u2014 Syntax error in JS template<\\/li>\\n<li>Fixed: Hotspots \\u2014 JS error when adding new hotpots<\\/li>\\n<li>Fixed: Hotspots \\u2014 Tooltips z-index issue<\\/li>\\n<li>Fixed: Hotspots \\u2014 Bottom tooltips animated down instead of up<\\/li>\\n<li>Fixed: Hotspots \\u2014 Html being added as string when hotspots are triggered through the open_editor hook<\\/li>\\n<li>Fixed: Hotspots \\u2014 Tooltips not editable immediately when dragged into preview<\\/li>\\n<li>Fixed: Image Comparison \\u2014 images are not set to occupy full width<\\/li>\\n<\\/ul>\\n<h4> 0.1.2 <\\/h4>\\n<ul>\\n<li>Added: Hotspots \\u2014 Rewrote code entirely to allow for preview mode support, customisation of tooltips and faster rendering<\\/li>\\n<li>Added: Circle progress \\u2014 Better handling of value suffix<\\/li>\\n<li>Fixed: Scripts dependencies<\\/li>\\n<li>Fixed: Devices \\u2014 Issue where global colors where used instead of skins<\\/li>\\n<li>Fixed: Various compatibility issues with the Elementor color scheme<\\/li>\\n<li>Fixed: Image Gallery Extension \\u2014 Styling issues when choosing to justify gallery items<\\/li>\\n<li>Fixed: Sticky Extension \\u2014 Sitcky offset would not preview correctly and sometimes having multiple sticky widgets would cause interference amongst them<\\/li>\\n<li>Fixed: Parallax Gallery \\u2014 Removed any kinds of transformation for odd children<\\/li>\\n<\\/ul>\\n<h4> 0.1.1 <\\/h4>\\n<ul>\\n<li>Fixed: Buttons groups \\u2014 Responsive alignment of buttons<\\/li>\\n<li>Added: Buttons groups \\u2014 option to stack buttons on tablet or mobile<\\/li>\\n<\\/ul>\\n<h4> 0.1.0 <\\/h4>\\n<ul>\\n<li>Initial Private Beta<\\/li>\\n<\\/ul>\",\"installation\":\"<ol>\\n<li>Make sure Elementor is installed and active on your website<\\/li>\\n<li>Activate the plugin through the \'Plugins\' menu in WordPress<\\/li>\\n<li>Edit a page (or post) using Elementor<\\/li>\\n<li>Find and use the new widgets and extensions<\\/li>\\n<\\/ol>\"},\"banners\":{\"high\":\"https:\\/\\/shop.namogo.com\\/wp-content\\/uploads\\/edd\\/2019\\/09\\/Banner-2.2.png\",\"low\":\"https:\\/\\/shop.namogo.com\\/wp-content\\/uploads\\/edd\\/2019\\/09\\/Banner-2.2@05x.png\"},\"icons\":{\"1x\":\"https:\\/\\/shop.namogo.com\\/wp-content\\/uploads\\/2017\\/08\\/Logo@2x.png\",\"2x\":\"https:\\/\\/shop.namogo.com\\/wp-content\\/uploads\\/2017\\/08\\/Logo@2x.png\"},\"tested\":\"5.5.0\",\"compatibility\":\"a:1:{s:5:\\\"5.2.3\\\";a:1:{s:6:\\\"1.5.23\\\";a:3:{i:0;s:4:\\\"100%\\\";i:1;s:1:\\\"5\\\";i:2;s:1:\\\"5\\\";}}}\",\"stable_tag\":\"2.2.37\",\"license\":\"GPLv3 or later\",\"added\":\"2017-05-31\",\"description\":[\"<p>Extras is one of the first premium Wordpress plugin for Elementor. It extends its capability with many unique widgets and extensions that make Elementor even more powerful.<\\/p>\\n<h4> Copyright and licensing <\\/h4>\\n<p>Copyright (C) 2016-2019 Elementor Ltd.<\\/p>\\n<p>This program is free software: you can redistribute it and\\/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.<\\/p>\\n<p>This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.<\\/p>\\n<p>You should have received a copy of the GNU General Public License along with this program. If not, see <a href=\\\"https:\\/\\/www.gnu.org\\/licenses\\/\\\">https:\\/\\/www.gnu.org\\/licenses\\/<\\/a>.<\\/p>\\n<h4> Third Party Code <\\/h4>\\n<p>Extras for Elementor incorporates code from:<\\/p>\\n<ul>\\n<li><strong>jquery-circle-progress<\\/strong> v1.2.2, Copyright Rostyslav Bryzgunov Licenses: MIT Source: link <a href=\\\"http:\\/\\/kottenator.github.io\\/jquery-circle-progress\\/\\\">http:\\/\\/kottenator.github.io\\/jquery-circle-progress\\/<\\/a><\\/li>\\n<li><strong>jQuery appear plugin<\\/strong> v0.3.6, Copyright 2012 Andrey Sidorov Licenses: MIT Source: link <a href=\\\"https:\\/\\/github.com\\/morr\\/jquery.appear\\/\\\">https:\\/\\/github.com\\/morr\\/jquery.appear\\/<\\/a><\\/li>\\n<li><strong>LongShadow jQuery Plugin<\\/strong> v1.1.0, Copyright 2013 - 2016 Dang Van Thanh Licenses: MIT Source: link git:\\/\\/github.com\\/dangvanthanh\\/jquery.longShadow.git<\\/li>\\n<li><strong>HC-Sticky<\\/strong> v2.2.3, Copyright Some Web Media License: MIT Source: link <a href=\\\"https:\\/\\/github.com\\/somewebmedia\\/hc-sticky\\\">https:\\/\\/github.com\\/somewebmedia\\/hc-sticky<\\/a><\\/li>\\n<li><strong>jQuery Mobile<\\/strong> v1.4.3, Copyright 2010, 2014 jQuery Foundation, Inc. Licenses: jquery.org\\/license<\\/li>\\n<li><strong>jquery-visible<\\/strong>, Copyright 2012, Digital Fusion, License: <a href=\\\"http:\\/\\/teamdf.com\\/jquery-plugins\\/license\\/\\\">http:\\/\\/teamdf.com\\/jquery-plugins\\/license\\/<\\/a> Source: <a href=\\\"http:\\/\\/teamdf.com\\/jquery-plugins\\/license\\/\\\">http:\\/\\/teamdf.com\\/jquery-plugins\\/license\\/<\\/a><\\/li>\\n<li><strong>Parallax Background<\\/strong> v1.2, by Eren Suleymanoglu Licenses: MIT Source: link <a href=\\\"https:\\/\\/github.com\\/erensuleymanoglu\\/parallax-background\\\">https:\\/\\/github.com\\/erensuleymanoglu\\/parallax-background<\\/a><\\/li>\\n<li><strong>TableSorter<\\/strong> v2.0.5b, Copyright 2007 Christian Bach Licenses: Dual licensed under the MIT and GPL licenses Source: link <a href=\\\"http:\\/\\/tablesorter.com\\\">http:\\/\\/tablesorter.com<\\/a><\\/li>\\n<li><strong>Isotope<\\/strong> PACKAGED v3.0.6, Copyright 2017 Metafizzy License: GPLv3 Source: link <a href=\\\"http:\\/\\/isotope.metafizzy.co\\\">http:\\/\\/isotope.metafizzy.co<\\/a><\\/li>\\n<li><strong>Infinite Scroll<\\/strong> PACKAGED v3.0.2, Copyright 2017 Metafizzy License: GPLv3 Source: link <a href=\\\"https:\\/\\/infinite-scroll.com\\\">https:\\/\\/infinite-scroll.com<\\/a><\\/li>\\n<li><strong>Packery layout mode<\\/strong> PACKAGED v2.0.0 Copyright 2017 Metafizzy License: GPLv3 Source: link <a href=\\\"http:\\/\\/isotope.metafizzy.co\\\">http:\\/\\/isotope.metafizzy.co<\\/a><\\/li>\\n<li><strong>javascript-detect-element-resize<\\/strong> v0.5.3 Copyright (c) 2013 Sebasti\\u00e1n D\\u00e9cima License: MIT Source: link <a href=\\\"https:\\/\\/github.com\\/sdecima\\/javascript-detect-element-resize\\\">https:\\/\\/github.com\\/sdecima\\/javascript-detect-element-resize<\\/a><\\/li>\\n<li><strong>tilt.js<\\/strong> 1.2.1, Copyright (c) 2017 Gijs Rog\\u00e9 License: MIT Source: link <a href=\\\"https:\\/\\/github.com\\/gijsroge\\/tilt.js\\\">https:\\/\\/github.com\\/gijsroge\\/tilt.js<\\/a><\\/li>\\n<li><strong>CLNDR<\\/strong> v1.4.7, Copyright Kyle Stetz (github.com\\/kylestetz) License: MIT Source: link <a href=\\\"https:\\/\\/github.com\\/kylestetz\\/CLNDR\\\">https:\\/\\/github.com\\/kylestetz\\/CLNDR<\\/a><\\/li>\\n<li><strong>GMAP3 Plugin for jQuery<\\/strong> v7.2 Copyright DEMONTE Jean-Baptiste License: GPL-3.0+ Source: link <a href=\\\"http:\\/\\/gmap3.net\\\">http:\\/\\/gmap3.net<\\/a><\\/li>\\n<li><strong>Moment.js<\\/strong> v2.22.2 License: MIT Source: link <a href=\\\"https:\\/\\/github.com\\/moment\\/moment\\/\\\">https:\\/\\/github.com\\/moment\\/moment\\/<\\/a><\\/li>\\n<li><strong>Slidebars<\\/strong> v2 Copyright Adam Charles Smith License: MIT <a href=\\\"http:\\/\\/www.adchsm.com\\/slidebars\\/license\\/\\\">http:\\/\\/www.adchsm.com\\/slidebars\\/license\\/<\\/a> Source: link <a href=\\\"http:\\/\\/www.adchsm.com\\/slidebars\\/\\\">http:\\/\\/www.adchsm.com\\/slidebars\\/<\\/a><\\/li>\\n<li><strong>Splittext.js<\\/strong> Copyright (c) 2008-2016, GreenSock<\\/li>\\n<li><strong>Magnific Popup<\\/strong> v1.1.0 License: MIT Copyright 2016 Dmitry Semenov Soruce: link <a href=\\\"http:\\/\\/dimsemenov.com\\/plugins\\/magnific-popup\\/\\\">http:\\/\\/dimsemenov.com\\/plugins\\/magnific-popup\\/<\\/a><\\/li>\\n<\\/ul>\\n<h4> Important Links <\\/h4>\\n<p><a href=\\\"https:\\/\\/shop.namogo.com\\/docs\\/elementor-extras\\/getting-started\\/#update-official\\\">Updating Extras<\\/a>\\n<a href=\\\"https:\\/\\/shop.namogo.com\\/topic\\/elementor-extras\\/\\\">Documentation<\\/a>\\n<a href=\\\"https:\\/\\/shop.namogo.com\\/account\\/\\\">Your Account<\\/a>\\n<a href=\\\"https:\\/\\/shop.namogo.com\\/account\\/support\\/\\\">Support<\\/a>\\n<a href=\\\"https:\\/\\/shop.namogo.com\\/docs\\/elementor-extras\\/frequently-asked-questions\\/\\\">FAQ<\\/a><\\/p>\"],\"changelog\":[\"<h4> 2.2.37 <\\/h4>\\n<ul>\\n<li>Added: Scroll Indicator \\u2014 Allow scroll offset option for all skins<\\/li>\\n<li>Fixed: Gallery \\u2014 Vertical spacing control not applying spacing when images are not linked<\\/li>\\n<li>Fixed: Posts \\u2014 Pagination bug with WP 5.5<\\/li>\\n<li>Tweak: Search Form \\u2014 Allow search without query<\\/li>\\n<\\/ul>\\n<h4> 2.2.36 <\\/h4>\\n<ul>\\n<li>Tweak: Revert support for Elementor Pro to 2.8.0<\\/li>\\n<\\/ul>\\n<h4> 2.2.35 <\\/h4>\\n<ul>\\n<li>Fixed: Compatibility with Elementor 3.0<\\/li>\\n<li>Fixed: Search Form \\u2014 CSS height align bug with expand skin<\\/li>\\n<li>Increased minimum required Elementor version to 3.0<\\/li>\\n<li>Increased minimum required Elementor Pro version to 3.0<\\/li>\\n<\\/ul>\\n<h4> 2.2.34 <\\/h4>\\n<ul>\\n<li>Fixed: Posts \\u2014 Temporary fix for posts pagination due to bug introduced in Wordpress 5.5<\\/li>\\n<li>Fixed: Posts \\u2014 Carousel RTL arrows misplacement<\\/li>\\n<li>Fixed: Display Conditions \\u2013 Day of week condition not including timezone<\\/li>\\n<li>Fixed: Display Conditions \\u2013 Wrong index for Sunday<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Panel header being printed even if no title or close enabled<\\/li>\\n<li>Fixed: Search Form \\u2014 Taxonomy term not excluded if taxonomy has only one term<\\/li>\\n<li>Fixed: Table \\u2014 Inline editing bugs<\\/li>\\n<\\/ul>\\n<h4> 2.2.33 <\\/h4>\\n<ul>\\n<li>Added: Display Conditions \\u2014 Support for ACF options page fields<\\/li>\\n<li>Fixed: Lightbox in post skin slides through all instances inside loop<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Edge case width calculation bug<\\/li>\\n<li>Fixed: Offcanvas \\u2014 CSS overriding default body margin and padding<\\/li>\\n<li>Fixed: Timeline \\u2014 Dynamic tags support in default skin not working<\\/li>\\n<li>Fixed: Search Form \\u2014 Safari back button keeps form fields disabled<\\/li>\\n<\\/ul>\\n<h4> 2.2.32 <\\/h4>\\n<ul>\\n<li>Added: Toggle Element \\u2014 Show element by url hash<\\/li>\\n<li>Added: Toggle Element \\u2014 Change url hash when toggling elements<\\/li>\\n<li>Added: Posts Extra \\u2014 Option to try to force equal height on post skins<\\/li>\\n<li>Added: Audio Player \\u2014 Support for m4a files<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Added missing prefix and suffix fields to translatable fields<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Edge case js error with empty slider controls size values<\\/li>\\n<li>Fixed: Swiper destroy on element remove fails with multiple instances on page<\\/li>\\n<li>Fixed: Slide Menu \\u2014 Sibling submenu items showing behind current active submenu<\\/li>\\n<li>Fixed: Slide Menu \\u2013 Removed default browser padding for ul<\\/li>\\n<li>Fixed: Search Form \\u2014 Edge case where restrictions not being passed if page is loaded using back browser button<\\/li>\\n<\\/ul>\\n<h4> 2.2.31 <\\/h4>\\n<ul>\\n<li>Added: Toggle Element \\u2014 Option to enable refreshing elements inside template when toggling<\\/li>\\n<li>Fixed: Toggle Element \\u2014 Recalculate swipers inside templates<\\/li>\\n<li>Fixed: Ensure loop template data attributes<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Compatibility with usage inside looped template<\\/li>\\n<li>Fixed: Circle Progress \\u2013 Decimal point applied to all widget instances<\\/li>\\n<li>Fixed: Offcanvas \\u2014 JS error on Offcanvas anchor navigation on links with dynamic tags enabled<\\/li>\\n<li>Tweak: Remove focus outline from swiper arrows<\\/li>\\n<li>Tweak: Circle Progress \\u2014 Remove limit for max value when using absolute<\\/li>\\n<\\/ul>\\n<h4> 2.2.30 <\\/h4>\\n<ul>\\n<li>Fixed: Gallery Slider \\u2014 Active thumbnail index for multiple widgets on same page<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Remove buggy auto-height control for thumbnails carousel<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Bug with overlay and reveal animations on same page<\\/li>\\n<li>Fixed: Audio Player \\u2013 Reset user agent padding on playlist<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Exclude em and rem from terms typography control<\\/li>\\n<\\/ul>\\n<h4> 2.2.29 <\\/h4>\\n<ul>\\n<li>Added: Gallery Slider \\u2014 Possibility to add multiple caption types<\\/li>\\n<li>Added: Gallery Slider \\u2014 Ken Burns effect option with. advanced controls<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Missing preview captions text align control<\\/li>\\n<li>Fixed: Display Conditions \\u2014 ACF Choice field check fails<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 Remove fade effect on thumbnails carousel<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 Condition image fit control to work only for slide effect<\\/li>\\n<\\/ul>\\n<h4> 2.2.28 <\\/h4>\\n<ul>\\n<li>Added: Toggle Element \\u2014 Padding control for labels<\\/li>\\n<li>Added: Breadcrumbs \\u2014 Control to disable structured data attributes<\\/li>\\n<li>Added: Gallery Slider, Gallery Extra, Switcher \\u2014 Option to disable slideshow in lightbox<\\/li>\\n<li>Added: Posts \\u2014 Wordpress filters for post and post wrapper classes<\\/li>\\n<li>Added: Video Player \\u2014 Control to remove Chrome\'s download option in fullscreen mode<\\/li>\\n<li>Fixed: Gallery Slider, Gallery Extra, Random Image, Switcher \\u2014 Missing lightbox captions<\\/li>\\n<li>Fixed: Toggle Element \\u2014 Low CSS specificity for ul and li elements causing themes override<\\/li>\\n<li>Fixed: Popup \\u2014 Exit intent not working correctly<\\/li>\\n<li>Tweak: Updated translations .pot file<\\/li>\\n<\\/ul>\\n<h4> 2.2.27 <\\/h4>\\n<ul>\\n<li>Added: Display Conditions \\u2014 Shortcode output condition<\\/li>\\n<li>Added: Display Conditions \\u2014 Post meta condition<\\/li>\\n<li>Added: Posts Extra \\u2014 Control to stack filters responsively<\\/li>\\n<li>Added: Posts Extra \\u2014 Option to trigger a window resize events after each carousel slide to fix displaying issues of certain widgets when using custom post skins<\\/li>\\n<li>Added: Gallery Slider \\u2014 Option to contain centre fit images inside preview slider when custom height is set<\\/li>\\n<li>Fixed: Incorrect Breadcrumbs and Slide Menu WPML integration<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Filters not changing active class when using masonry<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Load more button not hidden when no pagination available<\\/li>\\n<li>Fixed: Video Player \\u2014 Trigger window resize to position correctly elements with motion effects enabled after the video is loaded<\\/li>\\n<li>Fixed: Global Tooltips \\u2014 Removed label_block from slider control that broke controls<\\/li>\\n<\\/ul>\\n<h4> 2.2.26 <\\/h4>\\n<ul>\\n<li>Fixed: Posts Extra \\u2014 Carousel pagination selector breaks pagination when multiple carousels on same page<\\/li>\\n<li>Fixed: Search Form \\u2014 Submit button icon spacing control bug<\\/li>\\n<li>Fixed: Search Form \\u2014 Beautified option fields icons not displaying properly<\\/li>\\n<li>Fixed: Gallery Slider \\u2013 Figure line height causing caption display issues<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Distance control for thumbnails carousel arrows not working<\\/li>\\n<\\/ul>\\n<h4> 2.2.25 <\\/h4>\\n<ul>\\n<li>Added: Display Conditions \\u2014 If no condition value is set check to see if field is set to any value<\\/li>\\n<li>Added: Gallery Slider \\u2014 Options to set max. width and horizontal and vertical alignment for thumbnails carousel<\\/li>\\n<li>Added: Gallery Slider \\u2014 Option to set custom height for preview slides<\\/li>\\n<li>Added: Popup \\u2014 Option to disable refreshing frontend functionality for elements inside the popup<\\/li>\\n<li>Added: Offcanvas \\u2014 Option to disable refreshing frontend functionality for elements inside the panel<\\/li>\\n<li>Added: Calendar \\u2014 Typography control for header week days<\\/li>\\n<li>Added: Google Map \\u2014 Option to set zoom level when navigating to a location<\\/li>\\n<li>Fixed: Bug where one swiper slider\'s arrows control all swiper sliders on the same page<\\/li>\\n<li>Fixed: Calendar \\u2014 Separator style for header not working<\\/li>\\n<li>Fixed: Gallery \\u2014 Instagram lightbox not working for my photos<\\/li>\\n<li>Fixed: Gallery \\u2014 Instagram links bug for hashtag posts<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Filters with masonry enabled when two widgets on page breaks filtering<\\/li>\\n<li>Tweak: Circle Progress \\u2014 Allow 0 value to be shown<\\/li>\\n<\\/ul>\\n<h4> 2.2.24 <\\/h4>\\n<ul>\\n<li>Added: Gallery Slider \\u2014 Option to enable carousel on thumbnails<\\/li>\\n<li>Added: Posts Extra \\u2014 More swiper settings<\\/li>\\n<li>Fixed: Circle Progress \\u2014 Compatibility with display conditions<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Dynamic tag background styles<\\/li>\\n<li>Fixed: Don\'t include Elementor form widget in refreshable widgets due to reCaptcha reinitialisation uncaught error<\\/li>\\n<li>Fixed: Timeline \\u2014 Date entrance animation on left right and overlay alignments<\\/li>\\n<\\/ul>\\n<h4> 2.2.23 <\\/h4>\\n<ul>\\n<li>Added: Popup \\u2014 Margin control for close icon<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Instagram compatibility with new API changes<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Carousel compatibility with Elementor 2.9.4 swiper.js changes<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Allow -1 as posts per page value for specific query source<\\/li>\\n<li>Fixed: Display Conditions \\u2014 Use wp_timezone instead of timezone_string in case timezone is set as offset<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Filter post count style controls conditions<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Carousel remove deprecated Columns control<\\/li>\\n<li>Tweak: Google Map \\u2014 Convert description control from text to WYSIWYG type<\\/li>\\n<\\/ul>\\n<h4> 2.2.22 <\\/h4>\\n<ul>\\n<li>Fixed: Timeline \\u2014 Points and dates not showing when animate cards is on<\\/li>\\n<li>Fixed: Unfold \\u2014 Bug error showing button since last update<\\/li>\\n<\\/ul>\\n<h4> 2.2.21 <\\/h4>\\n<ul>\\n<li>Added: Display Conditions \\u2014 Current Date &amp; Time condition<\\/li>\\n<li>Added: Timeline \\u2014 New option to reverse position of cards<\\/li>\\n<li>Added: Text Divider \\u2014 Margin control for the text<\\/li>\\n<li>Added: Toggle Element \\u2014 Option to hide all elements by default<\\/li>\\n<li>Added: Timeline \\u2014 Controls for overriding text colour in custom mode<\\/li>\\n<li>Fixed: EE widget indicator in editor panel font<\\/li>\\n<li>Fixed: Unfold \\u2014 Removed elementor-button class from button which was adding a lot of padding<\\/li>\\n<li>Fixed: Unfold \\u2014 Editor preview spacing in js template<\\/li>\\n<li>Fixed: Query control width<\\/li>\\n<li>Fixed: PHP error on updater transient data<\\/li>\\n<li>Fixed: Video Player \\u2014 Stop play when played once in viewport<\\/li>\\n<li>Fixed: Timeline \\u2014 Correct dates when using custom post skin with a template that uses Posts Extra<\\/li>\\n<li>Fixed: Tooltips \\u2014 Tooltips not closing on mobile with touchstart event<\\/li>\\n<li>Fixed: Timeline \\u2014 Entrance animation triggering on page load instead of scroll to element<\\/li>\\n<li>Fixed: Timeline \\u2014 Query section not hidden if Source is Custom<\\/li>\\n<li>Fixed: Multiple SELECT2 controls width bug (missing css) after Elementor update<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Masonry layout broken when using custom size values in manual mode<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Changing filters disrupts any Elementor entrance animations placed after widget<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Run ready triggers for section and columns on infinite scroll<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Refresh elements even if infinite scroll button is off<\\/li>\\n<li>Fixed: ACF fields not showing inside templates when ACF Extended plugin is active<\\/li>\\n<li>Tweak: Unfold \\u2014 Hide button when there is no content or visible lines exceeds number of existing lines<\\/li>\\n<li>Tweak: Tooltips \\u2014 Integrate Elementor breakpoints<\\/li>\\n<li>Tweak: Gallery Extra \\u2014 Improved buggy responsive custom sizing method<\\/li>\\n<li>Revert: Display Conditions \\u2014 Added time to Current Date conditions\' date control<\\/li>\\n<\\/ul>\\n<h4> 2.2.20 <\\/h4>\\n<ul>\\n<li>Added: Display Conditions \\u2014 \'Current User\' condition<\\/li>\\n<li>Added: Display Conditions \\u2014 Added time to Current Date conditions\' date control<\\/li>\\n<li>Fixed: Some icon controls hidden due to Elementor changing label_block control attribute<\\/li>\\n<li>Fixed: Popup \\u2014 Close button control conditions<\\/li>\\n<li>Fixed: Popup \\u2014 Close icon not hiding on frontend<\\/li>\\n<\\/ul>\\n<h4> 2.2.19 <\\/h4>\\n<ul>\\n<li>Added: Popup \\u2014 Option to set max number of times a non-persistent popup should open<\\/li>\\n<li>Fixed: Posts \\u2014 Carousel compatibility with Elementor 2.9.0 swiper js upgrade<\\/li>\\n<li>Fixed: Switcher \\u2014 Title direction on RTL<\\/li>\\n<\\/ul>\\n<h4> 2.2.18 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Filters infinite scroll warning<\\/li>\\n<li>Added: Popup \\u2014 Border controls for iframe and image<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 PHP warning<\\/li>\\n<li>Fixed: Buttons \\u2014 Theme CSS override for anchors<\\/li>\\n<li>Fixed: Popup \\u2014 PHP warning when using placeholder image<\\/li>\\n<li>Fixed: Popup \\u2014 Overflow hidden missing from popup content<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Restrict refreshing widget inside offcanvas panel to refreshable list<\\/li>\\n<li>Fixed: Scroll Indicator \\u2014 Clicking bullets on mobile doesn\'t scroll to section when tooltips are enabled<\\/li>\\n<li>Tweak: Scroll Indicator \\u2014 Separate control for enabling opening of tooltips on focus for better integration<\\/li>\\n<li>Tweak: Switcher \\u2014 Convert description textarea field to WYSIWYG<\\/li>\\n<li>Tweak: Slide Menu \\u2014 More specific selector typography control<\\/li>\\n<li>Tweak: Popup \\u2014 Default close button size for iframe<\\/li>\\n<li>Tweak: Make license renewal reminder dismissable<\\/li>\\n<\\/ul>\\n<h4> 2.2.17 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Option to open in new tab for Title link<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Run ready triggers for widgets inside panel when opening<\\/li>\\n<li>Tweak: Posts \\u2014 Hide Media area if no thumbnail or placeholder even if it has content parts<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 Default thumbs spacing to 24<\\/li>\\n<li>Tweak: Update TweenMax version<\\/li>\\n<\\/ul>\\n<h4> 2.2.16 <\\/h4>\\n<ul>\\n<li>Added: Scroll Indicator \\u2014 Offset for scrolling to section<\\/li>\\n<li>Added: Gallery Slider \\u2014 Lazy load images in preview<\\/li>\\n<li>Added: Slide Menu \\u2014 \'elementor_extras\\/widgets\\/slide_menu\\/nav_menu\\/walker_start_el\' filter for walker_nav_menu_start_el hook<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Tilt perspective issue<\\/li>\\n<li>Fixed: Gallery \\u2014 Tilt captions depth not working<\\/li>\\n<li>Fixed: Global Tooltips \\u2014 Distance for repositioned tooltips<\\/li>\\n<li>Fixed: Global Tooltips \\u2014 Multiple tooltips appearing only in edit mode when changing tooltip position<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Remove posts per page setting for current query<\\/li>\\n<li>Fixed: Display Conditions \\u2014 GET and POST not returning true for any value<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Minor PHP warning<\\/li>\\n<li>Fixed: Random Image \\u2014 Error when using only one image<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Duplicate images in Elementor lightbox when infinite loop is enabled<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Include &quot;related&quot; source in Price position control conditions<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Meta Key not showing when Order By is set to Meta Value (number)<\\/li>\\n<li>Fixed: Timeline \\u2014 Meta Key not showing when Order By is set to Meta Value (number)<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Disable add to cart button when used inside a linked Media area<\\/li>\\n<li>Tweak: Timeline \\u2014 Responsive entrance animation<\\/li>\\n<\\/ul>\\n<h4> 2.2.15 <\\/h4>\\n<ul>\\n<li>Fixed: Popup \\u2014 Date comparison fail for non-persistent interval setting<\\/li>\\n<li>Fixed: Tooltips \\u2014 Tooltips empty in some cases after last update<\\/li>\\n<li>Fixed: Calendar \\u2014 Support for ACF date time picker fields<\\/li>\\n<li>Tweak: Hotspots \\u2014 Better css method for disabling pulse effect<\\/li>\\n<li>Tweak: Posts Extra \\u2014 New &quot;hide&quot; icon for content parts positioning<\\/li>\\n<li>Tweak: Nicons<\\/li>\\n<\\/ul>\\n<h4> 2.2.14 <\\/h4>\\n<ul>\\n<li>Fixed: Audio Player \\u2014 Edge case bug when stopping a player inside a section stuck with Elementor sticky setting<\\/li>\\n<li>Fixed: Switcher \\u2014 Loader thickness not working in Firefox<\\/li>\\n<li>Fixed: Offcanvas \\u2014 WPML not fetching content boxes repeater fields<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Masonry missing on frontend after last update<\\/li>\\n<li>Tweak: Tooltips \\u2014 Use append method to add content to the tooltip<\\/li>\\n<\\/ul>\\n<h4> 2.2.13 <\\/h4>\\n<ul>\\n<li>Fixed: Posts Extra \\u2014 Media left right alignment not working<\\/li>\\n<\\/ul>\\n<h4> 2.2.12 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Post border radius control<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Safari layout bug on infinite scroll and masonry layout<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Carousel slides to scroll on tablet bug<\\/li>\\n<li>Fixed: Timeline \\u2014 Date options not showing for custom post skin option<\\/li>\\n<li>Fixed: Sticky Elements \\u2014 Force sticky sections to flex align to start for Safari flex stretch bug<\\/li>\\n<\\/ul>\\n<h4> 2.2.11 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Infinite scroll fields for WPML<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Better support for post type archive links on archive pages<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Flexbox causing horizontal media layout issue on mobile<\\/li>\\n<li>Fixed: Circle Progress \\u2014 Compatibility with wordpress 5.3<\\/li>\\n<li>Tweak: Offcanvas \\u2014 Mode container background colour control from site settings to widget settings<\\/li>\\n<\\/ul>\\n<h4> 2.2.10 <\\/h4>\\n<ul>\\n<li>Added: Popup \\u2014 Option to open url inside popup<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Check for existing non built-in custom post types before iteration<\\/li>\\n<li>Fixed: Display Conditions \\u2014 ACF Date support for custom locale<\\/li>\\n<li>Fixed: Calendar \\u2014 ACF Date support for custom locale<\\/li>\\n<li>Fixed: Switcher \\u2014 Description not available for translation<\\/li>\\n<li>Fixed: Gallery \\u2014 Safari backface-visibility bug<\\/li>\\n<\\/ul>\\n<h4> 2.2.9 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Align media vertically on horizontal post layouts<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Text separator not displaying<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Default horizontal layout width control to 30<\\/li>\\n<\\/ul>\\n<h4> 2.2.8 <\\/h4>\\n<ul>\\n<li>Added: Breadcrumbs \\u2014 Granular controls for crumbs settings on archive and single pages<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Moved images loaded container selector to ajax response<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Show all filters option not working<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Infinite scroll pagination html output rendering more links than needed<\\/li>\\n<li>Fixed: PHP notice for licensing admin notification<\\/li>\\n<li>Fixed: Switcher \\u2014 Border radius control CSS selector<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Cleanup on pagination html output needed for infinite scroll<\\/li>\\n<\\/ul>\\n<h4> 2.2.7 <\\/h4>\\n<ul>\\n<li>Fixed: Compatibility with third-party plugin<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Edge case bug when calculating anchor position<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Notices<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Overlapping items on infinite scroll when filters active<\\/li>\\n<\\/ul>\\n<h4> 2.2.6 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Global \'elementor_extras\\/widgets\\/posts\\/link\' filter<\\/li>\\n<li>Added: Offcanvas \\u2014 Typography control for content boxes<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Infinite Scroll stopping before all posts load<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Panel background selector<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Page jump when navigating to anchor<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Edge case js error in nouislider script<\\/li>\\n<li>Fixed: Templates Control \\u2014 Restrict global query override for templates inside loops<\\/li>\\n<li>Fixed: Slide Menu \\u2014 Nav menu item classes don\'t work when coming from template control<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Wrong order for hierarchical taxonomies<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Flicker when performing infinite scroll on filtered posts<\\/li>\\n<li>Fixed: Sticky Elements \\u2014 Additional padding in some cases below sticky element<\\/li>\\n<li>Fixed: Display Conditions \\u2014 Missing day of week condition<\\/li>\\n<li>Fixed: Hotspots \\u2014 Better handling of icon vertical alignment in css<\\/li>\\n<\\/ul>\\n<h4> 2.2.5 <\\/h4>\\n<ul>\\n<li>Added: Toggle Element \\u2014 Control to hide items without any content<\\/li>\\n<li>Added: Popup \\u2014 Support for usage within Posts Extra custom post skin<\\/li>\\n<li>Added: Audio Player \\u2014 Option to disable preloading of audio files<\\/li>\\n<li>Added: Calendar \\u2014 Search custom fields by field name<\\/li>\\n<li>Added: Offcanvas \\u2014 Options in widgets\' settings to fix page jump issue<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Certain actions not working<\\/li>\\n<li>Fixed: Calendar \\u2014 Pods controls not fetching fields<\\/li>\\n<li>Fixed: Calendar \\u2014 Toolset controls not fetching fields<\\/li>\\n<li>Fixed: Query Control \\u2014 Return only matching queries for pods and toolset<\\/li>\\n<li>Fixed: Calendar \\u2014 Placeholder functionality<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Edge case where css width selectors get overridden by defaults<\\/li>\\n<li>Tweak: Posts Extra \\u2013 Default css order value for parts and areas in frontend css<\\/li>\\n<li>Tweak: Popup \\u2014 Replaced multiple template selection control with single control. IMPORTANT: Settings review required!<\\/li>\\n<li>Tweak: Breadcrumbs \\u2014 Refactor widget code<\\/li>\\n<\\/ul>\\n<h4> 2.2.4 <\\/h4>\\n<ul>\\n<li>Added: Dynamic background image support for custom post skin<\\/li>\\n<li>Added: Breadcrumbs \\u2014 Filter for home breadcrumb link<\\/li>\\n<li>Fixed: Timeline \\u2014 Wrong card content selector for transition control<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Broken selectors after last offcanvas update<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Remove default border around posts<\\/li>\\n<\\/ul>\\n<h4> 2.2.3 <\\/h4>\\n<ul>\\n<li>Added: Offcanvas \\u2014 Compatibility with templates in loops in Posts Extra and other plugins<\\/li>\\n<li>Added: Posts Extra \\u2014 Refresh all widgets scripts on appended infinite scroll items<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Button style gone when placed in linked media area<\\/li>\\n<li>Fixed: Sticky Elements \\u2014 Bug when sticky section inside page body within theme builder header template<\\/li>\\n<li>Fixed: Scroll Indicator \\u2014 Tooltips not working with bullets skin<\\/li>\\n<\\/ul>\\n<h4> 2.2.2 <\\/h4>\\n<ul>\\n<li>Fixed: Scroll Indicator \\u2014 Bug when tooltips disabled on bullets skin<\\/li>\\n<li>Fixed: Timeline \\u2014 Option to hide thumbnail not working in posts mode<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Bug with before parent category filters<\\/li>\\n<li>Fixed: Bug with third party elementor addon that enqueue editor scripts on plugin load<\\/li>\\n<li>Fixed: Posts \\u2014 Default metas control to include price for previous saved settings<\\/li>\\n<li>Added: Search Form \\u2014 Compatibility with Relevanssi search results on custom templates with search form id condition<\\/li>\\n<li>Added: Timeline \\u2014 Option to set a dynamic tag instead of date, title and excerpt in posts mode<\\/li>\\n<li>Added: Timeline \\u2014 Option to set HTML element for title in posts mode<\\/li>\\n<li>Added: Posts Extra \\u2014 Filter for the media area link<\\/li>\\n<li>Added: Posts Extra \\u2014 Option to open media and button links in new tab<\\/li>\\n<li>Added: Table \\u2014 WPML translation of header cells text<\\/li>\\n<li>Tweak: Sticky Elements \\u2014 Additional listeners for recalculating sticky<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Less restrictive css selector for the woocommerce add to cart button<\\/li>\\n<\\/ul>\\n<h4> 2.2.1 <\\/h4>\\n<ul>\\n<li>Added: Scroll Indicator \\u2014 Option to offset start and end positions<\\/li>\\n<li>Added: Posts Extra \\u2014 Responsive media width control<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Missing custom field order options<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Avatar meta showing even if removed from metas list<\\/li>\\n<li>Fixed: Display Conditions \\u2014 ACF Choice fails for radio field<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Bug with left aligned media flex width on mobile<\\/li>\\n<\\/ul>\\n<h4> 2.2.0 <\\/h4>\\n<ul>\\n<li>Added: Google Map \\u2014 Route travel mode options<\\/li>\\n<li>Added: Global Tooltips \\u2014 Compatibility with usage inside post skin templates for Posts Extra<\\/li>\\n<li>Added: Global Tooltips \\u2014 z-index control in both element and global settings<\\/li>\\n<li>Added: Display Conditions \\u2014 Term archive condition<\\/li>\\n<li>Added: Display Conditions \\u2014 ACF conditions<\\/li>\\n<li>Added: Display Conditions \\u2014 POST and GET variable conditions<\\/li>\\n<li>Added: Timeline \\u2014 Custom Post Skin via Elementor templates<\\/li>\\n<li>Added: Timeline \\u2014 Replaced default query controls with related query controls<\\/li>\\n<li>Added: Timeline \\u2014 Trim custom excerpt control<\\/li>\\n<li>Added: Timeline \\u2014 Custom post skin<\\/li>\\n<li>Added: Posts Extra \\u2014 Date formatting controls<\\/li>\\n<li>Added: Posts Extra \\u2014 Actions and filters<\\/li>\\n<li>Added: Calendar \\u2014 Actions and filters<\\/li>\\n<li>Added: Devices \\u2014 Actions<\\/li>\\n<li>Added: Breadcrumbs \\u2014 Actions and filters<\\/li>\\n<li>Added: Scroll Indicator \\u2014 Custom html tags for title and subtitle in list skin<\\/li>\\n<li>Added: Custom implementation for Template controls<\\/li>\\n<li>Fixed: Toggle Element \\u2014 Support for slick slider based widgets inside elements<\\/li>\\n<li>Fixed: Switcher \\u2014 Missing image link control<\\/li>\\n<li>Fixed: Timeline \\u2014 Markup improvement to allow for simpler border radius around cards<\\/li>\\n<li>Fixed: Timeline \\u2014 Custom icon replaces global if global is set<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Separator vertical alignment bug<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Icon migration markup issue<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Update elementor nerd box classes<\\/li>\\n<li>Fixed: Posts Extra \\u2014 ACF fields for custom skins used on archive pages<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Wrong access type for _query property<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Price conditions issue for area and editor panel section display<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Author and avatar metas additional controls conditions<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Removed infinite scroll pages loaded limit<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Handle multiple paginations control condition bug<\\/li>\\n<li>Fixed: Scroll Indicator \\u2014 Custom height control condition<\\/li>\\n<li>Fixed: Popup \\u2014 Compatibility with usage inside post skin templates for Posts Extra<\\/li>\\n<li>Fixed: Buttons \\u2014 Flip effect back is hidden during transition<\\/li>\\n<li>Tweak: Breadcrumbs \\u2014 Remove useless icon and icon class filters<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Update button text filters to include \\/posts\\/<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Default taxonomy order for filters<\\/li>\\n<\\/ul>\\n<h4> 2.1.8 <\\/h4>\\n<ul>\\n<li>Fixed: Missing elementor pro active condition<\\/li>\\n<\\/ul>\\n<h4> 2.1.7 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Order posts by custom fields<\\/li>\\n<li>Fixed: Calendar \\u2014 No events fetched when acf date field return format is different that display format<\\/li>\\n<li>Tweak: Better notices and plugin activation prevention for dependencies<\\/li>\\n<\\/ul>\\n<h4> 2.1.6 <\\/h4>\\n<ul>\\n<li>Fixed: Posts Extra \\u2014 Exclude category pages from previous current query fix<\\/li>\\n<li>Fixed: Posts Extra \\u2014 ACF fields for custom post skins used on archive pages<\\/li>\\n<\\/ul>\\n<h4> 2.1.5 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Filter for button link<\\/li>\\n<li>Added: Posts Extra \\u2014 Apply both \'button\' and \'add_to_cart\' filters to button<\\/li>\\n<li>Added: Audio Player \\u2014 Autoplay option<\\/li>\\n<li>Added: Support for new icon library in Elementor 2.6 in all widgets<\\/li>\\n<li>Added: Support for scaling SVG icon library assets when added to widgets<\\/li>\\n<li>Added: Breadcrumbs \\u2014 Option to hide current page<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Template control not fetching results after Elementor Pro 2.6.0 update<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Body order on horizontal posts<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Default query args prevent correct number of results on search templates<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Show all filters initially not working<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Wrong hierarchical taxonomies order when using custom post types<\\/li>\\n<li>Fixed: Calendar \\u2014 Border radius overflow issue<\\/li>\\n<li>Fixed: Circle Progress \\u2014 Progress not showing when shown below<\\/li>\\n<li>Fixed: Timeline \\u2014 Text align on tablet for RTL<\\/li>\\n<li>Fixed: Switcher \\u2014 Remove link image option when using overlay skin<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Edge case where page scrolls up when panel closed on firefox<\\/li>\\n<li>Fixed: Video Player \\u2014 Play button not centered in edge cases<\\/li>\\n<li>Tweak: Search Form \\u2014 Tax query verification<\\/li>\\n<\\/ul>\\n<h4> 2.1.4 <\\/h4>\\n<ul>\\n<li>Fixed: Audio Player \\u2014 External URL not. accepting dynamic tag in URL category<\\/li>\\n<li>Fixed: Video Player \\u2014 External URL not. accepting dynamic tag in URL category<\\/li>\\n<li>Fixed: Search Form \\u2014 Undefined index notice<\\/li>\\n<li>Added: Offcanvas \\u2014 Custom select for the close button<\\/li>\\n<li>Tweak: Offcanvas \\u2014 Separate control sections for title and close settings<\\/li>\\n<\\/ul>\\n<h4> 2.1.3 <\\/h4>\\n<ul>\\n<li>Fixed: Posts Extra \\u2014 Add to cart button alignment<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Pagination links on single templates<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Deprecated certain filters<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Added button text filter<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Added add to cart text filter<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Changed skin source terminology<\\/li>\\n<li>Tweak: Dissmisable admin licensing notices<\\/li>\\n<\\/ul>\\n<h4> 2.1.2 <\\/h4>\\n<ul>\\n<li>Added: Display Conditions \\u2014 New Term Archive condition<\\/li>\\n<li>Added: Posts Extra \\u2014 Area ordering controls<\\/li>\\n<li>Added: Posts Extra \\u2014 Add to cart button<\\/li>\\n<li>Added: Posts Extra \\u2014 Option to use Elementor templates as custom skin for posts<\\/li>\\n<li>Added: Timeline \\u2014 Separate controls for dates in hover and focused state<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Force square avatar image<\\/li>\\n<li>Fixed: Timeline \\u2014 Remove empty image wrapper when no image exists<\\/li>\\n<li>Fixed: Timeline \\u2014 Hover background color of arrow when focused<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Show price if source is current query<\\/li>\\n<li>Tweak: Timeline \\u2014 Allow Elementor custom image size<\\/li>\\n<li>Tweak: Timeline \\u2014 Responsive color controls<\\/li>\\n<\\/ul>\\n<h4> 2.1.1 <\\/h4>\\n<ul>\\n<li>Added: Tooltips \\u2014 Event for closing the tooltip by clicking anywhere<\\/li>\\n<li>Fixed: Buttons \\u2014 Text align when min width is set<\\/li>\\n<li>Tweak: Scroll Indicator \\u2014 Added options to select progress start and end calculation on scroll for sections<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Moved Infinite Scroll, Pagination and Filters activation controls to their respective sections.<\\/li>\\n<li>Tweak: Licensing \\u2014 Increase remote post request timeout value<\\/li>\\n<\\/ul>\\n<h4> 2.1.0 <\\/h4>\\n<ul>\\n<li>New Widget: Search Form \\u2014 Form widget with restrictions and filters<\\/li>\\n<li>New Widget: Scroll Indicator \\u2014 Create different types of scroll navigation indicators<\\/li>\\n<li>New Feature: Instagram \\u2014 Pull instagram feed to the Gallery widget<\\/li>\\n<li>Added: Posts Extra \\u2014 Vertical carousel<\\/li>\\n<li>Added: Posts Extra \\u2014 New control to select breakpoint for collapsing horizontal post layouts<\\/li>\\n<li>Added: Posts Extra \\u2014 Keep control to define page number limit for infinite scroll<\\/li>\\n<li>Added: Posts Extra \\u2014 Option to not show the &quot;All&quot; filter<\\/li>\\n<li>Added: Posts Extra \\u2014 New control for Slides to Show and deprecated old control [ Settings Review Required ]<\\/li>\\n<li>Added: Posts Extra \\u2014 Exclude taxonomy terms from filters<\\/li>\\n<li>Added: Gallery \\u2014 New spacing control specifically for mixed masonry layout. [ Settings Review Required ]<\\/li>\\n<li>Added: Gallery Slider \\u2014 Control to hide thumbnails<\\/li>\\n<li>Added: Tooltips \\u2014 Mobile event listeners [ Settings Review Required ]<\\/li>\\n<li>Added: Tooltips \\u2014 Responsive triggers and hide events [ Settings Review Required ]<\\/li>\\n<li>Added: Tooltips \\u2014 Separate events for closing the tooltip [ Settings Review Required ]<\\/li>\\n<li>Added: Tooltips \\u2014 New offset control to adjust alignment of arrow tip to target<\\/li>\\n<li>Added: Devices \\u2014 Option for video to cover screen<\\/li>\\n<li>Added: Breadcrumbs \\u2014 Hover colors controls<\\/li>\\n<li>Added: Calendar \\u2014 Disable links to posts<\\/li>\\n<li>Added: Calendar \\u2014 Add nofollow and open in new window on posts source<\\/li>\\n<li>Added: Buttons \\u2014 General padding control<\\/li>\\n<li>Added: Popup \\u2014 Horizontal align for inline trigger and popup close button<\\/li>\\n<li>Added: Notice for license domain mismatch<\\/li>\\n<li>Fixed: Circle Progress \\u2014 Wrong absolute max values<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Infinite scroll loading same posts<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Aligned column breakpoints to elementor default values<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Better override default theme padding on post item<\\/li>\\n<li>Fixed: Timeline \\u2014 CSS bug with overflow<\\/li>\\n<li>Fixed: Timeline \\u2014 Arrow color not working on frontend<\\/li>\\n<li>Fixed: Timeline \\u2014 Invalid code being generated in post css<\\/li>\\n<li>Fixed: Calendar \\u2014 Link target and nofollow<\\/li>\\n<li>Fixed: Devices \\u2014 Video controls conditions<\\/li>\\n<li>Fixed: Parallax Background \\u2014 Conflict with Elementor Pro scrolling effect<\\/li>\\n<li>Fixed: Popup \\u2014 Dynamic css selector for trigger not working<\\/li>\\n<li>Fixed: Calendar \\u2014 Link attributes in compact mode not working<\\/li>\\n<li>Fixed: Google Map \\u2014 Wrong value for default description tag<\\/li>\\n<li>Fixed: Google Map \\u2013 Set overflow to hidden to allow for advanced border radius setting<\\/li>\\n<li>Fixed: Switcher \\u2014 Rename effects section for compatibility with motion effects section name<\\/li>\\n<li>Fixed: Switcher \\u2014 Link to control should not be responsive<\\/li>\\n<li>Fixed: Unfold \\u2014 Bug with closing without focusing<\\/li>\\n<li>Fixed: Random Image \\u2014 Wrong caption<\\/li>\\n<li>Fixed: Display Conditions \\u2014 Check correct condition value<\\/li>\\n<li>Fixed: Toggle Element \\u2014 Text Label align controls<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Safari 12.1 CSS bug<\\/li>\\n<li>Fixed: Gallery \\u2014 Hover effects on mixed layout<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Edge case js error<\\/li>\\n<li>Fixed: Remove duplicate empty template messages from editor panel<\\/li>\\n<li>Fixed: Check license data before mismatch check<\\/li>\\n<li>Fixed: Tooltips \\u2014 Bug with hide event prevent default<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Allow horizontal post layout independent of columns value<\\/li>\\n<li>Tweak: Gallery \\u2014 Better controls conditions<\\/li>\\n<li>Tweak: Gallery \\u2014 Moved settings in their own sections under Content<\\/li>\\n<li>Tweak: Gallery \\u2014 Control conditions<\\/li>\\n<li>Tweak: Gallery \\u2014 Better markup, controls and css optimisation<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 Better markup, controls and css optimisation<\\/li>\\n<li>Tweak: Better license management, notifications and performance<\\/li>\\n<li>Tweak: Remove extension default enable for sticky and parallax background<\\/li>\\n<li>Tweak: Remove custom panel alert classes and revert to elementor ones<\\/li>\\n<li>Tweak: Update docs and support links in extras admin pages<\\/li>\\n<li>Tweak: Streamline get_image_caption across all modules to avoid code redundancy<\\/li>\\n<li>Tweak: Toggle Element \\u2014 Better Label alignment controls<\\/li>\\n<li>Tweak: Popup \\u2014 Empty trigger css adjustments<\\/li>\\n<li>Tweak: Admin pages styles<\\/li>\\n<\\/ul>\\n<h4> 2.0.17 <\\/h4>\\n<ul>\\n<li>Added: Timeline \\u2014 Overlay horizontal alignment option<\\/li>\\n<li>Fixed: Timeline \\u2014 Icon showing twice<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Default horizontal alignment to left<\\/li>\\n<\\/ul>\\n<h4> 2.0.16 <\\/h4>\\n<ul>\\n<li>Fixed: Include admin script only on extras pages<\\/li>\\n<li>Fixed: Posts Extra \\u2014 RTL margins and arrows<\\/li>\\n<li>Fixed: Calendar \\u2014 RTL arrows<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Override current query posts per page with control setting<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Carousel style section condition<\\/li>\\n<li>Added: Text Divider \\u2014 Control for alignment of text<\\/li>\\n<li>Added: Unfold \\u2014 Columns settings for content<\\/li>\\n<li>Added: Timeline \\u2014 New alignment controls to allow selecting layouts per breakpoint<\\/li>\\n<li>Added: Posts Extra \\u2014 Option to align posts horizontally<\\/li>\\n<li>Tweak: Admin settings RTL<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Responsive alignment controls<\\/li>\\n<li>Tweak: Timeline \\u2014 Responsive defaults for alignment controls<\\/li>\\n<\\/ul>\\n<h4> 2.0.15 <\\/h4>\\n<ul>\\n<li>IMPORTANT: This version requires Elementor 2.5 or above<\\/li>\\n<li>IMPORTANT: If you have Elementor Pro, this version requires version 2.5 or above<\\/li>\\n<li>Added: Posts Extra \\u2014 Elementor Pro new related posts module with include \\/ exclude and date range<\\/li>\\n<li>Added: Circle Progress \\u2014 Option to turn off animation<\\/li>\\n<li>Added: Display Conditions \\u2014 Day of week condition<\\/li>\\n<li>Added: Video Player &amp; Devices \\u2014 Option to not hide bar when video is playing<\\/li>\\n<li>Fixed: Sticky Elements \\u2014 Unstick for 768px wide tablets<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Compatibility with Elementor Pro 2.5<\\/li>\\n<li>Fixed: Timeline \\u2014 Compatibility with Elementor Pro 2.5<\\/li>\\n<li>Fixed: Sticky Elements \\u2014 Adjust on resize in editor<\\/li>\\n<li>Fixed: Calendar \\u2014 Query compatibility with WPML<\\/li>\\n<li>Fixed: Hotspots \\u2014 Check spaces in hotspot links<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Edge case where images don\'t display entirely<\\/li>\\n<li>Fixed: Timeline \\u2014 Correctly render dynamic tags<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Isotope on loading more posts when filter active<\\/li>\\n<li>Tweak: Video Player \\u2014 Automatically hide bar on mobile when playing<\\/li>\\n<\\/ul>\\n<h4> 2.0.14 <\\/h4>\\n<ul>\\n<li>Added: Toggle Element \\u2014 Option to select which item is active by default<\\/li>\\n<li>Fixed: Table \\u2014 Restrict cell max-width to msie<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Wrong arranging in some cases<\\/li>\\n<li>Fixed: Media Player text indicators wrapping<\\/li>\\n<\\/ul>\\n<h4> 2.0.13 <\\/h4>\\n<ul>\\n<li>Fixed: Posts Extra \\u2014 Carousel js error<\\/li>\\n<\\/ul>\\n<h4> 2.0.12 <\\/h4>\\n<ul>\\n<li>Added: Unfold \\u2014 Options to keep focus on content when folding or unfolding<\\/li>\\n<li>Fixed: Toggle Element \\u2014 Make sure Gallery Extra is initiated when toggling<\\/li>\\n<li>Fixed: Table \\u2014 Min-width breakpoint bug<\\/li>\\n<li>Fixed: Sticky Elements \\u2014 Compatibility with Elementor 2.5<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Z-index issues for panel<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Allow scroll on page not working<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Rare selector for anchors with link issue<\\/li>\\n<li>Fixed: Hotspots \\u2014 Rename css pulse animation<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Editor defaultView error<\\/li>\\n<li>Fixed: Sticky Elements \\u2014 Adjust breakpoint values<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Fallback to default wp posts per page option<\\/li>\\n<li>Tweak: Offcanvas \\u2014 Make sure html element has auto height<\\/li>\\n<li>Tweak: Better wpml classes check<\\/li>\\n<\\/ul>\\n<h4> 2.0.11 <\\/h4>\\n<ul>\\n<li>Fixed: Offcanvas \\u2014 Trigger not closing after open<\\/li>\\n<li>Fixed: Posts \\u2014 Grid overlapping on safari when infinite scroll is enabled<\\/li>\\n<li>Fixed: Table \\u2014 Restrict IE hack to tablet and up<\\/li>\\n<li>Fixed: Get element settings on frontend in edit mode<\\/li>\\n<li>Fixed: Google Map \\u2014 Require resize plugin<\\/li>\\n<li>Added: Posts Extra \\u2014 Button border controls<\\/li>\\n<\\/ul>\\n<h4> 2.0.10 <\\/h4>\\n<ul>\\n<li>Added: Parallax Elements \\u2014 Option to allow moving elements when they aren\'t visible inside viewport<\\/li>\\n<li>Fixed: Google Map \\u2014 Centering with dynamic tags not working<\\/li>\\n<li>Fixed: Calendar \\u2014 Don\'t limit number of posts fetched<\\/li>\\n<li>Fixed: Display Conditions \\u2014 Chrome check failing<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Responsive item aligning<\\/li>\\n<li>Fixed: Parallax Background \\u2014 Custom size control compatibility + tweaks<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Type control condition<\\/li>\\n<li>Tweak: Google Map \\u2014 Disable fitting and centering when route is enabled<\\/li>\\n<\\/ul>\\n<h4> 2.0.9 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Handle multiple paginated loops<\\/li>\\n<li>Added: Posts Extra \\u2014 Nothing found message<\\/li>\\n<li>Added: Image Comparison \\u2014 Option to turn off animation on entrance<\\/li>\\n<li>Added: Posts Extra \\u2014 Query ID filter on top of elementor pro one<\\/li>\\n<li>Added: Offcanvas \\u2014 Control to enable page scroll when offcanvas panel is open<\\/li>\\n<li>Fixed: Table \\u2014 IE cell text wrapping<\\/li>\\n<li>Fixed: Circle Progress \\u2014 Wrong absolute value when multiple widget instances on same page<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Wrong thumbnail order<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Z-index issues<\\/li>\\n<li>Fixed: Calendar \\u2014 Convert timestamp to integer<\\/li>\\n<li>Fixed: Gallery module attachment check<\\/li>\\n<li>Tweak: Timeline \\u2014 Rename timeline script<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Responsive row spacing control<\\/li>\\n<li>Tweak: Parallax Background \\u2014 Compatibility with Elementor 2.4<\\/li>\\n<\\/ul>\\n<h4> 2.0.8 <\\/h4>\\n<ul>\\n<li>Fixed: Text Divider \\u2014 Selector for link color<\\/li>\\n<li>Fixed: Timeline \\u2014 Notice<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Escape jquery expression<\\/li>\\n<li>Fixed: Google Map \\u2014 Handle invalid or undefined snazzy map style<\\/li>\\n<\\/ul>\\n<h4> 2.0.7 <\\/h4>\\n<ul>\\n<li>Fixed: Offcanvas \\u2014 Anchor navigation scroll calculation<\\/li>\\n<li>Added: Timeline \\u2014 Allow post content to be shown instead of excerpt<\\/li>\\n<li>Added: Timeline \\u2014 Control to set line progress position relative to viewport<\\/li>\\n<li>Tweak: Offcanvas \\u2014 Anchor condition<\\/li>\\n<\\/ul>\\n<h4> 2.0.6 <\\/h4>\\n<ul>\\n<li>Fixed: Popup \\u2014 Duplicate tab control name<\\/li>\\n<li>Fixed: Popup \\u2014 Remove rtl suffix<\\/li>\\n<li>Added: Offcanvas \\u2014 Global control for offcanvas container background color<\\/li>\\n<\\/ul>\\n<h4> 2.0.5 <\\/h4>\\n<ul>\\n<li>Added: Editor panel labels for widgets<\\/li>\\n<li>Added: Calendar \\u2014 Control to customise month names<\\/li>\\n<li>Added: Offcanvas \\u2014 Link navigate to anchors on page<\\/li>\\n<li>Added: Popup \\u2014 Text trigger styling controls<\\/li>\\n<li>Fixed: Inline SVG \\u2014 Multiple svgs have same settings<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 No parent custom taxonomy terms render all terms<\\/li>\\n<li>Fixed: Posts Extra \\u2014 PHP notice<\\/li>\\n<li>Tweak: Updated language file<\\/li>\\n<\\/ul>\\n<h4> 2.0.4 <\\/h4>\\n<ul>\\n<li>Fixed: Display Conditions \\u2014 Editor section for sections actions<\\/li>\\n<li>Fixed: Display Conditions \\u2014 Conditions evaluation per element<\\/li>\\n<\\/ul>\\n<h4> 2.0.3 <\\/h4>\\n<ul>\\n<li>Fixed: Popup Display Conditions \\u2014 Check widget visibility before opening automatically<\\/li>\\n<li>Fixed: Table \\u2014 First row has no classes<\\/li>\\n<li>Fixed: Google Map \\u2014 Handle no snazzy maps selection<\\/li>\\n<li>Fixed: Display Conditions \\u2014 Wrong default keys resulting in wrong display<\\/li>\\n<li>Fixed: Audio Player \\u2014 Border type selector<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Position structured data property<\\/li>\\n<li>Fixed: Parallax Element \\u2014 Parallax column affecting child columns<\\/li>\\n<li>Fixed: Devices \\u2014 Image extending outside the widget area<\\/li>\\n<li>Fixed: Popup \\u2014 Move font family to pseudo-element<\\/li>\\n<li>Fixed: Slide Menu \\u2014 Sub-menu links not working with link navigation turned on<\\/li>\\n<li>Tweak: Rename infinite-scroll script<\\/li>\\n<li>Tweak: Breadcrumbs \\u2014 Increase typography selector specificity<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Additional conditions for areas style sections<\\/li>\\n<li>Remove widget disabling admin notif<\\/li>\\n<li>Update Wordpress stable tag to 5.0.0<\\/li>\\n<\\/ul>\\n<h4> 2.0.2 <\\/h4>\\n<ul>\\n<li>Added: New Query Control<\\/li>\\n<li>Added: Display Conditions \\u2014 Ajax powered fields<\\/li>\\n<li>Added: Display Conditions \\u2014 Current post condition<\\/li>\\n<li>Fixed: Switcher \\u2013 Autoplay not working without entrance animation<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Custom taxonomy archive crumbs<\\/li>\\n<li>Tweak: Audio Player \\u2014 Added option for external sources<\\/li>\\n<\\/ul>\\n<h4> 2.0.1 <\\/h4>\\n<ul>\\n<li>Fixed: Google Map \\u2014 Navigation z-index<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Default button position to hidden<\\/li>\\n<li>Fixed: Devices \\u2014 Video in window frame not displaying<\\/li>\\n<li>Fixed: Google Map \\u2014 JSON incorrectly reported as invalid<\\/li>\\n<li>Fixed: Switcher \\u2014 Cover picture tag with CSS<\\/li>\\n<li>Fixed: Devices \\u2014 Video css for browser frame<\\/li>\\n<li>Added: Posts Extra \\u2014 Infinite load button transition control<\\/li>\\n<li>Added: Posts Extra \\u2014 Infinite load button border control<\\/li>\\n<li>Added: Hotspots \\u2014 Individual hover controls for each hotspot<\\/li>\\n<li>Added: Audio Player \\u2014 Option to loop playlist<\\/li>\\n<li>Tweak: Google Map \\u2014 Make fields dynamic<\\/li>\\n<li>Tweak: Audio Player \\u2014 Added custom js events<\\/li>\\n<li>Tweak: Audio Player \\u2014 Separate control for play icon size<\\/li>\\n<li>Tweak: Video Player \\u2014 Added custom js events<\\/li>\\n<\\/ul>\\n<h4> 2.0.0 <\\/h4>\\n<ul>\\n<li>New Extension: Display Conditions<\\/li>\\n<li>New Widget: Google Map<\\/li>\\n<li>New Widget: Popup<\\/li>\\n<li>New Widget: Age Gate<\\/li>\\n<li>New Widget: Toggle Element<\\/li>\\n<li>New Widget: Calendar<\\/li>\\n<li>New Widget: Audio Player<\\/li>\\n<li>New Widget: Offcanvas<\\/li>\\n<li>New Widget: Slide Menu<\\/li>\\n<li>New Widget: Random Image<\\/li>\\n<li>Added: Posts Extra \\u2014 Support for terms from multiple taxonomies<\\/li>\\n<li>Added: Breadcrumbs \\u2014 Include blog posts page in breadcrumbs<\\/li>\\n<li>Added: Switcher \\u2014 New option to add description<\\/li>\\n<li>Added: Sticky Elements \\u2014 Completely rewritten code<\\/li>\\n<li>Added: Sticky Elements \\u2014 Offset bottom control<\\/li>\\n<li>Added: Global Tooltips \\u2014 Control to disable on breakpoint<\\/li>\\n<li>Added: Breadcrumbs \\u2014 Option to show taxonomy terms for custom post types instead of CPT name<\\/li>\\n<li>Added: Tooltips \\u2014 New trigger on page load<\\/li>\\n<li>Added: Switcher \\u2014 Events to update when inside toggle element<\\/li>\\n<li>Added: Posts Extra \\u2014 Price meta for woocommerce products<\\/li>\\n<li>Added: Posts Extra \\u2014 Button content part replaces read more<\\/li>\\n<li>Added: Posts Extra \\u2014 Post count for filters<\\/li>\\n<li>Added: Breadcrumbs \\u2014 Schema.org properties<\\/li>\\n<li>Fixed: Tooltips \\u2014 Add option to disable on breakpoint<\\/li>\\n<li>Fixed: Global Tooltips \\u2014 Destroy on editor mode<\\/li>\\n<li>Fixed: Parallax Background \\u2014 Out of view sections have wrong background image positions<\\/li>\\n<li>Fixed: Global Tooltips \\u2014 Settings not being saved<\\/li>\\n<li>Fixed: Parallax Element \\u2014 Start position option not applying<\\/li>\\n<li>Fixed: Hotspots \\u2014 Image display block<\\/li>\\n<li>Fixed: Unfold \\u2014 Button alignment<\\/li>\\n<li>Fixed: Unfold \\u2014 Button icon position and indent<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Check for woocommerce for price fields<\\/li>\\n<li>Fixed: Video Player \\u2014 Volume size undefined error<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 RTL behviour on clicking thumbs<\\/li>\\n<li>Fixed: Inline SVG \\u2014 ACF image field<\\/li>\\n<li>Fixed: Update to getEditModel method<\\/li>\\n<li>Fixed: Compatibility with Elementor 2.3.0<\\/li>\\n<li>Fixed: License not deactivating if expired<\\/li>\\n<li>Fixed: Image Comparison \\u2014 Distance for top-aligned labels<\\/li>\\n<li>Fixed: Devices + Hotspots \\u2014 Compatibility with Elementor 2.3.0<\\/li>\\n<li>Fixed: Switcher \\u2014 Astra theme images css conflict<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Multiple hierarchical categories not showing<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Filtered posts not found message<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Wrong grid item width when filters are active and multiple instances on page<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Controls conditions<\\/li>\\n<li>Fixed: Breacrumbs \\u2014 Wrap crumbs automatically<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Hide fields not available for Current Query option<\\/li>\\n<li>Tweak: Hotspots \\u2014 Default hotspots for better ux<\\/li>\\n<li>Tweak: Video Player + Devices \\u2014 Better behaviour and interactions for video player<\\/li>\\n<li>Tweak: Video Player + Devices \\u2014 Better selection of video source files<\\/li>\\n<li>Tweak: Video Player + Devices \\u2014 Added playback speed option<\\/li>\\n<li>Tweak: Timeline \\u2014 Support for point numbers and letter for posts<\\/li>\\n<li>Tweak: Table \\u2014 Remove render template to improve editing performance<\\/li>\\n<li>Tweak: Buttons \\u2014 Add bottom margin to custom spacing control<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Increase options for carousel rows and slides to scroll<\\/li>\\n<li>Tweak: Enable docs link in admin settings page<\\/li>\\n<li>Tweak: Switcher \\u2014 Make description field dynamic<\\/li>\\n<li>Tweak: Google Maps \\u2013 Adjust controls structure<\\/li>\\n<li>Tweak: Table \\u2014 Control names<\\/li>\\n<li>Tweak: Text Divider \\u2014 Controls position<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Added read more to translatable fields for WPML<\\/li>\\n<\\/ul>\\n<h4> 1.9.16 <\\/h4>\\n<ul>\\n<li>Fixed: Elementor 2.3.0 compatibility<\\/li>\\n<\\/ul>\\n<h4> 1.9.15 <\\/h4>\\n<ul>\\n<li>Fixed: Posts Extra \\u2014 Load more button for multiple widget instances<\\/li>\\n<li>Fixed: Parallax Background \\u2014 Responsive speed options<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Columns above 9 don\'t become full width<\\/li>\\n<li>Tweak: Improve Elementor Pro version dependency and posts widget compatibility<\\/li>\\n<li>Tweak: Timeline \\u2014 Enable dynamic fields for custom source<\\/li>\\n<li>Tweak: Circle Progress \\u2014 Handling of divisions operation in value control<\\/li>\\n<li>Tweak: Circle Progress \\u2014 Option to allow numbers with decimals instead of percetanges<\\/li>\\n<li>Tweak: Circle Progress \\u2014 Options to allow for absolute values to be shown<\\/li>\\n<li>Tweak: Hotspots \\u2014 Make hotspots size and opacity control responsive<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Remove swiper slide overflow hidden<\\/li>\\n<li>Tweak: Added option to enable updates to beta versions or Extras<\\/li>\\n<\\/ul>\\n<h4> 1.9.14 <\\/h4>\\n<ul>\\n<li>Fixed: Rename resize script to avoid potential conflicts<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Carousel flickering when used in Tabs widget and switching tabs<\\/li>\\n<li>Fixed: Timeline \\u2014 Date showing current date instead of post date<\\/li>\\n<li>Fixed: Extras admin page conflict with Jetpack<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Link not accessible for preview images with caption<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Added query id control for server side filtering of widget queries<\\/li>\\n<li>Tweak: Hotspots \\u2014 HTML valid structure issue<\\/li>\\n<li>Tweak: Table \\u2014 Minor terminology improvements<\\/li>\\n<\\/ul>\\n<h4> 1.9.13 <\\/h4>\\n<ul>\\n<li>Fixed: Posts Extra \\u2014 Infinite scroll loading same posts<\\/li>\\n<li>Fixed: Inline SVG \\u2014 Space under image<\\/li>\\n<li>Fixed: Extensions not showing when Elementor Pro not active<\\/li>\\n<\\/ul>\\n<h4> 1.9.12 <\\/h4>\\n<ul>\\n<li>Added: CSS filter controls for widgets<\\/li>\\n<li>Added: Global Tooltips \\u2014 Support for shortcodes and dynamic fields<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Load more button causing error when not paginated<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Content inside media not showing when no thumbnail available<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Media area display conditions<\\/li>\\n<li>Fixed: Posts Extra \\u2014 PHP warning when excerpt length is empty<\\/li>\\n<li>Fixed: Posts Extra \\u2014 RTL alignment of posts in masonry mode<\\/li>\\n<li>Fixed: Circle Progress \\u2014 Default control value to string<\\/li>\\n<li>Fixed: Circle Progress \\u2014 Dynamic fields values not working<\\/li>\\n<li>Fixed: Parallax Elements \\u2014 Window height calculation<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Repeater fields conditions<\\/li>\\n<li>Fixed: Parallax Background \\u2014 Breaks when dynamic field is used<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Allow offset to be used in current query<\\/li>\\n<li>Tweak: Timeline \\u2014 Allow drafts and scheduled posts to be included<\\/li>\\n<\\/ul>\\n<h4> 1.9.11 <\\/h4>\\n<ul>\\n<li>Fixed: Posts Extra \\u2014 Sticky posts compatibility with pagination<\\/li>\\n<li>Fixed: Compatibility with new Swiper version in Elementor 2.1<\\/li>\\n<li>Tweak: Timeline \\u2014 Responsive date padding and margin controls<\\/li>\\n<\\/ul>\\n<h4> 1.9.10 <\\/h4>\\n<ul>\\n<li>Fixed: Sticky Elements \\u2014 Options appear twice<\\/li>\\n<li>Tweak: Remove group control sticky<\\/li>\\n<\\/ul>\\n<h4> 1.9.9 <\\/h4>\\n<ul>\\n<li>Fixed: Timeline \\u2014 Points and line not aligned on mobile and tablet if size defined only on desktop<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Default placeholder image overriding post thumbnail<\\/li>\\n<li>Fixed: Sticky Elements no longer working<\\/li>\\n<li>Fixed: Additional check for active Elementor Pro<\\/li>\\n<li>Tweak: Moved Extras advanced section behind Custom CSS section<\\/li>\\n<\\/ul>\\n<h4> 1.9.8 <\\/h4>\\n<ul>\\n<li>Added: Gallery Slider \\u2014 Arrows controls for preview<\\/li>\\n<li>Added: Posts Extra \\u2014 Option to show all filters when using infinite scroll<\\/li>\\n<li>Fixed: Unfold \\u2014 Icon right align not working<\\/li>\\n<li>Fixed: Compatibility with Elementor 2.1 beta<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Allow excerpt in media area<\\/li>\\n<li>Tweak: Timeline \\u2014 More specific color selectors<\\/li>\\n<li>Tweak: Timeline \\u2014 Text align dates to the right for right hand items<\\/li>\\n<\\/ul>\\n<h4> 1.9.7 <\\/h4>\\n<ul>\\n<li>Fixed: Gallery Extra \\u2014 Implemented work-around for warning caused by Elementor bug<\\/li>\\n<li>Fixed: Posts Extra \\u2014 IE 10 images bug<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Time not showing<\\/li>\\n<li>Fixed: Buttons \\u2014 Wrap buttons by default<\\/li>\\n<li>Fixed: Remove too broad css declaration<\\/li>\\n<li>Fixed: Parallax background \\u2014 Correct element resize function name<\\/li>\\n<\\/ul>\\n<h4> 1.9.6 <\\/h4>\\n<ul>\\n<li>Fixed: Parallax Elements \\u2014 Breaks if pan distance is undefined<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Read more typography control conditions<\\/li>\\n<li>Fixed: Unfold \\u2014 Force icon to show hide as inline block<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Stretch body to align all footers to bottom<\\/li>\\n<li>Fixed: Posts Extra \\u2014 IE 10 horizontal layout for posts<\\/li>\\n<li>Fixed: Renamed jquery resize plugin function<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 CSS overflow fix<\\/li>\\n<\\/ul>\\n<h4> 1.9.5 <\\/h4>\\n<ul>\\n<li>Added: Dynamic fields support for all widgets<\\/li>\\n<li>Fixed: Global Tooltips \\u2014 Position not being overriden<\\/li>\\n<li>Fixed: Timeline \\u2014 Pointer cursor not showing on linked cards<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Image bottom spacing on some themes<\\/li>\\n<li>Tweak: Gallery Extra \\u2014 Added unique classes to each item<\\/li>\\n<li>Tweak: HTML5 Video \\u2014 Added control to enable muted video for autoplay<\\/li>\\n<li>Tweak: HTML5 Video \\u2014 Added controls to enable or disable all elements inside the bar<\\/li>\\n<\\/ul>\\n<h4> 1.9.4 <\\/h4>\\n<ul>\\n<li>Added: Timeline \\u2014 Control to center images<\\/li>\\n<li>Added: Posts Extra \\u2014 New filters for post title, excerpt, comments and date<\\/li>\\n<li>Added: HTML5 Video \\u2014 Control to stop all other video players when current one is played.<\\/li>\\n<li>Fixed: Fixed: Column widths in post-css are rendered in the wrong order<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Posts per page doesn\'t take into account sticky posts<\\/li>\\n<li>Fixed: Buttons \\u2014 Item typography group control not working<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Responsive horizontal alignment for filters<\\/li>\\n<li>Fixed: Hotspots \\u2014 Tooltip position not being overriden at hotspot level<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Control conditions<\\/li>\\n<li>Tweak: Updated isotope version to 3.0.6 to fix 1px grid gap<\\/li>\\n<li>Tweak: Remove default webkit left padding from list navs<\\/li>\\n<li>Tweak: Parallax Background \\u2014 Increase plugin timeout reinit<\\/li>\\n<li>Tweak: Posts \\u2014 Increase excerpt length filter priority<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Added option to show only sticky posts<\\/li>\\n<\\/ul>\\n<h4> 1.9.3 <\\/h4>\\n<ul>\\n<li>Added: Sticky Elements \\u2014 Compatibility with the Lazy Loader wordpress plugin<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Safari &lt; 10.2 layout glitch layout glitch on mobile<\\/li>\\n<li>Fixed: HTML5 Video \\u2014 m4v files condition<\\/li>\\n<li>Fixed: Sticky \\u2014 Sticks only when resizing browser window<\\/li>\\n<li>Fixed: Sticky \\u2014 Not working correctly with Stretched parent<\\/li>\\n<li>Fixed: HTML5 Video \\u2014 m4v format not sufficient<\\/li>\\n<li>Fixed: Image Comparison \\u2013 Allow 0 percent values<\\/li>\\n<li>Tweak: HTML5 Video \\u2014 Render attributes<\\/li>\\n<li>Tweak: HTML5 Video \\u2014 Control conditions<\\/li>\\n<\\/ul>\\n<h4> 1.9.2 <\\/h4>\\n<ul>\\n<li>Fixed: Switcher \\u2014 Bug with arrow loader position and stroke width in older versions of Safari<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Compatibility with IE 11<\\/li>\\n<li>Fixed: Parallax Elements \\u2014 Control value undefined check<\\/li>\\n<\\/ul>\\n<h4> 1.9.1 <\\/h4>\\n<ul>\\n<li>Fixed: Parallax Elements \\u2014 Max distance not taking into account scroll position<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Filters not stacking on responsive.<\\/li>\\n<li>Fixed: Switcher \\u2014 Arrow loader not displaying in firefox<\\/li>\\n<li>Fixed: Parallax Elements \\u2014 Wrong position for scroll with start position<\\/li>\\n<li>Fixed: GSAP dependencies<\\/li>\\n<\\/ul>\\n<h4> 1.9.0 <\\/h4>\\n<ul>\\n<li>Added: New Switcher Widget! \\u2014 Switch photos and text using powerful javascript driven transitions. Features menu and arrows navigation, autoplay with progress loader, entrance animations, page background color switcher, two skins (default and overlay) and much more.<\\/li>\\n<li>Added: New Feature for Parallax Elements! \\u2014 Option to parallax columns and widgets on mouse move<\\/li>\\n<li>Added: Posts Extra \\u2014 Controls to style only sticky posts<\\/li>\\n<li>Added: Image Comparison \\u2014 Option to enable clicking on labels to uncover images<\\/li>\\n<li>Added: Hotspots \\u2014 Separate color controls for each hotspot<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Sticky posts not working when a category is selected in the query<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Invisible gallery when preview position is top on desktop<\\/li>\\n<li>Fixed: Image Comparison \\u2014 Remove labels if no text is present<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Hide carousel until properly rendered<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Added alt and title tags to image element<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Issue with negative margin resulting in right whitespace for the gallery<\\/li>\\n<li>Fixed: Timeline \\u2014 Controls conditions<\\/li>\\n<li>Fixed: Timeline \\u2014 Item point color override<\\/li>\\n<li>Fixed: Timeline \\u2014 Properly override point content<\\/li>\\n<li>Tweak: Parallax Elements \\u2014 Removed group control<\\/li>\\n<li>Tweak: Gallery Extra, Gallery Slider, Posts Extra \\u2014 Added notice with link to blend mode browser support for blend mode controls<\\/li>\\n<li>Tweak: Timeline \\u2014 Added repeater setting key method to card render function<\\/li>\\n<\\/ul>\\n<h4> 1.8.8 <\\/h4>\\n<ul>\\n<li>Added: Gallery Extra \\u2014 Control width and ratio of each individual image in manual mode<\\/li>\\n<li>Added: Timeline \\u2014 Option for automatic numbering and letters instead of icons to points<\\/li>\\n<li>Added: Timeline \\u2014 New control to set excerpt length<\\/li>\\n<li>Added: Unfold \\u2014 Option to change icon when unfolded<\\/li>\\n<li>Added: Sticky Elements \\u2014 Option to turn off bottoming of elements inside the parent<\\/li>\\n<li>Added: Posts Extra \\u2014 Option to enable sticky posts in query<\\/li>\\n<li>Added: Posts Extra \\u2014 Arrows sizing controls<\\/li>\\n<li>Added: Posts Extra \\u2014 Transition control for carousel arrows and pagination<\\/li>\\n<li>Added: Posts Extra \\u2014 Option to set how many slides to scroll<\\/li>\\n<li>Added: Image Comparison \\u2014 Control to define initial position of separator<\\/li>\\n<li>Added: Image Comparison \\u2014 Option to enable moving separator by clicking anywhere on the image<\\/li>\\n<li>Added: Buttons \\u2014 Control for label min width<\\/li>\\n<li>Added: Hotspots \\u2014 Control to disable pulsating animation<\\/li>\\n<li>Fixed: Sticky Elements \\u2014 Controls not showing on inner sections<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Images wider than 100% on mobile in manual mixed masonry layout mode<\\/li>\\n<li>Fixed: HTML5 Video \\u2014 CSS bottom whitespace<\\/li>\\n<li>Fixed: Buttons \\u2014 Remove block label for buttons icon, id and class controls<\\/li>\\n<li>Tweak: Timeline \\u2014 Take sticky posts into consideration in query<\\/li>\\n<li>Tweak: Unfold \\u2014 Organise controls<\\/li>\\n<li>Tweak: WPML Compatibility \\u2014 Change method to fix fields not saving<\\/li>\\n<\\/ul>\\n<h4> 1.8.7 <\\/h4>\\n<ul>\\n<li>Fixed: Posts Extra \\u2014 Filtering one widget\'s posts affects all other widgets<\\/li>\\n<li>Fixed: Hotspots \\u2014 Tooltips have an extra space at the bottom when first hovering<\\/li>\\n<li>Fixed: HTML5 Video \\u2014 Volume functionality breaks when controls are hidden<\\/li>\\n<li>Fixed: HTML5 Video \\u2014 Video reloading after each loop<\\/li>\\n<li>Added: Global Tooltips \\u2014 Global controls for distance and width<\\/li>\\n<li>Tweak: HTML5 Video \\u2014 Added width and horizontal alignment control to player<\\/li>\\n<li>Tweak: Global Tooltips \\u2014 Remove default global styling values after Elementor enqueue fix in 1.9.5<\\/li>\\n<\\/ul>\\n<h4> 1.8.6 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Term slug classes to filters and post terms<\\/li>\\n<li>Fixed: Replaced create_function with anonymous function for PHP 7.2 support<\\/li>\\n<li>Fixed: Inline SVG \\u2014 Handle internal CSS in non color overriding situations<\\/li>\\n<li>Fixed: Hotspots \\u2014 Tooltips showing even if they have no content<\\/li>\\n<li>Tweak: Sticky Elements \\u2014 Prevent sticky on a section that is stretched with js<\\/li>\\n<li>Tweak: Buttons \\u2014 Move typography control above tabs<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Move hover animation controls to separate section for better ux<\\/li>\\n<li>Tweak: Gallery Extra \\u2014 Moved hover controls to separate section<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 Moved hover controls to separate section<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 Default font size for thumbnail captions<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Fix condition<\\/li>\\n<li>Tweak: Hotspots \\u2014 Show label for tooltip content in editor<\\/li>\\n<\\/ul>\\n<h4> 1.8.5 <\\/h4>\\n<ul>\\n<li>Fixed: Gallery Extra \\u2014 Missing js dependency<\\/li>\\n<\\/ul>\\n<h4> 1.8.4 <\\/h4>\\n<ul>\\n<li>Fixed: Gallery Extra \\u2014 Random ordering not working<\\/li>\\n<li>Fixed: Timeline \\u2014 RTL optimisation<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Custom image size not working on manual mode<\\/li>\\n<li>Tweak: Add dismissible notice for recommended php version<\\/li>\\n<li>Tweak: Gallery Extra \\u2014 Add title and description caption types<\\/li>\\n<li>Tweak: Timeline \\u2014 Add link control description to avoid linking cards when content already contains links<\\/li>\\n<\\/ul>\\n<h4> 1.8.3 <\\/h4>\\n<ul>\\n<li>Fixed: HTML5 Video \\u2014 Video not playing on Safari and some mobile environments<\\/li>\\n<li>Fixed: Buttons \\u2014 Safari buttons vertical alignment<\\/li>\\n<li>Fixed: Devices \\u2014 device not displaying on Safari when portrait mode is enabled<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Grid broken on Safari<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 reinit masonry when images done loading<\\/li>\\n<li>Tweak: Move all Extras admin settings into Elementor menu<\\/li>\\n<li>Tweak: Image Comparison \\u2014 Remove default value for width control<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 default mobile and tablet gallery columns to larger numbers<\\/li>\\n<\\/ul>\\n<h4> 1.8.2 <\\/h4>\\n<ul>\\n<li>Added: Parallax Background \\u2014 Support for section resize in elementor preview mode<\\/li>\\n<li>Fixed: Parallax Background \\u2014 Compatibility with stretched section<\\/li>\\n<li>Fixed: HTML5 Video \\u2014 Interface style controls conditions<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Right side white-space after thumbnails on top preview position<\\/li>\\n<li>Fixed: Unfold \\u2014 Page stops responding when entering invalid html in text editor mode<\\/li>\\n<li>Tweak: Unfold \\u2014 Allow accordions, tabs and all resizing elements inside content<\\/li>\\n<\\/ul>\\n<h4> 1.8.1 <\\/h4>\\n<ul>\\n<li>Fixed: Posts Extra \\u2014 Masonry broken when infinite scroll is enabled<\\/li>\\n<\\/ul>\\n<h4> 1.8.0 <\\/h4>\\n<ul>\\n<li>New extension: Global Tooltips \\u2014 Add a tooltip to any widget<\\/li>\\n<li>New: Disable Widgets &amp; Extensions \\u2014 You can now disable Extras widgets and extensions via the admin settings page<\\/li>\\n<li>Added: WPML compatibility \\u2014 String Translation and Translation Editor support for all widgets<\\/li>\\n<li>Added: Circle Progress \\u2014 Icon support inside circle<\\/li>\\n<li>Added: Update .pot translation file<\\/li>\\n<li>Added: Buttons \\u2014 Tooltips duration control<\\/li>\\n<li>Added: Global settings for Extras tooltips<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Widget not available on multisite installations<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Infinite scroll breaks when using multiple widgets on same page<\\/li>\\n<li>Fixed: Parallax Background \\u2014 Conflict with Anywhere Elementor Pro featured image background<\\/li>\\n<li>Tweak: Parallax Background \\u2014 requestAnimationFrame method for better performance<\\/li>\\n<li>Tweak: Buttons \\u2014 Rename text align label<\\/li>\\n<li>Tweak: Update nicons font<\\/li>\\n<\\/ul>\\n<h4> 1.7.4 <\\/h4>\\n<ul>\\n<li>Fixed: Gallery Extra \\u2014 Custom link broken and attributes not added<\\/li>\\n<\\/ul>\\n<h4> 1.7.3 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Column vertical alignment controls for carousel<\\/li>\\n<li>Added: Timeline \\u2014  Color controls for post title and excerpt<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Carousel rows number control not impacting preview<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Avatar vertical alignment on stretched media content<\\/li>\\n<li>Fixed: Sticky Elements \\u2014 Incorrect spacer height<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Improve editing flow by with advanced controls conditioning<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Controls position<\\/li>\\n<li>Tweak: Sticky Elements \\u2014 Remove popover from group control<\\/li>\\n<li>Tweak: Parallax Elements \\u2014 Remove popover from group control<\\/li>\\n<\\/ul>\\n<h4> 1.7.2 <\\/h4>\\n<ul>\\n<li>Added: Gallery Slider \\u2014 Overlay captions for preview and thumbnails<\\/li>\\n<li>Added: Gallery Slider \\u2014 Controls for caption effects, layout and hover properties<\\/li>\\n<li>Added: Gallery Slider \\u2014 Controls for active thumbs caption<\\/li>\\n<li>Fixed: Buttons \\u2014 Removed popover control on effects<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 Improved carousel adapt on preview resize<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 Improved thumbnails grid<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 Better controls for stacking and position of preview<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 Replace background color with background control for preview captions and overlay<\\/li>\\n<li>Tweak: Gallery Slider + Gallery Extra \\u2014 Better BEM classes<\\/li>\\n<\\/ul>\\n<h4> 1.7.1 <\\/h4>\\n<ul>\\n<li>Added: Gallery Extra \\u2014 Caption horizontal and vertical alignment and hover effects<\\/li>\\n<li>Added: Gallery Extra \\u2014 Ratio and alignment controls to masonry layout<\\/li>\\n<li>Added: Gallery Extra \\u2014 New border and border radius controls for captions<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Bring image to front when hovered<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Images not displaying on infinite load on iOS Safari and Chrome<\\/li>\\n<li>Tweak: Image Comparison \\u2014 Force override of modified image max-width attribute<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Added extra classes to media elements<\\/li>\\n<\\/ul>\\n<h4> 1.7.0 <\\/h4>\\n<ul>\\n<li>Added: Gallery Extra \\u2014 Masonry layout with mixed mode<\\/li>\\n<li>Added: Gallery Extra \\u2014 Tilt effect<\\/li>\\n<li>Added: Gallery Extra \\u2014 Caption horizontal and vertical alignment and hover effects<\\/li>\\n<li>Added: Gallery Extra \\u2014 Overlay, caption and image transition controls<\\/li>\\n<li>Added: Gallery Extra \\u2014 Overlay blend mode control<\\/li>\\n<li>Added: Gallery Extra \\u2014 Image scale controls for default and hover states<\\/li>\\n<li>Added: Gallery Extra \\u2014 Overlay margin controls for default and hover states<\\/li>\\n<li>Added: Gallery Extra \\u2014 Manual mode that allows entering of every image manually and linking it to any URL<\\/li>\\n<li>Added: Inline SVG widget<\\/li>\\n<li>Added: Posts Extra \\u2014 Controls to disable linking for post title, media and terms<\\/li>\\n<li>Added: Posts Extra \\u2014 Control to select default applied filter for filter bar<\\/li>\\n<li>Added: Timeline \\u2014 New controls for post title typography and spacing, post excerpt typography and padding<\\/li>\\n<li>Added: Image Comparison \\u2014 Image size control<\\/li>\\n<li>Added: New css transition control for Gallery Extra, Gallery Slider, Hotspots, Posts Extra, Timeline, Table and Inline SVG widgets<\\/li>\\n<li>Added: HTML5 Video \\u2014 M4V format support<\\/li>\\n<li>Added: Devices \\u2014 M4V format support for video<\\/li>\\n<li>Fixed: Buttons \\u2014 Flicker on flip effect<\\/li>\\n<li>Fixed: Timeline \\u2014 CSS class conflict<\\/li>\\n<li>Fixed: Table \\u2014 ID and class don\'t apply to header<\\/li>\\n<li>Tweak: Improved Elementor 1.9 compatibility for Extras group controls<\\/li>\\n<li>Tweak: Update TweenMax to latest version (1.20.2)<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Simplified CSS<\\/li>\\n<li>Tweak: Unfold \\u2014 Disconnect button and content from control alignment logic<\\/li>\\n<\\/ul>\\n<h4> 1.6.3 <\\/h4>\\n<ul>\\n<li>Fixed: Breadcrumbs \\u2014 Display correctly when used within an Elementor library template<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Condition terms separator<\\/li>\\n<li>Tweak: Breadcrumbs \\u2014 Avoid naming conflict with Elementor Pro widget<\\/li>\\n<\\/ul>\\n<h4> 1.6.2 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 New autoplay, autoheight and fade effect controls<\\/li>\\n<li>Added: Posts Extra \\u2014 &quot;Top&quot; option to media position on horizontal layout<\\/li>\\n<li>Added: Posts Extra \\u2014 Allowed media to be positioned horizontally on 2 columns layouts<\\/li>\\n<li>Added: Posts Extra \\u2014 New border controls for media<\\/li>\\n<li>Added: Table \\u2014 Allow table responsive behaviour to be turned off<\\/li>\\n<li>Tweak: Buttons \\u2014 Default button content alignment to justify<\\/li>\\n<li>Fix: Timeline \\u2014 Potential fatal error<\\/li>\\n<li>Fix: Posts Extra \\u2014 Post media position controls conditions<\\/li>\\n<li>Fix: Buttons \\u2014 Delay on transitioned properties<\\/li>\\n<li>Fix: Posts Extra \\u2014 Wrong tablet breakpoint set for number of columns<\\/li>\\n<li>Fix: Parallax Background \\u2014 Remove initial background image once parallax is activated<\\/li>\\n<\\/ul>\\n<h4> 1.6.1 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Link author name and avatar to author posts pages<\\/li>\\n<li>Added: Posts Extra \\u2014 Read more link to excerpt<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Added separate hide option for Position for better UX <\\/li>\\n<li>Tweak: Posts Extra \\u2014 Improved position icons<\\/li>\\n<\\/ul>\\n<h4> 1.6.0 <\\/h4>\\n<ul>\\n<li>New Widget \\u2014 Posts Extra - Create ANY layout for posts with masonry, infinite load, filtering and custom post type support. Works only with Elementor Pro<\\/li>\\n<li>Tweak: Breadcrumbs \\u2014 Added horizontal position and text alignment controls<\\/li>\\n<li>Tweak: Buttons \\u2014 Improved CSS and better alignment and stacking options<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Error outputting separator<\\/li>\\n<li>Fixed: Buttons \\u2014 Transition on button content when effects are turned on<\\/li>\\n<\\/ul>\\n<h4> 1.5.6 <\\/h4>\\n<ul>\\n<li>Fixed: Parallax Background \\u2014 Replaced parallax class name to avoid future conflicts<\\/li>\\n<li>Fixed: Timeline \\u2014 Remove flex from left aligned timeline and allow image spacing for horizontal layouts<\\/li>\\n<li>Fixed: PHP fatal error<\\/li>\\n<li>Tweak: Unfold \\u2014 Switched Settings with Content sections in editor for better UX<\\/li>\\n<\\/ul>\\n<h4> 1.5.5 <\\/h4>\\n<ul>\\n<li>Added: Buttons \\u2014 Inline editing<\\/li>\\n<li>Added: Breadcrumbs \\u2014 Inline editing<\\/li>\\n<li>Added: Circle Progress \\u2014 Inline editing<\\/li>\\n<li>Added: Hotspots \\u2014 Inline editing<\\/li>\\n<li>Added: Image Comparison \\u2014 Inline editing<\\/li>\\n<li>Added: Table \\u2014 Inline editing<\\/li>\\n<li>Added: Text Divider \\u2014 Inline editing<\\/li>\\n<li>Added: Timeline \\u2014 Inline editing<\\/li>\\n<li>Added: Unfold \\u2014 Inline editing<\\/li>\\n<li>Fixed: Tooltips \\u2014 Error &quot;size&quot; of undefined appears for delay_in in some cases<\\/li>\\n<li>Fixed: Unfold \\u2014 Issue that resulted in wrong calculation of unfolded height<\\/li>\\n<li>Tweak: Default to text cursor for text where inline editing is available<\\/li>\\n<\\/ul>\\n<h4> 1.5.4 <\\/h4>\\n<ul>\\n<li>Added: HTML5 Video \\u2014 Option to end video at last frame<\\/li>\\n<li>Tweak: HTML5 Video \\u2014 Removed auto pausing when interacting with progress bar<\\/li>\\n<\\/ul>\\n<h4> 1.5.3 <\\/h4>\\n<ul>\\n<li>Fixed: Unfold \\u2014 Content folds back automatically when scrolling on mobile browsers that vertically resize the viewport<\\/li>\\n<\\/ul>\\n<h4> 1.5.2 <\\/h4>\\n<ul>\\n<li>Added: Gallery Extra \\u2014 Allow gallery navigation in lightbox<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Image box shadow not applying<\\/li>\\n<li>Fixed: Buttons \\u2014 Issue with transition delays on buttons without effects<\\/li>\\n<\\/ul>\\n<h4> 1.5.1 <\\/h4>\\n<ul>\\n<li>Added: Table \\u2014 Control to show header on mobile as a block or a column<\\/li>\\n<li>Added: Table \\u2014 Border control for table rows<\\/li>\\n<li>Added: Table \\u2014 Option to automatically try to fetch correct headers for mobile with override possibility<\\/li>\\n<li>Added: Table \\u2014 Control to set width for mobile headers<\\/li>\\n<li>Tweak: Table \\u2014 Remove column rules from mobile<\\/li>\\n<li>Tweak: Table \\u2014 Removed first \\/ last child border rules from mobile<\\/li>\\n<li>Tweak: Table \\u2014 Added pointer cursor on sortable header cells<\\/li>\\n<li>Tweak: Table \\u2014 Moved padding to text for better handling of responsive layout and removed negative margin technique<\\/li>\\n<li>Tweak: Table \\u2014 Responsive cells and header cells padding controls<\\/li>\\n<li>Tweak: Table \\u2014 Move cell header control to top<\\/li>\\n<li>Tweak: Table \\u2014 Added option to hide headers completely on mobile<\\/li>\\n<li>Tweak: Table \\u2014 Hide mobile headers that have no content<\\/li>\\n<li>Tweak: Sticky \\u2014 Set default z-index to 1 for stickable elements<\\/li>\\n<li>Fixed: Image Comparison \\u2014 Separator not showing<\\/li>\\n<li>Fixed: Image Comparison \\u2014 Remove space between images and widget container<\\/li>\\n<li>Fixed: Table \\u2014 PHP Warning when allowing empty on repeater fields<\\/li>\\n<li>Fixed: Table \\u2014 Width and alignment not working<\\/li>\\n<li>Fixed: Table \\u2014 Added missing custom class and id from markup<\\/li>\\n<\\/ul>\\n<h4> 1.5.0 <\\/h4>\\n<ul>\\n<li>New Widget: Table<\\/li>\\n<li>Fixed: Prefix CSS helper classes to avoid potential conflicts<\\/li>\\n<\\/ul>\\n<h4> 1.4.0 <\\/h4>\\n<ul>\\n<li>New: Buttons Effects<\\/li>\\n<li>Added: Breadcrumbs \\u2014 Control to manually specify which post or page to generate breadcrumbs for<\\/li>\\n<li>Fixed: Devices \\u2014 Horizontal orientation image not visible<\\/li>\\n<\\/ul>\\n<h4> 1.3.1 <\\/h4>\\n<ul>\\n<li>Fixed: Parallax Background \\u2014 Wrong position when loading page off viewport<\\/li>\\n<li>Fixed: Timeline \\u2014 Enlarged points not aligned to line on tablet and mobile<\\/li>\\n<li>Added: Timeline \\u2014 Responsive controls for point size and icon size<\\/li>\\n<\\/ul>\\n<h4> 1.3.0 <\\/h4>\\n<ul>\\n<li>Added: New Widget! \\u2014 HTML5 Video<\\/li>\\n<li>Added: Devices \\u2014 Added HTML5 Video controls<\\/li>\\n<li>Added: Devices \\u2014 Added option to stretch the video to fit into the device screen<\\/li>\\n<li>Added: Devices \\u2014 Added option to choose wether or not to stop the video when leaving viewport<\\/li>\\n<li>Added: Timeline \\u2014 Hover properties for points<\\/li>\\n<li>Added: Timeline \\u2014 More style override options for each card<\\/li>\\n<li>Added: Gallery Slider \\u2014 More responsive controls for preview position and spacing<\\/li>\\n<li>Fixed: Timeline \\u2014 Removed unnecessary z-index from cards<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Preview spacing doesn\'t work on mobile when the layout is vertical<\\/li>\\n<li>Fixed: Devices \\u2014 Replaced SVG IDs with classes to avoid code invalidation<\\/li>\\n<li>Fixed: Circle Progress \\u2014 Canvas distorted on responsive<\\/li>\\n<li>Fixed: Hotspots \\u2014 Links concatenating from one repeater field to another<\\/li>\\n<li>Fixed: Parallax Background \\u2014 Images move up after scrolling up and down multiple times<\\/li>\\n<li>Fixed: Parallax Background \\u2014 Background position is off when section Stretch is turned on<\\/li>\\n<li>Fixed: Hotspots \\u2014 Links inside tooltips appear outside of the tooltip<\\/li>\\n<li>Tweak: Timeline \\u2014 Changed &quot;Size Ratio&quot; name to &quot;Scale&quot;<\\/li>\\n<li>Tweak: Gallery Extras \\u2014 Bring 3D items to front on hover<\\/li>\\n<li>Tweak: Hotspots \\u2014 Moved tooltip content outside hotspot to avoid invalid nodes<\\/li>\\n<li>Tweak: Hotspots \\u2014 Don\'t activate tooltips that have no content set<\\/li>\\n<\\/ul>\\n<h4> 1.2.5 <\\/h4>\\n<ul>\\n<li>Tweak: Replaced text align icons with horizontal align icons where appropriate<\\/li>\\n<li>Fixed: Sticky elements not bottoming out correctly when using custom parent selector<\\/li>\\n<li>Fixed: Removing unstick for any breakpoint would break sticky functionality<\\/li>\\n<\\/ul>\\n<h4> 1.2.4 <\\/h4>\\n<ul>\\n<li>Added: Sticky \\u2014 Custom selector for sticky parent to allow for elements to stick in any parent element<\\/li>\\n<li>Tweak: Timeline \\u2014 Responsive padding controls<\\/li>\\n<li>Tweak: Timeline \\u2014 Refactoring and improved performance and accuracy on progress bar<\\/li>\\n<li>Tweak: Image Comparison \\u2014 Adjust spacing method for labels and vertical alignment improvements<\\/li>\\n<li>Tweak: Image Comparison \\u2014 Allow for widget border radius control to affect images<\\/li>\\n<li>Fixed: Parallax Background \\u2014 Scroll breaks on mobile when hiding a parallaxed section<\\/li>\\n<li>Fixed: Timeline \\u2014 Cards not animating when first in view<\\/li>\\n<li>Fixed: Timeline \\u2014 Content wrapper present even if no card content is set<\\/li>\\n<\\/ul>\\n<h4> 1.2.3 <\\/h4>\\n<ul>\\n<li>Fixed: Parallax Background \\u2014 Section background not reverting after parallax turned on again<\\/li>\\n<li>Fixed: Parallax Background \\u2014 Calculating wrong dimensions when using Elementor JS stretch option<\\/li>\\n<li>Fixed: Issue where updating Elementor when Extras is active would result in an error<\\/li>\\n<li>Tweak: Hotspots \\u2014 Adjusted default tooltip width<\\/li>\\n<\\/ul>\\n<h4> 1.2.2 <\\/h4>\\n<ul>\\n<li>Fixed: Heading Extra \\u2014 Complete html support<\\/li>\\n<\\/ul>\\n<h4> 1.2.1 <\\/h4>\\n<ul>\\n<li>Fixed: Heading Extra \\u2014 Gradient would show only for the first line<\\/li>\\n<li>Fixed: Parallax Background \\u2014 When using padding on sections, image position calculation would not be correct<\\/li>\\n<\\/ul>\\n<h4> 1.2.0 <\\/h4>\\n<ul>\\n<li>Added: New Feature! \\u2014 Parallax Background \\u2014 Now you can parallax section backgrounds and have it move up, down, left or right while scrolling<\\/li>\\n<li>Added: New Widget! \\u2014 Unfold \\u2014 Lets you hide content and reveal it on demand<\\/li>\\n<li>Added: New Widget! \\u2014 Breadcrumbs<\\/li>\\n<li>Added: Parallax Elements \\u2014 Allow to select whether to parallax an element relative to its own position or the middle of the viewport<\\/li>\\n<li>Added: Hotspots \\u2014 Ability to add links to hotspots if tooltips are triggered on hover<\\/li>\\n<li>Added: Tooltips \\u2014 Added left and right tooltips for both Hotspots and Button Groups<\\/li>\\n<li>Added: Tooltips \\u2014 Better handling of repositioning tooltips when they flow outside of the viewport<\\/li>\\n<li>Added: Tooltips \\u2014 Ability to override tooltip position for each button of hotspot individually<\\/li>\\n<li>Added: Heading Extra \\u2014 Text fill now supports clipped images<\\/li>\\n<li>Tweak: Heading Extra \\u2014 Allow to have both text shadow and long shadow on the same text<\\/li>\\n<li>Tweak: Text Divider \\u2014 Responsive alignment and spacing controls<\\/li>\\n<li>Tweak: Text Divider \\u2014 Proper horizontal alignment of text and separators<\\/li>\\n<li>Fixed: Heading Extra \\u2014 Multiple z-index related issues<\\/li>\\n<li>Fixed: Parallax Elements \\u2014 Fix issue where elements would jump when scrolling<\\/li>\\n<\\/ul>\\n<h4> 1.1.4 <\\/h4>\\n<ul>\\n<li>Added: Sticky sections!<\\/li>\\n<li>Added: Sticky \\u2014 New controls to unstick for mobile and tablet<\\/li>\\n<li>Added: Parallax Elements \\u2014 New controls to set different speeds for different breakpoints<\\/li>\\n<li>Added: Gallery Slider \\u2014 Links on images and support for the new Elementor lightbox feature<\\/li>\\n<li>Tweak: Improved shortcode support for all widgets, especially tooltips<\\/li>\\n<li>Tweak: Parallax Elements \\u2014 Greatly improved performance for parallaxed items<\\/li>\\n<li>Tweak: Parallax Elements \\u2014 Changed speed control logic to allow for reverse parallax<\\/li>\\n<li>Tweak: Created custom group controls for Sticky and Parallax features<\\/li>\\n<li>Fixed: Removed z-index from sticky elements to allow z-index setting from Elementor controls<\\/li>\\n<li>Fixed: Gallery Extras \\u2014 Some styling controls were conditioned by the &quot;Link to&quot; control<\\/li>\\n<li>Fixed: Removed potentially buggy call to Elementor class<\\/li>\\n<\\/ul>\\n<h4> 1.1.3 <\\/h4>\\n<ul>\\n<li>Tweak: Devices \\u2014 Refactored and cleaned up code for editor functionality<\\/li>\\n<li>Tweak: Gallery Extra \\u2014 Moved distance control after parallax controls<\\/li>\\n<li>Added: Controls to add parallax to any widget or column<\\/li>\\n<li>Added: Global control for turning off parallax functionality for tablet and mobile<\\/li>\\n<li>Added: Gallery Extra \\u2014 Control for settings horizontal overlap of images<\\/li>\\n<li>Added: Image Comparison \\u2014 Separator between images<\\/li>\\n<li>Added: Global \\u2014 Implemented the new Text Shadow controls for all widgets<\\/li>\\n<li>Added: Button Groups \\u2014 Responsive control of spacing for stacked buttons<\\/li>\\n<li>Fixed: Devices \\u2014 Issue where frames would not properly change in editor mode<\\/li>\\n<li>Fixed: Changed license page capability to \'manage_options\'<\\/li>\\n<li>Fixed: Compatibility with Elementor 1.6<\\/li>\\n<\\/ul>\\n<h4> 1.1.2 <\\/h4>\\n<ul>\\n<li>Fixed: Class namespace change in Elementor Pro 1.5.7 resulting in fatal error<\\/li>\\n<\\/ul>\\n<h4> 1.1.1 <\\/h4>\\n<ul>\\n<li>Fixed: Devices \\u2014 Overlay not visible for laptop and desktop<\\/li>\\n<li>Fixed: Timeline \\u2014 PHP empty function fatal error<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Width remained 50% even if vertical layout selected<\\/li>\\n<\\/ul>\\n<h4> 1.1.0 <\\/h4>\\n<ul>\\n<li>Added: New Widget! \\u2014 Gallery Extra \\u2014 We\'ve taken aside the parallax functionality and created a whole new widget with nots of posibilities.<\\/li>\\n<li>Added: New Widget! \\u2014 Gallery Slider \\u2014 A gallery layout with inline preview.<\\/li>\\n<li>Added: New Feature! \\u2014 Button tooltips \\u2014 You can now use the Button Groups widget to add buttons with tooltips.<\\/li>\\n<li>Added: New Feature! \\u2014 Timeline \\u2014 Integration with Woocommerce products.<\\/li>\\n<li>Added: New Feature! \\u2014 Hotspots \\u2014 Added support for icons inside hotspots.<\\/li>\\n<li>Added: New Feature! \\u2014 Hotspots \\u2014 Ability to set the delay for both entrance close animations.<\\/li>\\n<li>Added: Circle Progress \\u2014 Control too choose start angle for the circle progress.<\\/li>\\n<li>Added: Devices \\u2014 Support for multiple video formats<\\/li>\\n<li>Added: Timeline \\u2014 Add featured images from separate control.<\\/li>\\n<li>Added: Elementor Portfolio Widget \\u2014 Speed control for parallax feature.<\\/li>\\n<li>Added: Timeline \\u2014 Turn on and off for excerpts, content, title and featured image.<\\/li>\\n<li>Fixed: Image Comparison \\u2014 Handle now goes all the way until the end of the image.<\\/li>\\n<li>Fixed: Timeline \\u2014 Date color wasn\'t changing properly.<\\/li>\\n<li>Fixed: Issue where disabling and changing license was not possible.<\\/li>\\n<li>Fixed: Sticky - Issue where in preview mode wrong height of the element was calculated.<\\/li>\\n<li>Fixed: Image Gallery \\u2014 Issue with displaying on Firefox.<\\/li>\\n<li>Fixed: Image Comparison \\u2014 Handle jumps when using multiple widgets on same page.<\\/li>\\n<li>Fixed: Timeline \\u2014 Scheme style override issue for points.<\\/li>\\n<li>Fixed: Devices \\u2014 Video would not play on iOS devices<\\/li>\\n<\\/ul>\\n<h4> 1.0.5 <\\/h4>\\n<ul>\\n<li>Added: Button Groups \\u2014 Box shadow control.<\\/li>\\n<li>Fixed: Ensured compatibility with other jquery appear plugins.<\\/li>\\n<li>Fixed: Issue where disabling and changing license was not possible.<\\/li>\\n<\\/ul>\\n<h4> 1.0.4 <\\/h4>\\n<ul>\\n<li>Added: Added translation support<\\/li>\\n<li>Fixed: Devices \\u2014 Issue where controls would always display as a white rectangular shape.<\\/li>\\n<\\/ul>\\n<h4> 1.0.3 <\\/h4>\\n<ul>\\n<li>Fixed: Image Galleries \\u2014 Issue where galleries with no links would break the layout<\\/li>\\n<li>Fixed: Hotspots \\u2014 When using multiple hotspots widgets on the same page additional widgets would show the first widget\'s tooltips instead of their own<\\/li>\\n<\\/ul>\\n<h4> 1.0.2 <\\/h4>\\n<ul>\\n<li>Added: Hotspots \\u2014 New controls: text align, padding, border and typography<\\/li>\\n<li>Fixed: Hotspots \\u2014 Hide arrow control not working<\\/li>\\n<li>Fixed: Hotspots \\u2014 Issue where tooltips don\'t remain open on click trigger option and thus preventing clicking off links inside tooltips<\\/li>\\n<li>Fixed: Button Groups \\u2014 Replaced custom border controls with border group control<\\/li>\\n<li>Fixed: Extended Heading \\u2014 Compability with Elementor 1.5<\\/li>\\n<li>Fixed: Extended Heading \\u2014 Heading size not working<\\/li>\\n<li>Fixed: Image Comparison \\u2014 Issue where colors of labels would not change colors for printed templates<\\/li>\\n<\\/ul>\\n<h4> 1.0.1 <\\/h4>\\n<ul>\\n<li>Fixed: Image Comparison \\u2014 Issue where dragging the handle on mobile would not work<\\/li>\\n<\\/ul>\\n<h4> 1.0.0 <\\/h4>\\n<ul>\\n<li>Added: New &quot;Timeline&quot; widget with posts support for Elementor Pro<\\/li>\\n<li>Added: Image Comparison \\u2014 Different colors for both labels<\\/li>\\n<li>Tweak: Image Comparison \\u2014 Moved alignment &amp; scaling options to widget wrapper<\\/li>\\n<li>Tweak: Aligned default widgets colors to selected color scheme<\\/li>\\n<li>Tweak: Removed sticky from sections temporarily<\\/li>\\n<li>Tweak: Removed parallax scrolling from section backgrounds<\\/li>\\n<li>Tweak: Button Groups \\u2014 Reorganized repeater controls under tabs<\\/li>\\n<li>Tweak: Full compatibility with global color schemes for all widgets<\\/li>\\n<li>Tweak: Hotspots \\u2014 Reorganized repeater controls under tabs<\\/li>\\n<li>Fixed: Timeline \\u2014 Issue where arrow colors would not apply<\\/li>\\n<li>Fixed: Extended Heading \\u2014 Entrace animation hides the shadow when animation is complete<\\/li>\\n<li>Fixed: Devices \\u2014 Border type not present in hover state for video controls<\\/li>\\n<li>Fixed: Image Comparison \\u2014 Removed small space after widget<\\/li>\\n<li>Fixed: Hotspots \\u2014 Syntax error in JS template<\\/li>\\n<li>Fixed: Hotspots \\u2014 JS error when adding new hotpots<\\/li>\\n<li>Fixed: Hotspots \\u2014 Tooltips z-index issue<\\/li>\\n<li>Fixed: Hotspots \\u2014 Bottom tooltips animated down instead of up<\\/li>\\n<li>Fixed: Hotspots \\u2014 Html being added as string when hotspots are triggered through the open_editor hook<\\/li>\\n<li>Fixed: Hotspots \\u2014 Tooltips not editable immediately when dragged into preview<\\/li>\\n<li>Fixed: Image Comparison \\u2014 images are not set to occupy full width<\\/li>\\n<\\/ul>\\n<h4> 0.1.2 <\\/h4>\\n<ul>\\n<li>Added: Hotspots \\u2014 Rewrote code entirely to allow for preview mode support, customisation of tooltips and faster rendering<\\/li>\\n<li>Added: Circle progress \\u2014 Better handling of value suffix<\\/li>\\n<li>Fixed: Scripts dependencies<\\/li>\\n<li>Fixed: Devices \\u2014 Issue where global colors where used instead of skins<\\/li>\\n<li>Fixed: Various compatibility issues with the Elementor color scheme<\\/li>\\n<li>Fixed: Image Gallery Extension \\u2014 Styling issues when choosing to justify gallery items<\\/li>\\n<li>Fixed: Sticky Extension \\u2014 Sitcky offset would not preview correctly and sometimes having multiple sticky widgets would cause interference amongst them<\\/li>\\n<li>Fixed: Parallax Gallery \\u2014 Removed any kinds of transformation for odd children<\\/li>\\n<\\/ul>\\n<h4> 0.1.1 <\\/h4>\\n<ul>\\n<li>Fixed: Buttons groups \\u2014 Responsive alignment of buttons<\\/li>\\n<li>Added: Buttons groups \\u2014 option to stack buttons on tablet or mobile<\\/li>\\n<\\/ul>\\n<h4> 0.1.0 <\\/h4>\\n<ul>\\n<li>Initial Private Beta<\\/li>\\n<\\/ul>\"],\"installation\":[\"<ol>\\n<li>Make sure Elementor is installed and active on your website<\\/li>\\n<li>Activate the plugin through the \'Plugins\' menu in WordPress<\\/li>\\n<li>Edit a page (or post) using Elementor<\\/li>\\n<li>Find and use the new widgets and extensions<\\/li>\\n<\\/ol>\"]}\";}", "no");
INSERT INTO `puy_options` VALUES("845", "recovery_mode_email_last_sent", "1596019644", "yes");
INSERT INTO `puy_options` VALUES("859", "cpto_options", "a:7:{s:23:\"show_reorder_interfaces\";a:7:{s:4:\"post\";s:4:\"show\";s:10:\"attachment\";s:4:\"show\";s:8:\"wp_block\";s:4:\"show\";s:17:\"elementor_library\";s:4:\"show\";s:8:\"branches\";s:4:\"show\";s:14:\"elementor_font\";s:4:\"show\";s:15:\"elementor_icons\";s:4:\"show\";}s:8:\"autosort\";i:1;s:9:\"adminsort\";i:1;s:18:\"use_query_ASC_DESC\";s:0:\"\";s:17:\"archive_drag_drop\";i:1;s:10:\"capability\";s:14:\"manage_options\";s:21:\"navigation_sort_apply\";i:1;}", "yes");
INSERT INTO `puy_options` VALUES("860", "CPT_configured", "TRUE", "yes");
INSERT INTO `puy_options` VALUES("881", "category_children", "a:0:{}", "yes");
INSERT INTO `puy_options` VALUES("1266", "duplicator_lite_inst_hash_notice", "1", "yes");
INSERT INTO `puy_options` VALUES("1356", "disallowed_keys", "", "no");
INSERT INTO `puy_options` VALUES("1357", "comment_previously_approved", "1", "yes");
INSERT INTO `puy_options` VALUES("1358", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `puy_options` VALUES("1359", "finished_updating_comment_type", "1", "yes");
INSERT INTO `puy_options` VALUES("1360", "db_upgraded", "", "yes");
INSERT INTO `puy_options` VALUES("1363", "can_compress_scripts", "0", "no");
INSERT INTO `puy_options` VALUES("1445", "_transient_update_plugins", "O:8:\"stdClass\":1:{s:12:\"last_checked\";i:0;}", "yes");
INSERT INTO `puy_options` VALUES("1446", "_transient_update_themes", "O:8:\"stdClass\":1:{s:12:\"last_checked\";i:0;}", "yes");
INSERT INTO `puy_options` VALUES("1492", "googlesitekit_new_site_posts", "1", "yes");
INSERT INTO `puy_options` VALUES("1493", "googlesitekit_db_version", "1.8.1", "yes");
INSERT INTO `puy_options` VALUES("1496", "_transient_googlesitekit_verification_meta_tags", "a:0:{}", "yes");
INSERT INTO `puy_options` VALUES("1497", "googlesitekit_credentials", "YM1clcyh1bNm/K1My999aEdkWWs2VUpneEdsWk9Ld0pvb0VZcnNaL0VCZC9leEI4dlJCdmZ5dHpmQmliTDBaQkJxdGxnazB2eVU3SURGOVcyaTJBWUtwK3ZVRkZMWXBqeXhiVWtGaVBNZURMSzRkSU1panR5dEUvbndTa2sxdm5hZEorRXVjeTNWaWQxaDUxNTdsRnZXQTB2bkRaWWU5K04vMm5JRDZJeVNxQ1F1YzhNMjdYN0Q2dzV6MnpnM3hNTk5KOTFKeHM5ODJMWVpjUi84U3JDbFhiQWM1WDRXOXRxcnJwRjVnODU2cllVbWdZZ0RTNTdOeG8ydFF2azU4dGVDTGVnQVRHUit0cjhya1dwS1MreWZ4SFVlSmJRVDh3STVnT1lUSVphaG42YzFNVFpCa1BoaVQ5Smd5MndEQjNmMFZLSzc1b2pRPT0=", "yes");
INSERT INTO `puy_options` VALUES("1498", "googlesitekit_search-console_settings", "a:1:{s:10:\"propertyID\";s:25:\"https://www.c-serv.co.il/\";}", "yes");
INSERT INTO `puy_options` VALUES("1499", "googlesitekit_first_admin", "3", "yes");
INSERT INTO `puy_options` VALUES("1500", "googlesitekit_active_modules", "a:2:{i:0;s:9:\"analytics\";i:1;s:18:\"pagespeed-insights\";}", "yes");
INSERT INTO `puy_options` VALUES("1501", "googlesitekit_analytics_settings", "a:8:{s:9:\"accountID\";s:8:\"86266851\";s:13:\"adsenseLinked\";b:0;s:11:\"anonymizeIP\";b:1;s:21:\"internalWebPropertyID\";s:9:\"243013170\";s:9:\"profileID\";s:9:\"226400968\";s:10:\"propertyID\";s:14:\"UA-86266851-38\";s:16:\"trackingDisabled\";a:1:{i:0;s:13:\"loggedinUsers\";}s:10:\"useSnippet\";b:1;}", "yes");
INSERT INTO `puy_options` VALUES("1519", "wpseo", "a:30:{s:8:\"tracking\";b:0;s:22:\"license_server_version\";s:1:\"2\";s:15:\"ms_defaults_set\";b:0;s:40:\"ignore_search_engines_discouraged_notice\";b:0;s:25:\"ignore_indexation_warning\";b:0;s:29:\"indexation_warning_hide_until\";b:0;s:18:\"indexation_started\";b:0;s:28:\"indexables_indexation_reason\";s:0:\"\";s:31:\"indexables_indexation_completed\";b:1;s:7:\"version\";s:4:\"14.9\";s:16:\"previous_version\";s:6:\"14.8.1\";s:20:\"disableadvanced_meta\";b:1;s:30:\"enable_headless_rest_endpoints\";b:1;s:17:\"ryte_indexability\";b:1;s:11:\"baiduverify\";s:0:\"\";s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";s:9:\"site_type\";s:0:\"\";s:20:\"has_multiple_authors\";b:1;s:16:\"environment_type\";s:10:\"production\";s:23:\"content_analysis_active\";b:1;s:23:\"keyword_analysis_active\";b:1;s:21:\"enable_admin_bar_menu\";b:1;s:26:\"enable_cornerstone_content\";b:1;s:18:\"enable_xml_sitemap\";b:1;s:24:\"enable_text_link_counter\";b:1;s:22:\"show_onboarding_notice\";b:0;s:18:\"first_activated_on\";i:1597311664;s:13:\"myyoast-oauth\";b:0;}", "yes");
INSERT INTO `puy_options` VALUES("1520", "wpseo_titles", "a:82:{s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-dash\";s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:43:\"%%name%%, מחבר ב-%%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:66:\"חיפוש עבור %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:45:\"העמוד לא נמצא %%sep%% %%sitename%%\";s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:66:\"הפוסט %%POSTLINK%% הופיע לראשונה ב-%%BLOGLINK%%.\";s:20:\"noindex-author-wpseo\";b:0;s:28:\"noindex-author-noposts-wpseo\";b:1;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:19:\"disable-post_format\";b:0;s:18:\"disable-attachment\";b:1;s:23:\"is-media-purge-relevant\";b:0;s:20:\"breadcrumbs-404crumb\";s:36:\"שגיאה 404: הדף לא נמצא\";s:29:\"breadcrumbs-display-blog-page\";b:1;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:21:\"ארכיון עבור\";s:18:\"breadcrumbs-enable\";b:0;s:16:\"breadcrumbs-home\";s:13:\"דף הבית\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:10:\"חיפשת\";s:15:\"breadcrumbs-sep\";s:7:\"&raquo;\";s:12:\"website_name\";s:19:\"שירות מרום\";s:11:\"person_name\";s:0:\"\";s:11:\"person_logo\";s:0:\"\";s:14:\"person_logo_id\";i:0;s:22:\"alternate_website_name\";s:0:\"\";s:12:\"company_logo\";s:60:\"https://www.c-serv.co.il/wp-content/uploads/2020/07/Logo.png\";s:15:\"company_logo_id\";i:31;s:12:\"company_name\";s:8:\"מרום\";s:17:\"company_or_person\";s:7:\"company\";s:25:\"company_or_person_user_id\";b:0;s:17:\"stripcategorybase\";b:0;s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:23:\"display-metabox-pt-post\";b:1;s:23:\"post_types-post-maintax\";i:0;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:23:\"display-metabox-pt-page\";b:1;s:23:\"post_types-page-maintax\";i:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:29:\"display-metabox-pt-attachment\";b:1;s:29:\"post_types-attachment-maintax\";i:0;s:23:\"title-elementor_library\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:26:\"metadesc-elementor_library\";s:0:\"\";s:25:\"noindex-elementor_library\";b:1;s:36:\"display-metabox-pt-elementor_library\";b:1;s:36:\"post_types-elementor_library-maintax\";i:0;s:14:\"title-branches\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:17:\"metadesc-branches\";s:0:\"\";s:16:\"noindex-branches\";b:0;s:27:\"display-metabox-pt-branches\";b:1;s:27:\"post_types-branches-maintax\";i:0;s:18:\"title-tax-category\";s:57:\"ארכיון %%term_title%% %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:28:\"display-metabox-tax-category\";b:1;s:20:\"noindex-tax-category\";b:0;s:18:\"title-tax-post_tag\";s:57:\"ארכיון %%term_title%% %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:28:\"display-metabox-tax-post_tag\";b:1;s:20:\"noindex-tax-post_tag\";b:0;s:21:\"title-tax-post_format\";s:57:\"ארכיון %%term_title%% %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:31:\"display-metabox-tax-post_format\";b:1;s:23:\"noindex-tax-post_format\";b:1;s:15:\"title-tax-types\";s:57:\"ארכיון %%term_title%% %%page%% %%sep%% %%sitename%%\";s:18:\"metadesc-tax-types\";s:0:\"\";s:25:\"display-metabox-tax-types\";b:1;s:17:\"noindex-tax-types\";b:0;s:23:\"taxonomy-types-ptparent\";i:0;}", "yes");
INSERT INTO `puy_options` VALUES("1521", "wpseo_social", "a:19:{s:13:\"facebook_site\";s:38:\"https://www.facebook.com/maromservice/\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:19:\"og_default_image_id\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:21:\"og_frontpage_image_id\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:11:\"youtube_url\";s:0:\"\";s:13:\"wikipedia_url\";s:0:\"\";s:10:\"fbadminapp\";s:0:\"\";}", "yes");
INSERT INTO `puy_options` VALUES("1522", "wpseo_flush_rewrite", "1", "yes");
INSERT INTO `puy_options` VALUES("1523", "yoast_migrations_free", "a:1:{s:7:\"version\";s:4:\"14.9\";}", "yes");
INSERT INTO `puy_options` VALUES("1524", "_transient_timeout_wpseo_link_table_inaccessible", "1628847666", "no");
INSERT INTO `puy_options` VALUES("1525", "_transient_wpseo_link_table_inaccessible", "0", "no");
INSERT INTO `puy_options` VALUES("1526", "_transient_timeout_wpseo_meta_table_inaccessible", "1628847666", "no");
INSERT INTO `puy_options` VALUES("1527", "_transient_wpseo_meta_table_inaccessible", "0", "no");
INSERT INTO `puy_options` VALUES("1535", "wpseo_ryte", "a:2:{s:6:\"status\";i:1;s:10:\"last_fetch\";i:1602150102;}", "yes");
INSERT INTO `puy_options` VALUES("1586", "_transient_health-check-site-status-result", "{\"good\":\"9\",\"recommended\":\"9\",\"critical\":\"2\"}", "yes");
INSERT INTO `puy_options` VALUES("1764", "redirection_options", "a:24:{s:7:\"support\";b:0;s:5:\"token\";s:32:\"5171d560b8f052afecb355d845990c9a\";s:12:\"monitor_post\";i:0;s:13:\"monitor_types\";a:0:{}s:19:\"associated_redirect\";s:0:\"\";s:11:\"auto_target\";s:0:\"\";s:15:\"expire_redirect\";i:-1;s:10:\"expire_404\";i:-1;s:7:\"modules\";a:0:{}s:10:\"newsletter\";b:0;s:14:\"redirect_cache\";i:1;s:10:\"ip_logging\";i:0;s:13:\"last_group_id\";i:1;s:8:\"rest_api\";i:0;s:5:\"https\";b:0;s:7:\"headers\";a:0:{}s:8:\"database\";s:3:\"4.1\";s:8:\"relocate\";s:0:\"\";s:16:\"preferred_domain\";s:0:\"\";s:7:\"aliases\";a:0:{}s:10:\"flag_query\";s:5:\"exact\";s:9:\"flag_case\";b:0;s:13:\"flag_trailing\";b:0;s:10:\"flag_regex\";b:0;}", "yes");
INSERT INTO `puy_options` VALUES("1822", "pojo_a11y_customizer_options", "a:13:{s:17:\"a11y_toolbar_icon\";s:10:\"wheelchair\";s:21:\"a11y_toolbar_position\";s:5:\"right\";s:25:\"a11y_toolbar_distance_top\";s:5:\"100px\";s:32:\"a11y_toolbar_distance_top_mobile\";s:4:\"50px\";s:15:\"a11y_bg_toolbar\";s:7:\"#ffffff\";s:18:\"a11y_color_toolbar\";s:7:\"#333333\";s:27:\"a11y_toggle_button_bg_color\";s:7:\"#4054b2\";s:24:\"a11y_toggle_button_color\";s:7:\"#ffffff\";s:14:\"a11y_bg_active\";s:7:\"#4054b2\";s:17:\"a11y_color_active\";s:7:\"#ffffff\";s:24:\"a11y_focus_outline_style\";s:5:\"solid\";s:24:\"a11y_focus_outline_width\";s:3:\"1px\";s:24:\"a11y_focus_outline_color\";s:7:\"#FF0000\";}", "yes");
INSERT INTO `puy_options` VALUES("2148", "googlesitekit_has_connected_admins", "1", "yes");
INSERT INTO `puy_options` VALUES("2552", "duplicate_page_options", "a:4:{s:21:\"duplicate_post_status\";s:5:\"draft\";s:23:\"duplicate_post_redirect\";s:7:\"to_list\";s:21:\"duplicate_post_suffix\";s:0:\"\";s:21:\"duplicate_post_editor\";s:7:\"classic\";}", "yes");
INSERT INTO `puy_options` VALUES("2558", "elementor_install_history", "a:3:{s:5:\"3.0.3\";i:1598781336;s:5:\"3.0.5\";i:1599123628;s:5:\"3.0.6\";i:1599457707;}", "yes");
INSERT INTO `puy_options` VALUES("2688", "rewrite_rules", "a:136:{s:19:\"sitemap_index\\.xml$\";s:19:\"index.php?sitemap=1\";s:31:\"([^/]+?)-sitemap([0-9]+)?\\.xml$\";s:51:\"index.php?sitemap=$matches[1]&sitemap_n=$matches[2]\";s:24:\"([a-z]+)?-?sitemap\\.xsl$\";s:39:\"index.php?yoast-sitemap-xsl=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:36:\"branches/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"branches/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"branches/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"branches/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"branches/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"branches/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:25:\"branches/([^/]+)/embed/?$\";s:41:\"index.php?branches=$matches[1]&embed=true\";s:29:\"branches/([^/]+)/trackback/?$\";s:35:\"index.php?branches=$matches[1]&tb=1\";s:37:\"branches/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?branches=$matches[1]&paged=$matches[2]\";s:44:\"branches/([^/]+)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?branches=$matches[1]&cpage=$matches[2]\";s:33:\"branches/([^/]+)(?:/([0-9]+))?/?$\";s:47:\"index.php?branches=$matches[1]&page=$matches[2]\";s:25:\"branches/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:35:\"branches/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:55:\"branches/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"branches/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"branches/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:31:\"branches/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:50:\"locations/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?types=$matches[1]&feed=$matches[2]\";s:45:\"locations/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?types=$matches[1]&feed=$matches[2]\";s:26:\"locations/([^/]+)/embed/?$\";s:38:\"index.php?types=$matches[1]&embed=true\";s:38:\"locations/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?types=$matches[1]&paged=$matches[2]\";s:20:\"locations/([^/]+)/?$\";s:27:\"index.php?types=$matches[1]\";s:42:\"elementor_lead/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"elementor_lead/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"elementor_lead/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"elementor_lead/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"elementor_lead/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"elementor_lead/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"elementor_lead/([^/]+)/embed/?$\";s:47:\"index.php?elementor_lead=$matches[1]&embed=true\";s:35:\"elementor_lead/([^/]+)/trackback/?$\";s:41:\"index.php?elementor_lead=$matches[1]&tb=1\";s:43:\"elementor_lead/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?elementor_lead=$matches[1]&paged=$matches[2]\";s:50:\"elementor_lead/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?elementor_lead=$matches[1]&cpage=$matches[2]\";s:39:\"elementor_lead/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?elementor_lead=$matches[1]&page=$matches[2]\";s:31:\"elementor_lead/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"elementor_lead/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"elementor_lead/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"elementor_lead/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"elementor_lead/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"elementor_lead/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:38:\"index.php?&page_id=2&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `puy_options` VALUES("2745", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:20:\"matan@hdigital.co.il\";s:7:\"version\";s:5:\"5.5.1\";s:9:\"timestamp\";i:1599008143;}", "no");
INSERT INTO `puy_options` VALUES("2764", "edd_api_request_5eb31cae0d7a62b4e5f10a6f9d170a4e", "a:2:{s:7:\"timeout\";i:1599039191;s:5:\"value\";s:191865:\"{\"new_version\":\"2.2.36\",\"stable_version\":\"2.2.36\",\"name\":\"Elementor Extras\",\"slug\":\"elementor-extras\",\"url\":\"https:\\/\\/shop.namogo.com\\/product\\/extras-elementor\\/?changelog=1\",\"last_updated\":\"3 days ago\",\"homepage\":\"https:\\/\\/shop.namogo.com\\/product\\/elementor-extras\",\"package\":\"https:\\/\\/shop.namogo.com\\/edd-sl\\/package_download\\/MTU5OTI5ODM5MTo5NDJmN2M1NDk1YTYxZjlmMzM0OWNjMGRhZWZlYzg5MjoxOTowZjYwMjM2NWZhNmIwODU5YzMwYTMxYWZiMjA4NzRmMzpodHRwc0AvL3d3dy5jLXNlcnYuY28uaWw6MA==\",\"download_link\":\"https:\\/\\/shop.namogo.com\\/edd-sl\\/package_download\\/MTU5OTI5ODM5MTo5NDJmN2M1NDk1YTYxZjlmMzM0OWNjMGRhZWZlYzg5MjoxOTowZjYwMjM2NWZhNmIwODU5YzMwYTMxYWZiMjA4NzRmMzpodHRwc0AvL3d3dy5jLXNlcnYuY28uaWw6MA==\",\"sections\":{\"description\":\"<p>Extras is one of the first premium Wordpress plugin for Elementor. It extends its capability with many unique widgets and extensions that make Elementor even more powerful.<\\/p>\\n<h4> Copyright and licensing <\\/h4>\\n<p>Copyright (C) 2016-2019 Elementor Ltd.<\\/p>\\n<p>This program is free software: you can redistribute it and\\/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.<\\/p>\\n<p>This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.<\\/p>\\n<p>You should have received a copy of the GNU General Public License along with this program. If not, see <a href=\\\"https:\\/\\/www.gnu.org\\/licenses\\/\\\">https:\\/\\/www.gnu.org\\/licenses\\/<\\/a>.<\\/p>\\n<h4> Third Party Code <\\/h4>\\n<p>Extras for Elementor incorporates code from:<\\/p>\\n<ul>\\n<li><strong>jquery-circle-progress<\\/strong> v1.2.2, Copyright Rostyslav Bryzgunov Licenses: MIT Source: link <a href=\\\"http:\\/\\/kottenator.github.io\\/jquery-circle-progress\\/\\\">http:\\/\\/kottenator.github.io\\/jquery-circle-progress\\/<\\/a><\\/li>\\n<li><strong>jQuery appear plugin<\\/strong> v0.3.6, Copyright 2012 Andrey Sidorov Licenses: MIT Source: link <a href=\\\"https:\\/\\/github.com\\/morr\\/jquery.appear\\/\\\">https:\\/\\/github.com\\/morr\\/jquery.appear\\/<\\/a><\\/li>\\n<li><strong>LongShadow jQuery Plugin<\\/strong> v1.1.0, Copyright 2013 - 2016 Dang Van Thanh Licenses: MIT Source: link git:\\/\\/github.com\\/dangvanthanh\\/jquery.longShadow.git<\\/li>\\n<li><strong>HC-Sticky<\\/strong> v2.2.3, Copyright Some Web Media License: MIT Source: link <a href=\\\"https:\\/\\/github.com\\/somewebmedia\\/hc-sticky\\\">https:\\/\\/github.com\\/somewebmedia\\/hc-sticky<\\/a><\\/li>\\n<li><strong>jQuery Mobile<\\/strong> v1.4.3, Copyright 2010, 2014 jQuery Foundation, Inc. Licenses: jquery.org\\/license<\\/li>\\n<li><strong>jquery-visible<\\/strong>, Copyright 2012, Digital Fusion, License: <a href=\\\"http:\\/\\/teamdf.com\\/jquery-plugins\\/license\\/\\\">http:\\/\\/teamdf.com\\/jquery-plugins\\/license\\/<\\/a> Source: <a href=\\\"http:\\/\\/teamdf.com\\/jquery-plugins\\/license\\/\\\">http:\\/\\/teamdf.com\\/jquery-plugins\\/license\\/<\\/a><\\/li>\\n<li><strong>Parallax Background<\\/strong> v1.2, by Eren Suleymanoglu Licenses: MIT Source: link <a href=\\\"https:\\/\\/github.com\\/erensuleymanoglu\\/parallax-background\\\">https:\\/\\/github.com\\/erensuleymanoglu\\/parallax-background<\\/a><\\/li>\\n<li><strong>TableSorter<\\/strong> v2.0.5b, Copyright 2007 Christian Bach Licenses: Dual licensed under the MIT and GPL licenses Source: link <a href=\\\"http:\\/\\/tablesorter.com\\\">http:\\/\\/tablesorter.com<\\/a><\\/li>\\n<li><strong>Isotope<\\/strong> PACKAGED v3.0.6, Copyright 2017 Metafizzy License: GPLv3 Source: link <a href=\\\"http:\\/\\/isotope.metafizzy.co\\\">http:\\/\\/isotope.metafizzy.co<\\/a><\\/li>\\n<li><strong>Infinite Scroll<\\/strong> PACKAGED v3.0.2, Copyright 2017 Metafizzy License: GPLv3 Source: link <a href=\\\"https:\\/\\/infinite-scroll.com\\\">https:\\/\\/infinite-scroll.com<\\/a><\\/li>\\n<li><strong>Packery layout mode<\\/strong> PACKAGED v2.0.0 Copyright 2017 Metafizzy License: GPLv3 Source: link <a href=\\\"http:\\/\\/isotope.metafizzy.co\\\">http:\\/\\/isotope.metafizzy.co<\\/a><\\/li>\\n<li><strong>javascript-detect-element-resize<\\/strong> v0.5.3 Copyright (c) 2013 Sebasti\\u00e1n D\\u00e9cima License: MIT Source: link <a href=\\\"https:\\/\\/github.com\\/sdecima\\/javascript-detect-element-resize\\\">https:\\/\\/github.com\\/sdecima\\/javascript-detect-element-resize<\\/a><\\/li>\\n<li><strong>tilt.js<\\/strong> 1.2.1, Copyright (c) 2017 Gijs Rog\\u00e9 License: MIT Source: link <a href=\\\"https:\\/\\/github.com\\/gijsroge\\/tilt.js\\\">https:\\/\\/github.com\\/gijsroge\\/tilt.js<\\/a><\\/li>\\n<li><strong>CLNDR<\\/strong> v1.4.7, Copyright Kyle Stetz (github.com\\/kylestetz) License: MIT Source: link <a href=\\\"https:\\/\\/github.com\\/kylestetz\\/CLNDR\\\">https:\\/\\/github.com\\/kylestetz\\/CLNDR<\\/a><\\/li>\\n<li><strong>GMAP3 Plugin for jQuery<\\/strong> v7.2 Copyright DEMONTE Jean-Baptiste License: GPL-3.0+ Source: link <a href=\\\"http:\\/\\/gmap3.net\\\">http:\\/\\/gmap3.net<\\/a><\\/li>\\n<li><strong>Moment.js<\\/strong> v2.22.2 License: MIT Source: link <a href=\\\"https:\\/\\/github.com\\/moment\\/moment\\/\\\">https:\\/\\/github.com\\/moment\\/moment\\/<\\/a><\\/li>\\n<li><strong>Slidebars<\\/strong> v2 Copyright Adam Charles Smith License: MIT <a href=\\\"http:\\/\\/www.adchsm.com\\/slidebars\\/license\\/\\\">http:\\/\\/www.adchsm.com\\/slidebars\\/license\\/<\\/a> Source: link <a href=\\\"http:\\/\\/www.adchsm.com\\/slidebars\\/\\\">http:\\/\\/www.adchsm.com\\/slidebars\\/<\\/a><\\/li>\\n<li><strong>Splittext.js<\\/strong> Copyright (c) 2008-2016, GreenSock<\\/li>\\n<li><strong>Magnific Popup<\\/strong> v1.1.0 License: MIT Copyright 2016 Dmitry Semenov Soruce: link <a href=\\\"http:\\/\\/dimsemenov.com\\/plugins\\/magnific-popup\\/\\\">http:\\/\\/dimsemenov.com\\/plugins\\/magnific-popup\\/<\\/a><\\/li>\\n<\\/ul>\\n<h4> Important Links <\\/h4>\\n<p><a href=\\\"https:\\/\\/shop.namogo.com\\/docs\\/elementor-extras\\/getting-started\\/#update-official\\\">Updating Extras<\\/a>\\n<a href=\\\"https:\\/\\/shop.namogo.com\\/topic\\/elementor-extras\\/\\\">Documentation<\\/a>\\n<a href=\\\"https:\\/\\/shop.namogo.com\\/account\\/\\\">Your Account<\\/a>\\n<a href=\\\"https:\\/\\/shop.namogo.com\\/account\\/support\\/\\\">Support<\\/a>\\n<a href=\\\"https:\\/\\/shop.namogo.com\\/docs\\/elementor-extras\\/frequently-asked-questions\\/\\\">FAQ<\\/a><\\/p>\",\"changelog\":\"<h4> 2.2.36 <\\/h4>\\n<ul>\\n<li>Tweak: Revert support for Elementor Pro to 2.8.0<\\/li>\\n<\\/ul>\\n<h4> 2.2.35 <\\/h4>\\n<ul>\\n<li>Fixed: Compatibility with Elementor 3.0<\\/li>\\n<li>Fixed: Search Form \\u2014 CSS height align bug with expand skin<\\/li>\\n<li>Increased minimum required Elementor version to 3.0<\\/li>\\n<li>Increased minimum required Elementor Pro version to 3.0<\\/li>\\n<\\/ul>\\n<h4> 2.2.34 <\\/h4>\\n<ul>\\n<li>Fixed: Posts \\u2014 Temporary fix for posts pagination due to bug introduced in Wordpress 5.5<\\/li>\\n<li>Fixed: Posts \\u2014 Carousel RTL arrows misplacement<\\/li>\\n<li>Fixed: Display Conditions \\u2013 Day of week condition not including timezone<\\/li>\\n<li>Fixed: Display Conditions \\u2013 Wrong index for Sunday<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Panel header being printed even if no title or close enabled<\\/li>\\n<li>Fixed: Search Form \\u2014 Taxonomy term not excluded if taxonomy has only one term<\\/li>\\n<li>Fixed: Table \\u2014 Inline editing bugs<\\/li>\\n<\\/ul>\\n<h4> 2.2.33 <\\/h4>\\n<ul>\\n<li>Added: Display Conditions \\u2014 Support for ACF options page fields<\\/li>\\n<li>Fixed: Lightbox in post skin slides through all instances inside loop<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Edge case width calculation bug<\\/li>\\n<li>Fixed: Offcanvas \\u2014 CSS overriding default body margin and padding<\\/li>\\n<li>Fixed: Timeline \\u2014 Dynamic tags support in default skin not working<\\/li>\\n<li>Fixed: Search Form \\u2014 Safari back button keeps form fields disabled<\\/li>\\n<\\/ul>\\n<h4> 2.2.32 <\\/h4>\\n<ul>\\n<li>Added: Toggle Element \\u2014 Show element by url hash<\\/li>\\n<li>Added: Toggle Element \\u2014 Change url hash when toggling elements<\\/li>\\n<li>Added: Posts Extra \\u2014 Option to try to force equal height on post skins<\\/li>\\n<li>Added: Audio Player \\u2014 Support for m4a files<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Added missing prefix and suffix fields to translatable fields<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Edge case js error with empty slider controls size values<\\/li>\\n<li>Fixed: Swiper destroy on element remove fails with multiple instances on page<\\/li>\\n<li>Fixed: Slide Menu \\u2014 Sibling submenu items showing behind current active submenu<\\/li>\\n<li>Fixed: Slide Menu \\u2013 Removed default browser padding for ul<\\/li>\\n<li>Fixed: Search Form \\u2014 Edge case where restrictions not being passed if page is loaded using back browser button<\\/li>\\n<\\/ul>\\n<h4> 2.2.31 <\\/h4>\\n<ul>\\n<li>Added: Toggle Element \\u2014 Option to enable refreshing elements inside template when toggling<\\/li>\\n<li>Fixed: Toggle Element \\u2014 Recalculate swipers inside templates<\\/li>\\n<li>Fixed: Ensure loop template data attributes<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Compatibility with usage inside looped template<\\/li>\\n<li>Fixed: Circle Progress \\u2013 Decimal point applied to all widget instances<\\/li>\\n<li>Fixed: Offcanvas \\u2014 JS error on Offcanvas anchor navigation on links with dynamic tags enabled<\\/li>\\n<li>Tweak: Remove focus outline from swiper arrows<\\/li>\\n<li>Tweak: Circle Progress \\u2014 Remove limit for max value when using absolute<\\/li>\\n<\\/ul>\\n<h4> 2.2.30 <\\/h4>\\n<ul>\\n<li>Fixed: Gallery Slider \\u2014 Active thumbnail index for multiple widgets on same page<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Remove buggy auto-height control for thumbnails carousel<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Bug with overlay and reveal animations on same page<\\/li>\\n<li>Fixed: Audio Player \\u2013 Reset user agent padding on playlist<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Exclude em and rem from terms typography control<\\/li>\\n<\\/ul>\\n<h4> 2.2.29 <\\/h4>\\n<ul>\\n<li>Added: Gallery Slider \\u2014 Possibility to add multiple caption types<\\/li>\\n<li>Added: Gallery Slider \\u2014 Ken Burns effect option with. advanced controls<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Missing preview captions text align control<\\/li>\\n<li>Fixed: Display Conditions \\u2014 ACF Choice field check fails<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 Remove fade effect on thumbnails carousel<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 Condition image fit control to work only for slide effect<\\/li>\\n<\\/ul>\\n<h4> 2.2.28 <\\/h4>\\n<ul>\\n<li>Added: Toggle Element \\u2014 Padding control for labels<\\/li>\\n<li>Added: Breadcrumbs \\u2014 Control to disable structured data attributes<\\/li>\\n<li>Added: Gallery Slider, Gallery Extra, Switcher \\u2014 Option to disable slideshow in lightbox<\\/li>\\n<li>Added: Posts \\u2014 Wordpress filters for post and post wrapper classes<\\/li>\\n<li>Added: Video Player \\u2014 Control to remove Chrome\'s download option in fullscreen mode<\\/li>\\n<li>Fixed: Gallery Slider, Gallery Extra, Random Image, Switcher \\u2014 Missing lightbox captions<\\/li>\\n<li>Fixed: Toggle Element \\u2014 Low CSS specificity for ul and li elements causing themes override<\\/li>\\n<li>Fixed: Popup \\u2014 Exit intent not working correctly<\\/li>\\n<li>Tweak: Updated translations .pot file<\\/li>\\n<\\/ul>\\n<h4> 2.2.27 <\\/h4>\\n<ul>\\n<li>Added: Display Conditions \\u2014 Shortcode output condition<\\/li>\\n<li>Added: Display Conditions \\u2014 Post meta condition<\\/li>\\n<li>Added: Posts Extra \\u2014 Control to stack filters responsively<\\/li>\\n<li>Added: Posts Extra \\u2014 Option to trigger a window resize events after each carousel slide to fix displaying issues of certain widgets when using custom post skins<\\/li>\\n<li>Added: Gallery Slider \\u2014 Option to contain centre fit images inside preview slider when custom height is set<\\/li>\\n<li>Fixed: Incorrect Breadcrumbs and Slide Menu WPML integration<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Filters not changing active class when using masonry<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Load more button not hidden when no pagination available<\\/li>\\n<li>Fixed: Video Player \\u2014 Trigger window resize to position correctly elements with motion effects enabled after the video is loaded<\\/li>\\n<li>Fixed: Global Tooltips \\u2014 Removed label_block from slider control that broke controls<\\/li>\\n<\\/ul>\\n<h4> 2.2.26 <\\/h4>\\n<ul>\\n<li>Fixed: Posts Extra \\u2014 Carousel pagination selector breaks pagination when multiple carousels on same page<\\/li>\\n<li>Fixed: Search Form \\u2014 Submit button icon spacing control bug<\\/li>\\n<li>Fixed: Search Form \\u2014 Beautified option fields icons not displaying properly<\\/li>\\n<li>Fixed: Gallery Slider \\u2013 Figure line height causing caption display issues<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Distance control for thumbnails carousel arrows not working<\\/li>\\n<\\/ul>\\n<h4> 2.2.25 <\\/h4>\\n<ul>\\n<li>Added: Display Conditions \\u2014 If no condition value is set check to see if field is set to any value<\\/li>\\n<li>Added: Gallery Slider \\u2014 Options to set max. width and horizontal and vertical alignment for thumbnails carousel<\\/li>\\n<li>Added: Gallery Slider \\u2014 Option to set custom height for preview slides<\\/li>\\n<li>Added: Popup \\u2014 Option to disable refreshing frontend functionality for elements inside the popup<\\/li>\\n<li>Added: Offcanvas \\u2014 Option to disable refreshing frontend functionality for elements inside the panel<\\/li>\\n<li>Added: Calendar \\u2014 Typography control for header week days<\\/li>\\n<li>Added: Google Map \\u2014 Option to set zoom level when navigating to a location<\\/li>\\n<li>Fixed: Bug where one swiper slider\'s arrows control all swiper sliders on the same page<\\/li>\\n<li>Fixed: Calendar \\u2014 Separator style for header not working<\\/li>\\n<li>Fixed: Gallery \\u2014 Instagram lightbox not working for my photos<\\/li>\\n<li>Fixed: Gallery \\u2014 Instagram links bug for hashtag posts<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Filters with masonry enabled when two widgets on page breaks filtering<\\/li>\\n<li>Tweak: Circle Progress \\u2014 Allow 0 value to be shown<\\/li>\\n<\\/ul>\\n<h4> 2.2.24 <\\/h4>\\n<ul>\\n<li>Added: Gallery Slider \\u2014 Option to enable carousel on thumbnails<\\/li>\\n<li>Added: Posts Extra \\u2014 More swiper settings<\\/li>\\n<li>Fixed: Circle Progress \\u2014 Compatibility with display conditions<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Dynamic tag background styles<\\/li>\\n<li>Fixed: Don\'t include Elementor form widget in refreshable widgets due to reCaptcha reinitialisation uncaught error<\\/li>\\n<li>Fixed: Timeline \\u2014 Date entrance animation on left right and overlay alignments<\\/li>\\n<\\/ul>\\n<h4> 2.2.23 <\\/h4>\\n<ul>\\n<li>Added: Popup \\u2014 Margin control for close icon<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Instagram compatibility with new API changes<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Carousel compatibility with Elementor 2.9.4 swiper.js changes<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Allow -1 as posts per page value for specific query source<\\/li>\\n<li>Fixed: Display Conditions \\u2014 Use wp_timezone instead of timezone_string in case timezone is set as offset<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Filter post count style controls conditions<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Carousel remove deprecated Columns control<\\/li>\\n<li>Tweak: Google Map \\u2014 Convert description control from text to WYSIWYG type<\\/li>\\n<\\/ul>\\n<h4> 2.2.22 <\\/h4>\\n<ul>\\n<li>Fixed: Timeline \\u2014 Points and dates not showing when animate cards is on<\\/li>\\n<li>Fixed: Unfold \\u2014 Bug error showing button since last update<\\/li>\\n<\\/ul>\\n<h4> 2.2.21 <\\/h4>\\n<ul>\\n<li>Added: Display Conditions \\u2014 Current Date &amp; Time condition<\\/li>\\n<li>Added: Timeline \\u2014 New option to reverse position of cards<\\/li>\\n<li>Added: Text Divider \\u2014 Margin control for the text<\\/li>\\n<li>Added: Toggle Element \\u2014 Option to hide all elements by default<\\/li>\\n<li>Added: Timeline \\u2014 Controls for overriding text colour in custom mode<\\/li>\\n<li>Fixed: EE widget indicator in editor panel font<\\/li>\\n<li>Fixed: Unfold \\u2014 Removed elementor-button class from button which was adding a lot of padding<\\/li>\\n<li>Fixed: Unfold \\u2014 Editor preview spacing in js template<\\/li>\\n<li>Fixed: Query control width<\\/li>\\n<li>Fixed: PHP error on updater transient data<\\/li>\\n<li>Fixed: Video Player \\u2014 Stop play when played once in viewport<\\/li>\\n<li>Fixed: Timeline \\u2014 Correct dates when using custom post skin with a template that uses Posts Extra<\\/li>\\n<li>Fixed: Tooltips \\u2014 Tooltips not closing on mobile with touchstart event<\\/li>\\n<li>Fixed: Timeline \\u2014 Entrance animation triggering on page load instead of scroll to element<\\/li>\\n<li>Fixed: Timeline \\u2014 Query section not hidden if Source is Custom<\\/li>\\n<li>Fixed: Multiple SELECT2 controls width bug (missing css) after Elementor update<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Masonry layout broken when using custom size values in manual mode<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Changing filters disrupts any Elementor entrance animations placed after widget<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Run ready triggers for section and columns on infinite scroll<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Refresh elements even if infinite scroll button is off<\\/li>\\n<li>Fixed: ACF fields not showing inside templates when ACF Extended plugin is active<\\/li>\\n<li>Tweak: Unfold \\u2014 Hide button when there is no content or visible lines exceeds number of existing lines<\\/li>\\n<li>Tweak: Tooltips \\u2014 Integrate Elementor breakpoints<\\/li>\\n<li>Tweak: Gallery Extra \\u2014 Improved buggy responsive custom sizing method<\\/li>\\n<li>Revert: Display Conditions \\u2014 Added time to Current Date conditions\' date control<\\/li>\\n<\\/ul>\\n<h4> 2.2.20 <\\/h4>\\n<ul>\\n<li>Added: Display Conditions \\u2014 \'Current User\' condition<\\/li>\\n<li>Added: Display Conditions \\u2014 Added time to Current Date conditions\' date control<\\/li>\\n<li>Fixed: Some icon controls hidden due to Elementor changing label_block control attribute<\\/li>\\n<li>Fixed: Popup \\u2014 Close button control conditions<\\/li>\\n<li>Fixed: Popup \\u2014 Close icon not hiding on frontend<\\/li>\\n<\\/ul>\\n<h4> 2.2.19 <\\/h4>\\n<ul>\\n<li>Added: Popup \\u2014 Option to set max number of times a non-persistent popup should open<\\/li>\\n<li>Fixed: Posts \\u2014 Carousel compatibility with Elementor 2.9.0 swiper js upgrade<\\/li>\\n<li>Fixed: Switcher \\u2014 Title direction on RTL<\\/li>\\n<\\/ul>\\n<h4> 2.2.18 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Filters infinite scroll warning<\\/li>\\n<li>Added: Popup \\u2014 Border controls for iframe and image<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 PHP warning<\\/li>\\n<li>Fixed: Buttons \\u2014 Theme CSS override for anchors<\\/li>\\n<li>Fixed: Popup \\u2014 PHP warning when using placeholder image<\\/li>\\n<li>Fixed: Popup \\u2014 Overflow hidden missing from popup content<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Restrict refreshing widget inside offcanvas panel to refreshable list<\\/li>\\n<li>Fixed: Scroll Indicator \\u2014 Clicking bullets on mobile doesn\'t scroll to section when tooltips are enabled<\\/li>\\n<li>Tweak: Scroll Indicator \\u2014 Separate control for enabling opening of tooltips on focus for better integration<\\/li>\\n<li>Tweak: Switcher \\u2014 Convert description textarea field to WYSIWYG<\\/li>\\n<li>Tweak: Slide Menu \\u2014 More specific selector typography control<\\/li>\\n<li>Tweak: Popup \\u2014 Default close button size for iframe<\\/li>\\n<li>Tweak: Make license renewal reminder dismissable<\\/li>\\n<\\/ul>\\n<h4> 2.2.17 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Option to open in new tab for Title link<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Run ready triggers for widgets inside panel when opening<\\/li>\\n<li>Tweak: Posts \\u2014 Hide Media area if no thumbnail or placeholder even if it has content parts<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 Default thumbs spacing to 24<\\/li>\\n<li>Tweak: Update TweenMax version<\\/li>\\n<\\/ul>\\n<h4> 2.2.16 <\\/h4>\\n<ul>\\n<li>Added: Scroll Indicator \\u2014 Offset for scrolling to section<\\/li>\\n<li>Added: Gallery Slider \\u2014 Lazy load images in preview<\\/li>\\n<li>Added: Slide Menu \\u2014 \'elementor_extras\\/widgets\\/slide_menu\\/nav_menu\\/walker_start_el\' filter for walker_nav_menu_start_el hook<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Tilt perspective issue<\\/li>\\n<li>Fixed: Gallery \\u2014 Tilt captions depth not working<\\/li>\\n<li>Fixed: Global Tooltips \\u2014 Distance for repositioned tooltips<\\/li>\\n<li>Fixed: Global Tooltips \\u2014 Multiple tooltips appearing only in edit mode when changing tooltip position<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Remove posts per page setting for current query<\\/li>\\n<li>Fixed: Display Conditions \\u2014 GET and POST not returning true for any value<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Minor PHP warning<\\/li>\\n<li>Fixed: Random Image \\u2014 Error when using only one image<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Duplicate images in Elementor lightbox when infinite loop is enabled<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Include &quot;related&quot; source in Price position control conditions<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Meta Key not showing when Order By is set to Meta Value (number)<\\/li>\\n<li>Fixed: Timeline \\u2014 Meta Key not showing when Order By is set to Meta Value (number)<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Disable add to cart button when used inside a linked Media area<\\/li>\\n<li>Tweak: Timeline \\u2014 Responsive entrance animation<\\/li>\\n<\\/ul>\\n<h4> 2.2.15 <\\/h4>\\n<ul>\\n<li>Fixed: Popup \\u2014 Date comparison fail for non-persistent interval setting<\\/li>\\n<li>Fixed: Tooltips \\u2014 Tooltips empty in some cases after last update<\\/li>\\n<li>Fixed: Calendar \\u2014 Support for ACF date time picker fields<\\/li>\\n<li>Tweak: Hotspots \\u2014 Better css method for disabling pulse effect<\\/li>\\n<li>Tweak: Posts Extra \\u2014 New &quot;hide&quot; icon for content parts positioning<\\/li>\\n<li>Tweak: Nicons<\\/li>\\n<\\/ul>\\n<h4> 2.2.14 <\\/h4>\\n<ul>\\n<li>Fixed: Audio Player \\u2014 Edge case bug when stopping a player inside a section stuck with Elementor sticky setting<\\/li>\\n<li>Fixed: Switcher \\u2014 Loader thickness not working in Firefox<\\/li>\\n<li>Fixed: Offcanvas \\u2014 WPML not fetching content boxes repeater fields<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Masonry missing on frontend after last update<\\/li>\\n<li>Tweak: Tooltips \\u2014 Use append method to add content to the tooltip<\\/li>\\n<\\/ul>\\n<h4> 2.2.13 <\\/h4>\\n<ul>\\n<li>Fixed: Posts Extra \\u2014 Media left right alignment not working<\\/li>\\n<\\/ul>\\n<h4> 2.2.12 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Post border radius control<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Safari layout bug on infinite scroll and masonry layout<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Carousel slides to scroll on tablet bug<\\/li>\\n<li>Fixed: Timeline \\u2014 Date options not showing for custom post skin option<\\/li>\\n<li>Fixed: Sticky Elements \\u2014 Force sticky sections to flex align to start for Safari flex stretch bug<\\/li>\\n<\\/ul>\\n<h4> 2.2.11 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Infinite scroll fields for WPML<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Better support for post type archive links on archive pages<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Flexbox causing horizontal media layout issue on mobile<\\/li>\\n<li>Fixed: Circle Progress \\u2014 Compatibility with wordpress 5.3<\\/li>\\n<li>Tweak: Offcanvas \\u2014 Mode container background colour control from site settings to widget settings<\\/li>\\n<\\/ul>\\n<h4> 2.2.10 <\\/h4>\\n<ul>\\n<li>Added: Popup \\u2014 Option to open url inside popup<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Check for existing non built-in custom post types before iteration<\\/li>\\n<li>Fixed: Display Conditions \\u2014 ACF Date support for custom locale<\\/li>\\n<li>Fixed: Calendar \\u2014 ACF Date support for custom locale<\\/li>\\n<li>Fixed: Switcher \\u2014 Description not available for translation<\\/li>\\n<li>Fixed: Gallery \\u2014 Safari backface-visibility bug<\\/li>\\n<\\/ul>\\n<h4> 2.2.9 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Align media vertically on horizontal post layouts<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Text separator not displaying<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Default horizontal layout width control to 30<\\/li>\\n<\\/ul>\\n<h4> 2.2.8 <\\/h4>\\n<ul>\\n<li>Added: Breadcrumbs \\u2014 Granular controls for crumbs settings on archive and single pages<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Moved images loaded container selector to ajax response<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Show all filters option not working<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Infinite scroll pagination html output rendering more links than needed<\\/li>\\n<li>Fixed: PHP notice for licensing admin notification<\\/li>\\n<li>Fixed: Switcher \\u2014 Border radius control CSS selector<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Cleanup on pagination html output needed for infinite scroll<\\/li>\\n<\\/ul>\\n<h4> 2.2.7 <\\/h4>\\n<ul>\\n<li>Fixed: Compatibility with third-party plugin<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Edge case bug when calculating anchor position<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Notices<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Overlapping items on infinite scroll when filters active<\\/li>\\n<\\/ul>\\n<h4> 2.2.6 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Global \'elementor_extras\\/widgets\\/posts\\/link\' filter<\\/li>\\n<li>Added: Offcanvas \\u2014 Typography control for content boxes<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Infinite Scroll stopping before all posts load<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Panel background selector<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Page jump when navigating to anchor<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Edge case js error in nouislider script<\\/li>\\n<li>Fixed: Templates Control \\u2014 Restrict global query override for templates inside loops<\\/li>\\n<li>Fixed: Slide Menu \\u2014 Nav menu item classes don\'t work when coming from template control<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Wrong order for hierarchical taxonomies<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Flicker when performing infinite scroll on filtered posts<\\/li>\\n<li>Fixed: Sticky Elements \\u2014 Additional padding in some cases below sticky element<\\/li>\\n<li>Fixed: Display Conditions \\u2014 Missing day of week condition<\\/li>\\n<li>Fixed: Hotspots \\u2014 Better handling of icon vertical alignment in css<\\/li>\\n<\\/ul>\\n<h4> 2.2.5 <\\/h4>\\n<ul>\\n<li>Added: Toggle Element \\u2014 Control to hide items without any content<\\/li>\\n<li>Added: Popup \\u2014 Support for usage within Posts Extra custom post skin<\\/li>\\n<li>Added: Audio Player \\u2014 Option to disable preloading of audio files<\\/li>\\n<li>Added: Calendar \\u2014 Search custom fields by field name<\\/li>\\n<li>Added: Offcanvas \\u2014 Options in widgets\' settings to fix page jump issue<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Certain actions not working<\\/li>\\n<li>Fixed: Calendar \\u2014 Pods controls not fetching fields<\\/li>\\n<li>Fixed: Calendar \\u2014 Toolset controls not fetching fields<\\/li>\\n<li>Fixed: Query Control \\u2014 Return only matching queries for pods and toolset<\\/li>\\n<li>Fixed: Calendar \\u2014 Placeholder functionality<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Edge case where css width selectors get overridden by defaults<\\/li>\\n<li>Tweak: Posts Extra \\u2013 Default css order value for parts and areas in frontend css<\\/li>\\n<li>Tweak: Popup \\u2014 Replaced multiple template selection control with single control. IMPORTANT: Settings review required!<\\/li>\\n<li>Tweak: Breadcrumbs \\u2014 Refactor widget code<\\/li>\\n<\\/ul>\\n<h4> 2.2.4 <\\/h4>\\n<ul>\\n<li>Added: Dynamic background image support for custom post skin<\\/li>\\n<li>Added: Breadcrumbs \\u2014 Filter for home breadcrumb link<\\/li>\\n<li>Fixed: Timeline \\u2014 Wrong card content selector for transition control<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Broken selectors after last offcanvas update<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Remove default border around posts<\\/li>\\n<\\/ul>\\n<h4> 2.2.3 <\\/h4>\\n<ul>\\n<li>Added: Offcanvas \\u2014 Compatibility with templates in loops in Posts Extra and other plugins<\\/li>\\n<li>Added: Posts Extra \\u2014 Refresh all widgets scripts on appended infinite scroll items<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Button style gone when placed in linked media area<\\/li>\\n<li>Fixed: Sticky Elements \\u2014 Bug when sticky section inside page body within theme builder header template<\\/li>\\n<li>Fixed: Scroll Indicator \\u2014 Tooltips not working with bullets skin<\\/li>\\n<\\/ul>\\n<h4> 2.2.2 <\\/h4>\\n<ul>\\n<li>Fixed: Scroll Indicator \\u2014 Bug when tooltips disabled on bullets skin<\\/li>\\n<li>Fixed: Timeline \\u2014 Option to hide thumbnail not working in posts mode<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Bug with before parent category filters<\\/li>\\n<li>Fixed: Bug with third party elementor addon that enqueue editor scripts on plugin load<\\/li>\\n<li>Fixed: Posts \\u2014 Default metas control to include price for previous saved settings<\\/li>\\n<li>Added: Search Form \\u2014 Compatibility with Relevanssi search results on custom templates with search form id condition<\\/li>\\n<li>Added: Timeline \\u2014 Option to set a dynamic tag instead of date, title and excerpt in posts mode<\\/li>\\n<li>Added: Timeline \\u2014 Option to set HTML element for title in posts mode<\\/li>\\n<li>Added: Posts Extra \\u2014 Filter for the media area link<\\/li>\\n<li>Added: Posts Extra \\u2014 Option to open media and button links in new tab<\\/li>\\n<li>Added: Table \\u2014 WPML translation of header cells text<\\/li>\\n<li>Tweak: Sticky Elements \\u2014 Additional listeners for recalculating sticky<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Less restrictive css selector for the woocommerce add to cart button<\\/li>\\n<\\/ul>\\n<h4> 2.2.1 <\\/h4>\\n<ul>\\n<li>Added: Scroll Indicator \\u2014 Option to offset start and end positions<\\/li>\\n<li>Added: Posts Extra \\u2014 Responsive media width control<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Missing custom field order options<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Avatar meta showing even if removed from metas list<\\/li>\\n<li>Fixed: Display Conditions \\u2014 ACF Choice fails for radio field<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Bug with left aligned media flex width on mobile<\\/li>\\n<\\/ul>\\n<h4> 2.2.0 <\\/h4>\\n<ul>\\n<li>Added: Google Map \\u2014 Route travel mode options<\\/li>\\n<li>Added: Global Tooltips \\u2014 Compatibility with usage inside post skin templates for Posts Extra<\\/li>\\n<li>Added: Global Tooltips \\u2014 z-index control in both element and global settings<\\/li>\\n<li>Added: Display Conditions \\u2014 Term archive condition<\\/li>\\n<li>Added: Display Conditions \\u2014 ACF conditions<\\/li>\\n<li>Added: Display Conditions \\u2014 POST and GET variable conditions<\\/li>\\n<li>Added: Timeline \\u2014 Custom Post Skin via Elementor templates<\\/li>\\n<li>Added: Timeline \\u2014 Replaced default query controls with related query controls<\\/li>\\n<li>Added: Timeline \\u2014 Trim custom excerpt control<\\/li>\\n<li>Added: Timeline \\u2014 Custom post skin<\\/li>\\n<li>Added: Posts Extra \\u2014 Date formatting controls<\\/li>\\n<li>Added: Posts Extra \\u2014 Actions and filters<\\/li>\\n<li>Added: Calendar \\u2014 Actions and filters<\\/li>\\n<li>Added: Devices \\u2014 Actions<\\/li>\\n<li>Added: Breadcrumbs \\u2014 Actions and filters<\\/li>\\n<li>Added: Scroll Indicator \\u2014 Custom html tags for title and subtitle in list skin<\\/li>\\n<li>Added: Custom implementation for Template controls<\\/li>\\n<li>Fixed: Toggle Element \\u2014 Support for slick slider based widgets inside elements<\\/li>\\n<li>Fixed: Switcher \\u2014 Missing image link control<\\/li>\\n<li>Fixed: Timeline \\u2014 Markup improvement to allow for simpler border radius around cards<\\/li>\\n<li>Fixed: Timeline \\u2014 Custom icon replaces global if global is set<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Separator vertical alignment bug<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Icon migration markup issue<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Update elementor nerd box classes<\\/li>\\n<li>Fixed: Posts Extra \\u2014 ACF fields for custom skins used on archive pages<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Wrong access type for _query property<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Price conditions issue for area and editor panel section display<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Author and avatar metas additional controls conditions<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Removed infinite scroll pages loaded limit<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Handle multiple paginations control condition bug<\\/li>\\n<li>Fixed: Scroll Indicator \\u2014 Custom height control condition<\\/li>\\n<li>Fixed: Popup \\u2014 Compatibility with usage inside post skin templates for Posts Extra<\\/li>\\n<li>Fixed: Buttons \\u2014 Flip effect back is hidden during transition<\\/li>\\n<li>Tweak: Breadcrumbs \\u2014 Remove useless icon and icon class filters<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Update button text filters to include \\/posts\\/<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Default taxonomy order for filters<\\/li>\\n<\\/ul>\\n<h4> 2.1.8 <\\/h4>\\n<ul>\\n<li>Fixed: Missing elementor pro active condition<\\/li>\\n<\\/ul>\\n<h4> 2.1.7 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Order posts by custom fields<\\/li>\\n<li>Fixed: Calendar \\u2014 No events fetched when acf date field return format is different that display format<\\/li>\\n<li>Tweak: Better notices and plugin activation prevention for dependencies<\\/li>\\n<\\/ul>\\n<h4> 2.1.6 <\\/h4>\\n<ul>\\n<li>Fixed: Posts Extra \\u2014 Exclude category pages from previous current query fix<\\/li>\\n<li>Fixed: Posts Extra \\u2014 ACF fields for custom post skins used on archive pages<\\/li>\\n<\\/ul>\\n<h4> 2.1.5 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Filter for button link<\\/li>\\n<li>Added: Posts Extra \\u2014 Apply both \'button\' and \'add_to_cart\' filters to button<\\/li>\\n<li>Added: Audio Player \\u2014 Autoplay option<\\/li>\\n<li>Added: Support for new icon library in Elementor 2.6 in all widgets<\\/li>\\n<li>Added: Support for scaling SVG icon library assets when added to widgets<\\/li>\\n<li>Added: Breadcrumbs \\u2014 Option to hide current page<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Template control not fetching results after Elementor Pro 2.6.0 update<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Body order on horizontal posts<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Default query args prevent correct number of results on search templates<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Show all filters initially not working<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Wrong hierarchical taxonomies order when using custom post types<\\/li>\\n<li>Fixed: Calendar \\u2014 Border radius overflow issue<\\/li>\\n<li>Fixed: Circle Progress \\u2014 Progress not showing when shown below<\\/li>\\n<li>Fixed: Timeline \\u2014 Text align on tablet for RTL<\\/li>\\n<li>Fixed: Switcher \\u2014 Remove link image option when using overlay skin<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Edge case where page scrolls up when panel closed on firefox<\\/li>\\n<li>Fixed: Video Player \\u2014 Play button not centered in edge cases<\\/li>\\n<li>Tweak: Search Form \\u2014 Tax query verification<\\/li>\\n<\\/ul>\\n<h4> 2.1.4 <\\/h4>\\n<ul>\\n<li>Fixed: Audio Player \\u2014 External URL not. accepting dynamic tag in URL category<\\/li>\\n<li>Fixed: Video Player \\u2014 External URL not. accepting dynamic tag in URL category<\\/li>\\n<li>Fixed: Search Form \\u2014 Undefined index notice<\\/li>\\n<li>Added: Offcanvas \\u2014 Custom select for the close button<\\/li>\\n<li>Tweak: Offcanvas \\u2014 Separate control sections for title and close settings<\\/li>\\n<\\/ul>\\n<h4> 2.1.3 <\\/h4>\\n<ul>\\n<li>Fixed: Posts Extra \\u2014 Add to cart button alignment<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Pagination links on single templates<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Deprecated certain filters<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Added button text filter<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Added add to cart text filter<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Changed skin source terminology<\\/li>\\n<li>Tweak: Dissmisable admin licensing notices<\\/li>\\n<\\/ul>\\n<h4> 2.1.2 <\\/h4>\\n<ul>\\n<li>Added: Display Conditions \\u2014 New Term Archive condition<\\/li>\\n<li>Added: Posts Extra \\u2014 Area ordering controls<\\/li>\\n<li>Added: Posts Extra \\u2014 Add to cart button<\\/li>\\n<li>Added: Posts Extra \\u2014 Option to use Elementor templates as custom skin for posts<\\/li>\\n<li>Added: Timeline \\u2014 Separate controls for dates in hover and focused state<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Force square avatar image<\\/li>\\n<li>Fixed: Timeline \\u2014 Remove empty image wrapper when no image exists<\\/li>\\n<li>Fixed: Timeline \\u2014 Hover background color of arrow when focused<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Show price if source is current query<\\/li>\\n<li>Tweak: Timeline \\u2014 Allow Elementor custom image size<\\/li>\\n<li>Tweak: Timeline \\u2014 Responsive color controls<\\/li>\\n<\\/ul>\\n<h4> 2.1.1 <\\/h4>\\n<ul>\\n<li>Added: Tooltips \\u2014 Event for closing the tooltip by clicking anywhere<\\/li>\\n<li>Fixed: Buttons \\u2014 Text align when min width is set<\\/li>\\n<li>Tweak: Scroll Indicator \\u2014 Added options to select progress start and end calculation on scroll for sections<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Moved Infinite Scroll, Pagination and Filters activation controls to their respective sections.<\\/li>\\n<li>Tweak: Licensing \\u2014 Increase remote post request timeout value<\\/li>\\n<\\/ul>\\n<h4> 2.1.0 <\\/h4>\\n<ul>\\n<li>New Widget: Search Form \\u2014 Form widget with restrictions and filters<\\/li>\\n<li>New Widget: Scroll Indicator \\u2014 Create different types of scroll navigation indicators<\\/li>\\n<li>New Feature: Instagram \\u2014 Pull instagram feed to the Gallery widget<\\/li>\\n<li>Added: Posts Extra \\u2014 Vertical carousel<\\/li>\\n<li>Added: Posts Extra \\u2014 New control to select breakpoint for collapsing horizontal post layouts<\\/li>\\n<li>Added: Posts Extra \\u2014 Keep control to define page number limit for infinite scroll<\\/li>\\n<li>Added: Posts Extra \\u2014 Option to not show the &quot;All&quot; filter<\\/li>\\n<li>Added: Posts Extra \\u2014 New control for Slides to Show and deprecated old control [ Settings Review Required ]<\\/li>\\n<li>Added: Posts Extra \\u2014 Exclude taxonomy terms from filters<\\/li>\\n<li>Added: Gallery \\u2014 New spacing control specifically for mixed masonry layout. [ Settings Review Required ]<\\/li>\\n<li>Added: Gallery Slider \\u2014 Control to hide thumbnails<\\/li>\\n<li>Added: Tooltips \\u2014 Mobile event listeners [ Settings Review Required ]<\\/li>\\n<li>Added: Tooltips \\u2014 Responsive triggers and hide events [ Settings Review Required ]<\\/li>\\n<li>Added: Tooltips \\u2014 Separate events for closing the tooltip [ Settings Review Required ]<\\/li>\\n<li>Added: Tooltips \\u2014 New offset control to adjust alignment of arrow tip to target<\\/li>\\n<li>Added: Devices \\u2014 Option for video to cover screen<\\/li>\\n<li>Added: Breadcrumbs \\u2014 Hover colors controls<\\/li>\\n<li>Added: Calendar \\u2014 Disable links to posts<\\/li>\\n<li>Added: Calendar \\u2014 Add nofollow and open in new window on posts source<\\/li>\\n<li>Added: Buttons \\u2014 General padding control<\\/li>\\n<li>Added: Popup \\u2014 Horizontal align for inline trigger and popup close button<\\/li>\\n<li>Added: Notice for license domain mismatch<\\/li>\\n<li>Fixed: Circle Progress \\u2014 Wrong absolute max values<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Infinite scroll loading same posts<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Aligned column breakpoints to elementor default values<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Better override default theme padding on post item<\\/li>\\n<li>Fixed: Timeline \\u2014 CSS bug with overflow<\\/li>\\n<li>Fixed: Timeline \\u2014 Arrow color not working on frontend<\\/li>\\n<li>Fixed: Timeline \\u2014 Invalid code being generated in post css<\\/li>\\n<li>Fixed: Calendar \\u2014 Link target and nofollow<\\/li>\\n<li>Fixed: Devices \\u2014 Video controls conditions<\\/li>\\n<li>Fixed: Parallax Background \\u2014 Conflict with Elementor Pro scrolling effect<\\/li>\\n<li>Fixed: Popup \\u2014 Dynamic css selector for trigger not working<\\/li>\\n<li>Fixed: Calendar \\u2014 Link attributes in compact mode not working<\\/li>\\n<li>Fixed: Google Map \\u2014 Wrong value for default description tag<\\/li>\\n<li>Fixed: Google Map \\u2013 Set overflow to hidden to allow for advanced border radius setting<\\/li>\\n<li>Fixed: Switcher \\u2014 Rename effects section for compatibility with motion effects section name<\\/li>\\n<li>Fixed: Switcher \\u2014 Link to control should not be responsive<\\/li>\\n<li>Fixed: Unfold \\u2014 Bug with closing without focusing<\\/li>\\n<li>Fixed: Random Image \\u2014 Wrong caption<\\/li>\\n<li>Fixed: Display Conditions \\u2014 Check correct condition value<\\/li>\\n<li>Fixed: Toggle Element \\u2014 Text Label align controls<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Safari 12.1 CSS bug<\\/li>\\n<li>Fixed: Gallery \\u2014 Hover effects on mixed layout<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Edge case js error<\\/li>\\n<li>Fixed: Remove duplicate empty template messages from editor panel<\\/li>\\n<li>Fixed: Check license data before mismatch check<\\/li>\\n<li>Fixed: Tooltips \\u2014 Bug with hide event prevent default<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Allow horizontal post layout independent of columns value<\\/li>\\n<li>Tweak: Gallery \\u2014 Better controls conditions<\\/li>\\n<li>Tweak: Gallery \\u2014 Moved settings in their own sections under Content<\\/li>\\n<li>Tweak: Gallery \\u2014 Control conditions<\\/li>\\n<li>Tweak: Gallery \\u2014 Better markup, controls and css optimisation<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 Better markup, controls and css optimisation<\\/li>\\n<li>Tweak: Better license management, notifications and performance<\\/li>\\n<li>Tweak: Remove extension default enable for sticky and parallax background<\\/li>\\n<li>Tweak: Remove custom panel alert classes and revert to elementor ones<\\/li>\\n<li>Tweak: Update docs and support links in extras admin pages<\\/li>\\n<li>Tweak: Streamline get_image_caption across all modules to avoid code redundancy<\\/li>\\n<li>Tweak: Toggle Element \\u2014 Better Label alignment controls<\\/li>\\n<li>Tweak: Popup \\u2014 Empty trigger css adjustments<\\/li>\\n<li>Tweak: Admin pages styles<\\/li>\\n<\\/ul>\\n<h4> 2.0.17 <\\/h4>\\n<ul>\\n<li>Added: Timeline \\u2014 Overlay horizontal alignment option<\\/li>\\n<li>Fixed: Timeline \\u2014 Icon showing twice<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Default horizontal alignment to left<\\/li>\\n<\\/ul>\\n<h4> 2.0.16 <\\/h4>\\n<ul>\\n<li>Fixed: Include admin script only on extras pages<\\/li>\\n<li>Fixed: Posts Extra \\u2014 RTL margins and arrows<\\/li>\\n<li>Fixed: Calendar \\u2014 RTL arrows<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Override current query posts per page with control setting<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Carousel style section condition<\\/li>\\n<li>Added: Text Divider \\u2014 Control for alignment of text<\\/li>\\n<li>Added: Unfold \\u2014 Columns settings for content<\\/li>\\n<li>Added: Timeline \\u2014 New alignment controls to allow selecting layouts per breakpoint<\\/li>\\n<li>Added: Posts Extra \\u2014 Option to align posts horizontally<\\/li>\\n<li>Tweak: Admin settings RTL<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Responsive alignment controls<\\/li>\\n<li>Tweak: Timeline \\u2014 Responsive defaults for alignment controls<\\/li>\\n<\\/ul>\\n<h4> 2.0.15 <\\/h4>\\n<ul>\\n<li>IMPORTANT: This version requires Elementor 2.5 or above<\\/li>\\n<li>IMPORTANT: If you have Elementor Pro, this version requires version 2.5 or above<\\/li>\\n<li>Added: Posts Extra \\u2014 Elementor Pro new related posts module with include \\/ exclude and date range<\\/li>\\n<li>Added: Circle Progress \\u2014 Option to turn off animation<\\/li>\\n<li>Added: Display Conditions \\u2014 Day of week condition<\\/li>\\n<li>Added: Video Player &amp; Devices \\u2014 Option to not hide bar when video is playing<\\/li>\\n<li>Fixed: Sticky Elements \\u2014 Unstick for 768px wide tablets<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Compatibility with Elementor Pro 2.5<\\/li>\\n<li>Fixed: Timeline \\u2014 Compatibility with Elementor Pro 2.5<\\/li>\\n<li>Fixed: Sticky Elements \\u2014 Adjust on resize in editor<\\/li>\\n<li>Fixed: Calendar \\u2014 Query compatibility with WPML<\\/li>\\n<li>Fixed: Hotspots \\u2014 Check spaces in hotspot links<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Edge case where images don\'t display entirely<\\/li>\\n<li>Fixed: Timeline \\u2014 Correctly render dynamic tags<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Isotope on loading more posts when filter active<\\/li>\\n<li>Tweak: Video Player \\u2014 Automatically hide bar on mobile when playing<\\/li>\\n<\\/ul>\\n<h4> 2.0.14 <\\/h4>\\n<ul>\\n<li>Added: Toggle Element \\u2014 Option to select which item is active by default<\\/li>\\n<li>Fixed: Table \\u2014 Restrict cell max-width to msie<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Wrong arranging in some cases<\\/li>\\n<li>Fixed: Media Player text indicators wrapping<\\/li>\\n<\\/ul>\\n<h4> 2.0.13 <\\/h4>\\n<ul>\\n<li>Fixed: Posts Extra \\u2014 Carousel js error<\\/li>\\n<\\/ul>\\n<h4> 2.0.12 <\\/h4>\\n<ul>\\n<li>Added: Unfold \\u2014 Options to keep focus on content when folding or unfolding<\\/li>\\n<li>Fixed: Toggle Element \\u2014 Make sure Gallery Extra is initiated when toggling<\\/li>\\n<li>Fixed: Table \\u2014 Min-width breakpoint bug<\\/li>\\n<li>Fixed: Sticky Elements \\u2014 Compatibility with Elementor 2.5<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Z-index issues for panel<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Allow scroll on page not working<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Rare selector for anchors with link issue<\\/li>\\n<li>Fixed: Hotspots \\u2014 Rename css pulse animation<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Editor defaultView error<\\/li>\\n<li>Fixed: Sticky Elements \\u2014 Adjust breakpoint values<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Fallback to default wp posts per page option<\\/li>\\n<li>Tweak: Offcanvas \\u2014 Make sure html element has auto height<\\/li>\\n<li>Tweak: Better wpml classes check<\\/li>\\n<\\/ul>\\n<h4> 2.0.11 <\\/h4>\\n<ul>\\n<li>Fixed: Offcanvas \\u2014 Trigger not closing after open<\\/li>\\n<li>Fixed: Posts \\u2014 Grid overlapping on safari when infinite scroll is enabled<\\/li>\\n<li>Fixed: Table \\u2014 Restrict IE hack to tablet and up<\\/li>\\n<li>Fixed: Get element settings on frontend in edit mode<\\/li>\\n<li>Fixed: Google Map \\u2014 Require resize plugin<\\/li>\\n<li>Added: Posts Extra \\u2014 Button border controls<\\/li>\\n<\\/ul>\\n<h4> 2.0.10 <\\/h4>\\n<ul>\\n<li>Added: Parallax Elements \\u2014 Option to allow moving elements when they aren\'t visible inside viewport<\\/li>\\n<li>Fixed: Google Map \\u2014 Centering with dynamic tags not working<\\/li>\\n<li>Fixed: Calendar \\u2014 Don\'t limit number of posts fetched<\\/li>\\n<li>Fixed: Display Conditions \\u2014 Chrome check failing<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Responsive item aligning<\\/li>\\n<li>Fixed: Parallax Background \\u2014 Custom size control compatibility + tweaks<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Type control condition<\\/li>\\n<li>Tweak: Google Map \\u2014 Disable fitting and centering when route is enabled<\\/li>\\n<\\/ul>\\n<h4> 2.0.9 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Handle multiple paginated loops<\\/li>\\n<li>Added: Posts Extra \\u2014 Nothing found message<\\/li>\\n<li>Added: Image Comparison \\u2014 Option to turn off animation on entrance<\\/li>\\n<li>Added: Posts Extra \\u2014 Query ID filter on top of elementor pro one<\\/li>\\n<li>Added: Offcanvas \\u2014 Control to enable page scroll when offcanvas panel is open<\\/li>\\n<li>Fixed: Table \\u2014 IE cell text wrapping<\\/li>\\n<li>Fixed: Circle Progress \\u2014 Wrong absolute value when multiple widget instances on same page<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Wrong thumbnail order<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Z-index issues<\\/li>\\n<li>Fixed: Calendar \\u2014 Convert timestamp to integer<\\/li>\\n<li>Fixed: Gallery module attachment check<\\/li>\\n<li>Tweak: Timeline \\u2014 Rename timeline script<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Responsive row spacing control<\\/li>\\n<li>Tweak: Parallax Background \\u2014 Compatibility with Elementor 2.4<\\/li>\\n<\\/ul>\\n<h4> 2.0.8 <\\/h4>\\n<ul>\\n<li>Fixed: Text Divider \\u2014 Selector for link color<\\/li>\\n<li>Fixed: Timeline \\u2014 Notice<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Escape jquery expression<\\/li>\\n<li>Fixed: Google Map \\u2014 Handle invalid or undefined snazzy map style<\\/li>\\n<\\/ul>\\n<h4> 2.0.7 <\\/h4>\\n<ul>\\n<li>Fixed: Offcanvas \\u2014 Anchor navigation scroll calculation<\\/li>\\n<li>Added: Timeline \\u2014 Allow post content to be shown instead of excerpt<\\/li>\\n<li>Added: Timeline \\u2014 Control to set line progress position relative to viewport<\\/li>\\n<li>Tweak: Offcanvas \\u2014 Anchor condition<\\/li>\\n<\\/ul>\\n<h4> 2.0.6 <\\/h4>\\n<ul>\\n<li>Fixed: Popup \\u2014 Duplicate tab control name<\\/li>\\n<li>Fixed: Popup \\u2014 Remove rtl suffix<\\/li>\\n<li>Added: Offcanvas \\u2014 Global control for offcanvas container background color<\\/li>\\n<\\/ul>\\n<h4> 2.0.5 <\\/h4>\\n<ul>\\n<li>Added: Editor panel labels for widgets<\\/li>\\n<li>Added: Calendar \\u2014 Control to customise month names<\\/li>\\n<li>Added: Offcanvas \\u2014 Link navigate to anchors on page<\\/li>\\n<li>Added: Popup \\u2014 Text trigger styling controls<\\/li>\\n<li>Fixed: Inline SVG \\u2014 Multiple svgs have same settings<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 No parent custom taxonomy terms render all terms<\\/li>\\n<li>Fixed: Posts Extra \\u2014 PHP notice<\\/li>\\n<li>Tweak: Updated language file<\\/li>\\n<\\/ul>\\n<h4> 2.0.4 <\\/h4>\\n<ul>\\n<li>Fixed: Display Conditions \\u2014 Editor section for sections actions<\\/li>\\n<li>Fixed: Display Conditions \\u2014 Conditions evaluation per element<\\/li>\\n<\\/ul>\\n<h4> 2.0.3 <\\/h4>\\n<ul>\\n<li>Fixed: Popup Display Conditions \\u2014 Check widget visibility before opening automatically<\\/li>\\n<li>Fixed: Table \\u2014 First row has no classes<\\/li>\\n<li>Fixed: Google Map \\u2014 Handle no snazzy maps selection<\\/li>\\n<li>Fixed: Display Conditions \\u2014 Wrong default keys resulting in wrong display<\\/li>\\n<li>Fixed: Audio Player \\u2014 Border type selector<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Position structured data property<\\/li>\\n<li>Fixed: Parallax Element \\u2014 Parallax column affecting child columns<\\/li>\\n<li>Fixed: Devices \\u2014 Image extending outside the widget area<\\/li>\\n<li>Fixed: Popup \\u2014 Move font family to pseudo-element<\\/li>\\n<li>Fixed: Slide Menu \\u2014 Sub-menu links not working with link navigation turned on<\\/li>\\n<li>Tweak: Rename infinite-scroll script<\\/li>\\n<li>Tweak: Breadcrumbs \\u2014 Increase typography selector specificity<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Additional conditions for areas style sections<\\/li>\\n<li>Remove widget disabling admin notif<\\/li>\\n<li>Update Wordpress stable tag to 5.0.0<\\/li>\\n<\\/ul>\\n<h4> 2.0.2 <\\/h4>\\n<ul>\\n<li>Added: New Query Control<\\/li>\\n<li>Added: Display Conditions \\u2014 Ajax powered fields<\\/li>\\n<li>Added: Display Conditions \\u2014 Current post condition<\\/li>\\n<li>Fixed: Switcher \\u2013 Autoplay not working without entrance animation<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Custom taxonomy archive crumbs<\\/li>\\n<li>Tweak: Audio Player \\u2014 Added option for external sources<\\/li>\\n<\\/ul>\\n<h4> 2.0.1 <\\/h4>\\n<ul>\\n<li>Fixed: Google Map \\u2014 Navigation z-index<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Default button position to hidden<\\/li>\\n<li>Fixed: Devices \\u2014 Video in window frame not displaying<\\/li>\\n<li>Fixed: Google Map \\u2014 JSON incorrectly reported as invalid<\\/li>\\n<li>Fixed: Switcher \\u2014 Cover picture tag with CSS<\\/li>\\n<li>Fixed: Devices \\u2014 Video css for browser frame<\\/li>\\n<li>Added: Posts Extra \\u2014 Infinite load button transition control<\\/li>\\n<li>Added: Posts Extra \\u2014 Infinite load button border control<\\/li>\\n<li>Added: Hotspots \\u2014 Individual hover controls for each hotspot<\\/li>\\n<li>Added: Audio Player \\u2014 Option to loop playlist<\\/li>\\n<li>Tweak: Google Map \\u2014 Make fields dynamic<\\/li>\\n<li>Tweak: Audio Player \\u2014 Added custom js events<\\/li>\\n<li>Tweak: Audio Player \\u2014 Separate control for play icon size<\\/li>\\n<li>Tweak: Video Player \\u2014 Added custom js events<\\/li>\\n<\\/ul>\\n<h4> 2.0.0 <\\/h4>\\n<ul>\\n<li>New Extension: Display Conditions<\\/li>\\n<li>New Widget: Google Map<\\/li>\\n<li>New Widget: Popup<\\/li>\\n<li>New Widget: Age Gate<\\/li>\\n<li>New Widget: Toggle Element<\\/li>\\n<li>New Widget: Calendar<\\/li>\\n<li>New Widget: Audio Player<\\/li>\\n<li>New Widget: Offcanvas<\\/li>\\n<li>New Widget: Slide Menu<\\/li>\\n<li>New Widget: Random Image<\\/li>\\n<li>Added: Posts Extra \\u2014 Support for terms from multiple taxonomies<\\/li>\\n<li>Added: Breadcrumbs \\u2014 Include blog posts page in breadcrumbs<\\/li>\\n<li>Added: Switcher \\u2014 New option to add description<\\/li>\\n<li>Added: Sticky Elements \\u2014 Completely rewritten code<\\/li>\\n<li>Added: Sticky Elements \\u2014 Offset bottom control<\\/li>\\n<li>Added: Global Tooltips \\u2014 Control to disable on breakpoint<\\/li>\\n<li>Added: Breadcrumbs \\u2014 Option to show taxonomy terms for custom post types instead of CPT name<\\/li>\\n<li>Added: Tooltips \\u2014 New trigger on page load<\\/li>\\n<li>Added: Switcher \\u2014 Events to update when inside toggle element<\\/li>\\n<li>Added: Posts Extra \\u2014 Price meta for woocommerce products<\\/li>\\n<li>Added: Posts Extra \\u2014 Button content part replaces read more<\\/li>\\n<li>Added: Posts Extra \\u2014 Post count for filters<\\/li>\\n<li>Added: Breadcrumbs \\u2014 Schema.org properties<\\/li>\\n<li>Fixed: Tooltips \\u2014 Add option to disable on breakpoint<\\/li>\\n<li>Fixed: Global Tooltips \\u2014 Destroy on editor mode<\\/li>\\n<li>Fixed: Parallax Background \\u2014 Out of view sections have wrong background image positions<\\/li>\\n<li>Fixed: Global Tooltips \\u2014 Settings not being saved<\\/li>\\n<li>Fixed: Parallax Element \\u2014 Start position option not applying<\\/li>\\n<li>Fixed: Hotspots \\u2014 Image display block<\\/li>\\n<li>Fixed: Unfold \\u2014 Button alignment<\\/li>\\n<li>Fixed: Unfold \\u2014 Button icon position and indent<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Check for woocommerce for price fields<\\/li>\\n<li>Fixed: Video Player \\u2014 Volume size undefined error<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 RTL behviour on clicking thumbs<\\/li>\\n<li>Fixed: Inline SVG \\u2014 ACF image field<\\/li>\\n<li>Fixed: Update to getEditModel method<\\/li>\\n<li>Fixed: Compatibility with Elementor 2.3.0<\\/li>\\n<li>Fixed: License not deactivating if expired<\\/li>\\n<li>Fixed: Image Comparison \\u2014 Distance for top-aligned labels<\\/li>\\n<li>Fixed: Devices + Hotspots \\u2014 Compatibility with Elementor 2.3.0<\\/li>\\n<li>Fixed: Switcher \\u2014 Astra theme images css conflict<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Multiple hierarchical categories not showing<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Filtered posts not found message<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Wrong grid item width when filters are active and multiple instances on page<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Controls conditions<\\/li>\\n<li>Fixed: Breacrumbs \\u2014 Wrap crumbs automatically<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Hide fields not available for Current Query option<\\/li>\\n<li>Tweak: Hotspots \\u2014 Default hotspots for better ux<\\/li>\\n<li>Tweak: Video Player + Devices \\u2014 Better behaviour and interactions for video player<\\/li>\\n<li>Tweak: Video Player + Devices \\u2014 Better selection of video source files<\\/li>\\n<li>Tweak: Video Player + Devices \\u2014 Added playback speed option<\\/li>\\n<li>Tweak: Timeline \\u2014 Support for point numbers and letter for posts<\\/li>\\n<li>Tweak: Table \\u2014 Remove render template to improve editing performance<\\/li>\\n<li>Tweak: Buttons \\u2014 Add bottom margin to custom spacing control<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Increase options for carousel rows and slides to scroll<\\/li>\\n<li>Tweak: Enable docs link in admin settings page<\\/li>\\n<li>Tweak: Switcher \\u2014 Make description field dynamic<\\/li>\\n<li>Tweak: Google Maps \\u2013 Adjust controls structure<\\/li>\\n<li>Tweak: Table \\u2014 Control names<\\/li>\\n<li>Tweak: Text Divider \\u2014 Controls position<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Added read more to translatable fields for WPML<\\/li>\\n<\\/ul>\\n<h4> 1.9.16 <\\/h4>\\n<ul>\\n<li>Fixed: Elementor 2.3.0 compatibility<\\/li>\\n<\\/ul>\\n<h4> 1.9.15 <\\/h4>\\n<ul>\\n<li>Fixed: Posts Extra \\u2014 Load more button for multiple widget instances<\\/li>\\n<li>Fixed: Parallax Background \\u2014 Responsive speed options<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Columns above 9 don\'t become full width<\\/li>\\n<li>Tweak: Improve Elementor Pro version dependency and posts widget compatibility<\\/li>\\n<li>Tweak: Timeline \\u2014 Enable dynamic fields for custom source<\\/li>\\n<li>Tweak: Circle Progress \\u2014 Handling of divisions operation in value control<\\/li>\\n<li>Tweak: Circle Progress \\u2014 Option to allow numbers with decimals instead of percetanges<\\/li>\\n<li>Tweak: Circle Progress \\u2014 Options to allow for absolute values to be shown<\\/li>\\n<li>Tweak: Hotspots \\u2014 Make hotspots size and opacity control responsive<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Remove swiper slide overflow hidden<\\/li>\\n<li>Tweak: Added option to enable updates to beta versions or Extras<\\/li>\\n<\\/ul>\\n<h4> 1.9.14 <\\/h4>\\n<ul>\\n<li>Fixed: Rename resize script to avoid potential conflicts<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Carousel flickering when used in Tabs widget and switching tabs<\\/li>\\n<li>Fixed: Timeline \\u2014 Date showing current date instead of post date<\\/li>\\n<li>Fixed: Extras admin page conflict with Jetpack<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Link not accessible for preview images with caption<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Added query id control for server side filtering of widget queries<\\/li>\\n<li>Tweak: Hotspots \\u2014 HTML valid structure issue<\\/li>\\n<li>Tweak: Table \\u2014 Minor terminology improvements<\\/li>\\n<\\/ul>\\n<h4> 1.9.13 <\\/h4>\\n<ul>\\n<li>Fixed: Posts Extra \\u2014 Infinite scroll loading same posts<\\/li>\\n<li>Fixed: Inline SVG \\u2014 Space under image<\\/li>\\n<li>Fixed: Extensions not showing when Elementor Pro not active<\\/li>\\n<\\/ul>\\n<h4> 1.9.12 <\\/h4>\\n<ul>\\n<li>Added: CSS filter controls for widgets<\\/li>\\n<li>Added: Global Tooltips \\u2014 Support for shortcodes and dynamic fields<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Load more button causing error when not paginated<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Content inside media not showing when no thumbnail available<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Media area display conditions<\\/li>\\n<li>Fixed: Posts Extra \\u2014 PHP warning when excerpt length is empty<\\/li>\\n<li>Fixed: Posts Extra \\u2014 RTL alignment of posts in masonry mode<\\/li>\\n<li>Fixed: Circle Progress \\u2014 Default control value to string<\\/li>\\n<li>Fixed: Circle Progress \\u2014 Dynamic fields values not working<\\/li>\\n<li>Fixed: Parallax Elements \\u2014 Window height calculation<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Repeater fields conditions<\\/li>\\n<li>Fixed: Parallax Background \\u2014 Breaks when dynamic field is used<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Allow offset to be used in current query<\\/li>\\n<li>Tweak: Timeline \\u2014 Allow drafts and scheduled posts to be included<\\/li>\\n<\\/ul>\\n<h4> 1.9.11 <\\/h4>\\n<ul>\\n<li>Fixed: Posts Extra \\u2014 Sticky posts compatibility with pagination<\\/li>\\n<li>Fixed: Compatibility with new Swiper version in Elementor 2.1<\\/li>\\n<li>Tweak: Timeline \\u2014 Responsive date padding and margin controls<\\/li>\\n<\\/ul>\\n<h4> 1.9.10 <\\/h4>\\n<ul>\\n<li>Fixed: Sticky Elements \\u2014 Options appear twice<\\/li>\\n<li>Tweak: Remove group control sticky<\\/li>\\n<\\/ul>\\n<h4> 1.9.9 <\\/h4>\\n<ul>\\n<li>Fixed: Timeline \\u2014 Points and line not aligned on mobile and tablet if size defined only on desktop<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Default placeholder image overriding post thumbnail<\\/li>\\n<li>Fixed: Sticky Elements no longer working<\\/li>\\n<li>Fixed: Additional check for active Elementor Pro<\\/li>\\n<li>Tweak: Moved Extras advanced section behind Custom CSS section<\\/li>\\n<\\/ul>\\n<h4> 1.9.8 <\\/h4>\\n<ul>\\n<li>Added: Gallery Slider \\u2014 Arrows controls for preview<\\/li>\\n<li>Added: Posts Extra \\u2014 Option to show all filters when using infinite scroll<\\/li>\\n<li>Fixed: Unfold \\u2014 Icon right align not working<\\/li>\\n<li>Fixed: Compatibility with Elementor 2.1 beta<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Allow excerpt in media area<\\/li>\\n<li>Tweak: Timeline \\u2014 More specific color selectors<\\/li>\\n<li>Tweak: Timeline \\u2014 Text align dates to the right for right hand items<\\/li>\\n<\\/ul>\\n<h4> 1.9.7 <\\/h4>\\n<ul>\\n<li>Fixed: Gallery Extra \\u2014 Implemented work-around for warning caused by Elementor bug<\\/li>\\n<li>Fixed: Posts Extra \\u2014 IE 10 images bug<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Time not showing<\\/li>\\n<li>Fixed: Buttons \\u2014 Wrap buttons by default<\\/li>\\n<li>Fixed: Remove too broad css declaration<\\/li>\\n<li>Fixed: Parallax background \\u2014 Correct element resize function name<\\/li>\\n<\\/ul>\\n<h4> 1.9.6 <\\/h4>\\n<ul>\\n<li>Fixed: Parallax Elements \\u2014 Breaks if pan distance is undefined<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Read more typography control conditions<\\/li>\\n<li>Fixed: Unfold \\u2014 Force icon to show hide as inline block<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Stretch body to align all footers to bottom<\\/li>\\n<li>Fixed: Posts Extra \\u2014 IE 10 horizontal layout for posts<\\/li>\\n<li>Fixed: Renamed jquery resize plugin function<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 CSS overflow fix<\\/li>\\n<\\/ul>\\n<h4> 1.9.5 <\\/h4>\\n<ul>\\n<li>Added: Dynamic fields support for all widgets<\\/li>\\n<li>Fixed: Global Tooltips \\u2014 Position not being overriden<\\/li>\\n<li>Fixed: Timeline \\u2014 Pointer cursor not showing on linked cards<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Image bottom spacing on some themes<\\/li>\\n<li>Tweak: Gallery Extra \\u2014 Added unique classes to each item<\\/li>\\n<li>Tweak: HTML5 Video \\u2014 Added control to enable muted video for autoplay<\\/li>\\n<li>Tweak: HTML5 Video \\u2014 Added controls to enable or disable all elements inside the bar<\\/li>\\n<\\/ul>\\n<h4> 1.9.4 <\\/h4>\\n<ul>\\n<li>Added: Timeline \\u2014 Control to center images<\\/li>\\n<li>Added: Posts Extra \\u2014 New filters for post title, excerpt, comments and date<\\/li>\\n<li>Added: HTML5 Video \\u2014 Control to stop all other video players when current one is played.<\\/li>\\n<li>Fixed: Fixed: Column widths in post-css are rendered in the wrong order<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Posts per page doesn\'t take into account sticky posts<\\/li>\\n<li>Fixed: Buttons \\u2014 Item typography group control not working<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Responsive horizontal alignment for filters<\\/li>\\n<li>Fixed: Hotspots \\u2014 Tooltip position not being overriden at hotspot level<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Control conditions<\\/li>\\n<li>Tweak: Updated isotope version to 3.0.6 to fix 1px grid gap<\\/li>\\n<li>Tweak: Remove default webkit left padding from list navs<\\/li>\\n<li>Tweak: Parallax Background \\u2014 Increase plugin timeout reinit<\\/li>\\n<li>Tweak: Posts \\u2014 Increase excerpt length filter priority<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Added option to show only sticky posts<\\/li>\\n<\\/ul>\\n<h4> 1.9.3 <\\/h4>\\n<ul>\\n<li>Added: Sticky Elements \\u2014 Compatibility with the Lazy Loader wordpress plugin<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Safari &lt; 10.2 layout glitch layout glitch on mobile<\\/li>\\n<li>Fixed: HTML5 Video \\u2014 m4v files condition<\\/li>\\n<li>Fixed: Sticky \\u2014 Sticks only when resizing browser window<\\/li>\\n<li>Fixed: Sticky \\u2014 Not working correctly with Stretched parent<\\/li>\\n<li>Fixed: HTML5 Video \\u2014 m4v format not sufficient<\\/li>\\n<li>Fixed: Image Comparison \\u2013 Allow 0 percent values<\\/li>\\n<li>Tweak: HTML5 Video \\u2014 Render attributes<\\/li>\\n<li>Tweak: HTML5 Video \\u2014 Control conditions<\\/li>\\n<\\/ul>\\n<h4> 1.9.2 <\\/h4>\\n<ul>\\n<li>Fixed: Switcher \\u2014 Bug with arrow loader position and stroke width in older versions of Safari<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Compatibility with IE 11<\\/li>\\n<li>Fixed: Parallax Elements \\u2014 Control value undefined check<\\/li>\\n<\\/ul>\\n<h4> 1.9.1 <\\/h4>\\n<ul>\\n<li>Fixed: Parallax Elements \\u2014 Max distance not taking into account scroll position<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Filters not stacking on responsive.<\\/li>\\n<li>Fixed: Switcher \\u2014 Arrow loader not displaying in firefox<\\/li>\\n<li>Fixed: Parallax Elements \\u2014 Wrong position for scroll with start position<\\/li>\\n<li>Fixed: GSAP dependencies<\\/li>\\n<\\/ul>\\n<h4> 1.9.0 <\\/h4>\\n<ul>\\n<li>Added: New Switcher Widget! \\u2014 Switch photos and text using powerful javascript driven transitions. Features menu and arrows navigation, autoplay with progress loader, entrance animations, page background color switcher, two skins (default and overlay) and much more.<\\/li>\\n<li>Added: New Feature for Parallax Elements! \\u2014 Option to parallax columns and widgets on mouse move<\\/li>\\n<li>Added: Posts Extra \\u2014 Controls to style only sticky posts<\\/li>\\n<li>Added: Image Comparison \\u2014 Option to enable clicking on labels to uncover images<\\/li>\\n<li>Added: Hotspots \\u2014 Separate color controls for each hotspot<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Sticky posts not working when a category is selected in the query<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Invisible gallery when preview position is top on desktop<\\/li>\\n<li>Fixed: Image Comparison \\u2014 Remove labels if no text is present<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Hide carousel until properly rendered<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Added alt and title tags to image element<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Issue with negative margin resulting in right whitespace for the gallery<\\/li>\\n<li>Fixed: Timeline \\u2014 Controls conditions<\\/li>\\n<li>Fixed: Timeline \\u2014 Item point color override<\\/li>\\n<li>Fixed: Timeline \\u2014 Properly override point content<\\/li>\\n<li>Tweak: Parallax Elements \\u2014 Removed group control<\\/li>\\n<li>Tweak: Gallery Extra, Gallery Slider, Posts Extra \\u2014 Added notice with link to blend mode browser support for blend mode controls<\\/li>\\n<li>Tweak: Timeline \\u2014 Added repeater setting key method to card render function<\\/li>\\n<\\/ul>\\n<h4> 1.8.8 <\\/h4>\\n<ul>\\n<li>Added: Gallery Extra \\u2014 Control width and ratio of each individual image in manual mode<\\/li>\\n<li>Added: Timeline \\u2014 Option for automatic numbering and letters instead of icons to points<\\/li>\\n<li>Added: Timeline \\u2014 New control to set excerpt length<\\/li>\\n<li>Added: Unfold \\u2014 Option to change icon when unfolded<\\/li>\\n<li>Added: Sticky Elements \\u2014 Option to turn off bottoming of elements inside the parent<\\/li>\\n<li>Added: Posts Extra \\u2014 Option to enable sticky posts in query<\\/li>\\n<li>Added: Posts Extra \\u2014 Arrows sizing controls<\\/li>\\n<li>Added: Posts Extra \\u2014 Transition control for carousel arrows and pagination<\\/li>\\n<li>Added: Posts Extra \\u2014 Option to set how many slides to scroll<\\/li>\\n<li>Added: Image Comparison \\u2014 Control to define initial position of separator<\\/li>\\n<li>Added: Image Comparison \\u2014 Option to enable moving separator by clicking anywhere on the image<\\/li>\\n<li>Added: Buttons \\u2014 Control for label min width<\\/li>\\n<li>Added: Hotspots \\u2014 Control to disable pulsating animation<\\/li>\\n<li>Fixed: Sticky Elements \\u2014 Controls not showing on inner sections<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Images wider than 100% on mobile in manual mixed masonry layout mode<\\/li>\\n<li>Fixed: HTML5 Video \\u2014 CSS bottom whitespace<\\/li>\\n<li>Fixed: Buttons \\u2014 Remove block label for buttons icon, id and class controls<\\/li>\\n<li>Tweak: Timeline \\u2014 Take sticky posts into consideration in query<\\/li>\\n<li>Tweak: Unfold \\u2014 Organise controls<\\/li>\\n<li>Tweak: WPML Compatibility \\u2014 Change method to fix fields not saving<\\/li>\\n<\\/ul>\\n<h4> 1.8.7 <\\/h4>\\n<ul>\\n<li>Fixed: Posts Extra \\u2014 Filtering one widget\'s posts affects all other widgets<\\/li>\\n<li>Fixed: Hotspots \\u2014 Tooltips have an extra space at the bottom when first hovering<\\/li>\\n<li>Fixed: HTML5 Video \\u2014 Volume functionality breaks when controls are hidden<\\/li>\\n<li>Fixed: HTML5 Video \\u2014 Video reloading after each loop<\\/li>\\n<li>Added: Global Tooltips \\u2014 Global controls for distance and width<\\/li>\\n<li>Tweak: HTML5 Video \\u2014 Added width and horizontal alignment control to player<\\/li>\\n<li>Tweak: Global Tooltips \\u2014 Remove default global styling values after Elementor enqueue fix in 1.9.5<\\/li>\\n<\\/ul>\\n<h4> 1.8.6 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Term slug classes to filters and post terms<\\/li>\\n<li>Fixed: Replaced create_function with anonymous function for PHP 7.2 support<\\/li>\\n<li>Fixed: Inline SVG \\u2014 Handle internal CSS in non color overriding situations<\\/li>\\n<li>Fixed: Hotspots \\u2014 Tooltips showing even if they have no content<\\/li>\\n<li>Tweak: Sticky Elements \\u2014 Prevent sticky on a section that is stretched with js<\\/li>\\n<li>Tweak: Buttons \\u2014 Move typography control above tabs<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Move hover animation controls to separate section for better ux<\\/li>\\n<li>Tweak: Gallery Extra \\u2014 Moved hover controls to separate section<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 Moved hover controls to separate section<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 Default font size for thumbnail captions<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Fix condition<\\/li>\\n<li>Tweak: Hotspots \\u2014 Show label for tooltip content in editor<\\/li>\\n<\\/ul>\\n<h4> 1.8.5 <\\/h4>\\n<ul>\\n<li>Fixed: Gallery Extra \\u2014 Missing js dependency<\\/li>\\n<\\/ul>\\n<h4> 1.8.4 <\\/h4>\\n<ul>\\n<li>Fixed: Gallery Extra \\u2014 Random ordering not working<\\/li>\\n<li>Fixed: Timeline \\u2014 RTL optimisation<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Custom image size not working on manual mode<\\/li>\\n<li>Tweak: Add dismissible notice for recommended php version<\\/li>\\n<li>Tweak: Gallery Extra \\u2014 Add title and description caption types<\\/li>\\n<li>Tweak: Timeline \\u2014 Add link control description to avoid linking cards when content already contains links<\\/li>\\n<\\/ul>\\n<h4> 1.8.3 <\\/h4>\\n<ul>\\n<li>Fixed: HTML5 Video \\u2014 Video not playing on Safari and some mobile environments<\\/li>\\n<li>Fixed: Buttons \\u2014 Safari buttons vertical alignment<\\/li>\\n<li>Fixed: Devices \\u2014 device not displaying on Safari when portrait mode is enabled<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Grid broken on Safari<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 reinit masonry when images done loading<\\/li>\\n<li>Tweak: Move all Extras admin settings into Elementor menu<\\/li>\\n<li>Tweak: Image Comparison \\u2014 Remove default value for width control<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 default mobile and tablet gallery columns to larger numbers<\\/li>\\n<\\/ul>\\n<h4> 1.8.2 <\\/h4>\\n<ul>\\n<li>Added: Parallax Background \\u2014 Support for section resize in elementor preview mode<\\/li>\\n<li>Fixed: Parallax Background \\u2014 Compatibility with stretched section<\\/li>\\n<li>Fixed: HTML5 Video \\u2014 Interface style controls conditions<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Right side white-space after thumbnails on top preview position<\\/li>\\n<li>Fixed: Unfold \\u2014 Page stops responding when entering invalid html in text editor mode<\\/li>\\n<li>Tweak: Unfold \\u2014 Allow accordions, tabs and all resizing elements inside content<\\/li>\\n<\\/ul>\\n<h4> 1.8.1 <\\/h4>\\n<ul>\\n<li>Fixed: Posts Extra \\u2014 Masonry broken when infinite scroll is enabled<\\/li>\\n<\\/ul>\\n<h4> 1.8.0 <\\/h4>\\n<ul>\\n<li>New extension: Global Tooltips \\u2014 Add a tooltip to any widget<\\/li>\\n<li>New: Disable Widgets &amp; Extensions \\u2014 You can now disable Extras widgets and extensions via the admin settings page<\\/li>\\n<li>Added: WPML compatibility \\u2014 String Translation and Translation Editor support for all widgets<\\/li>\\n<li>Added: Circle Progress \\u2014 Icon support inside circle<\\/li>\\n<li>Added: Update .pot translation file<\\/li>\\n<li>Added: Buttons \\u2014 Tooltips duration control<\\/li>\\n<li>Added: Global settings for Extras tooltips<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Widget not available on multisite installations<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Infinite scroll breaks when using multiple widgets on same page<\\/li>\\n<li>Fixed: Parallax Background \\u2014 Conflict with Anywhere Elementor Pro featured image background<\\/li>\\n<li>Tweak: Parallax Background \\u2014 requestAnimationFrame method for better performance<\\/li>\\n<li>Tweak: Buttons \\u2014 Rename text align label<\\/li>\\n<li>Tweak: Update nicons font<\\/li>\\n<\\/ul>\\n<h4> 1.7.4 <\\/h4>\\n<ul>\\n<li>Fixed: Gallery Extra \\u2014 Custom link broken and attributes not added<\\/li>\\n<\\/ul>\\n<h4> 1.7.3 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Column vertical alignment controls for carousel<\\/li>\\n<li>Added: Timeline \\u2014  Color controls for post title and excerpt<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Carousel rows number control not impacting preview<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Avatar vertical alignment on stretched media content<\\/li>\\n<li>Fixed: Sticky Elements \\u2014 Incorrect spacer height<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Improve editing flow by with advanced controls conditioning<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Controls position<\\/li>\\n<li>Tweak: Sticky Elements \\u2014 Remove popover from group control<\\/li>\\n<li>Tweak: Parallax Elements \\u2014 Remove popover from group control<\\/li>\\n<\\/ul>\\n<h4> 1.7.2 <\\/h4>\\n<ul>\\n<li>Added: Gallery Slider \\u2014 Overlay captions for preview and thumbnails<\\/li>\\n<li>Added: Gallery Slider \\u2014 Controls for caption effects, layout and hover properties<\\/li>\\n<li>Added: Gallery Slider \\u2014 Controls for active thumbs caption<\\/li>\\n<li>Fixed: Buttons \\u2014 Removed popover control on effects<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 Improved carousel adapt on preview resize<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 Improved thumbnails grid<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 Better controls for stacking and position of preview<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 Replace background color with background control for preview captions and overlay<\\/li>\\n<li>Tweak: Gallery Slider + Gallery Extra \\u2014 Better BEM classes<\\/li>\\n<\\/ul>\\n<h4> 1.7.1 <\\/h4>\\n<ul>\\n<li>Added: Gallery Extra \\u2014 Caption horizontal and vertical alignment and hover effects<\\/li>\\n<li>Added: Gallery Extra \\u2014 Ratio and alignment controls to masonry layout<\\/li>\\n<li>Added: Gallery Extra \\u2014 New border and border radius controls for captions<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Bring image to front when hovered<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Images not displaying on infinite load on iOS Safari and Chrome<\\/li>\\n<li>Tweak: Image Comparison \\u2014 Force override of modified image max-width attribute<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Added extra classes to media elements<\\/li>\\n<\\/ul>\\n<h4> 1.7.0 <\\/h4>\\n<ul>\\n<li>Added: Gallery Extra \\u2014 Masonry layout with mixed mode<\\/li>\\n<li>Added: Gallery Extra \\u2014 Tilt effect<\\/li>\\n<li>Added: Gallery Extra \\u2014 Caption horizontal and vertical alignment and hover effects<\\/li>\\n<li>Added: Gallery Extra \\u2014 Overlay, caption and image transition controls<\\/li>\\n<li>Added: Gallery Extra \\u2014 Overlay blend mode control<\\/li>\\n<li>Added: Gallery Extra \\u2014 Image scale controls for default and hover states<\\/li>\\n<li>Added: Gallery Extra \\u2014 Overlay margin controls for default and hover states<\\/li>\\n<li>Added: Gallery Extra \\u2014 Manual mode that allows entering of every image manually and linking it to any URL<\\/li>\\n<li>Added: Inline SVG widget<\\/li>\\n<li>Added: Posts Extra \\u2014 Controls to disable linking for post title, media and terms<\\/li>\\n<li>Added: Posts Extra \\u2014 Control to select default applied filter for filter bar<\\/li>\\n<li>Added: Timeline \\u2014 New controls for post title typography and spacing, post excerpt typography and padding<\\/li>\\n<li>Added: Image Comparison \\u2014 Image size control<\\/li>\\n<li>Added: New css transition control for Gallery Extra, Gallery Slider, Hotspots, Posts Extra, Timeline, Table and Inline SVG widgets<\\/li>\\n<li>Added: HTML5 Video \\u2014 M4V format support<\\/li>\\n<li>Added: Devices \\u2014 M4V format support for video<\\/li>\\n<li>Fixed: Buttons \\u2014 Flicker on flip effect<\\/li>\\n<li>Fixed: Timeline \\u2014 CSS class conflict<\\/li>\\n<li>Fixed: Table \\u2014 ID and class don\'t apply to header<\\/li>\\n<li>Tweak: Improved Elementor 1.9 compatibility for Extras group controls<\\/li>\\n<li>Tweak: Update TweenMax to latest version (1.20.2)<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Simplified CSS<\\/li>\\n<li>Tweak: Unfold \\u2014 Disconnect button and content from control alignment logic<\\/li>\\n<\\/ul>\\n<h4> 1.6.3 <\\/h4>\\n<ul>\\n<li>Fixed: Breadcrumbs \\u2014 Display correctly when used within an Elementor library template<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Condition terms separator<\\/li>\\n<li>Tweak: Breadcrumbs \\u2014 Avoid naming conflict with Elementor Pro widget<\\/li>\\n<\\/ul>\\n<h4> 1.6.2 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 New autoplay, autoheight and fade effect controls<\\/li>\\n<li>Added: Posts Extra \\u2014 &quot;Top&quot; option to media position on horizontal layout<\\/li>\\n<li>Added: Posts Extra \\u2014 Allowed media to be positioned horizontally on 2 columns layouts<\\/li>\\n<li>Added: Posts Extra \\u2014 New border controls for media<\\/li>\\n<li>Added: Table \\u2014 Allow table responsive behaviour to be turned off<\\/li>\\n<li>Tweak: Buttons \\u2014 Default button content alignment to justify<\\/li>\\n<li>Fix: Timeline \\u2014 Potential fatal error<\\/li>\\n<li>Fix: Posts Extra \\u2014 Post media position controls conditions<\\/li>\\n<li>Fix: Buttons \\u2014 Delay on transitioned properties<\\/li>\\n<li>Fix: Posts Extra \\u2014 Wrong tablet breakpoint set for number of columns<\\/li>\\n<li>Fix: Parallax Background \\u2014 Remove initial background image once parallax is activated<\\/li>\\n<\\/ul>\\n<h4> 1.6.1 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Link author name and avatar to author posts pages<\\/li>\\n<li>Added: Posts Extra \\u2014 Read more link to excerpt<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Added separate hide option for Position for better UX <\\/li>\\n<li>Tweak: Posts Extra \\u2014 Improved position icons<\\/li>\\n<\\/ul>\\n<h4> 1.6.0 <\\/h4>\\n<ul>\\n<li>New Widget \\u2014 Posts Extra - Create ANY layout for posts with masonry, infinite load, filtering and custom post type support. Works only with Elementor Pro<\\/li>\\n<li>Tweak: Breadcrumbs \\u2014 Added horizontal position and text alignment controls<\\/li>\\n<li>Tweak: Buttons \\u2014 Improved CSS and better alignment and stacking options<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Error outputting separator<\\/li>\\n<li>Fixed: Buttons \\u2014 Transition on button content when effects are turned on<\\/li>\\n<\\/ul>\\n<h4> 1.5.6 <\\/h4>\\n<ul>\\n<li>Fixed: Parallax Background \\u2014 Replaced parallax class name to avoid future conflicts<\\/li>\\n<li>Fixed: Timeline \\u2014 Remove flex from left aligned timeline and allow image spacing for horizontal layouts<\\/li>\\n<li>Fixed: PHP fatal error<\\/li>\\n<li>Tweak: Unfold \\u2014 Switched Settings with Content sections in editor for better UX<\\/li>\\n<\\/ul>\\n<h4> 1.5.5 <\\/h4>\\n<ul>\\n<li>Added: Buttons \\u2014 Inline editing<\\/li>\\n<li>Added: Breadcrumbs \\u2014 Inline editing<\\/li>\\n<li>Added: Circle Progress \\u2014 Inline editing<\\/li>\\n<li>Added: Hotspots \\u2014 Inline editing<\\/li>\\n<li>Added: Image Comparison \\u2014 Inline editing<\\/li>\\n<li>Added: Table \\u2014 Inline editing<\\/li>\\n<li>Added: Text Divider \\u2014 Inline editing<\\/li>\\n<li>Added: Timeline \\u2014 Inline editing<\\/li>\\n<li>Added: Unfold \\u2014 Inline editing<\\/li>\\n<li>Fixed: Tooltips \\u2014 Error &quot;size&quot; of undefined appears for delay_in in some cases<\\/li>\\n<li>Fixed: Unfold \\u2014 Issue that resulted in wrong calculation of unfolded height<\\/li>\\n<li>Tweak: Default to text cursor for text where inline editing is available<\\/li>\\n<\\/ul>\\n<h4> 1.5.4 <\\/h4>\\n<ul>\\n<li>Added: HTML5 Video \\u2014 Option to end video at last frame<\\/li>\\n<li>Tweak: HTML5 Video \\u2014 Removed auto pausing when interacting with progress bar<\\/li>\\n<\\/ul>\\n<h4> 1.5.3 <\\/h4>\\n<ul>\\n<li>Fixed: Unfold \\u2014 Content folds back automatically when scrolling on mobile browsers that vertically resize the viewport<\\/li>\\n<\\/ul>\\n<h4> 1.5.2 <\\/h4>\\n<ul>\\n<li>Added: Gallery Extra \\u2014 Allow gallery navigation in lightbox<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Image box shadow not applying<\\/li>\\n<li>Fixed: Buttons \\u2014 Issue with transition delays on buttons without effects<\\/li>\\n<\\/ul>\\n<h4> 1.5.1 <\\/h4>\\n<ul>\\n<li>Added: Table \\u2014 Control to show header on mobile as a block or a column<\\/li>\\n<li>Added: Table \\u2014 Border control for table rows<\\/li>\\n<li>Added: Table \\u2014 Option to automatically try to fetch correct headers for mobile with override possibility<\\/li>\\n<li>Added: Table \\u2014 Control to set width for mobile headers<\\/li>\\n<li>Tweak: Table \\u2014 Remove column rules from mobile<\\/li>\\n<li>Tweak: Table \\u2014 Removed first \\/ last child border rules from mobile<\\/li>\\n<li>Tweak: Table \\u2014 Added pointer cursor on sortable header cells<\\/li>\\n<li>Tweak: Table \\u2014 Moved padding to text for better handling of responsive layout and removed negative margin technique<\\/li>\\n<li>Tweak: Table \\u2014 Responsive cells and header cells padding controls<\\/li>\\n<li>Tweak: Table \\u2014 Move cell header control to top<\\/li>\\n<li>Tweak: Table \\u2014 Added option to hide headers completely on mobile<\\/li>\\n<li>Tweak: Table \\u2014 Hide mobile headers that have no content<\\/li>\\n<li>Tweak: Sticky \\u2014 Set default z-index to 1 for stickable elements<\\/li>\\n<li>Fixed: Image Comparison \\u2014 Separator not showing<\\/li>\\n<li>Fixed: Image Comparison \\u2014 Remove space between images and widget container<\\/li>\\n<li>Fixed: Table \\u2014 PHP Warning when allowing empty on repeater fields<\\/li>\\n<li>Fixed: Table \\u2014 Width and alignment not working<\\/li>\\n<li>Fixed: Table \\u2014 Added missing custom class and id from markup<\\/li>\\n<\\/ul>\\n<h4> 1.5.0 <\\/h4>\\n<ul>\\n<li>New Widget: Table<\\/li>\\n<li>Fixed: Prefix CSS helper classes to avoid potential conflicts<\\/li>\\n<\\/ul>\\n<h4> 1.4.0 <\\/h4>\\n<ul>\\n<li>New: Buttons Effects<\\/li>\\n<li>Added: Breadcrumbs \\u2014 Control to manually specify which post or page to generate breadcrumbs for<\\/li>\\n<li>Fixed: Devices \\u2014 Horizontal orientation image not visible<\\/li>\\n<\\/ul>\\n<h4> 1.3.1 <\\/h4>\\n<ul>\\n<li>Fixed: Parallax Background \\u2014 Wrong position when loading page off viewport<\\/li>\\n<li>Fixed: Timeline \\u2014 Enlarged points not aligned to line on tablet and mobile<\\/li>\\n<li>Added: Timeline \\u2014 Responsive controls for point size and icon size<\\/li>\\n<\\/ul>\\n<h4> 1.3.0 <\\/h4>\\n<ul>\\n<li>Added: New Widget! \\u2014 HTML5 Video<\\/li>\\n<li>Added: Devices \\u2014 Added HTML5 Video controls<\\/li>\\n<li>Added: Devices \\u2014 Added option to stretch the video to fit into the device screen<\\/li>\\n<li>Added: Devices \\u2014 Added option to choose wether or not to stop the video when leaving viewport<\\/li>\\n<li>Added: Timeline \\u2014 Hover properties for points<\\/li>\\n<li>Added: Timeline \\u2014 More style override options for each card<\\/li>\\n<li>Added: Gallery Slider \\u2014 More responsive controls for preview position and spacing<\\/li>\\n<li>Fixed: Timeline \\u2014 Removed unnecessary z-index from cards<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Preview spacing doesn\'t work on mobile when the layout is vertical<\\/li>\\n<li>Fixed: Devices \\u2014 Replaced SVG IDs with classes to avoid code invalidation<\\/li>\\n<li>Fixed: Circle Progress \\u2014 Canvas distorted on responsive<\\/li>\\n<li>Fixed: Hotspots \\u2014 Links concatenating from one repeater field to another<\\/li>\\n<li>Fixed: Parallax Background \\u2014 Images move up after scrolling up and down multiple times<\\/li>\\n<li>Fixed: Parallax Background \\u2014 Background position is off when section Stretch is turned on<\\/li>\\n<li>Fixed: Hotspots \\u2014 Links inside tooltips appear outside of the tooltip<\\/li>\\n<li>Tweak: Timeline \\u2014 Changed &quot;Size Ratio&quot; name to &quot;Scale&quot;<\\/li>\\n<li>Tweak: Gallery Extras \\u2014 Bring 3D items to front on hover<\\/li>\\n<li>Tweak: Hotspots \\u2014 Moved tooltip content outside hotspot to avoid invalid nodes<\\/li>\\n<li>Tweak: Hotspots \\u2014 Don\'t activate tooltips that have no content set<\\/li>\\n<\\/ul>\\n<h4> 1.2.5 <\\/h4>\\n<ul>\\n<li>Tweak: Replaced text align icons with horizontal align icons where appropriate<\\/li>\\n<li>Fixed: Sticky elements not bottoming out correctly when using custom parent selector<\\/li>\\n<li>Fixed: Removing unstick for any breakpoint would break sticky functionality<\\/li>\\n<\\/ul>\\n<h4> 1.2.4 <\\/h4>\\n<ul>\\n<li>Added: Sticky \\u2014 Custom selector for sticky parent to allow for elements to stick in any parent element<\\/li>\\n<li>Tweak: Timeline \\u2014 Responsive padding controls<\\/li>\\n<li>Tweak: Timeline \\u2014 Refactoring and improved performance and accuracy on progress bar<\\/li>\\n<li>Tweak: Image Comparison \\u2014 Adjust spacing method for labels and vertical alignment improvements<\\/li>\\n<li>Tweak: Image Comparison \\u2014 Allow for widget border radius control to affect images<\\/li>\\n<li>Fixed: Parallax Background \\u2014 Scroll breaks on mobile when hiding a parallaxed section<\\/li>\\n<li>Fixed: Timeline \\u2014 Cards not animating when first in view<\\/li>\\n<li>Fixed: Timeline \\u2014 Content wrapper present even if no card content is set<\\/li>\\n<\\/ul>\\n<h4> 1.2.3 <\\/h4>\\n<ul>\\n<li>Fixed: Parallax Background \\u2014 Section background not reverting after parallax turned on again<\\/li>\\n<li>Fixed: Parallax Background \\u2014 Calculating wrong dimensions when using Elementor JS stretch option<\\/li>\\n<li>Fixed: Issue where updating Elementor when Extras is active would result in an error<\\/li>\\n<li>Tweak: Hotspots \\u2014 Adjusted default tooltip width<\\/li>\\n<\\/ul>\\n<h4> 1.2.2 <\\/h4>\\n<ul>\\n<li>Fixed: Heading Extra \\u2014 Complete html support<\\/li>\\n<\\/ul>\\n<h4> 1.2.1 <\\/h4>\\n<ul>\\n<li>Fixed: Heading Extra \\u2014 Gradient would show only for the first line<\\/li>\\n<li>Fixed: Parallax Background \\u2014 When using padding on sections, image position calculation would not be correct<\\/li>\\n<\\/ul>\\n<h4> 1.2.0 <\\/h4>\\n<ul>\\n<li>Added: New Feature! \\u2014 Parallax Background \\u2014 Now you can parallax section backgrounds and have it move up, down, left or right while scrolling<\\/li>\\n<li>Added: New Widget! \\u2014 Unfold \\u2014 Lets you hide content and reveal it on demand<\\/li>\\n<li>Added: New Widget! \\u2014 Breadcrumbs<\\/li>\\n<li>Added: Parallax Elements \\u2014 Allow to select whether to parallax an element relative to its own position or the middle of the viewport<\\/li>\\n<li>Added: Hotspots \\u2014 Ability to add links to hotspots if tooltips are triggered on hover<\\/li>\\n<li>Added: Tooltips \\u2014 Added left and right tooltips for both Hotspots and Button Groups<\\/li>\\n<li>Added: Tooltips \\u2014 Better handling of repositioning tooltips when they flow outside of the viewport<\\/li>\\n<li>Added: Tooltips \\u2014 Ability to override tooltip position for each button of hotspot individually<\\/li>\\n<li>Added: Heading Extra \\u2014 Text fill now supports clipped images<\\/li>\\n<li>Tweak: Heading Extra \\u2014 Allow to have both text shadow and long shadow on the same text<\\/li>\\n<li>Tweak: Text Divider \\u2014 Responsive alignment and spacing controls<\\/li>\\n<li>Tweak: Text Divider \\u2014 Proper horizontal alignment of text and separators<\\/li>\\n<li>Fixed: Heading Extra \\u2014 Multiple z-index related issues<\\/li>\\n<li>Fixed: Parallax Elements \\u2014 Fix issue where elements would jump when scrolling<\\/li>\\n<\\/ul>\\n<h4> 1.1.4 <\\/h4>\\n<ul>\\n<li>Added: Sticky sections!<\\/li>\\n<li>Added: Sticky \\u2014 New controls to unstick for mobile and tablet<\\/li>\\n<li>Added: Parallax Elements \\u2014 New controls to set different speeds for different breakpoints<\\/li>\\n<li>Added: Gallery Slider \\u2014 Links on images and support for the new Elementor lightbox feature<\\/li>\\n<li>Tweak: Improved shortcode support for all widgets, especially tooltips<\\/li>\\n<li>Tweak: Parallax Elements \\u2014 Greatly improved performance for parallaxed items<\\/li>\\n<li>Tweak: Parallax Elements \\u2014 Changed speed control logic to allow for reverse parallax<\\/li>\\n<li>Tweak: Created custom group controls for Sticky and Parallax features<\\/li>\\n<li>Fixed: Removed z-index from sticky elements to allow z-index setting from Elementor controls<\\/li>\\n<li>Fixed: Gallery Extras \\u2014 Some styling controls were conditioned by the &quot;Link to&quot; control<\\/li>\\n<li>Fixed: Removed potentially buggy call to Elementor class<\\/li>\\n<\\/ul>\\n<h4> 1.1.3 <\\/h4>\\n<ul>\\n<li>Tweak: Devices \\u2014 Refactored and cleaned up code for editor functionality<\\/li>\\n<li>Tweak: Gallery Extra \\u2014 Moved distance control after parallax controls<\\/li>\\n<li>Added: Controls to add parallax to any widget or column<\\/li>\\n<li>Added: Global control for turning off parallax functionality for tablet and mobile<\\/li>\\n<li>Added: Gallery Extra \\u2014 Control for settings horizontal overlap of images<\\/li>\\n<li>Added: Image Comparison \\u2014 Separator between images<\\/li>\\n<li>Added: Global \\u2014 Implemented the new Text Shadow controls for all widgets<\\/li>\\n<li>Added: Button Groups \\u2014 Responsive control of spacing for stacked buttons<\\/li>\\n<li>Fixed: Devices \\u2014 Issue where frames would not properly change in editor mode<\\/li>\\n<li>Fixed: Changed license page capability to \'manage_options\'<\\/li>\\n<li>Fixed: Compatibility with Elementor 1.6<\\/li>\\n<\\/ul>\\n<h4> 1.1.2 <\\/h4>\\n<ul>\\n<li>Fixed: Class namespace change in Elementor Pro 1.5.7 resulting in fatal error<\\/li>\\n<\\/ul>\\n<h4> 1.1.1 <\\/h4>\\n<ul>\\n<li>Fixed: Devices \\u2014 Overlay not visible for laptop and desktop<\\/li>\\n<li>Fixed: Timeline \\u2014 PHP empty function fatal error<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Width remained 50% even if vertical layout selected<\\/li>\\n<\\/ul>\\n<h4> 1.1.0 <\\/h4>\\n<ul>\\n<li>Added: New Widget! \\u2014 Gallery Extra \\u2014 We\'ve taken aside the parallax functionality and created a whole new widget with nots of posibilities.<\\/li>\\n<li>Added: New Widget! \\u2014 Gallery Slider \\u2014 A gallery layout with inline preview.<\\/li>\\n<li>Added: New Feature! \\u2014 Button tooltips \\u2014 You can now use the Button Groups widget to add buttons with tooltips.<\\/li>\\n<li>Added: New Feature! \\u2014 Timeline \\u2014 Integration with Woocommerce products.<\\/li>\\n<li>Added: New Feature! \\u2014 Hotspots \\u2014 Added support for icons inside hotspots.<\\/li>\\n<li>Added: New Feature! \\u2014 Hotspots \\u2014 Ability to set the delay for both entrance close animations.<\\/li>\\n<li>Added: Circle Progress \\u2014 Control too choose start angle for the circle progress.<\\/li>\\n<li>Added: Devices \\u2014 Support for multiple video formats<\\/li>\\n<li>Added: Timeline \\u2014 Add featured images from separate control.<\\/li>\\n<li>Added: Elementor Portfolio Widget \\u2014 Speed control for parallax feature.<\\/li>\\n<li>Added: Timeline \\u2014 Turn on and off for excerpts, content, title and featured image.<\\/li>\\n<li>Fixed: Image Comparison \\u2014 Handle now goes all the way until the end of the image.<\\/li>\\n<li>Fixed: Timeline \\u2014 Date color wasn\'t changing properly.<\\/li>\\n<li>Fixed: Issue where disabling and changing license was not possible.<\\/li>\\n<li>Fixed: Sticky - Issue where in preview mode wrong height of the element was calculated.<\\/li>\\n<li>Fixed: Image Gallery \\u2014 Issue with displaying on Firefox.<\\/li>\\n<li>Fixed: Image Comparison \\u2014 Handle jumps when using multiple widgets on same page.<\\/li>\\n<li>Fixed: Timeline \\u2014 Scheme style override issue for points.<\\/li>\\n<li>Fixed: Devices \\u2014 Video would not play on iOS devices<\\/li>\\n<\\/ul>\\n<h4> 1.0.5 <\\/h4>\\n<ul>\\n<li>Added: Button Groups \\u2014 Box shadow control.<\\/li>\\n<li>Fixed: Ensured compatibility with other jquery appear plugins.<\\/li>\\n<li>Fixed: Issue where disabling and changing license was not possible.<\\/li>\\n<\\/ul>\\n<h4> 1.0.4 <\\/h4>\\n<ul>\\n<li>Added: Added translation support<\\/li>\\n<li>Fixed: Devices \\u2014 Issue where controls would always display as a white rectangular shape.<\\/li>\\n<\\/ul>\\n<h4> 1.0.3 <\\/h4>\\n<ul>\\n<li>Fixed: Image Galleries \\u2014 Issue where galleries with no links would break the layout<\\/li>\\n<li>Fixed: Hotspots \\u2014 When using multiple hotspots widgets on the same page additional widgets would show the first widget\'s tooltips instead of their own<\\/li>\\n<\\/ul>\\n<h4> 1.0.2 <\\/h4>\\n<ul>\\n<li>Added: Hotspots \\u2014 New controls: text align, padding, border and typography<\\/li>\\n<li>Fixed: Hotspots \\u2014 Hide arrow control not working<\\/li>\\n<li>Fixed: Hotspots \\u2014 Issue where tooltips don\'t remain open on click trigger option and thus preventing clicking off links inside tooltips<\\/li>\\n<li>Fixed: Button Groups \\u2014 Replaced custom border controls with border group control<\\/li>\\n<li>Fixed: Extended Heading \\u2014 Compability with Elementor 1.5<\\/li>\\n<li>Fixed: Extended Heading \\u2014 Heading size not working<\\/li>\\n<li>Fixed: Image Comparison \\u2014 Issue where colors of labels would not change colors for printed templates<\\/li>\\n<\\/ul>\\n<h4> 1.0.1 <\\/h4>\\n<ul>\\n<li>Fixed: Image Comparison \\u2014 Issue where dragging the handle on mobile would not work<\\/li>\\n<\\/ul>\\n<h4> 1.0.0 <\\/h4>\\n<ul>\\n<li>Added: New &quot;Timeline&quot; widget with posts support for Elementor Pro<\\/li>\\n<li>Added: Image Comparison \\u2014 Different colors for both labels<\\/li>\\n<li>Tweak: Image Comparison \\u2014 Moved alignment &amp; scaling options to widget wrapper<\\/li>\\n<li>Tweak: Aligned default widgets colors to selected color scheme<\\/li>\\n<li>Tweak: Removed sticky from sections temporarily<\\/li>\\n<li>Tweak: Removed parallax scrolling from section backgrounds<\\/li>\\n<li>Tweak: Button Groups \\u2014 Reorganized repeater controls under tabs<\\/li>\\n<li>Tweak: Full compatibility with global color schemes for all widgets<\\/li>\\n<li>Tweak: Hotspots \\u2014 Reorganized repeater controls under tabs<\\/li>\\n<li>Fixed: Timeline \\u2014 Issue where arrow colors would not apply<\\/li>\\n<li>Fixed: Extended Heading \\u2014 Entrace animation hides the shadow when animation is complete<\\/li>\\n<li>Fixed: Devices \\u2014 Border type not present in hover state for video controls<\\/li>\\n<li>Fixed: Image Comparison \\u2014 Removed small space after widget<\\/li>\\n<li>Fixed: Hotspots \\u2014 Syntax error in JS template<\\/li>\\n<li>Fixed: Hotspots \\u2014 JS error when adding new hotpots<\\/li>\\n<li>Fixed: Hotspots \\u2014 Tooltips z-index issue<\\/li>\\n<li>Fixed: Hotspots \\u2014 Bottom tooltips animated down instead of up<\\/li>\\n<li>Fixed: Hotspots \\u2014 Html being added as string when hotspots are triggered through the open_editor hook<\\/li>\\n<li>Fixed: Hotspots \\u2014 Tooltips not editable immediately when dragged into preview<\\/li>\\n<li>Fixed: Image Comparison \\u2014 images are not set to occupy full width<\\/li>\\n<\\/ul>\\n<h4> 0.1.2 <\\/h4>\\n<ul>\\n<li>Added: Hotspots \\u2014 Rewrote code entirely to allow for preview mode support, customisation of tooltips and faster rendering<\\/li>\\n<li>Added: Circle progress \\u2014 Better handling of value suffix<\\/li>\\n<li>Fixed: Scripts dependencies<\\/li>\\n<li>Fixed: Devices \\u2014 Issue where global colors where used instead of skins<\\/li>\\n<li>Fixed: Various compatibility issues with the Elementor color scheme<\\/li>\\n<li>Fixed: Image Gallery Extension \\u2014 Styling issues when choosing to justify gallery items<\\/li>\\n<li>Fixed: Sticky Extension \\u2014 Sitcky offset would not preview correctly and sometimes having multiple sticky widgets would cause interference amongst them<\\/li>\\n<li>Fixed: Parallax Gallery \\u2014 Removed any kinds of transformation for odd children<\\/li>\\n<\\/ul>\\n<h4> 0.1.1 <\\/h4>\\n<ul>\\n<li>Fixed: Buttons groups \\u2014 Responsive alignment of buttons<\\/li>\\n<li>Added: Buttons groups \\u2014 option to stack buttons on tablet or mobile<\\/li>\\n<\\/ul>\\n<h4> 0.1.0 <\\/h4>\\n<ul>\\n<li>Initial Private Beta<\\/li>\\n<\\/ul>\",\"installation\":\"<ol>\\n<li>Make sure Elementor is installed and active on your website<\\/li>\\n<li>Activate the plugin through the \'Plugins\' menu in WordPress<\\/li>\\n<li>Edit a page (or post) using Elementor<\\/li>\\n<li>Find and use the new widgets and extensions<\\/li>\\n<\\/ol>\"},\"banners\":{\"high\":\"https:\\/\\/shop.namogo.com\\/wp-content\\/uploads\\/edd\\/2019\\/09\\/Banner-2.2.png\",\"low\":\"https:\\/\\/shop.namogo.com\\/wp-content\\/uploads\\/edd\\/2019\\/09\\/Banner-2.2@05x.png\"},\"icons\":{\"1x\":\"https:\\/\\/shop.namogo.com\\/wp-content\\/uploads\\/2017\\/08\\/Logo@2x.png\",\"2x\":\"https:\\/\\/shop.namogo.com\\/wp-content\\/uploads\\/2017\\/08\\/Logo@2x.png\"},\"tested\":\"5.5.0\",\"compatibility\":\"a:1:{s:5:\\\"5.2.3\\\";a:1:{s:6:\\\"1.5.23\\\";a:3:{i:0;s:4:\\\"100%\\\";i:1;s:1:\\\"5\\\";i:2;s:1:\\\"5\\\";}}}\",\"stable_tag\":\"2.2.36\",\"license\":\"GPLv3 or later\",\"added\":\"2017-05-31\",\"description\":[\"<p>Extras is one of the first premium Wordpress plugin for Elementor. It extends its capability with many unique widgets and extensions that make Elementor even more powerful.<\\/p>\\n<h4> Copyright and licensing <\\/h4>\\n<p>Copyright (C) 2016-2019 Elementor Ltd.<\\/p>\\n<p>This program is free software: you can redistribute it and\\/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.<\\/p>\\n<p>This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.<\\/p>\\n<p>You should have received a copy of the GNU General Public License along with this program. If not, see <a href=\\\"https:\\/\\/www.gnu.org\\/licenses\\/\\\">https:\\/\\/www.gnu.org\\/licenses\\/<\\/a>.<\\/p>\\n<h4> Third Party Code <\\/h4>\\n<p>Extras for Elementor incorporates code from:<\\/p>\\n<ul>\\n<li><strong>jquery-circle-progress<\\/strong> v1.2.2, Copyright Rostyslav Bryzgunov Licenses: MIT Source: link <a href=\\\"http:\\/\\/kottenator.github.io\\/jquery-circle-progress\\/\\\">http:\\/\\/kottenator.github.io\\/jquery-circle-progress\\/<\\/a><\\/li>\\n<li><strong>jQuery appear plugin<\\/strong> v0.3.6, Copyright 2012 Andrey Sidorov Licenses: MIT Source: link <a href=\\\"https:\\/\\/github.com\\/morr\\/jquery.appear\\/\\\">https:\\/\\/github.com\\/morr\\/jquery.appear\\/<\\/a><\\/li>\\n<li><strong>LongShadow jQuery Plugin<\\/strong> v1.1.0, Copyright 2013 - 2016 Dang Van Thanh Licenses: MIT Source: link git:\\/\\/github.com\\/dangvanthanh\\/jquery.longShadow.git<\\/li>\\n<li><strong>HC-Sticky<\\/strong> v2.2.3, Copyright Some Web Media License: MIT Source: link <a href=\\\"https:\\/\\/github.com\\/somewebmedia\\/hc-sticky\\\">https:\\/\\/github.com\\/somewebmedia\\/hc-sticky<\\/a><\\/li>\\n<li><strong>jQuery Mobile<\\/strong> v1.4.3, Copyright 2010, 2014 jQuery Foundation, Inc. Licenses: jquery.org\\/license<\\/li>\\n<li><strong>jquery-visible<\\/strong>, Copyright 2012, Digital Fusion, License: <a href=\\\"http:\\/\\/teamdf.com\\/jquery-plugins\\/license\\/\\\">http:\\/\\/teamdf.com\\/jquery-plugins\\/license\\/<\\/a> Source: <a href=\\\"http:\\/\\/teamdf.com\\/jquery-plugins\\/license\\/\\\">http:\\/\\/teamdf.com\\/jquery-plugins\\/license\\/<\\/a><\\/li>\\n<li><strong>Parallax Background<\\/strong> v1.2, by Eren Suleymanoglu Licenses: MIT Source: link <a href=\\\"https:\\/\\/github.com\\/erensuleymanoglu\\/parallax-background\\\">https:\\/\\/github.com\\/erensuleymanoglu\\/parallax-background<\\/a><\\/li>\\n<li><strong>TableSorter<\\/strong> v2.0.5b, Copyright 2007 Christian Bach Licenses: Dual licensed under the MIT and GPL licenses Source: link <a href=\\\"http:\\/\\/tablesorter.com\\\">http:\\/\\/tablesorter.com<\\/a><\\/li>\\n<li><strong>Isotope<\\/strong> PACKAGED v3.0.6, Copyright 2017 Metafizzy License: GPLv3 Source: link <a href=\\\"http:\\/\\/isotope.metafizzy.co\\\">http:\\/\\/isotope.metafizzy.co<\\/a><\\/li>\\n<li><strong>Infinite Scroll<\\/strong> PACKAGED v3.0.2, Copyright 2017 Metafizzy License: GPLv3 Source: link <a href=\\\"https:\\/\\/infinite-scroll.com\\\">https:\\/\\/infinite-scroll.com<\\/a><\\/li>\\n<li><strong>Packery layout mode<\\/strong> PACKAGED v2.0.0 Copyright 2017 Metafizzy License: GPLv3 Source: link <a href=\\\"http:\\/\\/isotope.metafizzy.co\\\">http:\\/\\/isotope.metafizzy.co<\\/a><\\/li>\\n<li><strong>javascript-detect-element-resize<\\/strong> v0.5.3 Copyright (c) 2013 Sebasti\\u00e1n D\\u00e9cima License: MIT Source: link <a href=\\\"https:\\/\\/github.com\\/sdecima\\/javascript-detect-element-resize\\\">https:\\/\\/github.com\\/sdecima\\/javascript-detect-element-resize<\\/a><\\/li>\\n<li><strong>tilt.js<\\/strong> 1.2.1, Copyright (c) 2017 Gijs Rog\\u00e9 License: MIT Source: link <a href=\\\"https:\\/\\/github.com\\/gijsroge\\/tilt.js\\\">https:\\/\\/github.com\\/gijsroge\\/tilt.js<\\/a><\\/li>\\n<li><strong>CLNDR<\\/strong> v1.4.7, Copyright Kyle Stetz (github.com\\/kylestetz) License: MIT Source: link <a href=\\\"https:\\/\\/github.com\\/kylestetz\\/CLNDR\\\">https:\\/\\/github.com\\/kylestetz\\/CLNDR<\\/a><\\/li>\\n<li><strong>GMAP3 Plugin for jQuery<\\/strong> v7.2 Copyright DEMONTE Jean-Baptiste License: GPL-3.0+ Source: link <a href=\\\"http:\\/\\/gmap3.net\\\">http:\\/\\/gmap3.net<\\/a><\\/li>\\n<li><strong>Moment.js<\\/strong> v2.22.2 License: MIT Source: link <a href=\\\"https:\\/\\/github.com\\/moment\\/moment\\/\\\">https:\\/\\/github.com\\/moment\\/moment\\/<\\/a><\\/li>\\n<li><strong>Slidebars<\\/strong> v2 Copyright Adam Charles Smith License: MIT <a href=\\\"http:\\/\\/www.adchsm.com\\/slidebars\\/license\\/\\\">http:\\/\\/www.adchsm.com\\/slidebars\\/license\\/<\\/a> Source: link <a href=\\\"http:\\/\\/www.adchsm.com\\/slidebars\\/\\\">http:\\/\\/www.adchsm.com\\/slidebars\\/<\\/a><\\/li>\\n<li><strong>Splittext.js<\\/strong> Copyright (c) 2008-2016, GreenSock<\\/li>\\n<li><strong>Magnific Popup<\\/strong> v1.1.0 License: MIT Copyright 2016 Dmitry Semenov Soruce: link <a href=\\\"http:\\/\\/dimsemenov.com\\/plugins\\/magnific-popup\\/\\\">http:\\/\\/dimsemenov.com\\/plugins\\/magnific-popup\\/<\\/a><\\/li>\\n<\\/ul>\\n<h4> Important Links <\\/h4>\\n<p><a href=\\\"https:\\/\\/shop.namogo.com\\/docs\\/elementor-extras\\/getting-started\\/#update-official\\\">Updating Extras<\\/a>\\n<a href=\\\"https:\\/\\/shop.namogo.com\\/topic\\/elementor-extras\\/\\\">Documentation<\\/a>\\n<a href=\\\"https:\\/\\/shop.namogo.com\\/account\\/\\\">Your Account<\\/a>\\n<a href=\\\"https:\\/\\/shop.namogo.com\\/account\\/support\\/\\\">Support<\\/a>\\n<a href=\\\"https:\\/\\/shop.namogo.com\\/docs\\/elementor-extras\\/frequently-asked-questions\\/\\\">FAQ<\\/a><\\/p>\"],\"changelog\":[\"<h4> 2.2.36 <\\/h4>\\n<ul>\\n<li>Tweak: Revert support for Elementor Pro to 2.8.0<\\/li>\\n<\\/ul>\\n<h4> 2.2.35 <\\/h4>\\n<ul>\\n<li>Fixed: Compatibility with Elementor 3.0<\\/li>\\n<li>Fixed: Search Form \\u2014 CSS height align bug with expand skin<\\/li>\\n<li>Increased minimum required Elementor version to 3.0<\\/li>\\n<li>Increased minimum required Elementor Pro version to 3.0<\\/li>\\n<\\/ul>\\n<h4> 2.2.34 <\\/h4>\\n<ul>\\n<li>Fixed: Posts \\u2014 Temporary fix for posts pagination due to bug introduced in Wordpress 5.5<\\/li>\\n<li>Fixed: Posts \\u2014 Carousel RTL arrows misplacement<\\/li>\\n<li>Fixed: Display Conditions \\u2013 Day of week condition not including timezone<\\/li>\\n<li>Fixed: Display Conditions \\u2013 Wrong index for Sunday<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Panel header being printed even if no title or close enabled<\\/li>\\n<li>Fixed: Search Form \\u2014 Taxonomy term not excluded if taxonomy has only one term<\\/li>\\n<li>Fixed: Table \\u2014 Inline editing bugs<\\/li>\\n<\\/ul>\\n<h4> 2.2.33 <\\/h4>\\n<ul>\\n<li>Added: Display Conditions \\u2014 Support for ACF options page fields<\\/li>\\n<li>Fixed: Lightbox in post skin slides through all instances inside loop<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Edge case width calculation bug<\\/li>\\n<li>Fixed: Offcanvas \\u2014 CSS overriding default body margin and padding<\\/li>\\n<li>Fixed: Timeline \\u2014 Dynamic tags support in default skin not working<\\/li>\\n<li>Fixed: Search Form \\u2014 Safari back button keeps form fields disabled<\\/li>\\n<\\/ul>\\n<h4> 2.2.32 <\\/h4>\\n<ul>\\n<li>Added: Toggle Element \\u2014 Show element by url hash<\\/li>\\n<li>Added: Toggle Element \\u2014 Change url hash when toggling elements<\\/li>\\n<li>Added: Posts Extra \\u2014 Option to try to force equal height on post skins<\\/li>\\n<li>Added: Audio Player \\u2014 Support for m4a files<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Added missing prefix and suffix fields to translatable fields<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Edge case js error with empty slider controls size values<\\/li>\\n<li>Fixed: Swiper destroy on element remove fails with multiple instances on page<\\/li>\\n<li>Fixed: Slide Menu \\u2014 Sibling submenu items showing behind current active submenu<\\/li>\\n<li>Fixed: Slide Menu \\u2013 Removed default browser padding for ul<\\/li>\\n<li>Fixed: Search Form \\u2014 Edge case where restrictions not being passed if page is loaded using back browser button<\\/li>\\n<\\/ul>\\n<h4> 2.2.31 <\\/h4>\\n<ul>\\n<li>Added: Toggle Element \\u2014 Option to enable refreshing elements inside template when toggling<\\/li>\\n<li>Fixed: Toggle Element \\u2014 Recalculate swipers inside templates<\\/li>\\n<li>Fixed: Ensure loop template data attributes<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Compatibility with usage inside looped template<\\/li>\\n<li>Fixed: Circle Progress \\u2013 Decimal point applied to all widget instances<\\/li>\\n<li>Fixed: Offcanvas \\u2014 JS error on Offcanvas anchor navigation on links with dynamic tags enabled<\\/li>\\n<li>Tweak: Remove focus outline from swiper arrows<\\/li>\\n<li>Tweak: Circle Progress \\u2014 Remove limit for max value when using absolute<\\/li>\\n<\\/ul>\\n<h4> 2.2.30 <\\/h4>\\n<ul>\\n<li>Fixed: Gallery Slider \\u2014 Active thumbnail index for multiple widgets on same page<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Remove buggy auto-height control for thumbnails carousel<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Bug with overlay and reveal animations on same page<\\/li>\\n<li>Fixed: Audio Player \\u2013 Reset user agent padding on playlist<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Exclude em and rem from terms typography control<\\/li>\\n<\\/ul>\\n<h4> 2.2.29 <\\/h4>\\n<ul>\\n<li>Added: Gallery Slider \\u2014 Possibility to add multiple caption types<\\/li>\\n<li>Added: Gallery Slider \\u2014 Ken Burns effect option with. advanced controls<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Missing preview captions text align control<\\/li>\\n<li>Fixed: Display Conditions \\u2014 ACF Choice field check fails<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 Remove fade effect on thumbnails carousel<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 Condition image fit control to work only for slide effect<\\/li>\\n<\\/ul>\\n<h4> 2.2.28 <\\/h4>\\n<ul>\\n<li>Added: Toggle Element \\u2014 Padding control for labels<\\/li>\\n<li>Added: Breadcrumbs \\u2014 Control to disable structured data attributes<\\/li>\\n<li>Added: Gallery Slider, Gallery Extra, Switcher \\u2014 Option to disable slideshow in lightbox<\\/li>\\n<li>Added: Posts \\u2014 Wordpress filters for post and post wrapper classes<\\/li>\\n<li>Added: Video Player \\u2014 Control to remove Chrome\'s download option in fullscreen mode<\\/li>\\n<li>Fixed: Gallery Slider, Gallery Extra, Random Image, Switcher \\u2014 Missing lightbox captions<\\/li>\\n<li>Fixed: Toggle Element \\u2014 Low CSS specificity for ul and li elements causing themes override<\\/li>\\n<li>Fixed: Popup \\u2014 Exit intent not working correctly<\\/li>\\n<li>Tweak: Updated translations .pot file<\\/li>\\n<\\/ul>\\n<h4> 2.2.27 <\\/h4>\\n<ul>\\n<li>Added: Display Conditions \\u2014 Shortcode output condition<\\/li>\\n<li>Added: Display Conditions \\u2014 Post meta condition<\\/li>\\n<li>Added: Posts Extra \\u2014 Control to stack filters responsively<\\/li>\\n<li>Added: Posts Extra \\u2014 Option to trigger a window resize events after each carousel slide to fix displaying issues of certain widgets when using custom post skins<\\/li>\\n<li>Added: Gallery Slider \\u2014 Option to contain centre fit images inside preview slider when custom height is set<\\/li>\\n<li>Fixed: Incorrect Breadcrumbs and Slide Menu WPML integration<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Filters not changing active class when using masonry<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Load more button not hidden when no pagination available<\\/li>\\n<li>Fixed: Video Player \\u2014 Trigger window resize to position correctly elements with motion effects enabled after the video is loaded<\\/li>\\n<li>Fixed: Global Tooltips \\u2014 Removed label_block from slider control that broke controls<\\/li>\\n<\\/ul>\\n<h4> 2.2.26 <\\/h4>\\n<ul>\\n<li>Fixed: Posts Extra \\u2014 Carousel pagination selector breaks pagination when multiple carousels on same page<\\/li>\\n<li>Fixed: Search Form \\u2014 Submit button icon spacing control bug<\\/li>\\n<li>Fixed: Search Form \\u2014 Beautified option fields icons not displaying properly<\\/li>\\n<li>Fixed: Gallery Slider \\u2013 Figure line height causing caption display issues<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Distance control for thumbnails carousel arrows not working<\\/li>\\n<\\/ul>\\n<h4> 2.2.25 <\\/h4>\\n<ul>\\n<li>Added: Display Conditions \\u2014 If no condition value is set check to see if field is set to any value<\\/li>\\n<li>Added: Gallery Slider \\u2014 Options to set max. width and horizontal and vertical alignment for thumbnails carousel<\\/li>\\n<li>Added: Gallery Slider \\u2014 Option to set custom height for preview slides<\\/li>\\n<li>Added: Popup \\u2014 Option to disable refreshing frontend functionality for elements inside the popup<\\/li>\\n<li>Added: Offcanvas \\u2014 Option to disable refreshing frontend functionality for elements inside the panel<\\/li>\\n<li>Added: Calendar \\u2014 Typography control for header week days<\\/li>\\n<li>Added: Google Map \\u2014 Option to set zoom level when navigating to a location<\\/li>\\n<li>Fixed: Bug where one swiper slider\'s arrows control all swiper sliders on the same page<\\/li>\\n<li>Fixed: Calendar \\u2014 Separator style for header not working<\\/li>\\n<li>Fixed: Gallery \\u2014 Instagram lightbox not working for my photos<\\/li>\\n<li>Fixed: Gallery \\u2014 Instagram links bug for hashtag posts<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Filters with masonry enabled when two widgets on page breaks filtering<\\/li>\\n<li>Tweak: Circle Progress \\u2014 Allow 0 value to be shown<\\/li>\\n<\\/ul>\\n<h4> 2.2.24 <\\/h4>\\n<ul>\\n<li>Added: Gallery Slider \\u2014 Option to enable carousel on thumbnails<\\/li>\\n<li>Added: Posts Extra \\u2014 More swiper settings<\\/li>\\n<li>Fixed: Circle Progress \\u2014 Compatibility with display conditions<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Dynamic tag background styles<\\/li>\\n<li>Fixed: Don\'t include Elementor form widget in refreshable widgets due to reCaptcha reinitialisation uncaught error<\\/li>\\n<li>Fixed: Timeline \\u2014 Date entrance animation on left right and overlay alignments<\\/li>\\n<\\/ul>\\n<h4> 2.2.23 <\\/h4>\\n<ul>\\n<li>Added: Popup \\u2014 Margin control for close icon<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Instagram compatibility with new API changes<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Carousel compatibility with Elementor 2.9.4 swiper.js changes<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Allow -1 as posts per page value for specific query source<\\/li>\\n<li>Fixed: Display Conditions \\u2014 Use wp_timezone instead of timezone_string in case timezone is set as offset<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Filter post count style controls conditions<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Carousel remove deprecated Columns control<\\/li>\\n<li>Tweak: Google Map \\u2014 Convert description control from text to WYSIWYG type<\\/li>\\n<\\/ul>\\n<h4> 2.2.22 <\\/h4>\\n<ul>\\n<li>Fixed: Timeline \\u2014 Points and dates not showing when animate cards is on<\\/li>\\n<li>Fixed: Unfold \\u2014 Bug error showing button since last update<\\/li>\\n<\\/ul>\\n<h4> 2.2.21 <\\/h4>\\n<ul>\\n<li>Added: Display Conditions \\u2014 Current Date &amp; Time condition<\\/li>\\n<li>Added: Timeline \\u2014 New option to reverse position of cards<\\/li>\\n<li>Added: Text Divider \\u2014 Margin control for the text<\\/li>\\n<li>Added: Toggle Element \\u2014 Option to hide all elements by default<\\/li>\\n<li>Added: Timeline \\u2014 Controls for overriding text colour in custom mode<\\/li>\\n<li>Fixed: EE widget indicator in editor panel font<\\/li>\\n<li>Fixed: Unfold \\u2014 Removed elementor-button class from button which was adding a lot of padding<\\/li>\\n<li>Fixed: Unfold \\u2014 Editor preview spacing in js template<\\/li>\\n<li>Fixed: Query control width<\\/li>\\n<li>Fixed: PHP error on updater transient data<\\/li>\\n<li>Fixed: Video Player \\u2014 Stop play when played once in viewport<\\/li>\\n<li>Fixed: Timeline \\u2014 Correct dates when using custom post skin with a template that uses Posts Extra<\\/li>\\n<li>Fixed: Tooltips \\u2014 Tooltips not closing on mobile with touchstart event<\\/li>\\n<li>Fixed: Timeline \\u2014 Entrance animation triggering on page load instead of scroll to element<\\/li>\\n<li>Fixed: Timeline \\u2014 Query section not hidden if Source is Custom<\\/li>\\n<li>Fixed: Multiple SELECT2 controls width bug (missing css) after Elementor update<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Masonry layout broken when using custom size values in manual mode<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Changing filters disrupts any Elementor entrance animations placed after widget<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Run ready triggers for section and columns on infinite scroll<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Refresh elements even if infinite scroll button is off<\\/li>\\n<li>Fixed: ACF fields not showing inside templates when ACF Extended plugin is active<\\/li>\\n<li>Tweak: Unfold \\u2014 Hide button when there is no content or visible lines exceeds number of existing lines<\\/li>\\n<li>Tweak: Tooltips \\u2014 Integrate Elementor breakpoints<\\/li>\\n<li>Tweak: Gallery Extra \\u2014 Improved buggy responsive custom sizing method<\\/li>\\n<li>Revert: Display Conditions \\u2014 Added time to Current Date conditions\' date control<\\/li>\\n<\\/ul>\\n<h4> 2.2.20 <\\/h4>\\n<ul>\\n<li>Added: Display Conditions \\u2014 \'Current User\' condition<\\/li>\\n<li>Added: Display Conditions \\u2014 Added time to Current Date conditions\' date control<\\/li>\\n<li>Fixed: Some icon controls hidden due to Elementor changing label_block control attribute<\\/li>\\n<li>Fixed: Popup \\u2014 Close button control conditions<\\/li>\\n<li>Fixed: Popup \\u2014 Close icon not hiding on frontend<\\/li>\\n<\\/ul>\\n<h4> 2.2.19 <\\/h4>\\n<ul>\\n<li>Added: Popup \\u2014 Option to set max number of times a non-persistent popup should open<\\/li>\\n<li>Fixed: Posts \\u2014 Carousel compatibility with Elementor 2.9.0 swiper js upgrade<\\/li>\\n<li>Fixed: Switcher \\u2014 Title direction on RTL<\\/li>\\n<\\/ul>\\n<h4> 2.2.18 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Filters infinite scroll warning<\\/li>\\n<li>Added: Popup \\u2014 Border controls for iframe and image<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 PHP warning<\\/li>\\n<li>Fixed: Buttons \\u2014 Theme CSS override for anchors<\\/li>\\n<li>Fixed: Popup \\u2014 PHP warning when using placeholder image<\\/li>\\n<li>Fixed: Popup \\u2014 Overflow hidden missing from popup content<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Restrict refreshing widget inside offcanvas panel to refreshable list<\\/li>\\n<li>Fixed: Scroll Indicator \\u2014 Clicking bullets on mobile doesn\'t scroll to section when tooltips are enabled<\\/li>\\n<li>Tweak: Scroll Indicator \\u2014 Separate control for enabling opening of tooltips on focus for better integration<\\/li>\\n<li>Tweak: Switcher \\u2014 Convert description textarea field to WYSIWYG<\\/li>\\n<li>Tweak: Slide Menu \\u2014 More specific selector typography control<\\/li>\\n<li>Tweak: Popup \\u2014 Default close button size for iframe<\\/li>\\n<li>Tweak: Make license renewal reminder dismissable<\\/li>\\n<\\/ul>\\n<h4> 2.2.17 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Option to open in new tab for Title link<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Run ready triggers for widgets inside panel when opening<\\/li>\\n<li>Tweak: Posts \\u2014 Hide Media area if no thumbnail or placeholder even if it has content parts<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 Default thumbs spacing to 24<\\/li>\\n<li>Tweak: Update TweenMax version<\\/li>\\n<\\/ul>\\n<h4> 2.2.16 <\\/h4>\\n<ul>\\n<li>Added: Scroll Indicator \\u2014 Offset for scrolling to section<\\/li>\\n<li>Added: Gallery Slider \\u2014 Lazy load images in preview<\\/li>\\n<li>Added: Slide Menu \\u2014 \'elementor_extras\\/widgets\\/slide_menu\\/nav_menu\\/walker_start_el\' filter for walker_nav_menu_start_el hook<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Tilt perspective issue<\\/li>\\n<li>Fixed: Gallery \\u2014 Tilt captions depth not working<\\/li>\\n<li>Fixed: Global Tooltips \\u2014 Distance for repositioned tooltips<\\/li>\\n<li>Fixed: Global Tooltips \\u2014 Multiple tooltips appearing only in edit mode when changing tooltip position<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Remove posts per page setting for current query<\\/li>\\n<li>Fixed: Display Conditions \\u2014 GET and POST not returning true for any value<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Minor PHP warning<\\/li>\\n<li>Fixed: Random Image \\u2014 Error when using only one image<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Duplicate images in Elementor lightbox when infinite loop is enabled<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Include &quot;related&quot; source in Price position control conditions<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Meta Key not showing when Order By is set to Meta Value (number)<\\/li>\\n<li>Fixed: Timeline \\u2014 Meta Key not showing when Order By is set to Meta Value (number)<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Disable add to cart button when used inside a linked Media area<\\/li>\\n<li>Tweak: Timeline \\u2014 Responsive entrance animation<\\/li>\\n<\\/ul>\\n<h4> 2.2.15 <\\/h4>\\n<ul>\\n<li>Fixed: Popup \\u2014 Date comparison fail for non-persistent interval setting<\\/li>\\n<li>Fixed: Tooltips \\u2014 Tooltips empty in some cases after last update<\\/li>\\n<li>Fixed: Calendar \\u2014 Support for ACF date time picker fields<\\/li>\\n<li>Tweak: Hotspots \\u2014 Better css method for disabling pulse effect<\\/li>\\n<li>Tweak: Posts Extra \\u2014 New &quot;hide&quot; icon for content parts positioning<\\/li>\\n<li>Tweak: Nicons<\\/li>\\n<\\/ul>\\n<h4> 2.2.14 <\\/h4>\\n<ul>\\n<li>Fixed: Audio Player \\u2014 Edge case bug when stopping a player inside a section stuck with Elementor sticky setting<\\/li>\\n<li>Fixed: Switcher \\u2014 Loader thickness not working in Firefox<\\/li>\\n<li>Fixed: Offcanvas \\u2014 WPML not fetching content boxes repeater fields<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Masonry missing on frontend after last update<\\/li>\\n<li>Tweak: Tooltips \\u2014 Use append method to add content to the tooltip<\\/li>\\n<\\/ul>\\n<h4> 2.2.13 <\\/h4>\\n<ul>\\n<li>Fixed: Posts Extra \\u2014 Media left right alignment not working<\\/li>\\n<\\/ul>\\n<h4> 2.2.12 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Post border radius control<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Safari layout bug on infinite scroll and masonry layout<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Carousel slides to scroll on tablet bug<\\/li>\\n<li>Fixed: Timeline \\u2014 Date options not showing for custom post skin option<\\/li>\\n<li>Fixed: Sticky Elements \\u2014 Force sticky sections to flex align to start for Safari flex stretch bug<\\/li>\\n<\\/ul>\\n<h4> 2.2.11 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Infinite scroll fields for WPML<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Better support for post type archive links on archive pages<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Flexbox causing horizontal media layout issue on mobile<\\/li>\\n<li>Fixed: Circle Progress \\u2014 Compatibility with wordpress 5.3<\\/li>\\n<li>Tweak: Offcanvas \\u2014 Mode container background colour control from site settings to widget settings<\\/li>\\n<\\/ul>\\n<h4> 2.2.10 <\\/h4>\\n<ul>\\n<li>Added: Popup \\u2014 Option to open url inside popup<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Check for existing non built-in custom post types before iteration<\\/li>\\n<li>Fixed: Display Conditions \\u2014 ACF Date support for custom locale<\\/li>\\n<li>Fixed: Calendar \\u2014 ACF Date support for custom locale<\\/li>\\n<li>Fixed: Switcher \\u2014 Description not available for translation<\\/li>\\n<li>Fixed: Gallery \\u2014 Safari backface-visibility bug<\\/li>\\n<\\/ul>\\n<h4> 2.2.9 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Align media vertically on horizontal post layouts<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Text separator not displaying<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Default horizontal layout width control to 30<\\/li>\\n<\\/ul>\\n<h4> 2.2.8 <\\/h4>\\n<ul>\\n<li>Added: Breadcrumbs \\u2014 Granular controls for crumbs settings on archive and single pages<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Moved images loaded container selector to ajax response<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Show all filters option not working<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Infinite scroll pagination html output rendering more links than needed<\\/li>\\n<li>Fixed: PHP notice for licensing admin notification<\\/li>\\n<li>Fixed: Switcher \\u2014 Border radius control CSS selector<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Cleanup on pagination html output needed for infinite scroll<\\/li>\\n<\\/ul>\\n<h4> 2.2.7 <\\/h4>\\n<ul>\\n<li>Fixed: Compatibility with third-party plugin<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Edge case bug when calculating anchor position<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Notices<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Overlapping items on infinite scroll when filters active<\\/li>\\n<\\/ul>\\n<h4> 2.2.6 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Global \'elementor_extras\\/widgets\\/posts\\/link\' filter<\\/li>\\n<li>Added: Offcanvas \\u2014 Typography control for content boxes<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Infinite Scroll stopping before all posts load<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Panel background selector<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Page jump when navigating to anchor<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Edge case js error in nouislider script<\\/li>\\n<li>Fixed: Templates Control \\u2014 Restrict global query override for templates inside loops<\\/li>\\n<li>Fixed: Slide Menu \\u2014 Nav menu item classes don\'t work when coming from template control<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Wrong order for hierarchical taxonomies<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Flicker when performing infinite scroll on filtered posts<\\/li>\\n<li>Fixed: Sticky Elements \\u2014 Additional padding in some cases below sticky element<\\/li>\\n<li>Fixed: Display Conditions \\u2014 Missing day of week condition<\\/li>\\n<li>Fixed: Hotspots \\u2014 Better handling of icon vertical alignment in css<\\/li>\\n<\\/ul>\\n<h4> 2.2.5 <\\/h4>\\n<ul>\\n<li>Added: Toggle Element \\u2014 Control to hide items without any content<\\/li>\\n<li>Added: Popup \\u2014 Support for usage within Posts Extra custom post skin<\\/li>\\n<li>Added: Audio Player \\u2014 Option to disable preloading of audio files<\\/li>\\n<li>Added: Calendar \\u2014 Search custom fields by field name<\\/li>\\n<li>Added: Offcanvas \\u2014 Options in widgets\' settings to fix page jump issue<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Certain actions not working<\\/li>\\n<li>Fixed: Calendar \\u2014 Pods controls not fetching fields<\\/li>\\n<li>Fixed: Calendar \\u2014 Toolset controls not fetching fields<\\/li>\\n<li>Fixed: Query Control \\u2014 Return only matching queries for pods and toolset<\\/li>\\n<li>Fixed: Calendar \\u2014 Placeholder functionality<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Edge case where css width selectors get overridden by defaults<\\/li>\\n<li>Tweak: Posts Extra \\u2013 Default css order value for parts and areas in frontend css<\\/li>\\n<li>Tweak: Popup \\u2014 Replaced multiple template selection control with single control. IMPORTANT: Settings review required!<\\/li>\\n<li>Tweak: Breadcrumbs \\u2014 Refactor widget code<\\/li>\\n<\\/ul>\\n<h4> 2.2.4 <\\/h4>\\n<ul>\\n<li>Added: Dynamic background image support for custom post skin<\\/li>\\n<li>Added: Breadcrumbs \\u2014 Filter for home breadcrumb link<\\/li>\\n<li>Fixed: Timeline \\u2014 Wrong card content selector for transition control<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Broken selectors after last offcanvas update<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Remove default border around posts<\\/li>\\n<\\/ul>\\n<h4> 2.2.3 <\\/h4>\\n<ul>\\n<li>Added: Offcanvas \\u2014 Compatibility with templates in loops in Posts Extra and other plugins<\\/li>\\n<li>Added: Posts Extra \\u2014 Refresh all widgets scripts on appended infinite scroll items<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Button style gone when placed in linked media area<\\/li>\\n<li>Fixed: Sticky Elements \\u2014 Bug when sticky section inside page body within theme builder header template<\\/li>\\n<li>Fixed: Scroll Indicator \\u2014 Tooltips not working with bullets skin<\\/li>\\n<\\/ul>\\n<h4> 2.2.2 <\\/h4>\\n<ul>\\n<li>Fixed: Scroll Indicator \\u2014 Bug when tooltips disabled on bullets skin<\\/li>\\n<li>Fixed: Timeline \\u2014 Option to hide thumbnail not working in posts mode<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Bug with before parent category filters<\\/li>\\n<li>Fixed: Bug with third party elementor addon that enqueue editor scripts on plugin load<\\/li>\\n<li>Fixed: Posts \\u2014 Default metas control to include price for previous saved settings<\\/li>\\n<li>Added: Search Form \\u2014 Compatibility with Relevanssi search results on custom templates with search form id condition<\\/li>\\n<li>Added: Timeline \\u2014 Option to set a dynamic tag instead of date, title and excerpt in posts mode<\\/li>\\n<li>Added: Timeline \\u2014 Option to set HTML element for title in posts mode<\\/li>\\n<li>Added: Posts Extra \\u2014 Filter for the media area link<\\/li>\\n<li>Added: Posts Extra \\u2014 Option to open media and button links in new tab<\\/li>\\n<li>Added: Table \\u2014 WPML translation of header cells text<\\/li>\\n<li>Tweak: Sticky Elements \\u2014 Additional listeners for recalculating sticky<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Less restrictive css selector for the woocommerce add to cart button<\\/li>\\n<\\/ul>\\n<h4> 2.2.1 <\\/h4>\\n<ul>\\n<li>Added: Scroll Indicator \\u2014 Option to offset start and end positions<\\/li>\\n<li>Added: Posts Extra \\u2014 Responsive media width control<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Missing custom field order options<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Avatar meta showing even if removed from metas list<\\/li>\\n<li>Fixed: Display Conditions \\u2014 ACF Choice fails for radio field<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Bug with left aligned media flex width on mobile<\\/li>\\n<\\/ul>\\n<h4> 2.2.0 <\\/h4>\\n<ul>\\n<li>Added: Google Map \\u2014 Route travel mode options<\\/li>\\n<li>Added: Global Tooltips \\u2014 Compatibility with usage inside post skin templates for Posts Extra<\\/li>\\n<li>Added: Global Tooltips \\u2014 z-index control in both element and global settings<\\/li>\\n<li>Added: Display Conditions \\u2014 Term archive condition<\\/li>\\n<li>Added: Display Conditions \\u2014 ACF conditions<\\/li>\\n<li>Added: Display Conditions \\u2014 POST and GET variable conditions<\\/li>\\n<li>Added: Timeline \\u2014 Custom Post Skin via Elementor templates<\\/li>\\n<li>Added: Timeline \\u2014 Replaced default query controls with related query controls<\\/li>\\n<li>Added: Timeline \\u2014 Trim custom excerpt control<\\/li>\\n<li>Added: Timeline \\u2014 Custom post skin<\\/li>\\n<li>Added: Posts Extra \\u2014 Date formatting controls<\\/li>\\n<li>Added: Posts Extra \\u2014 Actions and filters<\\/li>\\n<li>Added: Calendar \\u2014 Actions and filters<\\/li>\\n<li>Added: Devices \\u2014 Actions<\\/li>\\n<li>Added: Breadcrumbs \\u2014 Actions and filters<\\/li>\\n<li>Added: Scroll Indicator \\u2014 Custom html tags for title and subtitle in list skin<\\/li>\\n<li>Added: Custom implementation for Template controls<\\/li>\\n<li>Fixed: Toggle Element \\u2014 Support for slick slider based widgets inside elements<\\/li>\\n<li>Fixed: Switcher \\u2014 Missing image link control<\\/li>\\n<li>Fixed: Timeline \\u2014 Markup improvement to allow for simpler border radius around cards<\\/li>\\n<li>Fixed: Timeline \\u2014 Custom icon replaces global if global is set<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Separator vertical alignment bug<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Icon migration markup issue<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Update elementor nerd box classes<\\/li>\\n<li>Fixed: Posts Extra \\u2014 ACF fields for custom skins used on archive pages<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Wrong access type for _query property<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Price conditions issue for area and editor panel section display<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Author and avatar metas additional controls conditions<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Removed infinite scroll pages loaded limit<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Handle multiple paginations control condition bug<\\/li>\\n<li>Fixed: Scroll Indicator \\u2014 Custom height control condition<\\/li>\\n<li>Fixed: Popup \\u2014 Compatibility with usage inside post skin templates for Posts Extra<\\/li>\\n<li>Fixed: Buttons \\u2014 Flip effect back is hidden during transition<\\/li>\\n<li>Tweak: Breadcrumbs \\u2014 Remove useless icon and icon class filters<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Update button text filters to include \\/posts\\/<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Default taxonomy order for filters<\\/li>\\n<\\/ul>\\n<h4> 2.1.8 <\\/h4>\\n<ul>\\n<li>Fixed: Missing elementor pro active condition<\\/li>\\n<\\/ul>\\n<h4> 2.1.7 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Order posts by custom fields<\\/li>\\n<li>Fixed: Calendar \\u2014 No events fetched when acf date field return format is different that display format<\\/li>\\n<li>Tweak: Better notices and plugin activation prevention for dependencies<\\/li>\\n<\\/ul>\\n<h4> 2.1.6 <\\/h4>\\n<ul>\\n<li>Fixed: Posts Extra \\u2014 Exclude category pages from previous current query fix<\\/li>\\n<li>Fixed: Posts Extra \\u2014 ACF fields for custom post skins used on archive pages<\\/li>\\n<\\/ul>\\n<h4> 2.1.5 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Filter for button link<\\/li>\\n<li>Added: Posts Extra \\u2014 Apply both \'button\' and \'add_to_cart\' filters to button<\\/li>\\n<li>Added: Audio Player \\u2014 Autoplay option<\\/li>\\n<li>Added: Support for new icon library in Elementor 2.6 in all widgets<\\/li>\\n<li>Added: Support for scaling SVG icon library assets when added to widgets<\\/li>\\n<li>Added: Breadcrumbs \\u2014 Option to hide current page<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Template control not fetching results after Elementor Pro 2.6.0 update<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Body order on horizontal posts<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Default query args prevent correct number of results on search templates<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Show all filters initially not working<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Wrong hierarchical taxonomies order when using custom post types<\\/li>\\n<li>Fixed: Calendar \\u2014 Border radius overflow issue<\\/li>\\n<li>Fixed: Circle Progress \\u2014 Progress not showing when shown below<\\/li>\\n<li>Fixed: Timeline \\u2014 Text align on tablet for RTL<\\/li>\\n<li>Fixed: Switcher \\u2014 Remove link image option when using overlay skin<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Edge case where page scrolls up when panel closed on firefox<\\/li>\\n<li>Fixed: Video Player \\u2014 Play button not centered in edge cases<\\/li>\\n<li>Tweak: Search Form \\u2014 Tax query verification<\\/li>\\n<\\/ul>\\n<h4> 2.1.4 <\\/h4>\\n<ul>\\n<li>Fixed: Audio Player \\u2014 External URL not. accepting dynamic tag in URL category<\\/li>\\n<li>Fixed: Video Player \\u2014 External URL not. accepting dynamic tag in URL category<\\/li>\\n<li>Fixed: Search Form \\u2014 Undefined index notice<\\/li>\\n<li>Added: Offcanvas \\u2014 Custom select for the close button<\\/li>\\n<li>Tweak: Offcanvas \\u2014 Separate control sections for title and close settings<\\/li>\\n<\\/ul>\\n<h4> 2.1.3 <\\/h4>\\n<ul>\\n<li>Fixed: Posts Extra \\u2014 Add to cart button alignment<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Pagination links on single templates<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Deprecated certain filters<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Added button text filter<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Added add to cart text filter<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Changed skin source terminology<\\/li>\\n<li>Tweak: Dissmisable admin licensing notices<\\/li>\\n<\\/ul>\\n<h4> 2.1.2 <\\/h4>\\n<ul>\\n<li>Added: Display Conditions \\u2014 New Term Archive condition<\\/li>\\n<li>Added: Posts Extra \\u2014 Area ordering controls<\\/li>\\n<li>Added: Posts Extra \\u2014 Add to cart button<\\/li>\\n<li>Added: Posts Extra \\u2014 Option to use Elementor templates as custom skin for posts<\\/li>\\n<li>Added: Timeline \\u2014 Separate controls for dates in hover and focused state<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Force square avatar image<\\/li>\\n<li>Fixed: Timeline \\u2014 Remove empty image wrapper when no image exists<\\/li>\\n<li>Fixed: Timeline \\u2014 Hover background color of arrow when focused<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Show price if source is current query<\\/li>\\n<li>Tweak: Timeline \\u2014 Allow Elementor custom image size<\\/li>\\n<li>Tweak: Timeline \\u2014 Responsive color controls<\\/li>\\n<\\/ul>\\n<h4> 2.1.1 <\\/h4>\\n<ul>\\n<li>Added: Tooltips \\u2014 Event for closing the tooltip by clicking anywhere<\\/li>\\n<li>Fixed: Buttons \\u2014 Text align when min width is set<\\/li>\\n<li>Tweak: Scroll Indicator \\u2014 Added options to select progress start and end calculation on scroll for sections<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Moved Infinite Scroll, Pagination and Filters activation controls to their respective sections.<\\/li>\\n<li>Tweak: Licensing \\u2014 Increase remote post request timeout value<\\/li>\\n<\\/ul>\\n<h4> 2.1.0 <\\/h4>\\n<ul>\\n<li>New Widget: Search Form \\u2014 Form widget with restrictions and filters<\\/li>\\n<li>New Widget: Scroll Indicator \\u2014 Create different types of scroll navigation indicators<\\/li>\\n<li>New Feature: Instagram \\u2014 Pull instagram feed to the Gallery widget<\\/li>\\n<li>Added: Posts Extra \\u2014 Vertical carousel<\\/li>\\n<li>Added: Posts Extra \\u2014 New control to select breakpoint for collapsing horizontal post layouts<\\/li>\\n<li>Added: Posts Extra \\u2014 Keep control to define page number limit for infinite scroll<\\/li>\\n<li>Added: Posts Extra \\u2014 Option to not show the &quot;All&quot; filter<\\/li>\\n<li>Added: Posts Extra \\u2014 New control for Slides to Show and deprecated old control [ Settings Review Required ]<\\/li>\\n<li>Added: Posts Extra \\u2014 Exclude taxonomy terms from filters<\\/li>\\n<li>Added: Gallery \\u2014 New spacing control specifically for mixed masonry layout. [ Settings Review Required ]<\\/li>\\n<li>Added: Gallery Slider \\u2014 Control to hide thumbnails<\\/li>\\n<li>Added: Tooltips \\u2014 Mobile event listeners [ Settings Review Required ]<\\/li>\\n<li>Added: Tooltips \\u2014 Responsive triggers and hide events [ Settings Review Required ]<\\/li>\\n<li>Added: Tooltips \\u2014 Separate events for closing the tooltip [ Settings Review Required ]<\\/li>\\n<li>Added: Tooltips \\u2014 New offset control to adjust alignment of arrow tip to target<\\/li>\\n<li>Added: Devices \\u2014 Option for video to cover screen<\\/li>\\n<li>Added: Breadcrumbs \\u2014 Hover colors controls<\\/li>\\n<li>Added: Calendar \\u2014 Disable links to posts<\\/li>\\n<li>Added: Calendar \\u2014 Add nofollow and open in new window on posts source<\\/li>\\n<li>Added: Buttons \\u2014 General padding control<\\/li>\\n<li>Added: Popup \\u2014 Horizontal align for inline trigger and popup close button<\\/li>\\n<li>Added: Notice for license domain mismatch<\\/li>\\n<li>Fixed: Circle Progress \\u2014 Wrong absolute max values<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Infinite scroll loading same posts<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Aligned column breakpoints to elementor default values<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Better override default theme padding on post item<\\/li>\\n<li>Fixed: Timeline \\u2014 CSS bug with overflow<\\/li>\\n<li>Fixed: Timeline \\u2014 Arrow color not working on frontend<\\/li>\\n<li>Fixed: Timeline \\u2014 Invalid code being generated in post css<\\/li>\\n<li>Fixed: Calendar \\u2014 Link target and nofollow<\\/li>\\n<li>Fixed: Devices \\u2014 Video controls conditions<\\/li>\\n<li>Fixed: Parallax Background \\u2014 Conflict with Elementor Pro scrolling effect<\\/li>\\n<li>Fixed: Popup \\u2014 Dynamic css selector for trigger not working<\\/li>\\n<li>Fixed: Calendar \\u2014 Link attributes in compact mode not working<\\/li>\\n<li>Fixed: Google Map \\u2014 Wrong value for default description tag<\\/li>\\n<li>Fixed: Google Map \\u2013 Set overflow to hidden to allow for advanced border radius setting<\\/li>\\n<li>Fixed: Switcher \\u2014 Rename effects section for compatibility with motion effects section name<\\/li>\\n<li>Fixed: Switcher \\u2014 Link to control should not be responsive<\\/li>\\n<li>Fixed: Unfold \\u2014 Bug with closing without focusing<\\/li>\\n<li>Fixed: Random Image \\u2014 Wrong caption<\\/li>\\n<li>Fixed: Display Conditions \\u2014 Check correct condition value<\\/li>\\n<li>Fixed: Toggle Element \\u2014 Text Label align controls<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Safari 12.1 CSS bug<\\/li>\\n<li>Fixed: Gallery \\u2014 Hover effects on mixed layout<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Edge case js error<\\/li>\\n<li>Fixed: Remove duplicate empty template messages from editor panel<\\/li>\\n<li>Fixed: Check license data before mismatch check<\\/li>\\n<li>Fixed: Tooltips \\u2014 Bug with hide event prevent default<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Allow horizontal post layout independent of columns value<\\/li>\\n<li>Tweak: Gallery \\u2014 Better controls conditions<\\/li>\\n<li>Tweak: Gallery \\u2014 Moved settings in their own sections under Content<\\/li>\\n<li>Tweak: Gallery \\u2014 Control conditions<\\/li>\\n<li>Tweak: Gallery \\u2014 Better markup, controls and css optimisation<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 Better markup, controls and css optimisation<\\/li>\\n<li>Tweak: Better license management, notifications and performance<\\/li>\\n<li>Tweak: Remove extension default enable for sticky and parallax background<\\/li>\\n<li>Tweak: Remove custom panel alert classes and revert to elementor ones<\\/li>\\n<li>Tweak: Update docs and support links in extras admin pages<\\/li>\\n<li>Tweak: Streamline get_image_caption across all modules to avoid code redundancy<\\/li>\\n<li>Tweak: Toggle Element \\u2014 Better Label alignment controls<\\/li>\\n<li>Tweak: Popup \\u2014 Empty trigger css adjustments<\\/li>\\n<li>Tweak: Admin pages styles<\\/li>\\n<\\/ul>\\n<h4> 2.0.17 <\\/h4>\\n<ul>\\n<li>Added: Timeline \\u2014 Overlay horizontal alignment option<\\/li>\\n<li>Fixed: Timeline \\u2014 Icon showing twice<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Default horizontal alignment to left<\\/li>\\n<\\/ul>\\n<h4> 2.0.16 <\\/h4>\\n<ul>\\n<li>Fixed: Include admin script only on extras pages<\\/li>\\n<li>Fixed: Posts Extra \\u2014 RTL margins and arrows<\\/li>\\n<li>Fixed: Calendar \\u2014 RTL arrows<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Override current query posts per page with control setting<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Carousel style section condition<\\/li>\\n<li>Added: Text Divider \\u2014 Control for alignment of text<\\/li>\\n<li>Added: Unfold \\u2014 Columns settings for content<\\/li>\\n<li>Added: Timeline \\u2014 New alignment controls to allow selecting layouts per breakpoint<\\/li>\\n<li>Added: Posts Extra \\u2014 Option to align posts horizontally<\\/li>\\n<li>Tweak: Admin settings RTL<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Responsive alignment controls<\\/li>\\n<li>Tweak: Timeline \\u2014 Responsive defaults for alignment controls<\\/li>\\n<\\/ul>\\n<h4> 2.0.15 <\\/h4>\\n<ul>\\n<li>IMPORTANT: This version requires Elementor 2.5 or above<\\/li>\\n<li>IMPORTANT: If you have Elementor Pro, this version requires version 2.5 or above<\\/li>\\n<li>Added: Posts Extra \\u2014 Elementor Pro new related posts module with include \\/ exclude and date range<\\/li>\\n<li>Added: Circle Progress \\u2014 Option to turn off animation<\\/li>\\n<li>Added: Display Conditions \\u2014 Day of week condition<\\/li>\\n<li>Added: Video Player &amp; Devices \\u2014 Option to not hide bar when video is playing<\\/li>\\n<li>Fixed: Sticky Elements \\u2014 Unstick for 768px wide tablets<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Compatibility with Elementor Pro 2.5<\\/li>\\n<li>Fixed: Timeline \\u2014 Compatibility with Elementor Pro 2.5<\\/li>\\n<li>Fixed: Sticky Elements \\u2014 Adjust on resize in editor<\\/li>\\n<li>Fixed: Calendar \\u2014 Query compatibility with WPML<\\/li>\\n<li>Fixed: Hotspots \\u2014 Check spaces in hotspot links<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Edge case where images don\'t display entirely<\\/li>\\n<li>Fixed: Timeline \\u2014 Correctly render dynamic tags<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Isotope on loading more posts when filter active<\\/li>\\n<li>Tweak: Video Player \\u2014 Automatically hide bar on mobile when playing<\\/li>\\n<\\/ul>\\n<h4> 2.0.14 <\\/h4>\\n<ul>\\n<li>Added: Toggle Element \\u2014 Option to select which item is active by default<\\/li>\\n<li>Fixed: Table \\u2014 Restrict cell max-width to msie<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Wrong arranging in some cases<\\/li>\\n<li>Fixed: Media Player text indicators wrapping<\\/li>\\n<\\/ul>\\n<h4> 2.0.13 <\\/h4>\\n<ul>\\n<li>Fixed: Posts Extra \\u2014 Carousel js error<\\/li>\\n<\\/ul>\\n<h4> 2.0.12 <\\/h4>\\n<ul>\\n<li>Added: Unfold \\u2014 Options to keep focus on content when folding or unfolding<\\/li>\\n<li>Fixed: Toggle Element \\u2014 Make sure Gallery Extra is initiated when toggling<\\/li>\\n<li>Fixed: Table \\u2014 Min-width breakpoint bug<\\/li>\\n<li>Fixed: Sticky Elements \\u2014 Compatibility with Elementor 2.5<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Z-index issues for panel<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Allow scroll on page not working<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Rare selector for anchors with link issue<\\/li>\\n<li>Fixed: Hotspots \\u2014 Rename css pulse animation<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Editor defaultView error<\\/li>\\n<li>Fixed: Sticky Elements \\u2014 Adjust breakpoint values<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Fallback to default wp posts per page option<\\/li>\\n<li>Tweak: Offcanvas \\u2014 Make sure html element has auto height<\\/li>\\n<li>Tweak: Better wpml classes check<\\/li>\\n<\\/ul>\\n<h4> 2.0.11 <\\/h4>\\n<ul>\\n<li>Fixed: Offcanvas \\u2014 Trigger not closing after open<\\/li>\\n<li>Fixed: Posts \\u2014 Grid overlapping on safari when infinite scroll is enabled<\\/li>\\n<li>Fixed: Table \\u2014 Restrict IE hack to tablet and up<\\/li>\\n<li>Fixed: Get element settings on frontend in edit mode<\\/li>\\n<li>Fixed: Google Map \\u2014 Require resize plugin<\\/li>\\n<li>Added: Posts Extra \\u2014 Button border controls<\\/li>\\n<\\/ul>\\n<h4> 2.0.10 <\\/h4>\\n<ul>\\n<li>Added: Parallax Elements \\u2014 Option to allow moving elements when they aren\'t visible inside viewport<\\/li>\\n<li>Fixed: Google Map \\u2014 Centering with dynamic tags not working<\\/li>\\n<li>Fixed: Calendar \\u2014 Don\'t limit number of posts fetched<\\/li>\\n<li>Fixed: Display Conditions \\u2014 Chrome check failing<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Responsive item aligning<\\/li>\\n<li>Fixed: Parallax Background \\u2014 Custom size control compatibility + tweaks<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Type control condition<\\/li>\\n<li>Tweak: Google Map \\u2014 Disable fitting and centering when route is enabled<\\/li>\\n<\\/ul>\\n<h4> 2.0.9 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Handle multiple paginated loops<\\/li>\\n<li>Added: Posts Extra \\u2014 Nothing found message<\\/li>\\n<li>Added: Image Comparison \\u2014 Option to turn off animation on entrance<\\/li>\\n<li>Added: Posts Extra \\u2014 Query ID filter on top of elementor pro one<\\/li>\\n<li>Added: Offcanvas \\u2014 Control to enable page scroll when offcanvas panel is open<\\/li>\\n<li>Fixed: Table \\u2014 IE cell text wrapping<\\/li>\\n<li>Fixed: Circle Progress \\u2014 Wrong absolute value when multiple widget instances on same page<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Wrong thumbnail order<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Z-index issues<\\/li>\\n<li>Fixed: Calendar \\u2014 Convert timestamp to integer<\\/li>\\n<li>Fixed: Gallery module attachment check<\\/li>\\n<li>Tweak: Timeline \\u2014 Rename timeline script<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Responsive row spacing control<\\/li>\\n<li>Tweak: Parallax Background \\u2014 Compatibility with Elementor 2.4<\\/li>\\n<\\/ul>\\n<h4> 2.0.8 <\\/h4>\\n<ul>\\n<li>Fixed: Text Divider \\u2014 Selector for link color<\\/li>\\n<li>Fixed: Timeline \\u2014 Notice<\\/li>\\n<li>Fixed: Offcanvas \\u2014 Escape jquery expression<\\/li>\\n<li>Fixed: Google Map \\u2014 Handle invalid or undefined snazzy map style<\\/li>\\n<\\/ul>\\n<h4> 2.0.7 <\\/h4>\\n<ul>\\n<li>Fixed: Offcanvas \\u2014 Anchor navigation scroll calculation<\\/li>\\n<li>Added: Timeline \\u2014 Allow post content to be shown instead of excerpt<\\/li>\\n<li>Added: Timeline \\u2014 Control to set line progress position relative to viewport<\\/li>\\n<li>Tweak: Offcanvas \\u2014 Anchor condition<\\/li>\\n<\\/ul>\\n<h4> 2.0.6 <\\/h4>\\n<ul>\\n<li>Fixed: Popup \\u2014 Duplicate tab control name<\\/li>\\n<li>Fixed: Popup \\u2014 Remove rtl suffix<\\/li>\\n<li>Added: Offcanvas \\u2014 Global control for offcanvas container background color<\\/li>\\n<\\/ul>\\n<h4> 2.0.5 <\\/h4>\\n<ul>\\n<li>Added: Editor panel labels for widgets<\\/li>\\n<li>Added: Calendar \\u2014 Control to customise month names<\\/li>\\n<li>Added: Offcanvas \\u2014 Link navigate to anchors on page<\\/li>\\n<li>Added: Popup \\u2014 Text trigger styling controls<\\/li>\\n<li>Fixed: Inline SVG \\u2014 Multiple svgs have same settings<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 No parent custom taxonomy terms render all terms<\\/li>\\n<li>Fixed: Posts Extra \\u2014 PHP notice<\\/li>\\n<li>Tweak: Updated language file<\\/li>\\n<\\/ul>\\n<h4> 2.0.4 <\\/h4>\\n<ul>\\n<li>Fixed: Display Conditions \\u2014 Editor section for sections actions<\\/li>\\n<li>Fixed: Display Conditions \\u2014 Conditions evaluation per element<\\/li>\\n<\\/ul>\\n<h4> 2.0.3 <\\/h4>\\n<ul>\\n<li>Fixed: Popup Display Conditions \\u2014 Check widget visibility before opening automatically<\\/li>\\n<li>Fixed: Table \\u2014 First row has no classes<\\/li>\\n<li>Fixed: Google Map \\u2014 Handle no snazzy maps selection<\\/li>\\n<li>Fixed: Display Conditions \\u2014 Wrong default keys resulting in wrong display<\\/li>\\n<li>Fixed: Audio Player \\u2014 Border type selector<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Position structured data property<\\/li>\\n<li>Fixed: Parallax Element \\u2014 Parallax column affecting child columns<\\/li>\\n<li>Fixed: Devices \\u2014 Image extending outside the widget area<\\/li>\\n<li>Fixed: Popup \\u2014 Move font family to pseudo-element<\\/li>\\n<li>Fixed: Slide Menu \\u2014 Sub-menu links not working with link navigation turned on<\\/li>\\n<li>Tweak: Rename infinite-scroll script<\\/li>\\n<li>Tweak: Breadcrumbs \\u2014 Increase typography selector specificity<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Additional conditions for areas style sections<\\/li>\\n<li>Remove widget disabling admin notif<\\/li>\\n<li>Update Wordpress stable tag to 5.0.0<\\/li>\\n<\\/ul>\\n<h4> 2.0.2 <\\/h4>\\n<ul>\\n<li>Added: New Query Control<\\/li>\\n<li>Added: Display Conditions \\u2014 Ajax powered fields<\\/li>\\n<li>Added: Display Conditions \\u2014 Current post condition<\\/li>\\n<li>Fixed: Switcher \\u2013 Autoplay not working without entrance animation<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Custom taxonomy archive crumbs<\\/li>\\n<li>Tweak: Audio Player \\u2014 Added option for external sources<\\/li>\\n<\\/ul>\\n<h4> 2.0.1 <\\/h4>\\n<ul>\\n<li>Fixed: Google Map \\u2014 Navigation z-index<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Default button position to hidden<\\/li>\\n<li>Fixed: Devices \\u2014 Video in window frame not displaying<\\/li>\\n<li>Fixed: Google Map \\u2014 JSON incorrectly reported as invalid<\\/li>\\n<li>Fixed: Switcher \\u2014 Cover picture tag with CSS<\\/li>\\n<li>Fixed: Devices \\u2014 Video css for browser frame<\\/li>\\n<li>Added: Posts Extra \\u2014 Infinite load button transition control<\\/li>\\n<li>Added: Posts Extra \\u2014 Infinite load button border control<\\/li>\\n<li>Added: Hotspots \\u2014 Individual hover controls for each hotspot<\\/li>\\n<li>Added: Audio Player \\u2014 Option to loop playlist<\\/li>\\n<li>Tweak: Google Map \\u2014 Make fields dynamic<\\/li>\\n<li>Tweak: Audio Player \\u2014 Added custom js events<\\/li>\\n<li>Tweak: Audio Player \\u2014 Separate control for play icon size<\\/li>\\n<li>Tweak: Video Player \\u2014 Added custom js events<\\/li>\\n<\\/ul>\\n<h4> 2.0.0 <\\/h4>\\n<ul>\\n<li>New Extension: Display Conditions<\\/li>\\n<li>New Widget: Google Map<\\/li>\\n<li>New Widget: Popup<\\/li>\\n<li>New Widget: Age Gate<\\/li>\\n<li>New Widget: Toggle Element<\\/li>\\n<li>New Widget: Calendar<\\/li>\\n<li>New Widget: Audio Player<\\/li>\\n<li>New Widget: Offcanvas<\\/li>\\n<li>New Widget: Slide Menu<\\/li>\\n<li>New Widget: Random Image<\\/li>\\n<li>Added: Posts Extra \\u2014 Support for terms from multiple taxonomies<\\/li>\\n<li>Added: Breadcrumbs \\u2014 Include blog posts page in breadcrumbs<\\/li>\\n<li>Added: Switcher \\u2014 New option to add description<\\/li>\\n<li>Added: Sticky Elements \\u2014 Completely rewritten code<\\/li>\\n<li>Added: Sticky Elements \\u2014 Offset bottom control<\\/li>\\n<li>Added: Global Tooltips \\u2014 Control to disable on breakpoint<\\/li>\\n<li>Added: Breadcrumbs \\u2014 Option to show taxonomy terms for custom post types instead of CPT name<\\/li>\\n<li>Added: Tooltips \\u2014 New trigger on page load<\\/li>\\n<li>Added: Switcher \\u2014 Events to update when inside toggle element<\\/li>\\n<li>Added: Posts Extra \\u2014 Price meta for woocommerce products<\\/li>\\n<li>Added: Posts Extra \\u2014 Button content part replaces read more<\\/li>\\n<li>Added: Posts Extra \\u2014 Post count for filters<\\/li>\\n<li>Added: Breadcrumbs \\u2014 Schema.org properties<\\/li>\\n<li>Fixed: Tooltips \\u2014 Add option to disable on breakpoint<\\/li>\\n<li>Fixed: Global Tooltips \\u2014 Destroy on editor mode<\\/li>\\n<li>Fixed: Parallax Background \\u2014 Out of view sections have wrong background image positions<\\/li>\\n<li>Fixed: Global Tooltips \\u2014 Settings not being saved<\\/li>\\n<li>Fixed: Parallax Element \\u2014 Start position option not applying<\\/li>\\n<li>Fixed: Hotspots \\u2014 Image display block<\\/li>\\n<li>Fixed: Unfold \\u2014 Button alignment<\\/li>\\n<li>Fixed: Unfold \\u2014 Button icon position and indent<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Check for woocommerce for price fields<\\/li>\\n<li>Fixed: Video Player \\u2014 Volume size undefined error<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 RTL behviour on clicking thumbs<\\/li>\\n<li>Fixed: Inline SVG \\u2014 ACF image field<\\/li>\\n<li>Fixed: Update to getEditModel method<\\/li>\\n<li>Fixed: Compatibility with Elementor 2.3.0<\\/li>\\n<li>Fixed: License not deactivating if expired<\\/li>\\n<li>Fixed: Image Comparison \\u2014 Distance for top-aligned labels<\\/li>\\n<li>Fixed: Devices + Hotspots \\u2014 Compatibility with Elementor 2.3.0<\\/li>\\n<li>Fixed: Switcher \\u2014 Astra theme images css conflict<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Multiple hierarchical categories not showing<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Filtered posts not found message<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Wrong grid item width when filters are active and multiple instances on page<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Controls conditions<\\/li>\\n<li>Fixed: Breacrumbs \\u2014 Wrap crumbs automatically<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Hide fields not available for Current Query option<\\/li>\\n<li>Tweak: Hotspots \\u2014 Default hotspots for better ux<\\/li>\\n<li>Tweak: Video Player + Devices \\u2014 Better behaviour and interactions for video player<\\/li>\\n<li>Tweak: Video Player + Devices \\u2014 Better selection of video source files<\\/li>\\n<li>Tweak: Video Player + Devices \\u2014 Added playback speed option<\\/li>\\n<li>Tweak: Timeline \\u2014 Support for point numbers and letter for posts<\\/li>\\n<li>Tweak: Table \\u2014 Remove render template to improve editing performance<\\/li>\\n<li>Tweak: Buttons \\u2014 Add bottom margin to custom spacing control<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Increase options for carousel rows and slides to scroll<\\/li>\\n<li>Tweak: Enable docs link in admin settings page<\\/li>\\n<li>Tweak: Switcher \\u2014 Make description field dynamic<\\/li>\\n<li>Tweak: Google Maps \\u2013 Adjust controls structure<\\/li>\\n<li>Tweak: Table \\u2014 Control names<\\/li>\\n<li>Tweak: Text Divider \\u2014 Controls position<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Added read more to translatable fields for WPML<\\/li>\\n<\\/ul>\\n<h4> 1.9.16 <\\/h4>\\n<ul>\\n<li>Fixed: Elementor 2.3.0 compatibility<\\/li>\\n<\\/ul>\\n<h4> 1.9.15 <\\/h4>\\n<ul>\\n<li>Fixed: Posts Extra \\u2014 Load more button for multiple widget instances<\\/li>\\n<li>Fixed: Parallax Background \\u2014 Responsive speed options<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Columns above 9 don\'t become full width<\\/li>\\n<li>Tweak: Improve Elementor Pro version dependency and posts widget compatibility<\\/li>\\n<li>Tweak: Timeline \\u2014 Enable dynamic fields for custom source<\\/li>\\n<li>Tweak: Circle Progress \\u2014 Handling of divisions operation in value control<\\/li>\\n<li>Tweak: Circle Progress \\u2014 Option to allow numbers with decimals instead of percetanges<\\/li>\\n<li>Tweak: Circle Progress \\u2014 Options to allow for absolute values to be shown<\\/li>\\n<li>Tweak: Hotspots \\u2014 Make hotspots size and opacity control responsive<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Remove swiper slide overflow hidden<\\/li>\\n<li>Tweak: Added option to enable updates to beta versions or Extras<\\/li>\\n<\\/ul>\\n<h4> 1.9.14 <\\/h4>\\n<ul>\\n<li>Fixed: Rename resize script to avoid potential conflicts<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Carousel flickering when used in Tabs widget and switching tabs<\\/li>\\n<li>Fixed: Timeline \\u2014 Date showing current date instead of post date<\\/li>\\n<li>Fixed: Extras admin page conflict with Jetpack<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Link not accessible for preview images with caption<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Added query id control for server side filtering of widget queries<\\/li>\\n<li>Tweak: Hotspots \\u2014 HTML valid structure issue<\\/li>\\n<li>Tweak: Table \\u2014 Minor terminology improvements<\\/li>\\n<\\/ul>\\n<h4> 1.9.13 <\\/h4>\\n<ul>\\n<li>Fixed: Posts Extra \\u2014 Infinite scroll loading same posts<\\/li>\\n<li>Fixed: Inline SVG \\u2014 Space under image<\\/li>\\n<li>Fixed: Extensions not showing when Elementor Pro not active<\\/li>\\n<\\/ul>\\n<h4> 1.9.12 <\\/h4>\\n<ul>\\n<li>Added: CSS filter controls for widgets<\\/li>\\n<li>Added: Global Tooltips \\u2014 Support for shortcodes and dynamic fields<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Load more button causing error when not paginated<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Content inside media not showing when no thumbnail available<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Media area display conditions<\\/li>\\n<li>Fixed: Posts Extra \\u2014 PHP warning when excerpt length is empty<\\/li>\\n<li>Fixed: Posts Extra \\u2014 RTL alignment of posts in masonry mode<\\/li>\\n<li>Fixed: Circle Progress \\u2014 Default control value to string<\\/li>\\n<li>Fixed: Circle Progress \\u2014 Dynamic fields values not working<\\/li>\\n<li>Fixed: Parallax Elements \\u2014 Window height calculation<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Repeater fields conditions<\\/li>\\n<li>Fixed: Parallax Background \\u2014 Breaks when dynamic field is used<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Allow offset to be used in current query<\\/li>\\n<li>Tweak: Timeline \\u2014 Allow drafts and scheduled posts to be included<\\/li>\\n<\\/ul>\\n<h4> 1.9.11 <\\/h4>\\n<ul>\\n<li>Fixed: Posts Extra \\u2014 Sticky posts compatibility with pagination<\\/li>\\n<li>Fixed: Compatibility with new Swiper version in Elementor 2.1<\\/li>\\n<li>Tweak: Timeline \\u2014 Responsive date padding and margin controls<\\/li>\\n<\\/ul>\\n<h4> 1.9.10 <\\/h4>\\n<ul>\\n<li>Fixed: Sticky Elements \\u2014 Options appear twice<\\/li>\\n<li>Tweak: Remove group control sticky<\\/li>\\n<\\/ul>\\n<h4> 1.9.9 <\\/h4>\\n<ul>\\n<li>Fixed: Timeline \\u2014 Points and line not aligned on mobile and tablet if size defined only on desktop<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Default placeholder image overriding post thumbnail<\\/li>\\n<li>Fixed: Sticky Elements no longer working<\\/li>\\n<li>Fixed: Additional check for active Elementor Pro<\\/li>\\n<li>Tweak: Moved Extras advanced section behind Custom CSS section<\\/li>\\n<\\/ul>\\n<h4> 1.9.8 <\\/h4>\\n<ul>\\n<li>Added: Gallery Slider \\u2014 Arrows controls for preview<\\/li>\\n<li>Added: Posts Extra \\u2014 Option to show all filters when using infinite scroll<\\/li>\\n<li>Fixed: Unfold \\u2014 Icon right align not working<\\/li>\\n<li>Fixed: Compatibility with Elementor 2.1 beta<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Allow excerpt in media area<\\/li>\\n<li>Tweak: Timeline \\u2014 More specific color selectors<\\/li>\\n<li>Tweak: Timeline \\u2014 Text align dates to the right for right hand items<\\/li>\\n<\\/ul>\\n<h4> 1.9.7 <\\/h4>\\n<ul>\\n<li>Fixed: Gallery Extra \\u2014 Implemented work-around for warning caused by Elementor bug<\\/li>\\n<li>Fixed: Posts Extra \\u2014 IE 10 images bug<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Time not showing<\\/li>\\n<li>Fixed: Buttons \\u2014 Wrap buttons by default<\\/li>\\n<li>Fixed: Remove too broad css declaration<\\/li>\\n<li>Fixed: Parallax background \\u2014 Correct element resize function name<\\/li>\\n<\\/ul>\\n<h4> 1.9.6 <\\/h4>\\n<ul>\\n<li>Fixed: Parallax Elements \\u2014 Breaks if pan distance is undefined<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Read more typography control conditions<\\/li>\\n<li>Fixed: Unfold \\u2014 Force icon to show hide as inline block<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Stretch body to align all footers to bottom<\\/li>\\n<li>Fixed: Posts Extra \\u2014 IE 10 horizontal layout for posts<\\/li>\\n<li>Fixed: Renamed jquery resize plugin function<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 CSS overflow fix<\\/li>\\n<\\/ul>\\n<h4> 1.9.5 <\\/h4>\\n<ul>\\n<li>Added: Dynamic fields support for all widgets<\\/li>\\n<li>Fixed: Global Tooltips \\u2014 Position not being overriden<\\/li>\\n<li>Fixed: Timeline \\u2014 Pointer cursor not showing on linked cards<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Image bottom spacing on some themes<\\/li>\\n<li>Tweak: Gallery Extra \\u2014 Added unique classes to each item<\\/li>\\n<li>Tweak: HTML5 Video \\u2014 Added control to enable muted video for autoplay<\\/li>\\n<li>Tweak: HTML5 Video \\u2014 Added controls to enable or disable all elements inside the bar<\\/li>\\n<\\/ul>\\n<h4> 1.9.4 <\\/h4>\\n<ul>\\n<li>Added: Timeline \\u2014 Control to center images<\\/li>\\n<li>Added: Posts Extra \\u2014 New filters for post title, excerpt, comments and date<\\/li>\\n<li>Added: HTML5 Video \\u2014 Control to stop all other video players when current one is played.<\\/li>\\n<li>Fixed: Fixed: Column widths in post-css are rendered in the wrong order<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Posts per page doesn\'t take into account sticky posts<\\/li>\\n<li>Fixed: Buttons \\u2014 Item typography group control not working<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Responsive horizontal alignment for filters<\\/li>\\n<li>Fixed: Hotspots \\u2014 Tooltip position not being overriden at hotspot level<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Control conditions<\\/li>\\n<li>Tweak: Updated isotope version to 3.0.6 to fix 1px grid gap<\\/li>\\n<li>Tweak: Remove default webkit left padding from list navs<\\/li>\\n<li>Tweak: Parallax Background \\u2014 Increase plugin timeout reinit<\\/li>\\n<li>Tweak: Posts \\u2014 Increase excerpt length filter priority<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Added option to show only sticky posts<\\/li>\\n<\\/ul>\\n<h4> 1.9.3 <\\/h4>\\n<ul>\\n<li>Added: Sticky Elements \\u2014 Compatibility with the Lazy Loader wordpress plugin<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Safari &lt; 10.2 layout glitch layout glitch on mobile<\\/li>\\n<li>Fixed: HTML5 Video \\u2014 m4v files condition<\\/li>\\n<li>Fixed: Sticky \\u2014 Sticks only when resizing browser window<\\/li>\\n<li>Fixed: Sticky \\u2014 Not working correctly with Stretched parent<\\/li>\\n<li>Fixed: HTML5 Video \\u2014 m4v format not sufficient<\\/li>\\n<li>Fixed: Image Comparison \\u2013 Allow 0 percent values<\\/li>\\n<li>Tweak: HTML5 Video \\u2014 Render attributes<\\/li>\\n<li>Tweak: HTML5 Video \\u2014 Control conditions<\\/li>\\n<\\/ul>\\n<h4> 1.9.2 <\\/h4>\\n<ul>\\n<li>Fixed: Switcher \\u2014 Bug with arrow loader position and stroke width in older versions of Safari<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Compatibility with IE 11<\\/li>\\n<li>Fixed: Parallax Elements \\u2014 Control value undefined check<\\/li>\\n<\\/ul>\\n<h4> 1.9.1 <\\/h4>\\n<ul>\\n<li>Fixed: Parallax Elements \\u2014 Max distance not taking into account scroll position<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Filters not stacking on responsive.<\\/li>\\n<li>Fixed: Switcher \\u2014 Arrow loader not displaying in firefox<\\/li>\\n<li>Fixed: Parallax Elements \\u2014 Wrong position for scroll with start position<\\/li>\\n<li>Fixed: GSAP dependencies<\\/li>\\n<\\/ul>\\n<h4> 1.9.0 <\\/h4>\\n<ul>\\n<li>Added: New Switcher Widget! \\u2014 Switch photos and text using powerful javascript driven transitions. Features menu and arrows navigation, autoplay with progress loader, entrance animations, page background color switcher, two skins (default and overlay) and much more.<\\/li>\\n<li>Added: New Feature for Parallax Elements! \\u2014 Option to parallax columns and widgets on mouse move<\\/li>\\n<li>Added: Posts Extra \\u2014 Controls to style only sticky posts<\\/li>\\n<li>Added: Image Comparison \\u2014 Option to enable clicking on labels to uncover images<\\/li>\\n<li>Added: Hotspots \\u2014 Separate color controls for each hotspot<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Sticky posts not working when a category is selected in the query<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Invisible gallery when preview position is top on desktop<\\/li>\\n<li>Fixed: Image Comparison \\u2014 Remove labels if no text is present<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Hide carousel until properly rendered<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Added alt and title tags to image element<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Issue with negative margin resulting in right whitespace for the gallery<\\/li>\\n<li>Fixed: Timeline \\u2014 Controls conditions<\\/li>\\n<li>Fixed: Timeline \\u2014 Item point color override<\\/li>\\n<li>Fixed: Timeline \\u2014 Properly override point content<\\/li>\\n<li>Tweak: Parallax Elements \\u2014 Removed group control<\\/li>\\n<li>Tweak: Gallery Extra, Gallery Slider, Posts Extra \\u2014 Added notice with link to blend mode browser support for blend mode controls<\\/li>\\n<li>Tweak: Timeline \\u2014 Added repeater setting key method to card render function<\\/li>\\n<\\/ul>\\n<h4> 1.8.8 <\\/h4>\\n<ul>\\n<li>Added: Gallery Extra \\u2014 Control width and ratio of each individual image in manual mode<\\/li>\\n<li>Added: Timeline \\u2014 Option for automatic numbering and letters instead of icons to points<\\/li>\\n<li>Added: Timeline \\u2014 New control to set excerpt length<\\/li>\\n<li>Added: Unfold \\u2014 Option to change icon when unfolded<\\/li>\\n<li>Added: Sticky Elements \\u2014 Option to turn off bottoming of elements inside the parent<\\/li>\\n<li>Added: Posts Extra \\u2014 Option to enable sticky posts in query<\\/li>\\n<li>Added: Posts Extra \\u2014 Arrows sizing controls<\\/li>\\n<li>Added: Posts Extra \\u2014 Transition control for carousel arrows and pagination<\\/li>\\n<li>Added: Posts Extra \\u2014 Option to set how many slides to scroll<\\/li>\\n<li>Added: Image Comparison \\u2014 Control to define initial position of separator<\\/li>\\n<li>Added: Image Comparison \\u2014 Option to enable moving separator by clicking anywhere on the image<\\/li>\\n<li>Added: Buttons \\u2014 Control for label min width<\\/li>\\n<li>Added: Hotspots \\u2014 Control to disable pulsating animation<\\/li>\\n<li>Fixed: Sticky Elements \\u2014 Controls not showing on inner sections<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Images wider than 100% on mobile in manual mixed masonry layout mode<\\/li>\\n<li>Fixed: HTML5 Video \\u2014 CSS bottom whitespace<\\/li>\\n<li>Fixed: Buttons \\u2014 Remove block label for buttons icon, id and class controls<\\/li>\\n<li>Tweak: Timeline \\u2014 Take sticky posts into consideration in query<\\/li>\\n<li>Tweak: Unfold \\u2014 Organise controls<\\/li>\\n<li>Tweak: WPML Compatibility \\u2014 Change method to fix fields not saving<\\/li>\\n<\\/ul>\\n<h4> 1.8.7 <\\/h4>\\n<ul>\\n<li>Fixed: Posts Extra \\u2014 Filtering one widget\'s posts affects all other widgets<\\/li>\\n<li>Fixed: Hotspots \\u2014 Tooltips have an extra space at the bottom when first hovering<\\/li>\\n<li>Fixed: HTML5 Video \\u2014 Volume functionality breaks when controls are hidden<\\/li>\\n<li>Fixed: HTML5 Video \\u2014 Video reloading after each loop<\\/li>\\n<li>Added: Global Tooltips \\u2014 Global controls for distance and width<\\/li>\\n<li>Tweak: HTML5 Video \\u2014 Added width and horizontal alignment control to player<\\/li>\\n<li>Tweak: Global Tooltips \\u2014 Remove default global styling values after Elementor enqueue fix in 1.9.5<\\/li>\\n<\\/ul>\\n<h4> 1.8.6 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Term slug classes to filters and post terms<\\/li>\\n<li>Fixed: Replaced create_function with anonymous function for PHP 7.2 support<\\/li>\\n<li>Fixed: Inline SVG \\u2014 Handle internal CSS in non color overriding situations<\\/li>\\n<li>Fixed: Hotspots \\u2014 Tooltips showing even if they have no content<\\/li>\\n<li>Tweak: Sticky Elements \\u2014 Prevent sticky on a section that is stretched with js<\\/li>\\n<li>Tweak: Buttons \\u2014 Move typography control above tabs<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Move hover animation controls to separate section for better ux<\\/li>\\n<li>Tweak: Gallery Extra \\u2014 Moved hover controls to separate section<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 Moved hover controls to separate section<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 Default font size for thumbnail captions<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Fix condition<\\/li>\\n<li>Tweak: Hotspots \\u2014 Show label for tooltip content in editor<\\/li>\\n<\\/ul>\\n<h4> 1.8.5 <\\/h4>\\n<ul>\\n<li>Fixed: Gallery Extra \\u2014 Missing js dependency<\\/li>\\n<\\/ul>\\n<h4> 1.8.4 <\\/h4>\\n<ul>\\n<li>Fixed: Gallery Extra \\u2014 Random ordering not working<\\/li>\\n<li>Fixed: Timeline \\u2014 RTL optimisation<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Custom image size not working on manual mode<\\/li>\\n<li>Tweak: Add dismissible notice for recommended php version<\\/li>\\n<li>Tweak: Gallery Extra \\u2014 Add title and description caption types<\\/li>\\n<li>Tweak: Timeline \\u2014 Add link control description to avoid linking cards when content already contains links<\\/li>\\n<\\/ul>\\n<h4> 1.8.3 <\\/h4>\\n<ul>\\n<li>Fixed: HTML5 Video \\u2014 Video not playing on Safari and some mobile environments<\\/li>\\n<li>Fixed: Buttons \\u2014 Safari buttons vertical alignment<\\/li>\\n<li>Fixed: Devices \\u2014 device not displaying on Safari when portrait mode is enabled<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Grid broken on Safari<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 reinit masonry when images done loading<\\/li>\\n<li>Tweak: Move all Extras admin settings into Elementor menu<\\/li>\\n<li>Tweak: Image Comparison \\u2014 Remove default value for width control<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 default mobile and tablet gallery columns to larger numbers<\\/li>\\n<\\/ul>\\n<h4> 1.8.2 <\\/h4>\\n<ul>\\n<li>Added: Parallax Background \\u2014 Support for section resize in elementor preview mode<\\/li>\\n<li>Fixed: Parallax Background \\u2014 Compatibility with stretched section<\\/li>\\n<li>Fixed: HTML5 Video \\u2014 Interface style controls conditions<\\/li>\\n<li>Fixed: Gallery Slider \\u2014 Right side white-space after thumbnails on top preview position<\\/li>\\n<li>Fixed: Unfold \\u2014 Page stops responding when entering invalid html in text editor mode<\\/li>\\n<li>Tweak: Unfold \\u2014 Allow accordions, tabs and all resizing elements inside content<\\/li>\\n<\\/ul>\\n<h4> 1.8.1 <\\/h4>\\n<ul>\\n<li>Fixed: Posts Extra \\u2014 Masonry broken when infinite scroll is enabled<\\/li>\\n<\\/ul>\\n<h4> 1.8.0 <\\/h4>\\n<ul>\\n<li>New extension: Global Tooltips \\u2014 Add a tooltip to any widget<\\/li>\\n<li>New: Disable Widgets &amp; Extensions \\u2014 You can now disable Extras widgets and extensions via the admin settings page<\\/li>\\n<li>Added: WPML compatibility \\u2014 String Translation and Translation Editor support for all widgets<\\/li>\\n<li>Added: Circle Progress \\u2014 Icon support inside circle<\\/li>\\n<li>Added: Update .pot translation file<\\/li>\\n<li>Added: Buttons \\u2014 Tooltips duration control<\\/li>\\n<li>Added: Global settings for Extras tooltips<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Widget not available on multisite installations<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Infinite scroll breaks when using multiple widgets on same page<\\/li>\\n<li>Fixed: Parallax Background \\u2014 Conflict with Anywhere Elementor Pro featured image background<\\/li>\\n<li>Tweak: Parallax Background \\u2014 requestAnimationFrame method for better performance<\\/li>\\n<li>Tweak: Buttons \\u2014 Rename text align label<\\/li>\\n<li>Tweak: Update nicons font<\\/li>\\n<\\/ul>\\n<h4> 1.7.4 <\\/h4>\\n<ul>\\n<li>Fixed: Gallery Extra \\u2014 Custom link broken and attributes not added<\\/li>\\n<\\/ul>\\n<h4> 1.7.3 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Column vertical alignment controls for carousel<\\/li>\\n<li>Added: Timeline \\u2014  Color controls for post title and excerpt<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Carousel rows number control not impacting preview<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Avatar vertical alignment on stretched media content<\\/li>\\n<li>Fixed: Sticky Elements \\u2014 Incorrect spacer height<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Improve editing flow by with advanced controls conditioning<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Controls position<\\/li>\\n<li>Tweak: Sticky Elements \\u2014 Remove popover from group control<\\/li>\\n<li>Tweak: Parallax Elements \\u2014 Remove popover from group control<\\/li>\\n<\\/ul>\\n<h4> 1.7.2 <\\/h4>\\n<ul>\\n<li>Added: Gallery Slider \\u2014 Overlay captions for preview and thumbnails<\\/li>\\n<li>Added: Gallery Slider \\u2014 Controls for caption effects, layout and hover properties<\\/li>\\n<li>Added: Gallery Slider \\u2014 Controls for active thumbs caption<\\/li>\\n<li>Fixed: Buttons \\u2014 Removed popover control on effects<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 Improved carousel adapt on preview resize<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 Improved thumbnails grid<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 Better controls for stacking and position of preview<\\/li>\\n<li>Tweak: Gallery Slider \\u2014 Replace background color with background control for preview captions and overlay<\\/li>\\n<li>Tweak: Gallery Slider + Gallery Extra \\u2014 Better BEM classes<\\/li>\\n<\\/ul>\\n<h4> 1.7.1 <\\/h4>\\n<ul>\\n<li>Added: Gallery Extra \\u2014 Caption horizontal and vertical alignment and hover effects<\\/li>\\n<li>Added: Gallery Extra \\u2014 Ratio and alignment controls to masonry layout<\\/li>\\n<li>Added: Gallery Extra \\u2014 New border and border radius controls for captions<\\/li>\\n<li>Fixed: Gallery Extra \\u2014 Bring image to front when hovered<\\/li>\\n<li>Fixed: Posts Extra \\u2014 Images not displaying on infinite load on iOS Safari and Chrome<\\/li>\\n<li>Tweak: Image Comparison \\u2014 Force override of modified image max-width attribute<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Added extra classes to media elements<\\/li>\\n<\\/ul>\\n<h4> 1.7.0 <\\/h4>\\n<ul>\\n<li>Added: Gallery Extra \\u2014 Masonry layout with mixed mode<\\/li>\\n<li>Added: Gallery Extra \\u2014 Tilt effect<\\/li>\\n<li>Added: Gallery Extra \\u2014 Caption horizontal and vertical alignment and hover effects<\\/li>\\n<li>Added: Gallery Extra \\u2014 Overlay, caption and image transition controls<\\/li>\\n<li>Added: Gallery Extra \\u2014 Overlay blend mode control<\\/li>\\n<li>Added: Gallery Extra \\u2014 Image scale controls for default and hover states<\\/li>\\n<li>Added: Gallery Extra \\u2014 Overlay margin controls for default and hover states<\\/li>\\n<li>Added: Gallery Extra \\u2014 Manual mode that allows entering of every image manually and linking it to any URL<\\/li>\\n<li>Added: Inline SVG widget<\\/li>\\n<li>Added: Posts Extra \\u2014 Controls to disable linking for post title, media and terms<\\/li>\\n<li>Added: Posts Extra \\u2014 Control to select default applied filter for filter bar<\\/li>\\n<li>Added: Timeline \\u2014 New controls for post title typography and spacing, post excerpt typography and padding<\\/li>\\n<li>Added: Image Comparison \\u2014 Image size control<\\/li>\\n<li>Added: New css transition control for Gallery Extra, Gallery Slider, Hotspots, Posts Extra, Timeline, Table and Inline SVG widgets<\\/li>\\n<li>Added: HTML5 Video \\u2014 M4V format support<\\/li>\\n<li>Added: Devices \\u2014 M4V format support for video<\\/li>\\n<li>Fixed: Buttons \\u2014 Flicker on flip effect<\\/li>\\n<li>Fixed: Timeline \\u2014 CSS class conflict<\\/li>\\n<li>Fixed: Table \\u2014 ID and class don\'t apply to header<\\/li>\\n<li>Tweak: Improved Elementor 1.9 compatibility for Extras group controls<\\/li>\\n<li>Tweak: Update TweenMax to latest version (1.20.2)<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Simplified CSS<\\/li>\\n<li>Tweak: Unfold \\u2014 Disconnect button and content from control alignment logic<\\/li>\\n<\\/ul>\\n<h4> 1.6.3 <\\/h4>\\n<ul>\\n<li>Fixed: Breadcrumbs \\u2014 Display correctly when used within an Elementor library template<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Condition terms separator<\\/li>\\n<li>Tweak: Breadcrumbs \\u2014 Avoid naming conflict with Elementor Pro widget<\\/li>\\n<\\/ul>\\n<h4> 1.6.2 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 New autoplay, autoheight and fade effect controls<\\/li>\\n<li>Added: Posts Extra \\u2014 &quot;Top&quot; option to media position on horizontal layout<\\/li>\\n<li>Added: Posts Extra \\u2014 Allowed media to be positioned horizontally on 2 columns layouts<\\/li>\\n<li>Added: Posts Extra \\u2014 New border controls for media<\\/li>\\n<li>Added: Table \\u2014 Allow table responsive behaviour to be turned off<\\/li>\\n<li>Tweak: Buttons \\u2014 Default button content alignment to justify<\\/li>\\n<li>Fix: Timeline \\u2014 Potential fatal error<\\/li>\\n<li>Fix: Posts Extra \\u2014 Post media position controls conditions<\\/li>\\n<li>Fix: Buttons \\u2014 Delay on transitioned properties<\\/li>\\n<li>Fix: Posts Extra \\u2014 Wrong tablet breakpoint set for number of columns<\\/li>\\n<li>Fix: Parallax Background \\u2014 Remove initial background image once parallax is activated<\\/li>\\n<\\/ul>\\n<h4> 1.6.1 <\\/h4>\\n<ul>\\n<li>Added: Posts Extra \\u2014 Link author name and avatar to author posts pages<\\/li>\\n<li>Added: Posts Extra \\u2014 Read more link to excerpt<\\/li>\\n<li>Tweak: Posts Extra \\u2014 Added separate hide option for Position for better UX <\\/li>\\n<li>Tweak: Posts Extra \\u2014 Improved position icons<\\/li>\\n<\\/ul>\\n<h4> 1.6.0 <\\/h4>\\n<ul>\\n<li>New Widget \\u2014 Posts Extra - Create ANY layout for posts with masonry, infinite load, filtering and custom post type support. Works only with Elementor Pro<\\/li>\\n<li>Tweak: Breadcrumbs \\u2014 Added horizontal position and text alignment controls<\\/li>\\n<li>Tweak: Buttons \\u2014 Improved CSS and better alignment and stacking options<\\/li>\\n<li>Fixed: Breadcrumbs \\u2014 Error outputting separator<\\/li>\\n<li>Fixed: Buttons \\u2014 Transition on button content when effects are turned on<\\/li>\\n<\\/ul>\\n<h4> 1.5.6 <\\/h4>\\n<ul>\\n<li>Fixed: Parallax Background \\u2014 Replaced parallax class name to avoid future conflicts<\\/li>\\n<li>Fixed: Timeline \\u2014 Remove flex from left aligned timeline and allow image spacing for horizontal layouts<\\/li>\\n<li>Fixed: PHP fatal error<\\/li>\\n<li>Tweak: Unfold \\u2014 Switched Settings with Content sections in editor for better UX<\\/li>\\n<\\/ul>\\n<h4> 1.5.5 <\\/h4>\\n<ul>\\n<li>Added: Buttons \\u2014 Inline editing<\\/li>\\n<li>Added: Breadcrumbs \\u2014 Inline editing<\\/li>\\n<li>Added: Circle Progress \\u2014 Inline editing<\\/li>\\n<li>Added: Hotspots \\u2014 Inline editing<\\/li>\\n<li>Added: Image Comparison \\u2014 Inline editing<\\/li>\\n<li>Added: Table \\u2014 Inline editing<\\/li>\\n<li>Added: Text Divider \\u2014 Inline editing<\\/li>\\n<li>Added: Timeline \\u2014 Inline editing<\\/li>\\n<li>Added: Unfold \\u2014 Inline editing<\\/li>\\n<li>Fixed: Tooltips \\u2014 Error &quot;size&quot; of undefine